/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry.algorithms;

import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameSphere3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.algorithms.SphereWithConvexPolygonIntersector;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;

public class SphereWithConvexPolygonIntersectorTest {
    private static final ReferenceFrame WORLD = ReferenceFrame.getWorldFrame();

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testSimpleIntersections() {
        SphereWithConvexPolygonIntersector sphereWithConvexPolygonIntersector = new SphereWithConvexPolygonIntersector();
        FrameSphere3D sphere = new FrameSphere3D(WORLD, 5.0, 3.0, 1.0, 2.0);
        ArrayList<Point2D> vertices = new ArrayList<Point2D>();
        vertices.add(new Point2D(-10.0, -10.0));
        vertices.add(new Point2D(-10.0, 10.0));
        vertices.add(new Point2D(10.0, 10.0));
        vertices.add(new Point2D(10.0, -10.0));
        FrameConvexPolygon2D polygon = new FrameConvexPolygon2D(WORLD, Vertex2DSupplier.asVertex2DSupplier(vertices));
        Assert.assertTrue(sphereWithConvexPolygonIntersector.checkIfIntersectionExists(sphere, polygon));
        EuclidCoreTestTools.assertEquals((String)"intersection not right", (EuclidGeometry)new Point3D(5.0, 3.0, 0.0), (EuclidGeometry)sphereWithConvexPolygonIntersector.getClosestPointOnPolygon(), (double)1.0E-12);
        sphere = new FrameSphere3D(WORLD, 5.0, 3.0, 1.0, 0.5);
        vertices = new ArrayList();
        vertices.add(new Point2D(-10.0, -10.0));
        vertices.add(new Point2D(-10.0, 10.0));
        vertices.add(new Point2D(10.0, 10.0));
        vertices.add(new Point2D(10.0, -10.0));
        polygon = new FrameConvexPolygon2D(WORLD, Vertex2DSupplier.asVertex2DSupplier(vertices));
        Assert.assertFalse(sphereWithConvexPolygonIntersector.checkIfIntersectionExists(sphere, polygon));
        EuclidCoreTestTools.assertEquals((String)"intersection not right", (EuclidGeometry)new Point3D(5.0, 3.0, 0.0), (EuclidGeometry)sphereWithConvexPolygonIntersector.getClosestPointOnPolygon(), (double)1.0E-12);
        sphere = new FrameSphere3D(WORLD, 5.0, 3.0, 1.0, 0.5);
        vertices = new ArrayList();
        vertices.add(new Point2D(-1.0, -1.0));
        vertices.add(new Point2D(-1.0, 1.0));
        vertices.add(new Point2D(1.0, 1.0));
        vertices.add(new Point2D(1.0, -1.0));
        polygon = new FrameConvexPolygon2D(WORLD, Vertex2DSupplier.asVertex2DSupplier(vertices));
        Assert.assertFalse(sphereWithConvexPolygonIntersector.checkIfIntersectionExists(sphere, polygon));
        EuclidCoreTestTools.assertEquals((String)"intersection not right", (EuclidGeometry)new Point3D(1.0, 1.0, 0.0), (EuclidGeometry)sphereWithConvexPolygonIntersector.getClosestPointOnPolygon(), (double)1.0E-12);
        PoseReferenceFrame frame = new PoseReferenceFrame("testFrame1", WORLD);
        frame.setPositionWithoutChecksAndUpdate(5.0, 3.0, 0.0);
        sphere = new FrameSphere3D(WORLD, 5.0, 3.0, 1.0, 0.5);
        vertices = new ArrayList();
        vertices.add(new Point2D(-1.0, -1.0));
        vertices.add(new Point2D(-1.0, 1.0));
        vertices.add(new Point2D(1.0, 1.0));
        vertices.add(new Point2D(1.0, -1.0));
        polygon = new FrameConvexPolygon2D((ReferenceFrame)frame, Vertex2DSupplier.asVertex2DSupplier(vertices));
        Assert.assertFalse(sphereWithConvexPolygonIntersector.checkIfIntersectionExists(sphere, polygon));
        FramePoint3D closestPointOnPolygon = sphereWithConvexPolygonIntersector.getClosestPointOnPolygon();
        EuclidCoreTestTools.assertEquals((String)"intersection not right", (EuclidGeometry)new Point3D(5.0, 3.0, 0.0), (EuclidGeometry)closestPointOnPolygon, (double)1.0E-12);
        closestPointOnPolygon.changeFrame((ReferenceFrame)frame);
        EuclidCoreTestTools.assertEquals((String)"intersection not right", (EuclidGeometry)new Point3D(0.0, 0.0, 0.0), (EuclidGeometry)closestPointOnPolygon, (double)1.0E-12);
        frame = new PoseReferenceFrame("testFrame2", WORLD);
        frame.setPositionWithoutChecksAndUpdate(5.0, 3.0, 0.0);
        sphere = new FrameSphere3D(WORLD, 5.0, 3.0, 1.0, 1.0);
        vertices = new ArrayList();
        vertices.add(new Point2D(-1.0, -1.0));
        vertices.add(new Point2D(-1.0, 1.0));
        vertices.add(new Point2D(1.0, 1.0));
        vertices.add(new Point2D(1.0, -1.0));
        polygon = new FrameConvexPolygon2D((ReferenceFrame)frame, Vertex2DSupplier.asVertex2DSupplier(vertices));
        Assert.assertTrue(sphereWithConvexPolygonIntersector.checkIfIntersectionExists(sphere, polygon));
        closestPointOnPolygon = sphereWithConvexPolygonIntersector.getClosestPointOnPolygon();
        EuclidCoreTestTools.assertEquals((String)"intersection not right", (EuclidGeometry)new Point3D(5.0, 3.0, 0.0), (EuclidGeometry)closestPointOnPolygon, (double)1.0E-12);
        closestPointOnPolygon.changeFrame((ReferenceFrame)frame);
        EuclidCoreTestTools.assertEquals((String)"intersection not right", (EuclidGeometry)new Point3D(0.0, 0.0, 0.0), (EuclidGeometry)closestPointOnPolygon, (double)1.0E-12);
        frame = new PoseReferenceFrame("testFrame3", WORLD);
        frame.setPositionWithoutChecksAndUpdate(4.0, 2.0, 0.0);
        sphere = new FrameSphere3D(WORLD, 5.0, 3.0, 1.0, 2.0);
        vertices = new ArrayList();
        vertices.add(new Point2D(-1.0, -1.0));
        vertices.add(new Point2D(-1.0, 1.0));
        vertices.add(new Point2D(1.0, 1.0));
        vertices.add(new Point2D(1.0, -1.0));
        polygon = new FrameConvexPolygon2D((ReferenceFrame)frame, Vertex2DSupplier.asVertex2DSupplier(vertices));
        Assert.assertTrue(sphereWithConvexPolygonIntersector.checkIfIntersectionExists(sphere, polygon));
        closestPointOnPolygon = sphereWithConvexPolygonIntersector.getClosestPointOnPolygon();
        EuclidCoreTestTools.assertEquals((String)"intersection not right", (EuclidGeometry)new Point3D(5.0, 3.0, 0.0), (EuclidGeometry)closestPointOnPolygon, (double)1.0E-12);
        closestPointOnPolygon.changeFrame((ReferenceFrame)frame);
        EuclidCoreTestTools.assertEquals((String)"intersection not right", (EuclidGeometry)new Point3D(1.0, 1.0, 0.0), (EuclidGeometry)closestPointOnPolygon, (double)1.0E-12);
        frame = new PoseReferenceFrame("testFrame4", WORLD);
        frame.setPositionWithoutChecksAndUpdate(4.0, 2.0, 0.0);
        sphere = new FrameSphere3D((ReferenceFrame)frame, 5.0, 3.0, 1.0, 2.0);
        vertices = new ArrayList();
        vertices.add(new Point2D(-1.0, -1.0));
        vertices.add(new Point2D(-1.0, 1.0));
        vertices.add(new Point2D(1.0, 1.0));
        vertices.add(new Point2D(1.0, -1.0));
        PoseReferenceFrame frame2 = new PoseReferenceFrame("testFrame4", WORLD);
        frame2.setPositionWithoutChecksAndUpdate(9.5, 5.5, 0.0);
        polygon = new FrameConvexPolygon2D((ReferenceFrame)frame2, Vertex2DSupplier.asVertex2DSupplier(vertices));
        Assert.assertTrue(sphereWithConvexPolygonIntersector.checkIfIntersectionExists(sphere, polygon));
        closestPointOnPolygon = sphereWithConvexPolygonIntersector.getClosestPointOnPolygon();
        EuclidCoreTestTools.assertEquals((String)"intersection not right", (EuclidGeometry)new Point3D(9.0, 5.0, 0.0), (EuclidGeometry)closestPointOnPolygon, (double)1.0E-12);
        closestPointOnPolygon.changeFrame((ReferenceFrame)frame2);
        EuclidCoreTestTools.assertEquals((String)"intersection not right", (EuclidGeometry)new Point3D(-0.5, -0.5, 0.0), (EuclidGeometry)closestPointOnPolygon, (double)1.0E-12);
    }
}

