/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.robotics.Assert;

public class SmallQuaternionRelationshipTest {
    @Test
    public void testSmallAngleQuaternionDifferences() {
        Vector3D vectorOne = new Vector3D(0.2, 0.4, 0.6);
        Vector3D vectorTwo = new Vector3D(-0.3, 0.4, 0.6);
        vectorOne.normalize();
        vectorTwo.normalize();
        double angleOne = 0.3;
        double angleTwo = 0.35;
        AxisAngle axisAngleOne = new AxisAngle((Vector3DReadOnly)vectorOne, angleOne);
        AxisAngle axisAngleTwo = new AxisAngle((Vector3DReadOnly)vectorTwo, angleTwo);
        Quaternion quaternionOne = new Quaternion();
        quaternionOne.set((Orientation3DReadOnly)axisAngleOne);
        Quaternion quaternionTwo = new Quaternion();
        quaternionTwo.set((Orientation3DReadOnly)axisAngleTwo);
        Quaternion quaternionError = new Quaternion((QuaternionReadOnly)quaternionOne);
        quaternionError.multiplyConjugateOther((QuaternionReadOnly)quaternionTwo);
        System.out.println("quaternionError = " + String.valueOf(quaternionError));
        Vector3D rotationVectorOne = new Vector3D((Tuple3DReadOnly)vectorOne);
        rotationVectorOne.scale(angleOne);
        Vector3D rotationVectorTwo = new Vector3D((Tuple3DReadOnly)vectorTwo);
        rotationVectorTwo.scale(angleTwo);
        Vector3D crossOneTwo = new Vector3D();
        crossOneTwo.cross((Tuple3DReadOnly)rotationVectorOne, (Tuple3DReadOnly)rotationVectorTwo);
        crossOneTwo.scale(-0.5);
        Vector3D rotationVectorError = new Vector3D((Tuple3DReadOnly)rotationVectorOne);
        rotationVectorError.sub((Tuple3DReadOnly)rotationVectorTwo);
        rotationVectorError.add((Tuple3DReadOnly)crossOneTwo);
        Vector3D errorVector = new Vector3D((Tuple3DReadOnly)rotationVectorError);
        double errorAngle = errorVector.length();
        errorVector.normalize();
        AxisAngle axisAngleError = new AxisAngle((Vector3DReadOnly)errorVector, errorAngle);
        Quaternion quaternionErrorCheck = new Quaternion();
        quaternionErrorCheck.set((Orientation3DReadOnly)axisAngleError);
        System.out.println("quaternionErrorCheck = " + String.valueOf(quaternionErrorCheck));
        Quaternion quaternionShouldBeOne = new Quaternion((QuaternionReadOnly)quaternionError);
        quaternionShouldBeOne.multiplyConjugateOther((QuaternionReadOnly)quaternionErrorCheck);
        System.out.println("quaternionShouldBeOne = " + String.valueOf(quaternionShouldBeOne));
        AxisAngle axisAngleShouldBeOne = new AxisAngle();
        axisAngleShouldBeOne.set((Orientation3DReadOnly)quaternionShouldBeOne);
        System.out.println("axisAngleShouldBeOne = " + axisAngleShouldBeOne.getAngle());
        Assert.assertTrue(axisAngleShouldBeOne.getAngle() < 0.005);
    }
}

