/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class SmallAngleRotationDerivativeTest {
    @Test
    public void test() {
        Random random = new Random(125123412L);
        AxisAngle nominalAxisAngle = EuclidCoreRandomTools.nextAxisAngle((Random)random);
        Quaternion nominalQuaternion = new Quaternion();
        nominalQuaternion.set((Orientation3DReadOnly)nominalAxisAngle);
        RotationMatrix nominalRotation = new RotationMatrix();
        nominalRotation.set((Orientation3DReadOnly)nominalQuaternion);
        Vector3D vector = EuclidCoreRandomTools.nextVector3D((Random)random);
        Vector3D transformedVector = new Vector3D((Tuple3DReadOnly)vector);
        nominalRotation.transform((Tuple3DBasics)transformedVector);
        Matrix3D jacobian = new Matrix3D();
        jacobian.setToTildeForm((Tuple3DReadOnly)vector);
        jacobian.scale(-1.0);
        jacobian.preMultiply((Matrix3DReadOnly)nominalRotation);
        double perturbationMagnitude = 1.0E-6;
        double delta = 1.0E-12;
        for (Axis3D axis : Axis3D.values()) {
            Vector3D perturbationRotationVector = new Vector3D();
            perturbationRotationVector.setElement(axis, perturbationMagnitude);
            Vector3D expected = new Vector3D((Tuple3DReadOnly)perturbationRotationVector);
            jacobian.transform((Tuple3DBasics)expected);
            AxisAngle perturbationAxisAngle = new AxisAngle((Vector3DReadOnly)perturbationRotationVector);
            Quaternion perturbationQuaternion = new Quaternion();
            perturbationQuaternion.set((Orientation3DReadOnly)perturbationAxisAngle);
            Quaternion perturbedQuaternion = new Quaternion();
            perturbedQuaternion.multiply((QuaternionReadOnly)nominalQuaternion, (QuaternionReadOnly)perturbationQuaternion);
            RotationMatrix perturbedMatrix = new RotationMatrix();
            perturbedMatrix.set((Orientation3DReadOnly)perturbedQuaternion);
            Vector3D actual = new Vector3D((Tuple3DReadOnly)vector);
            perturbedMatrix.transform((Tuple3DBasics)actual);
            actual.sub((Tuple3DReadOnly)transformedVector);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)actual, (double)delta);
        }
    }
}

