/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import gnu.trove.list.array.TDoubleArrayList;
import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.QuaternionCalculus;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.geometry.AngleTools;
import us.ihmc.robotics.geometry.RotationTools;

public class RotationToolsTest {
    private Random random = new Random(100L);
    private static final double EPSILON = 1.0E-10;

    @Test
    public void testAxisAngleEpsilonEqualsIgnoreCompleteRotations() {
        AxisAngle axisAngleB;
        AxisAngle axisAngleA;
        Vector3D randomAxis;
        double randomAngle;
        int i;
        RotationTools.AxisAngleComparisonMode mode = RotationTools.AxisAngleComparisonMode.IGNORE_FLIPPED_AXES_ROTATION_DIRECTION_AND_COMPLETE_ROTATIONS;
        for (i = 0; i < 100; ++i) {
            randomAngle = AngleTools.generateRandomAngle((Random)this.random);
            randomAxis = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0);
            double randomAngleCompleteRotations = (double)this.random.nextInt(2) * (Math.PI * 2);
            axisAngleA = new AxisAngle((Vector3DReadOnly)randomAxis, randomAngle);
            axisAngleB = new AxisAngle((Vector3DReadOnly)randomAxis, randomAngle + randomAngleCompleteRotations);
            Assertions.assertTrue((boolean)RotationTools.axisAngleEpsilonEquals((AxisAngleReadOnly)axisAngleA, (AxisAngleReadOnly)axisAngleB, (double)1.0E-10, (RotationTools.AxisAngleComparisonMode)mode), (String)(String.valueOf(axisAngleA) + "\n should equal:\n" + String.valueOf(axisAngleB) + "!"));
        }
        for (i = 0; i < 100; ++i) {
            double randomAngleNotCompleteRotations;
            randomAngle = AngleTools.generateRandomAngle((Random)this.random);
            randomAxis = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0);
            axisAngleA = new AxisAngle((Vector3DReadOnly)randomAxis, randomAngle);
            Assertions.assertTrue((!RotationTools.axisAngleEpsilonEquals((AxisAngleReadOnly)axisAngleA, (AxisAngleReadOnly)(axisAngleB = new AxisAngle((Vector3DReadOnly)randomAxis, randomAngle + (randomAngleNotCompleteRotations = (double)this.random.nextInt(2) * (Math.PI * 2) + 0.25 * AngleTools.generateRandomAngle((Random)this.random)))), (double)1.0E-10, (RotationTools.AxisAngleComparisonMode)mode) ? 1 : 0) != 0, (String)(String.valueOf(axisAngleA) + "\n should *NOT* equal:\n" + String.valueOf(axisAngleB) + "!"));
        }
    }

    @Test
    public void testAxisAngleEpsilonEqualsIgnoreFlippedAxes() {
        AxisAngle axisAngleB;
        AxisAngle axisAngleA;
        Vector3D randomAxisA_flipped;
        Vector3D randomAxisA;
        double randomAngle;
        int i;
        for (i = 0; i < 100; ++i) {
            randomAngle = AngleTools.generateRandomAngle((Random)this.random);
            randomAxisA = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0);
            randomAxisA_flipped = new Vector3D((Tuple3DReadOnly)randomAxisA);
            randomAxisA_flipped.negate();
            axisAngleA = new AxisAngle((Vector3DReadOnly)randomAxisA, randomAngle);
            axisAngleB = new AxisAngle((Vector3DReadOnly)randomAxisA_flipped, -randomAngle);
            Assertions.assertTrue((boolean)RotationTools.axisAngleEpsilonEqualsIgnoreFlippedAxes((AxisAngleReadOnly)axisAngleA, (AxisAngleReadOnly)axisAngleB, (double)1.0E-10), (String)(String.valueOf(axisAngleA) + "\n should equal:\n" + String.valueOf(axisAngleB) + "!"));
        }
        for (i = 0; i < 100; ++i) {
            randomAngle = AngleTools.generateRandomAngle((Random)this.random);
            randomAxisA = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0);
            randomAxisA_flipped = new Vector3D((Tuple3DReadOnly)randomAxisA);
            randomAxisA_flipped.negate();
            axisAngleA = new AxisAngle((Vector3DReadOnly)randomAxisA, randomAngle);
            axisAngleB = new AxisAngle((Vector3DReadOnly)randomAxisA_flipped, randomAngle);
            Assertions.assertTrue((!RotationTools.axisAngleEpsilonEqualsIgnoreFlippedAxes((AxisAngleReadOnly)axisAngleA, (AxisAngleReadOnly)axisAngleB, (double)1.0E-10) ? 1 : 0) != 0, (String)(String.valueOf(axisAngleA) + "\n should *NOT* equal:\n" + String.valueOf(axisAngleB) + "!"));
        }
    }

    @Test
    public void testAxisAngleEpsilonEqualsAnglesAreZero() {
        int numberOfTests = 100;
        for (int i = 0; i < numberOfTests; ++i) {
            Vector3D randomAxisA = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0);
            Vector3D randomAxisB = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0);
            AxisAngle axisAngleA = new AxisAngle((Vector3DReadOnly)randomAxisA, 0.0);
            AxisAngle axisAngleB = new AxisAngle((Vector3DReadOnly)randomAxisB, 0.0);
            RotationTools.AxisAngleComparisonMode mode = RotationTools.AxisAngleComparisonMode.IGNORE_FLIPPED_AXES_ROTATION_DIRECTION_AND_COMPLETE_ROTATIONS;
            Assertions.assertTrue((boolean)RotationTools.axisAngleEpsilonEquals((AxisAngleReadOnly)axisAngleA, (AxisAngleReadOnly)axisAngleB, (double)1.0E-10, (RotationTools.AxisAngleComparisonMode)mode), (String)(String.valueOf(axisAngleA) + "\n should equal:\n" + String.valueOf(axisAngleB) + "!"));
        }
    }

    @Test
    public void testAxisAngleEpsilonEqualsAnglesDivisibleByTwoPi() {
        int i;
        int numberOfTests = 100;
        RotationTools.AxisAngleComparisonMode mode = RotationTools.AxisAngleComparisonMode.IGNORE_FLIPPED_AXES_ROTATION_DIRECTION_AND_COMPLETE_ROTATIONS;
        for (i = 0; i < numberOfTests; ++i) {
            double randomAngleA_MultipleOfTwoPi = (double)this.random.nextInt(2) * (Math.PI * 2);
            double randomAngleB_MultipleOfTwoPi = (double)this.random.nextInt(2) * (Math.PI * 2);
            Vector3D randomAxisA = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0);
            Vector3D randomAxisB = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0);
            AxisAngle axisAngleA = new AxisAngle((Vector3DReadOnly)randomAxisA, randomAngleA_MultipleOfTwoPi);
            AxisAngle axisAngleB = new AxisAngle((Vector3DReadOnly)randomAxisB, randomAngleB_MultipleOfTwoPi);
            Assertions.assertTrue((boolean)RotationTools.axisAngleEpsilonEquals((AxisAngleReadOnly)axisAngleA, (AxisAngleReadOnly)axisAngleB, (double)1.0E-10, (RotationTools.AxisAngleComparisonMode)mode), (String)(String.valueOf(axisAngleA) + "\n should equal:\n" + String.valueOf(axisAngleB) + "!"));
        }
        for (i = 0; i < numberOfTests; ++i) {
            double randomAngleEpsilonToHalfPiMinusEpsilon;
            double randomAngleMultipleOfTwoPi = (double)this.random.nextInt(2) * (Math.PI * 2);
            double randomAngleNotZeroOrMultipleOfTwoPi = randomAngleMultipleOfTwoPi + (randomAngleEpsilonToHalfPiMinusEpsilon = MathTools.clamp((double)this.random.nextDouble(), (double)0.1, (double)1.4707963267948965));
            double remainder = randomAngleNotZeroOrMultipleOfTwoPi % (Math.PI * 2);
            Assertions.assertTrue((Math.abs(remainder) != 0.0 ? 1 : 0) != 0, (String)(randomAngleNotZeroOrMultipleOfTwoPi + " is divisible by 2*PI, but should not be!"));
            Vector3D randomAxisA = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0);
            Vector3D randomAxisB = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0);
            AxisAngle axisAngleA = new AxisAngle((Vector3DReadOnly)randomAxisA, randomAngleMultipleOfTwoPi);
            AxisAngle axisAngleB = new AxisAngle((Vector3DReadOnly)randomAxisB, randomAngleNotZeroOrMultipleOfTwoPi);
            Assertions.assertTrue((!RotationTools.axisAngleEpsilonEquals((AxisAngleReadOnly)axisAngleA, (AxisAngleReadOnly)axisAngleB, (double)1.0E-10, (RotationTools.AxisAngleComparisonMode)mode) ? 1 : 0) != 0, (String)(String.valueOf(axisAngleA) + "\n should *NOT* equal:\n" + String.valueOf(axisAngleB) + "!"));
        }
    }

    @Test
    public void testAxisAngleEpsilonEqualsMinusPI() {
        int i;
        int numberOfTests = 100;
        for (i = 0; i < numberOfTests; ++i) {
            Vector3D randomAxis = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0);
            AxisAngle axisAngleA = new AxisAngle((Vector3DReadOnly)randomAxis, -Math.PI);
            AxisAngle axisAngleB = new AxisAngle((Vector3DReadOnly)randomAxis, -Math.PI);
            RotationTools.AxisAngleComparisonMode mode = RotationTools.AxisAngleComparisonMode.IGNORE_FLIPPED_AXES_ROTATION_DIRECTION_AND_COMPLETE_ROTATIONS;
            Assertions.assertTrue((boolean)RotationTools.axisAngleEpsilonEquals((AxisAngleReadOnly)axisAngleA, (AxisAngleReadOnly)axisAngleB, (double)1.0E-10, (RotationTools.AxisAngleComparisonMode)mode), (String)(String.valueOf(axisAngleA) + "\n should equal:\n" + String.valueOf(axisAngleB) + "!"));
        }
        for (i = 0; i < numberOfTests; ++i) {
            RotationTools.AxisAngleComparisonMode mode;
            Vector3D randomAxisB;
            AxisAngle axisAngleB;
            Vector3D randomAxisA = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0);
            AxisAngle axisAngleA = new AxisAngle((Vector3DReadOnly)randomAxisA, -Math.PI);
            Assertions.assertTrue((!RotationTools.axisAngleEpsilonEquals((AxisAngleReadOnly)axisAngleA, (AxisAngleReadOnly)(axisAngleB = new AxisAngle((Vector3DReadOnly)(randomAxisB = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0)), -Math.PI)), (double)1.0E-10, (RotationTools.AxisAngleComparisonMode)(mode = RotationTools.AxisAngleComparisonMode.IGNORE_FLIPPED_AXES_ROTATION_DIRECTION_AND_COMPLETE_ROTATIONS)) ? 1 : 0) != 0, (String)(String.valueOf(axisAngleA) + "\n should *NOT* equal:\n" + String.valueOf(axisAngleB) + "!"));
        }
    }

    @Test
    public void testAxisAngleEpsilonEqualsPlusPI() {
        int i;
        int numberOfTests = 100;
        for (i = 0; i < numberOfTests; ++i) {
            Vector3D randomAxis = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0);
            AxisAngle axisAngleA = new AxisAngle((Vector3DReadOnly)randomAxis, Math.PI);
            AxisAngle axisAngleB = new AxisAngle((Vector3DReadOnly)randomAxis, Math.PI);
            RotationTools.AxisAngleComparisonMode mode = RotationTools.AxisAngleComparisonMode.IGNORE_FLIPPED_AXES_ROTATION_DIRECTION_AND_COMPLETE_ROTATIONS;
            Assertions.assertTrue((boolean)RotationTools.axisAngleEpsilonEquals((AxisAngleReadOnly)axisAngleA, (AxisAngleReadOnly)axisAngleB, (double)1.0E-10, (RotationTools.AxisAngleComparisonMode)mode), (String)(String.valueOf(axisAngleA) + "\n should equal:\n" + String.valueOf(axisAngleB) + "!"));
        }
        for (i = 0; i < numberOfTests; ++i) {
            RotationTools.AxisAngleComparisonMode mode;
            Vector3D randomAxisB;
            AxisAngle axisAngleB;
            Vector3D randomAxisA = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0);
            AxisAngle axisAngleA = new AxisAngle((Vector3DReadOnly)randomAxisA, Math.PI);
            Assertions.assertTrue((!RotationTools.axisAngleEpsilonEquals((AxisAngleReadOnly)axisAngleA, (AxisAngleReadOnly)(axisAngleB = new AxisAngle((Vector3DReadOnly)(randomAxisB = EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)1.0)), Math.PI)), (double)1.0E-10, (RotationTools.AxisAngleComparisonMode)(mode = RotationTools.AxisAngleComparisonMode.IGNORE_FLIPPED_AXES_ROTATION_DIRECTION_AND_COMPLETE_ROTATIONS)) ? 1 : 0) != 0, (String)(String.valueOf(axisAngleA) + "\n should *NOT* equal:\n" + String.valueOf(axisAngleB) + "!"));
        }
    }

    @Test
    public void testGetQuaternionFromYawAndZNormal() {
        double yaw = 1.0;
        double pitch = 0.4;
        double roll = 0.8;
        RotationMatrix rotationMatrixToPack = new RotationMatrix();
        rotationMatrixToPack.setYawPitchRoll(yaw, pitch, roll);
        Vector3D normal = new Vector3D();
        rotationMatrixToPack.getColumn(2, (Tuple3DBasics)normal);
        Quaternion quatToPack = new Quaternion();
        quatToPack.set((Orientation3DReadOnly)rotationMatrixToPack);
        Quaternion quatSolution = new Quaternion();
        RotationTools.computeQuaternionFromYawAndZNormal((double)yaw, (Vector3DReadOnly)normal, (QuaternionBasics)quatSolution);
        Assertions.assertTrue((boolean)RotationTools.quaternionEpsilonEquals((QuaternionReadOnly)quatToPack, (QuaternionReadOnly)quatSolution, (double)1.0E-10));
        yaw = -3.151592653589793;
        pitch = 1.5697963267948967;
        roll = 0.8;
        rotationMatrixToPack.setYawPitchRoll(yaw, pitch, roll);
        normal = new Vector3D();
        rotationMatrixToPack.getColumn(2, (Tuple3DBasics)normal);
        quatToPack.set((Orientation3DReadOnly)rotationMatrixToPack);
        quatSolution = new Quaternion();
        RotationTools.computeQuaternionFromYawAndZNormal((double)yaw, (Vector3DReadOnly)normal, (QuaternionBasics)quatSolution);
        Assertions.assertTrue((boolean)RotationTools.quaternionEpsilonEquals((QuaternionReadOnly)quatToPack, (QuaternionReadOnly)quatSolution, (double)1.0E-10));
    }

    @Test
    public void testRandomGetQuaternionFromYawAndZNormal() {
        int numTests = 100;
        Random random = new Random(7362L);
        Vector3D normal = new Vector3D();
        Quaternion quatSolution = new Quaternion();
        for (int i = 0; i < numTests; ++i) {
            Quaternion quatToPack = EuclidCoreRandomTools.nextQuaternion((Random)random);
            RotationMatrix rotationMatrixToPack = new RotationMatrix();
            double yaw = quatToPack.getYaw();
            rotationMatrixToPack.set((Orientation3DReadOnly)quatToPack);
            rotationMatrixToPack.getColumn(2, (Tuple3DBasics)normal);
            RotationTools.computeQuaternionFromYawAndZNormal((double)yaw, (Vector3DReadOnly)normal, (QuaternionBasics)quatSolution);
            boolean quaternionsAreEqual = RotationTools.quaternionEpsilonEquals((QuaternionReadOnly)quatToPack, (QuaternionReadOnly)quatSolution, (double)1.0E-10);
            Assertions.assertTrue((boolean)quaternionsAreEqual);
        }
    }

    @Test
    public void testQuaternionStuff() {
        Quaternion q = new Quaternion();
        int nTests = 100;
        for (int i = 0; i < nTests; ++i) {
            double pi = Math.PI;
            double yaw = (this.random.nextDouble() - 0.5) * 2.0 * pi;
            double pitch = (this.random.nextDouble() - 0.5) * 0.5 * pi;
            double roll = (this.random.nextDouble() - 0.5) * 2.0 * pi;
            YawPitchRoll yawPitchRoll = new YawPitchRoll(yaw, pitch, roll);
            q.setYawPitchRoll(yaw, pitch, roll);
            YawPitchRoll yawPitchRollBack = new YawPitchRoll((Orientation3DReadOnly)q);
            double epsilon = 1.0E-8;
            EuclidCoreTestTools.assertEquals((EuclidGeometry)yawPitchRoll, (EuclidGeometry)yawPitchRollBack, (double)epsilon);
        }
    }

    private void testSetQuaternionBasedOnMatrix3withQuat(Quaternion qref) {
        RotationMatrix mTest = new RotationMatrix();
        qref.normalize();
        mTest.set((Orientation3DReadOnly)qref);
        Quaternion qtest = new Quaternion();
        qtest.set((Orientation3DReadOnly)mTest);
        qtest.normalize();
        Quaternion qdiff = new Quaternion((QuaternionReadOnly)qref);
        qdiff.inverse();
        qdiff.multiply((QuaternionReadOnly)qtest);
        qdiff.normalize();
        AxisAngle axDiff = new AxisAngle();
        axDiff.set((Orientation3DReadOnly)qdiff);
        Vector3D vdiff = new Vector3D(axDiff.getX() * axDiff.getAngle(), axDiff.getY() * axDiff.getAngle(), axDiff.getZ() * axDiff.getAngle());
        Assertions.assertEquals((double)0.0, (double)vdiff.length(), (double)1.0E-5);
    }

    @Test
    public void testSetQuaternionBasedOnMatrix_Case0() {
        Quaternion[] testCases = new Quaternion[]{new Quaternion(0.0, 0.0, 0.0, 1.0), new Quaternion(1.0, 0.0, 0.0, 0.0), new Quaternion(0.0, 1.0, 0.0, 0.0), new Quaternion(0.0, 0.0, 1.0, 0.0), new Quaternion(0.559509264745704, 0.035077807528218076, -0.8227912676126732, -0.09345298295434751), new Quaternion(0.7133445472962442, -0.08371774492091577, -0.6603514244907018, -0.2192416297174736), new Quaternion(-0.7133445472962443, 0.08371774492091585, 0.6603514244907018, 0.2192416297174736), new Quaternion(-0.9917335356139193, 0.06733355650738714, 0.034281272593992815, 0.10370911655260683), new Quaternion(-0.9248702158006187, 0.08471834534956858, 0.36789564511740885, 0.04572395640984045)};
        for (int i = 0; i < testCases.length; ++i) {
            this.testSetQuaternionBasedOnMatrix3withQuat(testCases[i]);
        }
    }

    @Test
    public void testSetQuaternionBasedOnMatrix3d() {
        Random random = new Random(1776L);
        Quaternion unitQuaternion = new Quaternion(0.0, 0.0, 0.0, 1.0);
        int numberOfTests = 100000;
        for (int i = 0; i < numberOfTests; ++i) {
            Quaternion randomQuaternion = EuclidCoreRandomTools.nextQuaternion((Random)random);
            RotationMatrix rotationMatrix = new RotationMatrix();
            rotationMatrix.set((Orientation3DReadOnly)randomQuaternion);
            Quaternion quaternionToPack = new Quaternion((Orientation3DReadOnly)rotationMatrix);
            quaternionToPack.multiplyConjugateOther((QuaternionReadOnly)randomQuaternion);
            if (quaternionToPack.getS() < 0.0) {
                quaternionToPack.negate();
            }
            boolean quaternionsAreEpsilonEquals = unitQuaternion.epsilonEquals((EuclidGeometry)quaternionToPack, 1.0E-7);
            Assertions.assertTrue((boolean)quaternionsAreEpsilonEquals);
        }
    }

    @Test
    public void testIntegrateToQuaternion() throws Exception {
        for (int i = 0; i < 100; ++i) {
            double dt;
            Vector3D expectedAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)this.random);
            Vector3D actualAngularVelocity = new Vector3D();
            Quaternion integrationResultPrevious = new Quaternion();
            Quaternion integrationResultCurrent = new Quaternion();
            Quaternion integrationResultNext = new Quaternion();
            Vector4D qDot = new Vector4D();
            QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
            for (double t = dt = 1.0E-4; t <= 1.0; t += dt) {
                RotationTools.integrateAngularVelocity((Vector3DReadOnly)expectedAngularVelocity, (double)(t - dt), (QuaternionBasics)integrationResultPrevious);
                RotationTools.integrateAngularVelocity((Vector3DReadOnly)expectedAngularVelocity, (double)t, (QuaternionBasics)integrationResultCurrent);
                RotationTools.integrateAngularVelocity((Vector3DReadOnly)expectedAngularVelocity, (double)(t + dt), (QuaternionBasics)integrationResultNext);
                QuaternionCalculus.computeQDotByFiniteDifferenceCentral((QuaternionReadOnly)integrationResultPrevious, (QuaternionReadOnly)integrationResultNext, (double)dt, (Vector4DBasics)qDot);
                quaternionCalculus.computeAngularVelocityInParentFrame((QuaternionReadOnly)integrationResultCurrent, (Vector4DReadOnly)qDot, (Vector3DBasics)actualAngularVelocity);
                Assertions.assertTrue((boolean)expectedAngularVelocity.epsilonEquals((EuclidGeometry)actualAngularVelocity, 1.0E-7));
            }
        }
    }

    @Test
    public void testComputeAngularVelocityInBodyFrameFromYawPitchRollAnglesRate() throws Exception {
        double dt = 1.0E-8;
        for (int i = 0; i < 1000; ++i) {
            double yaw = RandomNumbers.nextDouble((Random)this.random, (double)Math.PI);
            double pitch = RandomNumbers.nextDouble((Random)this.random, (double)1.5707963267948966);
            double roll = RandomNumbers.nextDouble((Random)this.random, (double)Math.PI);
            double yawRate = RandomNumbers.nextDouble((Random)this.random, (double)1.0);
            double pitchRate = RandomNumbers.nextDouble((Random)this.random, (double)1.0);
            double rollRate = RandomNumbers.nextDouble((Random)this.random, (double)1.0);
            double previousYaw = yaw - yawRate * dt;
            double previousPitch = pitch - pitchRate * dt;
            double previousRoll = roll - rollRate * dt;
            Quaternion rotation = new Quaternion();
            rotation.setYawPitchRoll(yaw, pitch, roll);
            Quaternion previousRotation = new Quaternion();
            previousRotation.setYawPitchRoll(previousYaw, previousPitch, previousRoll);
            Vector3D expectedAngularVelocity = new Vector3D();
            Quaternion difference = new Quaternion();
            difference.difference((QuaternionReadOnly)previousRotation, (QuaternionReadOnly)rotation);
            difference.getRotationVector((Vector3DBasics)expectedAngularVelocity);
            expectedAngularVelocity.scale(1.0 / dt);
            Vector3D actualAngularVelocity = new Vector3D();
            RotationTools.computeAngularVelocityInBodyFrameFromYawPitchRollAnglesRate((double)yaw, (double)pitch, (double)roll, (double)yawRate, (double)pitchRate, (double)rollRate, (Vector3DBasics)actualAngularVelocity);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularVelocity, (EuclidGeometry)actualAngularVelocity, (double)1.0E-7);
        }
    }

    @Test
    public void testComputeAngularVelocityInWorldFrameFromYawPitchRollAnglesRate() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            double yaw = RandomNumbers.nextDouble((Random)this.random, (double)Math.PI);
            double pitch = RandomNumbers.nextDouble((Random)this.random, (double)1.5707963267948966);
            double roll = RandomNumbers.nextDouble((Random)this.random, (double)Math.PI);
            double yawRate = RandomNumbers.nextDouble((Random)this.random, (double)1.0);
            double pitchRate = RandomNumbers.nextDouble((Random)this.random, (double)1.0);
            double rollRate = RandomNumbers.nextDouble((Random)this.random, (double)1.0);
            Quaternion rotation = new Quaternion();
            rotation.setYawPitchRoll(yaw, pitch, roll);
            Vector3D expectedAngularVelocity = new Vector3D();
            RotationTools.computeAngularVelocityInBodyFrameFromYawPitchRollAnglesRate((double)yaw, (double)pitch, (double)roll, (double)yawRate, (double)pitchRate, (double)rollRate, (Vector3DBasics)expectedAngularVelocity);
            rotation.transform((Tuple3DBasics)expectedAngularVelocity);
            Vector3D actualAngularVelocity = new Vector3D();
            RotationTools.computeAngularVelocityInWorldFrameFromYawPitchRollAnglesRate((double)yaw, (double)pitch, (double)roll, (double)yawRate, (double)pitchRate, (double)rollRate, (Vector3DBasics)actualAngularVelocity);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularVelocity, (EuclidGeometry)actualAngularVelocity, (double)1.0E-10);
        }
    }

    @Test
    public void computeYawPitchRollAngleRatesFromAngularVelocityInBodyFrame() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            double yaw = RandomNumbers.nextDouble((Random)this.random, (double)Math.PI);
            double pitch = RandomNumbers.nextDouble((Random)this.random, (double)1.5707963267948966);
            double roll = RandomNumbers.nextDouble((Random)this.random, (double)Math.PI);
            double yawRate = RandomNumbers.nextDouble((Random)this.random, (double)1.0);
            double pitchRate = RandomNumbers.nextDouble((Random)this.random, (double)1.0);
            double rollRate = RandomNumbers.nextDouble((Random)this.random, (double)1.0);
            Vector3D angularVelocityInBodyFrame = new Vector3D();
            RotationTools.computeAngularVelocityInBodyFrameFromYawPitchRollAnglesRate((double)yaw, (double)pitch, (double)roll, (double)yawRate, (double)pitchRate, (double)rollRate, (Vector3DBasics)angularVelocityInBodyFrame);
            double[] actualYawPitchRollRates = new double[3];
            RotationTools.computeYawPitchRollAngleRatesFromAngularVelocityInBodyFrame((Vector3DReadOnly)angularVelocityInBodyFrame, (double)yaw, (double)pitch, (double)roll, (double[])actualYawPitchRollRates);
            Assertions.assertEquals((double)yawRate, (double)actualYawPitchRollRates[0], (double)1.0E-10, (String)("Iteration: " + i));
            Assertions.assertEquals((double)pitchRate, (double)actualYawPitchRollRates[1], (double)1.0E-10, (String)("Iteration: " + i));
            Assertions.assertEquals((double)rollRate, (double)actualYawPitchRollRates[2], (double)1.0E-10, (String)("Iteration: " + i));
        }
    }

    @Test
    public void computeYawPitchRollAngleRatesFromAngularVelocityInWorldFrame() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            double yaw = RandomNumbers.nextDouble((Random)this.random, (double)Math.PI);
            double pitch = RandomNumbers.nextDouble((Random)this.random, (double)1.5707963267948966);
            double roll = RandomNumbers.nextDouble((Random)this.random, (double)Math.PI);
            double yawRate = RandomNumbers.nextDouble((Random)this.random, (double)1.0);
            double pitchRate = RandomNumbers.nextDouble((Random)this.random, (double)1.0);
            double rollRate = RandomNumbers.nextDouble((Random)this.random, (double)1.0);
            Vector3D angularVelocityInWorldFrame = new Vector3D();
            RotationTools.computeAngularVelocityInWorldFrameFromYawPitchRollAnglesRate((double)yaw, (double)pitch, (double)roll, (double)yawRate, (double)pitchRate, (double)rollRate, (Vector3DBasics)angularVelocityInWorldFrame);
            double[] actualYawPitchRollRates = new double[3];
            RotationTools.computeYawPitchRollAngleRatesFromAngularVelocityInWorldFrame((Vector3DReadOnly)angularVelocityInWorldFrame, (double)yaw, (double)pitch, (double)roll, (double[])actualYawPitchRollRates);
            Assertions.assertEquals((double)yawRate, (double)actualYawPitchRollRates[0], (double)1.0E-10);
            Assertions.assertEquals((double)pitchRate, (double)actualYawPitchRollRates[1], (double)1.0E-10);
            Assertions.assertEquals((double)rollRate, (double)actualYawPitchRollRates[2], (double)1.0E-10);
        }
    }

    @Test
    public void testQuaternionAveraging() throws Exception {
        int i;
        ArrayList<Quaternion> quaternions = new ArrayList<Quaternion>();
        TDoubleArrayList weights = new TDoubleArrayList();
        int totalQuaternions = 10;
        Point3D averageEulerAngles = new Point3D();
        for (i = 0; i < totalQuaternions; ++i) {
            averageEulerAngles.add(0.1 * (double)i, (double)i * 0.02, (double)i * 0.03);
            Quaternion quaternion = new Quaternion(0.1 * (double)i, (double)i * 0.02, (double)i * 0.03);
            quaternions.add(quaternion);
        }
        for (i = 0; i < totalQuaternions; ++i) {
            weights.add(1.0);
        }
        averageEulerAngles.scale(1.0 / (double)totalQuaternions);
        Point3D averageQuaternionEulerAngles = new Point3D();
        Quaternion averageQuaternion = RotationTools.computeAverageQuaternion(quaternions, (TDoubleArrayList)weights);
        averageQuaternion.getEuler((Tuple3DBasics)averageQuaternionEulerAngles);
        LogTools.info((String)("Average Euler angles: " + String.valueOf(averageEulerAngles)));
        LogTools.info((String)("Average quaternion: " + String.valueOf(averageQuaternion)));
        LogTools.info((String)("Average Quaternion Euler Angles: " + String.valueOf(averageQuaternionEulerAngles)));
        Assertions.assertEquals((double)averageEulerAngles.getX(), (double)averageQuaternionEulerAngles.getZ(), (double)0.1);
        Assertions.assertEquals((double)averageEulerAngles.getY(), (double)averageQuaternionEulerAngles.getY(), (double)0.1);
        Assertions.assertEquals((double)averageEulerAngles.getZ(), (double)averageQuaternionEulerAngles.getX(), (double)0.1);
    }

    @Disabled
    @Test
    public void testJava3dAxisAngleSetMatrixBug() {
        RotationMatrix m = new RotationMatrix(-0.9945629970516978, -0.10063678160888465, -0.02677093728187517, -0.10063683459913739, 0.8627481429886237, 0.49551777898633176, -0.026770738081164314, 0.4955177897483468, -0.8681851459369152);
        AxisAngle a = new AxisAngle();
        a.set((Orientation3DReadOnly)m);
        RotationMatrix m2 = new RotationMatrix();
        m2.set((Orientation3DReadOnly)a);
        Assertions.assertTrue((boolean)m2.epsilonEquals((EuclidGeometry)m, 1.0E-5));
    }

    @Disabled
    @Test
    public void testJava3dQuat4dSetMatrixBug() {
        RotationMatrix m = new RotationMatrix(-0.9945629970516978, -0.10063678160888465, -0.02677093728187517, -0.10063683459913739, 0.8627481429886237, 0.49551777898633176, -0.026770738081164314, 0.4955177897483468, -0.8681851459369152);
        Quaternion a = new Quaternion();
        a.set((Orientation3DReadOnly)m);
        RotationMatrix m2 = new RotationMatrix();
        m2.set((Orientation3DReadOnly)a);
        Assertions.assertTrue((boolean)m2.epsilonEquals((EuclidGeometry)m, 1.0E-5));
    }
}

