/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;

public class QuaternionRotationRelationshipTest {
    @Test
    public void testQuaternionRotationRelationship() {
        Random random = new Random(1776L);
        int numberOfTests = 1000;
        for (int i = 0; i < numberOfTests; ++i) {
            RigidBodyTransform transform1 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            RigidBodyTransform transform2 = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            transform1.getTranslation().set((Tuple3DReadOnly)new Vector3D());
            transform2.getTranslation().set((Tuple3DReadOnly)new Vector3D());
            this.verifyRelationship(transform1, transform2);
        }
    }

    private void verifyRelationship(RigidBodyTransform transform1, RigidBodyTransform transform2) {
        Quaternion quaternion1 = new Quaternion();
        Quaternion quaternion2 = new Quaternion();
        quaternion1.set((Orientation3DReadOnly)transform1.getRotation());
        quaternion2.set((Orientation3DReadOnly)transform2.getRotation());
        Quaternion quaternion1TimesQuaternion2TimesQuaternion1Inverse = this.computeQuat1Quat2Quat1Conjugate(quaternion1, quaternion2);
        Quaternion rotatedAxisAngle2Quaternion = this.computeRotatedRotationVector(transform1, quaternion1, quaternion2);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quaternion1TimesQuaternion2TimesQuaternion1Inverse, (EuclidGeometry)rotatedAxisAngle2Quaternion, (double)1.0E-7);
    }

    private Quaternion computeRotatedRotationVector(RigidBodyTransform transform1, Quaternion quaternion1, Quaternion quaternion2) {
        AxisAngle axisAngle1 = new AxisAngle();
        axisAngle1.set((Orientation3DReadOnly)quaternion1);
        AxisAngle axisAngle2 = new AxisAngle();
        axisAngle2.set((Orientation3DReadOnly)quaternion2);
        Vector3D axisAngleVector2 = QuaternionRotationRelationshipTest.axisAngleToVector(axisAngle2);
        Vector3D rotatedAxisAngleVector2 = new Vector3D((Tuple3DReadOnly)axisAngleVector2);
        transform1.transform((Vector3DBasics)rotatedAxisAngleVector2);
        Vector3D rotatedAxisAngleVector2Normalized = new Vector3D((Tuple3DReadOnly)rotatedAxisAngleVector2);
        rotatedAxisAngleVector2Normalized.normalize();
        double rotatedAxisAngleVector2Magnitude = rotatedAxisAngleVector2.length();
        AxisAngle rotatedAxisAngle2 = new AxisAngle((Vector3DReadOnly)rotatedAxisAngleVector2Normalized, rotatedAxisAngleVector2Magnitude);
        Quaternion rotatedAxisAngle2Quaternion = new Quaternion();
        rotatedAxisAngle2Quaternion.set((Orientation3DReadOnly)rotatedAxisAngle2);
        return rotatedAxisAngle2Quaternion;
    }

    private Quaternion computeQuat1Quat2Quat1Conjugate(Quaternion quaternion1, Quaternion quaternion2) {
        Quaternion quaternion1Inverse = new Quaternion((QuaternionReadOnly)quaternion1);
        quaternion1Inverse.inverse();
        Quaternion quaternion1TimesQuaternion2 = new Quaternion();
        quaternion1TimesQuaternion2.multiply((QuaternionReadOnly)quaternion1, (QuaternionReadOnly)quaternion2);
        Quaternion quaternion1TimesQuaternion2TimesQuaternion1Inverse = new Quaternion();
        quaternion1TimesQuaternion2TimesQuaternion1Inverse.multiply((QuaternionReadOnly)quaternion1TimesQuaternion2, (QuaternionReadOnly)quaternion1Inverse);
        return quaternion1TimesQuaternion2TimesQuaternion1Inverse;
    }

    private static Vector3D axisAngleToVector(AxisAngle axisAngle) {
        Vector3D ret = new Vector3D(axisAngle.getX(), axisAngle.getY(), axisAngle.getZ());
        ret.scale(axisAngle.getAngle());
        return ret;
    }
}

