/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class PlanarRegionsListTest {
    @Test
    public void testTrivialCase() throws Exception {
        ArrayList<ConvexPolygon2D> region1ConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon1 = new ConvexPolygon2D();
        polygon1.addVertex(5.0, 1.0);
        polygon1.addVertex(5.0, -1.0);
        polygon1.addVertex(-5.0, -1.0);
        polygon1.addVertex(-5.0, 1.0);
        region1ConvexPolygons.add(polygon1);
        for (ConvexPolygon2D convexPolygon : region1ConvexPolygons) {
            convexPolygon.update();
        }
        ArrayList<ConvexPolygon2D> region2ConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon2 = new ConvexPolygon2D();
        polygon2.addVertex(1.0, 5.0);
        polygon2.addVertex(1.0, -5.0);
        polygon2.addVertex(-1.0, -5.0);
        polygon2.addVertex(-1.0, 5.0);
        region2ConvexPolygons.add(polygon2);
        for (ConvexPolygon2D convexPolygon : region2ConvexPolygons) {
            convexPolygon.update();
        }
        RigidBodyTransform region1Transform = new RigidBodyTransform();
        RigidBodyTransform region2Transform = new RigidBodyTransform();
        region2Transform.getTranslation().set(0.0, 0.0, 1.0);
        PlanarRegion planarRegion1 = new PlanarRegion((RigidBodyTransformReadOnly)region1Transform, region1ConvexPolygons);
        PlanarRegion planarRegion2 = new PlanarRegion((RigidBodyTransformReadOnly)region2Transform, region2ConvexPolygons);
        ArrayList<PlanarRegion> planarRegions = new ArrayList<PlanarRegion>();
        planarRegions.add(planarRegion1);
        planarRegions.add(planarRegion2);
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(planarRegions);
        Assert.assertEquals("Unexpected number of planar regions.", 2L, planarRegionsList.getNumberOfPlanarRegions());
        for (int i = 0; i < 2; ++i) {
            Assert.assertTrue(planarRegionsList.getPlanarRegion(i).epsilonEquals((PlanarRegion)planarRegions.get(i), 1.0E-10));
        }
        Point2D point2d = new Point2D();
        List result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane(0.0, 0.0);
        Assert.assertEquals(2L, result.size());
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane(2.0, 0.0);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion1, 1.0E-10));
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane(-2.0, 0.0);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion1, 1.0E-10));
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane(0.0, 2.0);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion2, 1.0E-10));
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane(0.0, -2.0);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion2, 1.0E-10));
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane(2.0, 2.0);
        Assert.assertNull(result);
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane(2.0, -2.0);
        Assert.assertNull(result);
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane(-2.0, -2.0);
        Assert.assertNull(result);
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane(-2.0, 2.0);
        Assert.assertNull(result);
        point2d.set(0.0, 0.0);
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane((Point2DReadOnly)point2d);
        Assert.assertEquals(2L, result.size());
        point2d.set(2.0, 0.0);
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane((Point2DReadOnly)point2d);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion1, 1.0E-10));
        point2d.set(-2.0, 0.0);
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane((Point2DReadOnly)point2d);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion1, 1.0E-10));
        point2d.set(0.0, 2.0);
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane((Point2DReadOnly)point2d);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion2, 1.0E-10));
        point2d.set(0.0, -2.0);
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane((Point2DReadOnly)point2d);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion2, 1.0E-10));
        point2d.set(2.0, 2.0);
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane((Point2DReadOnly)point2d);
        Assert.assertNull(result);
        point2d.set(2.0, -2.0);
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane((Point2DReadOnly)point2d);
        Assert.assertNull(result);
        point2d.set(-2.0, -2.0);
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane((Point2DReadOnly)point2d);
        Assert.assertNull(result);
        point2d.set(-2.0, 2.0);
        result = planarRegionsList.findPlanarRegionsContainingPointByProjectionOntoXYPlane((Point2DReadOnly)point2d);
        Assert.assertNull(result);
        Point3D point3d = new Point3D();
        double epsilon = 0.001;
        point3d.set(0.0, 0.0, 0.0);
        result = planarRegionsList.findPlanarRegionsContainingPoint((Point3DReadOnly)point3d, epsilon);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion1, 1.0E-10));
        point3d.set(0.0, 0.0, 1.0);
        result = planarRegionsList.findPlanarRegionsContainingPoint((Point3DReadOnly)point3d, epsilon);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion2, 1.0E-10));
        point3d.set(0.0, 0.0, 0.5);
        result = planarRegionsList.findPlanarRegionsContainingPoint((Point3DReadOnly)point3d, epsilon);
        Assert.assertNull(result);
        result = planarRegionsList.findPlanarRegionsContainingPoint((Point3DReadOnly)point3d, 0.51);
        Assert.assertEquals(2L, result.size());
        ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
        convexPolygon.addVertex(0.2, 0.2);
        convexPolygon.addVertex(0.2, -0.2);
        convexPolygon.addVertex(-0.2, -0.2);
        convexPolygon.addVertex(-0.2, 0.2);
        convexPolygon.update();
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(PlanarRegionsList.class, PlanarRegionsListTest.class);
    }
}

