/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.geometry.BoundingBox2D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryPolygonTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.UnitVector3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;
import us.ihmc.robotics.geometry.PlanarRegionTools;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.geometry.PlanarRegionsListGenerator;

public class PlanarRegionToolsTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-12;

    @Test
    public void testProjectInZToPlanarRegion() {
        Random random = new Random(1738L);
        for (int i = 0; i < 1000; ++i) {
            Point3D randomPointToProject = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)100.0);
            PlanarRegion randomRegion = new PlanarRegion((RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random), new ArrayList());
            Point3D projectedRandomPoint = PlanarRegionTools.projectInZToPlanarRegion((Point3DReadOnly)randomPointToProject, (PlanarRegion)randomRegion);
            UnitVector3DReadOnly surfaceNormalInWorld = randomRegion.getNormal();
            RigidBodyTransformReadOnly transformToWorld = randomRegion.getTransformToWorld();
            Point3D planarRegionReferencePointInWorld = new Point3D(0.0, 0.0, 0.0);
            transformToWorld.transform((Point3DBasics)planarRegionReferencePointInWorld);
            Vector3D verticalLine = new Vector3D(0.0, 0.0, 1.0);
            Point3D expectedProjectedPoint = EuclidGeometryTools.intersectionBetweenLine3DAndPlane3D((Point3DReadOnly)planarRegionReferencePointInWorld, (Vector3DReadOnly)surfaceNormalInWorld, (Point3DReadOnly)randomPointToProject, (Vector3DReadOnly)verticalLine);
            EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expectedProjectedPoint, (Point3DReadOnly)projectedRandomPoint, (double)1.0E-8);
        }
    }

    @Test
    public void testPointAndLinesOnPlanarRegionWithIdentityTransform() {
        ArrayList<ConvexPolygon2D> regionConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon1 = new ConvexPolygon2D();
        polygon1.addVertex(1.0, 1.0);
        polygon1.addVertex(1.0, -1.0);
        polygon1.addVertex(-1.0, -1.0);
        polygon1.addVertex(-1.0, 1.0);
        ConvexPolygon2D polygon2 = new ConvexPolygon2D();
        polygon2.addVertex(3.0, 1.0);
        polygon2.addVertex(3.0, -1.0);
        polygon2.addVertex(1.0, -1.0);
        polygon2.addVertex(1.0, 1.0);
        ConvexPolygon2D polygon3 = new ConvexPolygon2D();
        polygon3.addVertex(1.0, 3.0);
        polygon3.addVertex(1.0, 1.0);
        polygon3.addVertex(-1.0, 1.0);
        polygon3.addVertex(-1.0, 3.0);
        regionConvexPolygons.add(polygon1);
        regionConvexPolygons.add(polygon2);
        regionConvexPolygons.add(polygon3);
        for (ConvexPolygon2D convexPolygon : regionConvexPolygons) {
            convexPolygon.update();
        }
        RigidBodyTransform regionTransform = new RigidBodyTransform();
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)regionTransform, regionConvexPolygons);
        Assertions.assertEquals((int)3, (int)planarRegion.getNumberOfConvexPolygons(), (String)"Wrong number of convex polygons in the region.");
        for (int i = 0; i < 3; ++i) {
            Assertions.assertTrue((boolean)((ConvexPolygon2D)regionConvexPolygons.get(i)).epsilonEquals((EuclidGeometry)planarRegion.getConvexPolygon(i), 1.0E-10), (String)"Unexpected region polygon.");
        }
        Vector3D actualNormal = new Vector3D();
        planarRegion.getNormal((Vector3DBasics)actualNormal);
        EuclidCoreTestTools.assertVector3DGeometricallyEquals((String)"Wrong region normal.", (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0), (Vector3DReadOnly)actualNormal, (double)1.0E-10);
        Point3D actualOrigin = new Point3D();
        planarRegion.getPointInRegion((Point3DBasics)actualOrigin);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((String)"Wrong region origin.", (Point3DReadOnly)new Point3D(), (Point3DReadOnly)actualOrigin, (double)1.0E-10);
        RigidBodyTransform actualTransform = new RigidBodyTransform();
        planarRegion.getTransformToWorld(actualTransform);
        Assertions.assertTrue((boolean)regionTransform.epsilonEquals((EuclidGeometry)actualTransform, 1.0E-10), (String)"Wrong region transform to world.");
        Point2D point2d = new Point2D();
        point2d.set(0.0, 0.0);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point2DReadOnly)point2d));
        point2d.set(2.0, 0.0);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point2DReadOnly)point2d));
        point2d.set(0.0, 2.0);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point2DReadOnly)point2d));
        point2d.set(2.0, 2.0);
        Assertions.assertFalse((boolean)planarRegion.isPointInside((Point2DReadOnly)point2d));
        Point3D point3d = new Point3D();
        double maximumOrthogonalDistance = 0.001;
        point3d.set(0.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(2.0, 0.0, 0.0);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(0.0, 2.0, 0.0);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(2.0, 2.0, 0.0);
        Assertions.assertFalse((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(0.0, 0.0, -0.5 * maximumOrthogonalDistance);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(2.0, 0.0, -0.5 * maximumOrthogonalDistance);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(0.0, 2.0, -0.5 * maximumOrthogonalDistance);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(0.0, 0.0, -1.5 * maximumOrthogonalDistance);
        Assertions.assertFalse((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(2.0, 0.0, -1.5 * maximumOrthogonalDistance);
        Assertions.assertFalse((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(0.0, 2.0, -1.5 * maximumOrthogonalDistance);
        Assertions.assertFalse((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(0.0, 0.0, 0.5 * maximumOrthogonalDistance);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(2.0, 0.0, 0.5 * maximumOrthogonalDistance);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(0.0, 2.0, 0.5 * maximumOrthogonalDistance);
        Assertions.assertTrue((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(0.0, 0.0, 1.5 * maximumOrthogonalDistance);
        Assertions.assertFalse((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(2.0, 0.0, 1.5 * maximumOrthogonalDistance);
        Assertions.assertFalse((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        point3d.set(0.0, 2.0, 1.5 * maximumOrthogonalDistance);
        Assertions.assertFalse((boolean)planarRegion.isPointInside((Point3DReadOnly)point3d, maximumOrthogonalDistance));
        Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane(0.0, 0.0));
        Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane(2.0, 0.0));
        Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane(0.0, 2.0));
        Assertions.assertFalse((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane(2.0, 2.0));
        point2d.set(0.0, 0.0);
        Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point2DReadOnly)point2d));
        point2d.set(2.0, 0.0);
        Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point2DReadOnly)point2d));
        point2d.set(0.0, 2.0);
        Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point2DReadOnly)point2d));
        point2d.set(2.0, 2.0);
        Assertions.assertFalse((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point2DReadOnly)point2d));
        point3d.set(0.0, 0.0, Double.POSITIVE_INFINITY);
        Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point3DReadOnly)point3d));
        point3d.set(2.0, 0.0, Double.POSITIVE_INFINITY);
        Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point3DReadOnly)point3d));
        point3d.set(0.0, 2.0, Double.POSITIVE_INFINITY);
        Assertions.assertTrue((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point3DReadOnly)point3d));
        point3d.set(2.0, 2.0, Double.POSITIVE_INFINITY);
        Assertions.assertFalse((boolean)planarRegion.isPointInsideByProjectionOntoXYPlane((Point3DReadOnly)point3d));
        LineSegment2D lineSegment = new LineSegment2D(0.0, 0.0, 2.0, 2.0);
        Assertions.assertTrue((boolean)planarRegion.isLineSegmentIntersecting((LineSegment2DReadOnly)lineSegment));
        ArrayList intersectionsInPlaneFrame = new ArrayList();
        planarRegion.getLineSegmentIntersectionsWhenProjectedVertically(lineSegment, intersectionsInPlaneFrame);
        Assertions.assertEquals((int)3, (int)intersectionsInPlaneFrame.size());
        lineSegment = new LineSegment2D(0.0, 0.0, 0.5, 0.5);
        Assertions.assertFalse((boolean)planarRegion.isLineSegmentIntersecting((LineSegment2DReadOnly)lineSegment), (String)"Not intersecting if fully inside a single polygon");
        intersectionsInPlaneFrame.clear();
        planarRegion.getLineSegmentIntersectionsWhenProjectedVertically(lineSegment, intersectionsInPlaneFrame);
        Assertions.assertEquals((int)0, (int)intersectionsInPlaneFrame.size());
        lineSegment = new LineSegment2D(0.0, 0.0, 0.0, 1.5);
        Assertions.assertTrue((boolean)planarRegion.isLineSegmentIntersecting((LineSegment2DReadOnly)lineSegment), (String)"Intersecting if fully inside but cross two polygons");
        intersectionsInPlaneFrame.clear();
        planarRegion.getLineSegmentIntersectionsWhenProjectedVertically(lineSegment, intersectionsInPlaneFrame);
        Assertions.assertEquals((int)2, (int)intersectionsInPlaneFrame.size());
        Point2DBasics[] points = (Point2DBasics[])intersectionsInPlaneFrame.get(0);
        Assertions.assertEquals((int)1, (int)points.length);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.0, 1.0), (Point2DReadOnly)points[0], (double)1.0E-7);
        points = (Point2DBasics[])intersectionsInPlaneFrame.get(1);
        Assertions.assertEquals((int)1, (int)points.length);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(0.0, 1.0), (Point2DReadOnly)points[0], (double)1.0E-7);
        lineSegment = new LineSegment2D(2.5, 0.5, 3.0, 9.0);
        Assertions.assertTrue((boolean)planarRegion.isLineSegmentIntersecting((LineSegment2DReadOnly)lineSegment));
        lineSegment = new LineSegment2D(2.5, 4.5, 3.0, 9.0);
        Assertions.assertFalse((boolean)planarRegion.isLineSegmentIntersecting((LineSegment2DReadOnly)lineSegment), (String)"Not intersecting if fully outside");
        lineSegment = new LineSegment2D(2.0, -2.0, 2.0, 2.0);
        Assertions.assertTrue((boolean)planarRegion.isLineSegmentIntersecting((LineSegment2DReadOnly)lineSegment));
        intersectionsInPlaneFrame.clear();
        planarRegion.getLineSegmentIntersectionsWhenProjectedVertically(lineSegment, intersectionsInPlaneFrame);
        Assertions.assertEquals((int)1, (int)intersectionsInPlaneFrame.size());
        points = (Point2DBasics[])intersectionsInPlaneFrame.get(0);
        Assertions.assertEquals((int)2, (int)points.length);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(2.0, 1.0), (Point2DReadOnly)points[0], (double)1.0E-7);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)new Point2D(2.0, -1.0), (Point2DReadOnly)points[1], (double)1.0E-7);
    }

    @Test
    public void testPolygonOnPlanarRegionWithIdentityTransform() {
        List intersections;
        ArrayList<ConvexPolygon2D> regionConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon1 = new ConvexPolygon2D();
        polygon1.addVertex(1.0, 1.0);
        polygon1.addVertex(1.0, -1.0);
        polygon1.addVertex(-1.0, -1.0);
        polygon1.addVertex(-1.0, 1.0);
        ConvexPolygon2D polygon2 = new ConvexPolygon2D();
        polygon2.addVertex(3.0, 1.0);
        polygon2.addVertex(3.0, -1.0);
        polygon2.addVertex(1.0, -1.0);
        polygon2.addVertex(1.0, 1.0);
        ConvexPolygon2D polygon3 = new ConvexPolygon2D();
        polygon3.addVertex(1.0, 3.0);
        polygon3.addVertex(1.0, 1.0);
        polygon3.addVertex(-1.0, 1.0);
        polygon3.addVertex(-1.0, 3.0);
        regionConvexPolygons.add(polygon1);
        regionConvexPolygons.add(polygon2);
        regionConvexPolygons.add(polygon3);
        for (ConvexPolygon2D convexPolygon : regionConvexPolygons) {
            convexPolygon.update();
        }
        RigidBodyTransform regionTransform = new RigidBodyTransform();
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)regionTransform, regionConvexPolygons);
        ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
        convexPolygon.addVertex(0.2, 0.2);
        convexPolygon.addVertex(0.2, -0.2);
        convexPolygon.addVertex(-0.2, -0.2);
        convexPolygon.addVertex(-0.2, 0.2);
        convexPolygon.update();
        ArrayList<Point2D> translatePointsAssertTrue = new ArrayList<Point2D>();
        ArrayList<Point2D> translatePointsAssertFalse = new ArrayList<Point2D>();
        translatePointsAssertTrue.add(new Point2D(0.0, 0.0));
        translatePointsAssertTrue.add(new Point2D(2.0, 0.0));
        translatePointsAssertTrue.add(new Point2D(0.0, 2.0));
        translatePointsAssertTrue.add(new Point2D(2.0, 0.0));
        translatePointsAssertFalse.add(new Point2D(2.0, 2.0));
        translatePointsAssertFalse.add(new Point2D(-2.0, -2.0));
        translatePointsAssertFalse.add(new Point2D(1.21, 1.21));
        translatePointsAssertTrue.add(new Point2D(-1.0, 0.0));
        translatePointsAssertTrue.add(new Point2D(3.0, 0.0));
        translatePointsAssertTrue.add(new Point2D(0.0, -1.0));
        translatePointsAssertTrue.add(new Point2D(0.0, 3.0));
        translatePointsAssertTrue.add(new Point2D(1.0, 2.0));
        translatePointsAssertTrue.add(new Point2D(-1.0, -1.0));
        translatePointsAssertTrue.add(new Point2D(-1.0, 3.0));
        translatePointsAssertTrue.add(new Point2D(1.0, 3.0));
        translatePointsAssertTrue.add(new Point2D(1.09, 1.09));
        translatePointsAssertTrue.add(new Point2D(1.09, 1.21));
        translatePointsAssertFalse.add(new Point2D(-1.2, 0.0));
        translatePointsAssertFalse.add(new Point2D(3.2, 0.0));
        translatePointsAssertFalse.add(new Point2D(0.0, -1.2));
        translatePointsAssertFalse.add(new Point2D(0.0, 3.2));
        translatePointsAssertFalse.add(new Point2D(-1.2, -1.2));
        translatePointsAssertFalse.add(new Point2D(-1.2, 3.2));
        translatePointsAssertFalse.add(new Point2D(1.2, 3.2));
        translatePointsAssertFalse.add(new Point2D(3.2, 1.2));
        translatePointsAssertFalse.add(new Point2D(3.2, -1.2));
        for (Point2D d : translatePointsAssertTrue) {
            Assertions.assertTrue((boolean)planarRegion.isPolygonIntersecting((ConvexPolygon2DReadOnly)PlanarRegionToolsTest.translateConvexPolygon(d, (ConvexPolygon2DReadOnly)convexPolygon)), (String)("Translated polygon was: " + String.valueOf(PlanarRegionToolsTest.translateConvexPolygon(d, (ConvexPolygon2DReadOnly)convexPolygon)) + ", Point was: " + String.valueOf(d)));
        }
        for (Point2D point2D : translatePointsAssertFalse) {
            Assertions.assertFalse((boolean)planarRegion.isPolygonIntersecting((ConvexPolygon2DReadOnly)PlanarRegionToolsTest.translateConvexPolygon(point2D, (ConvexPolygon2DReadOnly)convexPolygon)), (String)("Translated polygon was: " + String.valueOf(PlanarRegionToolsTest.translateConvexPolygon(point2D, (ConvexPolygon2DReadOnly)convexPolygon)) + ", Point was: " + String.valueOf(point2D)));
        }
        for (int i = 0; i < translatePointsAssertTrue.size() - 2; ++i) {
            intersections = PlanarRegionTools.getPolygonIntersectionsWhenProjectedVertically((PlanarRegion)planarRegion, (ConvexPolygon2DReadOnly)PlanarRegionToolsTest.translateConvexPolygon((Point2D)translatePointsAssertTrue.get(i), (ConvexPolygon2DReadOnly)convexPolygon));
            Assertions.assertEquals((int)4, (int)intersections.size(), (String)("Translated polygon was: " + String.valueOf(PlanarRegionToolsTest.translateConvexPolygon((Point2D)translatePointsAssertTrue.get(i), (ConvexPolygon2DReadOnly)convexPolygon)) + ", Point was: " + String.valueOf(translatePointsAssertTrue.get(i))));
        }
        for (Point2D point2D : translatePointsAssertFalse) {
            intersections = PlanarRegionTools.getPolygonIntersectionsWhenProjectedVertically((PlanarRegion)planarRegion, (ConvexPolygon2DReadOnly)PlanarRegionToolsTest.translateConvexPolygon(point2D, (ConvexPolygon2DReadOnly)convexPolygon));
            Assertions.assertEquals((int)0, (int)intersections.size(), (String)("Translated polygon was: " + String.valueOf(PlanarRegionToolsTest.translateConvexPolygon(point2D, (ConvexPolygon2DReadOnly)convexPolygon)) + ", Point was: " + String.valueOf(point2D)));
        }
        intersections = PlanarRegionTools.getPolygonIntersectionsWhenProjectedVertically((PlanarRegion)planarRegion, (ConvexPolygon2DReadOnly)PlanarRegionToolsTest.translateConvexPolygon((Point2D)translatePointsAssertTrue.get(12), (ConvexPolygon2DReadOnly)convexPolygon));
        Assertions.assertEquals((int)12, (int)intersections.size());
        intersections = PlanarRegionTools.getPolygonIntersectionsWhenProjectedVertically((PlanarRegion)planarRegion, (ConvexPolygon2DReadOnly)PlanarRegionToolsTest.translateConvexPolygon((Point2D)translatePointsAssertTrue.get(13), (ConvexPolygon2DReadOnly)convexPolygon));
        Assertions.assertEquals((int)4, (int)intersections.size());
    }

    @Test
    public void testAverageCentroid2DInLocal() {
        ConvexPolygon2D bigSquare = new ConvexPolygon2D();
        bigSquare.addVertex(10.0, 10.0);
        bigSquare.addVertex(10.0, 0.0);
        bigSquare.addVertex(-10.0, 0.0);
        bigSquare.addVertex(-10.0, 10.0);
        bigSquare.update();
        ConvexPolygon2D smallSquare = new ConvexPolygon2D();
        smallSquare.addVertex(5.0, -5.0);
        smallSquare.addVertex(5.0, 0.0);
        smallSquare.addVertex(-5.0, 0.0);
        smallSquare.addVertex(-5.0, -5.0);
        smallSquare.update();
        ArrayList<ConvexPolygon2D> squares = new ArrayList<ConvexPolygon2D>();
        squares.add(smallSquare);
        squares.add(bigSquare);
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), squares);
        double totalArea = bigSquare.getArea() + smallSquare.getArea();
        Assert.assertEquals(totalArea, PlanarRegionTools.computePlanarRegionArea((PlanarRegion)planarRegion), 1.0E-12);
        Point2D expectedCentroid = new Point2D((Tuple2DReadOnly)bigSquare.getCentroid());
        expectedCentroid.scale(bigSquare.getArea() / totalArea);
        expectedCentroid.scaleAdd(smallSquare.getArea() / totalArea, (Tuple2DReadOnly)smallSquare.getCentroid(), (Tuple2DReadOnly)expectedCentroid);
        EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)expectedCentroid, (Point2DReadOnly)PlanarRegionTools.getCentroid2DInLocal((PlanarRegion)planarRegion), (double)1.0E-12);
    }

    @Test
    public void isPointInsidePlanarRegion() {
        ArrayList<Point2D> vertices = new ArrayList<Point2D>();
        vertices.add(new Point2D(0.0, 0.0));
        vertices.add(new Point2D(0.0, 1.0));
        vertices.add(new Point2D(1.0, 1.0));
        vertices.add(new Point2D(1.0, 0.0));
        ConvexPolygon2D convexPolygonB = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(vertices));
        RigidBodyTransform transformB = new RigidBodyTransform();
        PlanarRegion regionB = new PlanarRegion((RigidBodyTransformReadOnly)transformB, (Vertex2DSupplier)convexPolygonB);
        vertices.forEach(point -> Assert.assertTrue(regionB.isPointInside(point)));
        vertices.forEach(point -> Assert.assertTrue(regionB.isPointInWorld2DInside((Point3DReadOnly)new Point3D((Tuple2DReadOnly)point))));
    }

    @Test
    public void testComputeMinHeightOfRegionAAboveRegionB() {
        double[][] verticesA = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 1.0}, {1.0, 0.0}};
        ConvexPolygon2D convexPolygonA = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesA));
        RigidBodyTransform transformA = new RigidBodyTransform();
        double heightAbove = 3.0;
        transformA.getTranslation().set(0.0, 0.0, heightAbove);
        PlanarRegion regionA = new PlanarRegion((RigidBodyTransformReadOnly)transformA, (Vertex2DSupplier)convexPolygonA);
        double[][] verticesB = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 1.0}, {1.0, 0.0}};
        ConvexPolygon2D convexPolygonB = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesB));
        RigidBodyTransform transformB = new RigidBodyTransform();
        PlanarRegion regionB = new PlanarRegion((RigidBodyTransformReadOnly)transformB, (Vertex2DSupplier)convexPolygonB);
        double minHeightOfRegionAAboveRegionB = PlanarRegionTools.computeMinHeightOfRegionAAboveRegionB((PlanarRegion)regionA, (PlanarRegion)regionB);
        Assert.assertEquals(heightAbove, minHeightOfRegionAAboveRegionB, 1.0E-12);
        transformB = new RigidBodyTransform();
        double rotationAngleB = -0.4789;
        transformB.getRotation().setEuler(0.0, rotationAngleB, 0.0);
        regionB = new PlanarRegion((RigidBodyTransformReadOnly)transformB, (Vertex2DSupplier)convexPolygonB);
        minHeightOfRegionAAboveRegionB = PlanarRegionTools.computeMinHeightOfRegionAAboveRegionB((PlanarRegion)regionA, (PlanarRegion)regionB);
        Assert.assertEquals(heightAbove + Math.sin(rotationAngleB), minHeightOfRegionAAboveRegionB, 1.0E-12);
        transformA = new RigidBodyTransform();
        double rotationAngleA = 0.123;
        transformA.getTranslation().set(0.0, 0.0, heightAbove);
        transformA.getRotation().setEuler(0.0, rotationAngleA, 0.0);
        regionA = new PlanarRegion((RigidBodyTransformReadOnly)transformA, (Vertex2DSupplier)convexPolygonA);
        minHeightOfRegionAAboveRegionB = PlanarRegionTools.computeMinHeightOfRegionAAboveRegionB((PlanarRegion)regionA, (PlanarRegion)regionB);
        double expectedMinHeight = heightAbove - Math.cos(rotationAngleB) * Math.tan(rotationAngleA) * 1.0 + Math.sin(rotationAngleB);
        Assert.assertEquals(expectedMinHeight, minHeightOfRegionAAboveRegionB, 1.0E-12);
        transformA = new RigidBodyTransform();
        rotationAngleA = -1.5707963267948966;
        transformA.getTranslation().set(0.0, 0.0, heightAbove);
        transformA.getRotation().setEuler(0.0, rotationAngleA, 0.0);
        regionA = new PlanarRegion((RigidBodyTransformReadOnly)transformA, (Vertex2DSupplier)convexPolygonA);
        minHeightOfRegionAAboveRegionB = PlanarRegionTools.computeMinHeightOfRegionAAboveRegionB((PlanarRegion)regionA, (PlanarRegion)regionB);
        expectedMinHeight = heightAbove;
        Assert.assertEquals(expectedMinHeight, minHeightOfRegionAAboveRegionB, 1.0E-12);
    }

    @Test
    public void testProjectPointToPlanes() {
        ConvexPolygon2D convexPolygon = this.createUnitSquarePolygon();
        RigidBodyTransform squarePose = new RigidBodyTransform();
        PlanarRegion square = new PlanarRegion((RigidBodyTransformReadOnly)squarePose, (Vertex2DSupplier)convexPolygon);
        Point3D pointToProject = new Point3D(0.0, 0.0, 5.0);
        PlanarRegionsList regions = new PlanarRegionsList();
        regions.addPlanarRegion(square);
        Point3D projectedPoint = PlanarRegionTools.projectPointToPlanes((Point3DReadOnly)pointToProject, (PlanarRegionsList)regions);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)new Point3D(0.0, 0.0, 0.0), (Point3DReadOnly)projectedPoint, (double)1.0E-10);
    }

    private ConvexPolygon2D createUnitSquarePolygon() {
        ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
        convexPolygon.addVertex((Point2DReadOnly)new Point2D(-0.5, -0.5));
        convexPolygon.addVertex((Point2DReadOnly)new Point2D(0.5, -0.5));
        convexPolygon.addVertex((Point2DReadOnly)new Point2D(0.5, 0.5));
        convexPolygon.addVertex((Point2DReadOnly)new Point2D(-0.5, 0.5));
        convexPolygon.update();
        return convexPolygon;
    }

    @Test
    public void testIsInsidePolygon() throws Exception {
        Random random = new Random(324534L);
        for (int i = 0; i < 1000; ++i) {
            List convexPolygon2D = EuclidGeometryRandomTools.nextCircleBasedConvexPolygon2D((Random)random, (double)10.0, (double)10.0, (int)100);
            int hullSize = EuclidGeometryPolygonTools.inPlaceGiftWrapConvexHull2D((List)convexPolygon2D);
            boolean clockwiseOrdered = random.nextBoolean();
            if (!clockwiseOrdered) {
                Collections.reverse(convexPolygon2D.subList(0, hullSize));
            }
            Point2DReadOnly[] convexPolygon2DArray = convexPolygon2D.subList(0, hullSize).toArray(new Point2DReadOnly[convexPolygon2D.size()]);
            Point2D centroid = new Point2D();
            EuclidGeometryPolygonTools.computeConvexPolygon2DArea((List)convexPolygon2D, (int)hullSize, (boolean)clockwiseOrdered, (Point2DBasics)centroid);
            int vertexIndex = random.nextInt(hullSize);
            int nextVertexIndex = EuclidCoreTools.next((int)vertexIndex, (int)hullSize);
            Point2DReadOnly vertex = (Point2DReadOnly)convexPolygon2D.get(vertexIndex);
            Point2DReadOnly nextVertex = (Point2DReadOnly)convexPolygon2D.get(nextVertexIndex);
            Point2D pointOnEdge = new Point2D();
            pointOnEdge.interpolate((Tuple2DReadOnly)vertex, (Tuple2DReadOnly)nextVertex, random.nextDouble());
            double alphaOutside = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0, (double)3.0);
            Point2D outsidePoint = new Point2D();
            outsidePoint.interpolate((Tuple2DReadOnly)centroid, (Tuple2DReadOnly)pointOnEdge, alphaOutside);
            Assert.assertFalse(PlanarRegionTools.isPointInsidePolygon((Point2DReadOnly[])convexPolygon2DArray, (Point2DReadOnly)outsidePoint));
            double alphaInside = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)1.0);
            Point2D insidePoint = new Point2D();
            insidePoint.interpolate((Tuple2DReadOnly)centroid, (Tuple2DReadOnly)pointOnEdge, alphaInside);
            Assert.assertTrue(PlanarRegionTools.isPointInsidePolygon((Point2DReadOnly[])convexPolygon2DArray, (Point2DReadOnly)insidePoint));
        }
    }

    @Test
    public void testIsInsidePolygonBug1() throws Exception {
        Point2D[] polygon = new Point2D[]{new Point2D(-0.3, 0.5), new Point2D(0.3, 0.5), new Point2D(0.3, -0.5), new Point2D(-0.3, -0.5)};
        Point2D pointToCheck = new Point2D(-2.0, 0.5);
        Assert.assertFalse(PlanarRegionTools.isPointInsidePolygon((Point2DReadOnly[])polygon, (Point2DReadOnly)pointToCheck));
    }

    @Test
    public void testProjectPointToPlanesVertically() {
        Random random = new Random(1738L);
        ArrayList<PlanarRegion> listOfPlanarRegions = new ArrayList<PlanarRegion>();
        int numberOfRegions = 5;
        ConvexPolygon2D polygonInWorld = EuclidGeometryRandomTools.nextConvexPolygon2D((Random)random, (double)10.0, (int)10);
        polygonInWorld.update();
        Point2D[] concaveHull = polygonInWorld.getPolygonVerticesView().toArray(new Point2D[0]);
        Point2DReadOnly centroidInWorld = polygonInWorld.getCentroid();
        ArrayList<ConvexPolygon2D> polygons = new ArrayList<ConvexPolygon2D>();
        polygons.add(polygonInWorld);
        double layerSeparation = 0.1;
        for (int i = 0; i < numberOfRegions; ++i) {
            RigidBodyTransform transform = new RigidBodyTransform();
            transform.getTranslation().set(0.0, 0.0, (double)i * layerSeparation);
            PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transform, Arrays.asList(concaveHull), polygons);
            listOfPlanarRegions.add(planarRegion);
        }
        Point3D pointToProject = new Point3D((Tuple2DReadOnly)centroidInWorld);
        Point3D projectedPoint = PlanarRegionTools.projectPointToPlanesVertically((Point3DReadOnly)pointToProject, listOfPlanarRegions);
        Point3D expectedPoint = new Point3D((Tuple3DReadOnly)pointToProject);
        expectedPoint.setZ(layerSeparation * (double)(numberOfRegions - 1));
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)expectedPoint, (Point3DReadOnly)projectedPoint, (double)1.0E-6);
        pointToProject = new Point3D(15.0, 15.0, 100.0);
        projectedPoint = PlanarRegionTools.projectPointToPlanesVertically((Point3DReadOnly)pointToProject, listOfPlanarRegions);
        Assert.assertNull(projectedPoint);
        ConvexPolygon2D polygonA = new ConvexPolygon2D();
        polygonA.addVertex(0.5, 0.5);
        polygonA.addVertex(0.5, -0.5);
        polygonA.addVertex(-0.5, 0.5);
        polygonA.addVertex(-0.5, -0.5);
        polygonA.update();
        ConvexPolygon2D polygonB = new ConvexPolygon2D();
        polygonB.addVertex(0.5, 0.5);
        polygonB.addVertex(0.5, -0.5);
        polygonB.addVertex(-0.5, 0.5);
        polygonB.addVertex(-0.5, -0.5);
        polygonB.update();
        polygons.clear();
        polygons.add(polygonA);
        polygons.add(polygonB);
        RigidBodyTransform transformA = new RigidBodyTransform();
        RigidBodyTransform transformB = new RigidBodyTransform();
        transformA.getTranslation().set((Tuple3DReadOnly)new Vector3D(0.4, 0.0, 0.0));
        transformB.getTranslation().set((Tuple3DReadOnly)new Vector3D(-0.4, 0.0, 0.1));
        PlanarRegion regionA = new PlanarRegion((RigidBodyTransformReadOnly)transformA, (Vertex2DSupplier)polygonA);
        PlanarRegion regionB = new PlanarRegion((RigidBodyTransformReadOnly)transformB, (Vertex2DSupplier)polygonB);
        listOfPlanarRegions.clear();
        listOfPlanarRegions.add(regionA);
        listOfPlanarRegions.add(regionB);
        pointToProject = new Point3D();
        projectedPoint = PlanarRegionTools.projectPointToPlanesVertically((Point3DReadOnly)pointToProject, listOfPlanarRegions);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)new Point3D(0.0, 0.0, 0.1), (Point3DReadOnly)projectedPoint, (double)1.0E-6);
        pointToProject = new Point3D(0.09999000000000001, 0.0, 0.0);
        projectedPoint = PlanarRegionTools.projectPointToPlanesVertically((Point3DReadOnly)pointToProject, listOfPlanarRegions);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)new Point3D(0.09999000000000001, 0.0, 0.1), (Point3DReadOnly)projectedPoint, (double)1.0E-6);
        pointToProject = new Point3D(0.2, 0.0, 0.0);
        projectedPoint = PlanarRegionTools.projectPointToPlanesVertically((Point3DReadOnly)pointToProject, listOfPlanarRegions);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)new Point3D(0.2, 0.0, 0.0), (Point3DReadOnly)projectedPoint, (double)1.0E-6);
        pointToProject = new Point3D(-0.2, 0.0, 0.0);
        projectedPoint = PlanarRegionTools.projectPointToPlanesVertically((Point3DReadOnly)pointToProject, listOfPlanarRegions);
        EuclidCoreTestTools.assertPoint3DGeometricallyEquals((Point3DReadOnly)new Point3D(-0.2, 0.0, 0.1), (Point3DReadOnly)projectedPoint, (double)1.0E-6);
    }

    @Test
    public void testFilterPlanarRegionsWithBoundingCircle() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 100; ++iter) {
            RigidBodyTransform transform;
            int i;
            double maxRegionDimension = 5.0;
            double maxRegionDistanceForGuaranteedOutOfBounds = Math.sqrt(2.0 * maxRegionDimension * maxRegionDimension);
            int numberOfPoints = 5;
            ConvexPolygon2D planarRegionPolygonA = new ConvexPolygon2D();
            ConvexPolygon2D planarRegionPolygonB = new ConvexPolygon2D();
            ArrayList<Point2D> concaveHull = new ArrayList<Point2D>();
            for (int i2 = 0; i2 < numberOfPoints; ++i2) {
                Point2D pointA = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)maxRegionDimension);
                Point2D pointB = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)maxRegionDimension);
                planarRegionPolygonA.addVertex((Point2DReadOnly)pointA);
                planarRegionPolygonB.addVertex((Point2DReadOnly)pointB);
                concaveHull.add(pointA);
                concaveHull.add(pointB);
            }
            planarRegionPolygonA.update();
            planarRegionPolygonB.update();
            double maxRegionDistance = Math.max(PlanarRegionToolsTest.findFurthestPointFromOrigin(planarRegionPolygonA), PlanarRegionToolsTest.findFurthestPointFromOrigin(planarRegionPolygonB));
            ArrayList<ConvexPolygon2D> polygons = new ArrayList<ConvexPolygon2D>();
            polygons.add(planarRegionPolygonA);
            polygons.add(planarRegionPolygonB);
            int numberOfRegionsWithinDistance = random.nextInt(10);
            int numberOfRegionsOutsideOfDistance = random.nextInt(20);
            Point3D randomOrigin = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            ArrayList<PlanarRegion> regionsWithinDistanceExpected = new ArrayList<PlanarRegion>();
            ArrayList<PlanarRegion> regionsOutsideDistance = new ArrayList<PlanarRegion>();
            ArrayList<PlanarRegion> allRegions = new ArrayList<PlanarRegion>();
            for (i = 0; i < numberOfRegionsWithinDistance; ++i) {
                transform = new RigidBodyTransform();
                Vector3D translation = EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-0.2 * maxRegionDistance), (double)(0.2 * maxRegionDistance));
                translation.add((Tuple3DReadOnly)randomOrigin);
                transform.getTranslation().set((Tuple3DReadOnly)translation);
                PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transform, concaveHull, polygons);
                regionsWithinDistanceExpected.add(planarRegion);
                allRegions.add(planarRegion);
            }
            for (i = 0; i < numberOfRegionsOutsideOfDistance; ++i) {
                transform = new RigidBodyTransform();
                double xSign = RandomNumbers.nextBoolean((Random)random, (double)0.5) ? 1.0 : -1.0;
                double ySign = RandomNumbers.nextBoolean((Random)random, (double)0.5) ? 1.0 : -1.0;
                double zSign = RandomNumbers.nextBoolean((Random)random, (double)0.5) ? 1.0 : -1.0;
                double xTranslation = xSign * RandomNumbers.nextDouble((Random)random, (double)maxRegionDistanceForGuaranteedOutOfBounds, (double)100000.0);
                double yTranslation = ySign * RandomNumbers.nextDouble((Random)random, (double)maxRegionDistanceForGuaranteedOutOfBounds, (double)100000.0);
                double zTranslation = zSign * RandomNumbers.nextDouble((Random)random, (double)maxRegionDistanceForGuaranteedOutOfBounds, (double)100000.0);
                Vector3D translation = new Vector3D(xTranslation, yTranslation, zTranslation);
                translation.add((Tuple3DReadOnly)randomOrigin);
                transform.getTranslation().set((Tuple3DReadOnly)translation);
                PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transform, concaveHull, polygons);
                regionsOutsideDistance.add(planarRegion);
                allRegions.add(planarRegion);
            }
            List regionsWithinDistance = PlanarRegionTools.filterPlanarRegionsWithBoundingCircle((Point2DReadOnly)new Point2D((Tuple3DReadOnly)randomOrigin), (double)maxRegionDistance, allRegions);
            Assert.assertEquals(regionsWithinDistanceExpected.size(), regionsWithinDistance.size());
            for (PlanarRegion planarRegion : regionsWithinDistance) {
                Assert.assertTrue(regionsWithinDistanceExpected.contains(planarRegion));
                Assert.assertFalse(regionsOutsideDistance.contains(planarRegion));
            }
        }
    }

    @Test
    public void testFilterPlanarRegionsWithBoundingCirclePointWithinBigRegion() {
        ConvexPolygon2D polygon2D = new ConvexPolygon2D();
        polygon2D.addVertex(10.0, 10.0);
        polygon2D.addVertex(10.0, -10.0);
        polygon2D.addVertex(-10.0, -10.0);
        polygon2D.addVertex(-10.0, 10.0);
        polygon2D.update();
        ArrayList<ConvexPolygon2D> polygons = new ArrayList<ConvexPolygon2D>();
        polygons.add(polygon2D);
        Point2D[] concaveHull = polygon2D.getPolygonVerticesView().toArray(new Point2D[0]);
        RigidBodyTransform transform = new RigidBodyTransform();
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transform, Arrays.asList(concaveHull), polygons);
        ArrayList<PlanarRegion> planarRegionList = new ArrayList<PlanarRegion>();
        planarRegionList.add(planarRegion);
        List regionsWithinDistance = PlanarRegionTools.filterPlanarRegionsWithBoundingCircle((Point2DReadOnly)new Point2D(), (double)1.0, planarRegionList);
        Assert.assertTrue(regionsWithinDistance.contains(planarRegion));
        regionsWithinDistance = PlanarRegionTools.filterPlanarRegionsWithBoundingCircle((Point2DReadOnly)new Point2D(10.5, 0.0), (double)1.0, planarRegionList);
        Assert.assertTrue(regionsWithinDistance.contains(planarRegion));
    }

    @Test
    public void testTrivialCase() throws Exception {
        ArrayList<ConvexPolygon2D> region1ConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon1 = new ConvexPolygon2D();
        polygon1.addVertex(5.0, 1.0);
        polygon1.addVertex(5.0, -1.0);
        polygon1.addVertex(-5.0, -1.0);
        polygon1.addVertex(-5.0, 1.0);
        region1ConvexPolygons.add(polygon1);
        for (ConvexPolygon2D convexPolygon : region1ConvexPolygons) {
            convexPolygon.update();
        }
        ArrayList<ConvexPolygon2D> region2ConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon2 = new ConvexPolygon2D();
        polygon2.addVertex(1.0, 5.0);
        polygon2.addVertex(1.0, -5.0);
        polygon2.addVertex(-1.0, -5.0);
        polygon2.addVertex(-1.0, 5.0);
        region2ConvexPolygons.add(polygon2);
        for (ConvexPolygon2D convexPolygon : region2ConvexPolygons) {
            convexPolygon.update();
        }
        RigidBodyTransform region1Transform = new RigidBodyTransform();
        RigidBodyTransform region2Transform = new RigidBodyTransform();
        region2Transform.getTranslation().set(0.0, 0.0, 1.0);
        PlanarRegion planarRegion1 = new PlanarRegion((RigidBodyTransformReadOnly)region1Transform, region1ConvexPolygons);
        PlanarRegion planarRegion2 = new PlanarRegion((RigidBodyTransformReadOnly)region2Transform, region2ConvexPolygons);
        ArrayList<PlanarRegion> planarRegions = new ArrayList<PlanarRegion>();
        planarRegions.add(planarRegion1);
        planarRegions.add(planarRegion2);
        PlanarRegionsList planarRegionsList = new PlanarRegionsList(planarRegions);
        ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
        convexPolygon.addVertex(0.2, 0.2);
        convexPolygon.addVertex(0.2, -0.2);
        convexPolygon.addVertex(-0.2, -0.2);
        convexPolygon.addVertex(-0.2, 0.2);
        convexPolygon.update();
        List result = PlanarRegionTools.findPlanarRegionsIntersectingPolygon((ConvexPolygon2DReadOnly)convexPolygon, (PlanarRegionsList)planarRegionsList);
        Assert.assertEquals(2L, result.size());
        result = PlanarRegionTools.findPlanarRegionsIntersectingPolygon((ConvexPolygon2DReadOnly)PlanarRegionToolsTest.translateConvexPolygon(2.0, 0.0, (ConvexPolygon2DReadOnly)convexPolygon), (PlanarRegionsList)planarRegionsList);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion1, 1.0E-10));
        result = PlanarRegionTools.findPlanarRegionsIntersectingPolygon((ConvexPolygon2DReadOnly)PlanarRegionToolsTest.translateConvexPolygon(-2.0, 0.0, (ConvexPolygon2DReadOnly)convexPolygon), (PlanarRegionsList)planarRegionsList);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion1, 1.0E-10));
        result = PlanarRegionTools.findPlanarRegionsIntersectingPolygon((ConvexPolygon2DReadOnly)PlanarRegionToolsTest.translateConvexPolygon(0.0, 2.0, (ConvexPolygon2DReadOnly)convexPolygon), (PlanarRegionsList)planarRegionsList);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion2, 1.0E-10));
        result = PlanarRegionTools.findPlanarRegionsIntersectingPolygon((ConvexPolygon2DReadOnly)PlanarRegionToolsTest.translateConvexPolygon(0.0, -2.0, (ConvexPolygon2DReadOnly)convexPolygon), (PlanarRegionsList)planarRegionsList);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion2, 1.0E-10));
        result = PlanarRegionTools.findPlanarRegionsIntersectingPolygon((ConvexPolygon2DReadOnly)PlanarRegionToolsTest.translateConvexPolygon(2.0, 2.0, (ConvexPolygon2DReadOnly)convexPolygon), (PlanarRegionsList)planarRegionsList);
        Assert.assertNull(result);
        result = PlanarRegionTools.findPlanarRegionsIntersectingPolygon((ConvexPolygon2DReadOnly)PlanarRegionToolsTest.translateConvexPolygon(2.0, -2.0, (ConvexPolygon2DReadOnly)convexPolygon), (PlanarRegionsList)planarRegionsList);
        Assert.assertNull(result);
        result = PlanarRegionTools.findPlanarRegionsIntersectingPolygon((ConvexPolygon2DReadOnly)PlanarRegionToolsTest.translateConvexPolygon(-2.0, -2.0, (ConvexPolygon2DReadOnly)convexPolygon), (PlanarRegionsList)planarRegionsList);
        Assert.assertNull(result);
        result = PlanarRegionTools.findPlanarRegionsIntersectingPolygon((ConvexPolygon2DReadOnly)PlanarRegionToolsTest.translateConvexPolygon(-2.0, 2.0, (ConvexPolygon2DReadOnly)convexPolygon), (PlanarRegionsList)planarRegionsList);
        Assert.assertNull(result);
    }

    static ConvexPolygon2DBasics translateConvexPolygon(double xTranslation, double yTranslation, ConvexPolygon2DReadOnly convexPolygon) {
        Vector2D translation = new Vector2D(xTranslation, yTranslation);
        return convexPolygon.translateCopy((Tuple2DReadOnly)translation);
    }

    static ConvexPolygon2DBasics translateConvexPolygon(Point2D pointTranslation, ConvexPolygon2DReadOnly convexPolygon) {
        Vector2D translation = new Vector2D(pointTranslation.getX(), pointTranslation.getY());
        return convexPolygon.translateCopy((Tuple2DReadOnly)translation);
    }

    @Test
    public void testFilterPlanarRegionsWithBoundingCapsule() {
        Random random = new Random(1738L);
        for (int iter = 0; iter < 100; ++iter) {
            RigidBodyTransform transform;
            int i;
            double maxRegionDimension = 5.0;
            double maxRegionDistanceForGuaranteedOutOfBounds = Math.sqrt(2.0 * maxRegionDimension * maxRegionDimension);
            int numberOfPoints = 5;
            ConvexPolygon2D planarRegionPolygonA = new ConvexPolygon2D();
            ConvexPolygon2D planarRegionPolygonB = new ConvexPolygon2D();
            ArrayList<Point2D> concaveHull = new ArrayList<Point2D>();
            for (int i2 = 0; i2 < numberOfPoints; ++i2) {
                Point2D pointA = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)maxRegionDimension);
                Point2D pointB = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)maxRegionDimension);
                planarRegionPolygonA.addVertex((Point2DReadOnly)pointA);
                planarRegionPolygonB.addVertex((Point2DReadOnly)pointB);
                concaveHull.add(pointA);
                concaveHull.add(pointB);
            }
            planarRegionPolygonA.update();
            planarRegionPolygonB.update();
            double maxRegionDistance = Math.max(PlanarRegionToolsTest.findFurthestPointFromOrigin(planarRegionPolygonA), PlanarRegionToolsTest.findFurthestPointFromOrigin(planarRegionPolygonB));
            ArrayList<ConvexPolygon2D> polygons = new ArrayList<ConvexPolygon2D>();
            polygons.add(planarRegionPolygonA);
            polygons.add(planarRegionPolygonB);
            int numberOfRegionsWithinDistance = random.nextInt(10);
            int numberOfRegionsOutsideOfDistance = random.nextInt(20);
            Point3D randomOriginStart = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            Point3D randomOriginEnd = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
            LineSegment3D randomSegment = new LineSegment3D((Point3DReadOnly)randomOriginStart, (Point3DReadOnly)randomOriginEnd);
            Point3D midpoint = new Point3D();
            midpoint.interpolate((Tuple3DReadOnly)randomOriginStart, (Tuple3DReadOnly)randomOriginEnd, 0.5);
            ArrayList<PlanarRegion> regionsWithinDistanceExpected = new ArrayList<PlanarRegion>();
            ArrayList<PlanarRegion> regionsOutsideDistance = new ArrayList<PlanarRegion>();
            ArrayList<PlanarRegion> allRegions = new ArrayList<PlanarRegion>();
            for (i = 0; i < numberOfRegionsWithinDistance; ++i) {
                transform = new RigidBodyTransform();
                Vector3D translation = EuclidCoreRandomTools.nextVector3D((Random)random, (double)(-0.2 * maxRegionDistance), (double)(0.2 * maxRegionDistance));
                translation.add((Tuple3DReadOnly)midpoint);
                transform.getTranslation().set((Tuple3DReadOnly)translation);
                PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transform, concaveHull, polygons);
                regionsWithinDistanceExpected.add(planarRegion);
                allRegions.add(planarRegion);
            }
            for (i = 0; i < numberOfRegionsOutsideOfDistance; ++i) {
                double distanceEnd;
                double zTranslation;
                double yTranslation;
                transform = new RigidBodyTransform();
                double xSign = RandomNumbers.nextBoolean((Random)random, (double)0.5) ? 1.0 : -1.0;
                double ySign = RandomNumbers.nextBoolean((Random)random, (double)0.5) ? 1.0 : -1.0;
                double zSign = RandomNumbers.nextBoolean((Random)random, (double)0.5) ? 1.0 : -1.0;
                double xTranslation = xSign * RandomNumbers.nextDouble((Random)random, (double)maxRegionDistanceForGuaranteedOutOfBounds, (double)100000.0);
                Vector3D translation = new Vector3D(xTranslation, yTranslation = ySign * RandomNumbers.nextDouble((Random)random, (double)maxRegionDistanceForGuaranteedOutOfBounds, (double)100000.0), zTranslation = zSign * RandomNumbers.nextDouble((Random)random, (double)maxRegionDistanceForGuaranteedOutOfBounds, (double)100000.0));
                double distanceStart = randomOriginStart.distance((Point3DReadOnly)new Point3D((Tuple3DReadOnly)translation));
                if (distanceStart < (distanceEnd = randomOriginStart.distance((Point3DReadOnly)new Point3D((Tuple3DReadOnly)translation)))) {
                    translation.add((Tuple3DReadOnly)randomOriginStart);
                } else {
                    translation.add((Tuple3DReadOnly)randomOriginEnd);
                }
                transform.getTranslation().set((Tuple3DReadOnly)translation);
                PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transform, concaveHull, polygons);
                regionsOutsideDistance.add(planarRegion);
                allRegions.add(planarRegion);
            }
            List regionsWithinDistance = PlanarRegionTools.filterPlanarRegionsWithBoundingCapsule((LineSegment3D)randomSegment, (double)maxRegionDistance, allRegions);
            Assert.assertEquals(regionsWithinDistanceExpected.size(), regionsWithinDistance.size());
            for (PlanarRegion planarRegion : regionsWithinDistance) {
                Assert.assertTrue(regionsWithinDistanceExpected.contains(planarRegion));
                Assert.assertFalse(regionsOutsideDistance.contains(planarRegion));
            }
        }
    }

    @Test
    public void testFilterPlanarRegionsWithBoundingCapsulePointWithinBigRegion() {
        ConvexPolygon2D polygon2D = new ConvexPolygon2D();
        polygon2D.addVertex(10.0, 10.0);
        polygon2D.addVertex(10.0, -10.0);
        polygon2D.addVertex(-10.0, -10.0);
        polygon2D.addVertex(-10.0, 10.0);
        polygon2D.update();
        ArrayList<ConvexPolygon2D> polygons = new ArrayList<ConvexPolygon2D>();
        polygons.add(polygon2D);
        Point2D[] concaveHull = polygon2D.getPolygonVerticesView().toArray(new Point2D[0]);
        RigidBodyTransform transform = new RigidBodyTransform();
        PlanarRegion planarRegion = new PlanarRegion((RigidBodyTransformReadOnly)transform, Arrays.asList(concaveHull), polygons);
        ArrayList<PlanarRegion> planarRegionList = new ArrayList<PlanarRegion>();
        planarRegionList.add(planarRegion);
        List regionsWithinDistance = PlanarRegionTools.filterPlanarRegionsWithBoundingCapsule((Point3DReadOnly)new Point3D(0.1, 0.0, 0.0), (Point3DReadOnly)new Point3D(-0.1, 0.0, 0.0), (double)1.0, planarRegionList);
        Assert.assertTrue(regionsWithinDistance.contains(planarRegion));
        regionsWithinDistance = PlanarRegionTools.filterPlanarRegionsWithBoundingCapsule((Point3DReadOnly)new Point3D(10.5, 0.1, 0.0), (Point3DReadOnly)new Point3D(10.5, -0.1, 0.0), (double)1.0, planarRegionList);
        Assert.assertTrue(regionsWithinDistance.contains(planarRegion));
    }

    @Test
    public void testIsRegionAOverlapingWithRegionB() {
        ConvexPolygon2D polygonA = new ConvexPolygon2D();
        polygonA.addVertex(1.0, 1.0);
        polygonA.addVertex(1.0, -1.0);
        polygonA.addVertex(-1.0, -1.0);
        polygonA.addVertex(-1.0, 1.0);
        polygonA.update();
        ConvexPolygon2D polygonB = new ConvexPolygon2D();
        polygonB.addVertex(3.1, 1.0);
        polygonB.addVertex(3.1, -1.0);
        polygonB.addVertex(1.1, -1.0);
        polygonB.addVertex(1.1, 1.0);
        polygonB.update();
        PlanarRegion regionA = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), (Vertex2DSupplier)polygonA);
        PlanarRegion regionB = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), (Vertex2DSupplier)polygonB);
        double epsilonForCheck = 0.0;
        Assert.assertFalse(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionA, (PlanarRegion)regionB, (double)epsilonForCheck));
        Assert.assertFalse(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionB, (PlanarRegion)regionA, (double)epsilonForCheck));
        epsilonForCheck = 0.099;
        Assert.assertFalse(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionA, (PlanarRegion)regionB, (double)epsilonForCheck));
        Assert.assertFalse(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionB, (PlanarRegion)regionA, (double)epsilonForCheck));
        epsilonForCheck = 0.101;
        Assert.assertTrue(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionA, (PlanarRegion)regionB, (double)epsilonForCheck));
        Assert.assertTrue(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionB, (PlanarRegion)regionA, (double)epsilonForCheck));
        epsilonForCheck = 100.0;
        Assert.assertTrue(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionA, (PlanarRegion)regionB, (double)epsilonForCheck));
        Assert.assertTrue(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionB, (PlanarRegion)regionA, (double)epsilonForCheck));
        RigidBodyTransform transformC = new RigidBodyTransform();
        transformC.getRotation().setEuler(0.0, 1.5707963267948966, 0.0);
        PlanarRegion regionC = new PlanarRegion((RigidBodyTransformReadOnly)transformC, (Vertex2DSupplier)polygonA);
        epsilonForCheck = 0.0;
        Assert.assertFalse(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionB, (PlanarRegion)regionC, (double)epsilonForCheck));
        Assert.assertFalse(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionC, (PlanarRegion)regionB, (double)epsilonForCheck));
        epsilonForCheck = 1.098;
        Assert.assertFalse(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionB, (PlanarRegion)regionC, (double)epsilonForCheck));
        Assert.assertFalse(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionC, (PlanarRegion)regionB, (double)epsilonForCheck));
        epsilonForCheck = 1.102;
        Assert.assertTrue(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionB, (PlanarRegion)regionC, (double)epsilonForCheck));
        Assert.assertTrue(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionC, (PlanarRegion)regionB, (double)epsilonForCheck));
        epsilonForCheck = 100.0;
        Assert.assertTrue(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionB, (PlanarRegion)regionC, (double)epsilonForCheck));
        Assert.assertTrue(PlanarRegionTools.isRegionAOverlappingWithRegionB((PlanarRegion)regionC, (PlanarRegion)regionB, (double)epsilonForCheck));
    }

    @Test
    public void testFindPlanarRegionsContainingPointByProjectionOntoXYPlane() throws Exception {
        ArrayList<ConvexPolygon2D> region1ConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon1 = new ConvexPolygon2D();
        polygon1.addVertex(5.0, 1.0);
        polygon1.addVertex(5.0, -1.0);
        polygon1.addVertex(-5.0, -1.0);
        polygon1.addVertex(-5.0, 1.0);
        region1ConvexPolygons.add(polygon1);
        for (ConvexPolygon2D convexPolygon : region1ConvexPolygons) {
            convexPolygon.update();
        }
        ArrayList<ConvexPolygon2D> region2ConvexPolygons = new ArrayList<ConvexPolygon2D>();
        ConvexPolygon2D polygon2 = new ConvexPolygon2D();
        polygon2.addVertex(1.0, 5.0);
        polygon2.addVertex(1.0, -5.0);
        polygon2.addVertex(-1.0, -5.0);
        polygon2.addVertex(-1.0, 5.0);
        region2ConvexPolygons.add(polygon2);
        for (ConvexPolygon2D convexPolygon : region2ConvexPolygons) {
            convexPolygon.update();
        }
        RigidBodyTransform region1Transform = new RigidBodyTransform();
        RigidBodyTransform region2Transform = new RigidBodyTransform();
        region2Transform.getTranslation().set(0.0, 0.0, 1.0);
        PlanarRegion planarRegion1 = new PlanarRegion((RigidBodyTransformReadOnly)region1Transform, region1ConvexPolygons);
        PlanarRegion planarRegion2 = new PlanarRegion((RigidBodyTransformReadOnly)region2Transform, region2ConvexPolygons);
        ArrayList<PlanarRegion> planarRegions = new ArrayList<PlanarRegion>();
        planarRegions.add(planarRegion1);
        planarRegions.add(planarRegion2);
        Point2D point2d = new Point2D();
        List result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (double)0.0, (double)0.0);
        Assert.assertEquals(2L, result.size());
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (double)2.0, (double)0.0);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion1, 1.0E-10));
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (double)-2.0, (double)0.0);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion1, 1.0E-10));
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (double)0.0, (double)2.0);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion2, 1.0E-10));
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (double)0.0, (double)-2.0);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion2, 1.0E-10));
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (double)2.0, (double)2.0);
        Assert.assertNull(result);
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (double)2.0, (double)-2.0);
        Assert.assertNull(result);
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (double)-2.0, (double)-2.0);
        Assert.assertNull(result);
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (double)-2.0, (double)2.0);
        Assert.assertNull(result);
        point2d.set(0.0, 0.0);
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (Point2DReadOnly)point2d);
        Assert.assertEquals(2L, result.size());
        point2d.set(2.0, 0.0);
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (Point2DReadOnly)point2d);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion1, 1.0E-10));
        point2d.set(-2.0, 0.0);
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (Point2DReadOnly)point2d);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion1, 1.0E-10));
        point2d.set(0.0, 2.0);
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (Point2DReadOnly)point2d);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion2, 1.0E-10));
        point2d.set(0.0, -2.0);
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (Point2DReadOnly)point2d);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion2, 1.0E-10));
        point2d.set(2.0, 2.0);
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (Point2DReadOnly)point2d);
        Assert.assertNull(result);
        point2d.set(2.0, -2.0);
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (Point2DReadOnly)point2d);
        Assert.assertNull(result);
        point2d.set(-2.0, -2.0);
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (Point2DReadOnly)point2d);
        Assert.assertNull(result);
        point2d.set(-2.0, 2.0);
        result = PlanarRegionTools.findPlanarRegionsContainingPointByProjectionOntoXYPlane(planarRegions, (Point2DReadOnly)point2d);
        Assert.assertNull(result);
        Point3D point3d = new Point3D();
        double epsilon = 0.001;
        point3d.set(0.0, 0.0, 0.0);
        result = PlanarRegionTools.findPlanarRegionsContainingPoint(planarRegions, (Point3DReadOnly)point3d, (double)epsilon);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion1, 1.0E-10));
        point3d.set(0.0, 0.0, 1.0);
        result = PlanarRegionTools.findPlanarRegionsContainingPoint(planarRegions, (Point3DReadOnly)point3d, (double)epsilon);
        Assert.assertEquals(1L, result.size());
        Assert.assertTrue(((PlanarRegion)result.get(0)).epsilonEquals(planarRegion2, 1.0E-10));
        point3d.set(0.0, 0.0, 0.5);
        result = PlanarRegionTools.findPlanarRegionsContainingPoint(planarRegions, (Point3DReadOnly)point3d, (double)epsilon);
        Assert.assertNull(result);
        result = PlanarRegionTools.findPlanarRegionsContainingPoint(planarRegions, (Point3DReadOnly)point3d, (double)0.51);
        Assert.assertEquals(2L, result.size());
        ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
        convexPolygon.addVertex(0.2, 0.2);
        convexPolygon.addVertex(0.2, -0.2);
        convexPolygon.addVertex(-0.2, -0.2);
        convexPolygon.addVertex(-0.2, 0.2);
        convexPolygon.update();
    }

    @Test
    public void testIsPlanarRegionAAbovePlanarRegionB() {
        ConvexPolygon2D polygonA = new ConvexPolygon2D();
        polygonA.addVertex(1.0, 1.0);
        polygonA.addVertex(1.0, -1.0);
        polygonA.addVertex(-1.0, -1.0);
        polygonA.addVertex(-1.0, 1.0);
        polygonA.update();
        ConvexPolygon2D polygonB = new ConvexPolygon2D();
        polygonB.addVertex(3.0, 1.0);
        polygonB.addVertex(3.0, -1.0);
        polygonB.addVertex(1.0, -1.0);
        polygonB.addVertex(1.0, 1.0);
        polygonB.update();
        PlanarRegion regionA = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), (Vertex2DSupplier)polygonA);
        PlanarRegion regionB = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), (Vertex2DSupplier)polygonB);
        double epsilon = 0.01;
        Assert.assertFalse(PlanarRegionTools.isPlanarRegionAAbovePlanarRegionB((PlanarRegion)regionA, (PlanarRegion)regionB, (double)epsilon));
        Assert.assertFalse(PlanarRegionTools.isPlanarRegionAAbovePlanarRegionB((PlanarRegion)regionB, (PlanarRegion)regionA, (double)epsilon));
        RigidBodyTransform transformOne = new RigidBodyTransform();
        transformOne.getTranslation().set(0.0, 0.0, 0.99 * epsilon);
        regionA = new PlanarRegion((RigidBodyTransformReadOnly)transformOne, (Vertex2DSupplier)polygonA);
        regionB = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), (Vertex2DSupplier)polygonB);
        Assert.assertFalse(PlanarRegionTools.isPlanarRegionAAbovePlanarRegionB((PlanarRegion)regionA, (PlanarRegion)regionB, (double)epsilon));
        Assert.assertFalse(PlanarRegionTools.isPlanarRegionAAbovePlanarRegionB((PlanarRegion)regionB, (PlanarRegion)regionA, (double)epsilon));
        transformOne = new RigidBodyTransform();
        transformOne.getTranslation().set(0.0, 0.0, 1.01 * epsilon);
        regionA = new PlanarRegion((RigidBodyTransformReadOnly)transformOne, (Vertex2DSupplier)polygonA);
        regionB = new PlanarRegion((RigidBodyTransformReadOnly)new RigidBodyTransform(), (Vertex2DSupplier)polygonB);
        Assert.assertTrue(PlanarRegionTools.isPlanarRegionAAbovePlanarRegionB((PlanarRegion)regionA, (PlanarRegion)regionB, (double)epsilon));
        Assert.assertFalse(PlanarRegionTools.isPlanarRegionAAbovePlanarRegionB((PlanarRegion)regionB, (PlanarRegion)regionA, (double)epsilon));
        transformOne = new RigidBodyTransform();
        transformOne.getTranslation().set(0.0, 0.0, 0.0);
        transformOne.getRotation().setEuler(0.0, 0.7853981633974483, 0.0);
        RigidBodyTransform transformTwo = new RigidBodyTransform();
        transformTwo.getTranslation().set(-10.0, 0.0, 0.0);
        regionA = new PlanarRegion((RigidBodyTransformReadOnly)transformOne, (Vertex2DSupplier)polygonA);
        regionB = new PlanarRegion((RigidBodyTransformReadOnly)transformTwo, (Vertex2DSupplier)polygonB);
        Assert.assertTrue(PlanarRegionTools.isPlanarRegionAAbovePlanarRegionB((PlanarRegion)regionA, (PlanarRegion)regionB, (double)epsilon));
        Assert.assertFalse(PlanarRegionTools.isPlanarRegionAAbovePlanarRegionB((PlanarRegion)regionB, (PlanarRegion)regionA, (double)epsilon));
        transformTwo = new RigidBodyTransform();
        transformTwo.getTranslation().set(10.0, 0.0, 0.0);
        regionA = new PlanarRegion((RigidBodyTransformReadOnly)transformOne, (Vertex2DSupplier)polygonA);
        regionB = new PlanarRegion((RigidBodyTransformReadOnly)transformTwo, (Vertex2DSupplier)polygonB);
        Assert.assertTrue(PlanarRegionTools.isPlanarRegionAAbovePlanarRegionB((PlanarRegion)regionA, (PlanarRegion)regionB, (double)epsilon));
        Assert.assertTrue(PlanarRegionTools.isPlanarRegionAAbovePlanarRegionB((PlanarRegion)regionB, (PlanarRegion)regionA, (double)epsilon));
        transformTwo = new RigidBodyTransform();
        transformTwo.getTranslation().set(0.0, 0.0, 0.0);
        regionA = new PlanarRegion((RigidBodyTransformReadOnly)transformOne, (Vertex2DSupplier)polygonA);
        regionB = new PlanarRegion((RigidBodyTransformReadOnly)transformTwo, (Vertex2DSupplier)polygonB);
        Assert.assertTrue(PlanarRegionTools.isPlanarRegionAAbovePlanarRegionB((PlanarRegion)regionA, (PlanarRegion)regionB, (double)epsilon));
        Assert.assertTrue(PlanarRegionTools.isPlanarRegionAAbovePlanarRegionB((PlanarRegion)regionB, (PlanarRegion)regionA, (double)epsilon));
    }

    @Test
    public void testGetLocalBoundingBox2DInLocal() {
        ConvexPolygon2D polygonA = new ConvexPolygon2D();
        polygonA.addVertex(4.1, 5.0);
        polygonA.addVertex(4.0, 3.0);
        polygonA.addVertex(2.0, 3.1);
        polygonA.addVertex(2.1, 5.1);
        polygonA.update();
        RigidBodyTransform transformToWorld = new RigidBodyTransform();
        transformToWorld.getRotation().setYawPitchRoll(1.2, 3.4, 5.6);
        transformToWorld.getTranslation().set(-1.0, 2.2, 3.4);
        PlanarRegion regionA = new PlanarRegion((RigidBodyTransformReadOnly)transformToWorld, (Vertex2DSupplier)polygonA);
        BoundingBox2D boundingBox2D = PlanarRegionTools.getLocalBoundingBox2DInLocal((PlanarRegion)regionA);
        Assert.assertEquals(boundingBox2D, new BoundingBox2D(2.0, 3.0, 4.1, 5.1));
    }

    @Test
    public void testSimpleConcaveHull() {
        ConvexPolygon2D bigSquare = new ConvexPolygon2D();
        bigSquare.addVertex(10.0, 10.0);
        bigSquare.addVertex(10.0, 0.0);
        bigSquare.addVertex(-10.0, 0.0);
        bigSquare.addVertex(-10.0, 10.0);
        bigSquare.update();
        ConvexPolygon2D smallSquare = new ConvexPolygon2D();
        smallSquare.addVertex(5.0, -5.0);
        smallSquare.addVertex(5.0, 0.0);
        smallSquare.addVertex(-5.0, 0.0);
        smallSquare.addVertex(-5.0, -5.0);
        smallSquare.update();
        ConvexPolygon2D convexHull = new ConvexPolygon2D();
        bigSquare.getPolygonVerticesView().forEach(arg_0 -> ((ConvexPolygon2D)convexHull).addVertex(arg_0));
        smallSquare.getPolygonVerticesView().forEach(arg_0 -> ((ConvexPolygon2D)convexHull).addVertex(arg_0));
        convexHull.update();
        ArrayList<Point2D> concaveHull = new ArrayList<Point2D>();
        concaveHull.add(new Point2D(10.0, 10.0));
        concaveHull.add(new Point2D(10.0, 0.0));
        concaveHull.add(new Point2D(5.0, 0.0));
        concaveHull.add(new Point2D(5.0, -5.0));
        concaveHull.add(new Point2D(-5.0, -5.0));
        concaveHull.add(new Point2D(-5.0, 0.0));
        concaveHull.add(new Point2D(-10.0, 0.0));
        concaveHull.add(new Point2D(-10.0, 10.0));
        ArrayList<Point2D> emptyZone1OfConvexHull = new ArrayList<Point2D>();
        emptyZone1OfConvexHull.add(new Point2D(10.0, 0.0));
        emptyZone1OfConvexHull.add(new Point2D(5.0, -5.0));
        emptyZone1OfConvexHull.add(new Point2D(5.0, 0.0));
        ArrayList<Point2D> emptyZone2OfConvexHull = new ArrayList<Point2D>();
        emptyZone2OfConvexHull.add(new Point2D(-10.0, 0.0));
        emptyZone2OfConvexHull.add(new Point2D(-5.0, 0.0));
        emptyZone2OfConvexHull.add(new Point2D(-5.0, -5.0));
        ConvexPolygon2D emptyZone2Hull = new ConvexPolygon2D();
        emptyZone2OfConvexHull.forEach(arg_0 -> ((ConvexPolygon2D)emptyZone2Hull).addVertex(arg_0));
        emptyZone2Hull.update();
        Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)new Point2D(5.0, 0.0)));
        Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)new Point2D(-2.5, 0.0)));
        Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)new Point2D()));
        concaveHull.forEach(point -> Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull((List)concaveHull, (Point2DReadOnly)point)));
        Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)new Point2D(0.0, 10.0)));
        Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)new Point2D(10.0, 5.0)));
        Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)new Point2D(7.5, 0.0)));
        Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)new Point2D(5.0, -2.5)));
        Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)new Point2D(0.0, -5.0)));
        Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)new Point2D(-5.0, -2.5)));
        Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)new Point2D(-7.5, 0.0)));
        Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)new Point2D(-10.0, 5.0)));
        Random random = new Random(1738L);
        for (int iter = 0; iter < 1000; ++iter) {
            String message = "Iter " + iter;
            Point2DReadOnly pointInBigSquare = PlanarRegionToolsTest.getRandomInteriorPoint(random, (ConvexPolygon2DReadOnly)bigSquare);
            Point2DReadOnly pointInSmallSquare = PlanarRegionToolsTest.getRandomInteriorPoint(random, (ConvexPolygon2DReadOnly)smallSquare);
            Point2DReadOnly pointInEmptyZone1 = PlanarRegionToolsTest.getRandomInteriorPoint(random, emptyZone1OfConvexHull);
            Point2DReadOnly pointInEmptyZone2 = PlanarRegionToolsTest.getRandomInteriorPoint(random, emptyZone2Hull.getPolygonVerticesView());
            Assert.assertTrue(message, PlanarRegionTools.isPointInsidePolygon((List)bigSquare.getPolygonVerticesView(), (Point2DReadOnly)pointInBigSquare));
            Assert.assertTrue(PlanarRegionTools.isPointInsidePolygon((List)smallSquare.getPolygonVerticesView(), (Point2DReadOnly)pointInSmallSquare));
            Assert.assertTrue(PlanarRegionTools.isPointInsidePolygon(emptyZone1OfConvexHull, (Point2DReadOnly)pointInEmptyZone1));
            Assert.assertTrue(PlanarRegionTools.isPointInsidePolygon(emptyZone2OfConvexHull, (Point2DReadOnly)pointInEmptyZone2));
            Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull((List)bigSquare.getPolygonVerticesView(), (Point2DReadOnly)pointInBigSquare));
            Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull((List)smallSquare.getPolygonVerticesView(), (Point2DReadOnly)pointInSmallSquare));
            Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull(emptyZone1OfConvexHull, (Point2DReadOnly)pointInEmptyZone1));
            Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull(emptyZone2OfConvexHull, (Point2DReadOnly)pointInEmptyZone2));
            Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull((List)convexHull.getPolygonVerticesView(), (Point2DReadOnly)pointInBigSquare));
            Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull((List)convexHull.getPolygonVerticesView(), (Point2DReadOnly)pointInSmallSquare));
            Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull((List)convexHull.getPolygonVerticesView(), (Point2DReadOnly)pointInEmptyZone1));
            Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull((List)convexHull.getPolygonVerticesView(), (Point2DReadOnly)pointInEmptyZone2));
            Assert.assertTrue(message, PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)pointInBigSquare));
            Assert.assertTrue(message, PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)pointInSmallSquare));
            Assert.assertFalse(message, PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)pointInEmptyZone1));
            Assert.assertFalse(message, PlanarRegionTools.isPointInsideConcaveHull(concaveHull, (Point2DReadOnly)pointInEmptyZone2));
        }
    }

    @Test
    public void testRayIntersectsWithEdge() {
        double slope = 4.0;
        double intercept = -1.0;
        Point2D firstPointOfSegment = new Point2D(0.5, 1.0);
        Point2D secondPointOfSegment = new Point2D(1.0, 3.0);
        Assert.assertEquals(firstPointOfSegment.getY(), firstPointOfSegment.getX() * slope + intercept);
        Assert.assertEquals(secondPointOfSegment.getY(), secondPointOfSegment.getX() * slope + intercept);
        Point2D startPoint = new Point2D(0.25, 0.5);
        Assert.assertFalse(PlanarRegionTools.rayIntersectsWithEdge((Point2DReadOnly)firstPointOfSegment, (Point2DReadOnly)secondPointOfSegment, (double)startPoint.getX(), (double)startPoint.getY()));
        startPoint = new Point2D(2.0, 1.0);
        Assert.assertFalse(PlanarRegionTools.rayIntersectsWithEdge((Point2DReadOnly)firstPointOfSegment, (Point2DReadOnly)secondPointOfSegment, (double)startPoint.getX(), (double)startPoint.getY()));
        startPoint = new Point2D(0.25, 2.0);
        Assert.assertTrue(PlanarRegionTools.rayIntersectsWithEdge((Point2DReadOnly)firstPointOfSegment, (Point2DReadOnly)secondPointOfSegment, (double)startPoint.getX(), (double)startPoint.getY()));
        startPoint = new Point2D(2.0, 2.0);
        Assert.assertFalse(PlanarRegionTools.rayIntersectsWithEdge((Point2DReadOnly)firstPointOfSegment, (Point2DReadOnly)secondPointOfSegment, (double)startPoint.getX(), (double)startPoint.getY()));
        startPoint = new Point2D(0.25, 3.5);
        Assert.assertFalse(PlanarRegionTools.rayIntersectsWithEdge((Point2DReadOnly)firstPointOfSegment, (Point2DReadOnly)secondPointOfSegment, (double)startPoint.getX(), (double)startPoint.getY()));
        startPoint = new Point2D(2.0, 3.5);
        Assert.assertFalse(PlanarRegionTools.rayIntersectsWithEdge((Point2DReadOnly)firstPointOfSegment, (Point2DReadOnly)secondPointOfSegment, (double)startPoint.getX(), (double)startPoint.getY()));
    }

    @Test
    public void testSimpleVerticalAndRotatedSnap() {
        ConvexPolygon2D polygonToSnap = PlanarRegionToolsTest.createRectanglePolygon(0.5, 0.25);
        RigidBodyTransform planarRegionTransform = new RigidBodyTransform();
        planarRegionTransform.setRotationEulerAndZeroTranslation(0.1, 0.2, 0.3);
        PlanarRegionsListGenerator generator = new PlanarRegionsListGenerator();
        generator.setTransform(planarRegionTransform);
        generator.addCubeReferencedAtBottomMiddle(1.0, 0.5, 0.7);
        PlanarRegionsList planarRegionsList = generator.getPlanarRegionsList();
        Assert.assertEquals(3L, PlanarRegionTools.findPlanarRegionsIntersectingPolygon((ConvexPolygon2DReadOnly)polygonToSnap, (PlanarRegionsList)planarRegionsList).size());
    }

    public static ConvexPolygon2D createRectanglePolygon(double lengthX, double widthY) {
        ConvexPolygon2D convexPolygon = new ConvexPolygon2D();
        convexPolygon.addVertex(lengthX / 2.0, widthY / 2.0);
        convexPolygon.addVertex(-lengthX / 2.0, widthY / 2.0);
        convexPolygon.addVertex(-lengthX / 2.0, -widthY / 2.0);
        convexPolygon.addVertex(lengthX / 2.0, -widthY / 2.0);
        convexPolygon.update();
        return convexPolygon;
    }

    @Test
    public void testIsPointInsideConcaveHull() {
        Random random = new Random(1738L);
        for (int iterA = 0; iterA < 1000; ++iterA) {
            ConvexPolygon2D randomPolygon = EuclidGeometryRandomTools.nextConvexPolygon2D((Random)random, (double)10.0, (int)20);
            double perimeter = PlanarRegionToolsTest.getPerimeter((ConvexPolygon2DReadOnly)randomPolygon);
            for (int iterB = 0; iterB < 1000; ++iterB) {
                Point2D randomPoint = EuclidCoreRandomTools.nextPoint2D((Random)random, (double)10.0);
                Assert.assertEquals(randomPolygon.isPointInside((Point2DReadOnly)randomPoint), PlanarRegionTools.isPointInsideConcaveHull((List)randomPolygon.getPolygonVerticesView(), (Point2DReadOnly)randomPoint));
                Point2DReadOnly interiorPoint = PlanarRegionToolsTest.getRandomInteriorPoint(random, (ConvexPolygon2DReadOnly)randomPolygon);
                Assert.assertTrue(PlanarRegionTools.isPointInsideConcaveHull((List)randomPolygon.getPolygonVerticesView(), (Point2DReadOnly)interiorPoint));
                double distanceAlongEdge = (double)iterB / 1000.0 * perimeter;
                Point2DReadOnly pointAlongPerimeter = PlanarRegionToolsTest.getPointAlongEdge(distanceAlongEdge, (ConvexPolygon2DReadOnly)randomPolygon);
                Assert.assertTrue(randomPolygon.pointIsOnPerimeter(pointAlongPerimeter));
            }
        }
    }

    private static Point2DReadOnly getRandomInteriorPoint(Random random, ConvexPolygon2DReadOnly polygon) {
        return PlanarRegionToolsTest.getRandomInteriorPoint(random, polygon.getPolygonVerticesView());
    }

    private static Point2DReadOnly getRandomInteriorPoint(Random random, List<? extends Point2DReadOnly> points) {
        Point2D point = new Point2D();
        double maxValue = 1.0;
        for (int i = 0; i < points.size(); ++i) {
            double ratio = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)maxValue);
            if (i == points.size() - 1) {
                ratio = maxValue;
            }
            point.scaleAdd(ratio, (Tuple2DReadOnly)points.get(i), (Tuple2DReadOnly)point);
            maxValue -= ratio;
        }
        return point;
    }

    private static Point2DReadOnly getPointAlongEdge(double distanceAround, ConvexPolygon2DReadOnly polygon) {
        Point2D point = null;
        double traveledDistance = 0.0;
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            double length = polygon.getVertex(i).distance(polygon.getNextVertex(i));
            if (distanceAround - traveledDistance >= length) {
                traveledDistance += length;
                continue;
            }
            double alpha = (distanceAround - traveledDistance) / length;
            point = new Point2D();
            point.interpolate((Tuple2DReadOnly)polygon.getVertex(i), (Tuple2DReadOnly)polygon.getNextVertex(i), alpha);
            break;
        }
        return point;
    }

    private static double getPerimeter(ConvexPolygon2DReadOnly polygon2DReadOnly) {
        double distance = 0.0;
        for (int i = 0; i < polygon2DReadOnly.getNumberOfVertices(); ++i) {
            distance += polygon2DReadOnly.getVertex(i).distance(polygon2DReadOnly.getNextVertex(i));
        }
        return distance;
    }

    private static double findFurthestPointFromOrigin(ConvexPolygon2D polygon) {
        Point2D origin = new Point2D();
        double distance = 0.0;
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            distance = Math.max(distance, polygon.getVertex(i).distance((Point2DReadOnly)origin));
        }
        return distance;
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(PlanarRegionTools.class, PlanarRegionToolsTest.class);
    }
}

