/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.PlanarRegion;

public class PlanarRegionTestTools {
    public static void assertPlanarRegionsEqual(PlanarRegion expected, PlanarRegion actual, double epsilon) {
        int i;
        RigidBodyTransform expectedTransform = new RigidBodyTransform();
        RigidBodyTransform actualTransform = new RigidBodyTransform();
        expected.getTransformToWorld(expectedTransform);
        actual.getTransformToWorld(actualTransform);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTransform, (EuclidGeometry)actualTransform, (double)epsilon);
        Assert.assertEquals(expected.getConcaveHullSize(), actual.getConcaveHullSize());
        for (i = 0; i < expected.getConcaveHullSize(); ++i) {
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expected.getConcaveHullVertex(i), (EuclidGeometry)actual.getConcaveHullVertex(i), (double)epsilon);
        }
        Assert.assertEquals(expected.getNumberOfConvexPolygons(), actual.getNumberOfConvexPolygons());
        for (i = 0; i < expected.getNumberOfConvexPolygons(); ++i) {
            ConvexPolygon2D expectedConvexPolygon = expected.getConvexPolygon(i);
            ConvexPolygon2D actualConvexPolygon = actual.getConvexPolygon(i);
            Assert.assertEquals(expectedConvexPolygon.getNumberOfVertices(), actualConvexPolygon.getNumberOfVertices());
            Assert.assertTrue(expectedConvexPolygon.epsilonEquals((EuclidGeometry)actualConvexPolygon, epsilon));
        }
    }

    public static void assertPlanarRegionsGeometricallyEqual(PlanarRegion expected, PlanarRegion actual, double epsilon) {
        int i;
        RigidBodyTransform expectedTransform = new RigidBodyTransform();
        RigidBodyTransform actualTransform = new RigidBodyTransform();
        expected.getTransformToWorld(expectedTransform);
        actual.getTransformToWorld(actualTransform);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedTransform, (EuclidGeometry)actualTransform, (double)epsilon);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected.getNormal(), (EuclidGeometry)actual.getNormal(), (double)epsilon);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected.getPoint(), (EuclidGeometry)actual.getPoint(), (double)epsilon);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected.getBoundingBox3dInWorld(), (EuclidGeometry)actual.getBoundingBox3dInWorld(), (double)epsilon);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected.getConvexHull(), (EuclidGeometry)actual.getConvexHull(), (double)epsilon);
        Assert.assertEquals(expected.getConcaveHullSize(), actual.getConcaveHullSize());
        for (i = 0; i < expected.getConcaveHullSize(); ++i) {
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expected.getConcaveHullVertex(i), (EuclidGeometry)actual.getConcaveHullVertex(i), (double)epsilon);
        }
        Assert.assertEquals(expected.getNumberOfConvexPolygons(), actual.getNumberOfConvexPolygons());
        for (i = 0; i < expected.getNumberOfConvexPolygons(); ++i) {
            ConvexPolygon2D expectedConvexPolygon = expected.getConvexPolygon(i);
            ConvexPolygon2D actualConvexPolygon = actual.getConvexPolygon(i);
            EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)expectedConvexPolygon, (EuclidGeometry)actualConvexPolygon, (double)epsilon);
        }
    }
}

