/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.GroundPlaneEstimator;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.robotics.robotSide.QuadrantDependentList;
import us.ihmc.robotics.robotSide.RobotEnd;
import us.ihmc.robotics.robotSide.RobotQuadrant;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.tools.MemoryTools;

public class GroundPlaneEstimatorTest {
    @BeforeEach
    public void showMemoryUsageBeforeTest() {
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)(this.getClass().getSimpleName() + " before test."));
    }

    @AfterEach
    public void destroySimulationAndRecycleMemory() {
        ReferenceFrameTools.clearWorldFrameTree();
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)(this.getClass().getSimpleName() + " after test."));
    }

    @Test
    public void testPointsWithSamePitchAndDifferentPositionGetSameAnswer() {
        GroundPlaneEstimator groundPlaneEstimator = new GroundPlaneEstimator();
        ArrayList<FramePoint3D> pointListA = new ArrayList<FramePoint3D>();
        Plane3D plane3dA = new Plane3D();
        pointListA.add(new FramePoint3D(ReferenceFrame.getWorldFrame(), 1.0, 1.0, 0.1));
        pointListA.add(new FramePoint3D(ReferenceFrame.getWorldFrame(), 1.0, -1.0, 0.1));
        pointListA.add(new FramePoint3D(ReferenceFrame.getWorldFrame(), -1.0, 1.0, -0.1));
        pointListA.add(new FramePoint3D(ReferenceFrame.getWorldFrame(), -1.0, -1.0, -0.1));
        groundPlaneEstimator.compute(pointListA);
        groundPlaneEstimator.getPlane(plane3dA);
        Vector3D normalA = new Vector3D((Tuple3DReadOnly)plane3dA.getNormal());
        ArrayList<FramePoint3D> pointListB = new ArrayList<FramePoint3D>();
        Plane3D plane3dB = new Plane3D();
        pointListB.add(new FramePoint3D(ReferenceFrame.getWorldFrame(), 5.0, 5.0, 0.1));
        pointListB.add(new FramePoint3D(ReferenceFrame.getWorldFrame(), 5.0, 3.0, 0.1));
        pointListB.add(new FramePoint3D(ReferenceFrame.getWorldFrame(), 3.0, 5.0, -0.1));
        pointListB.add(new FramePoint3D(ReferenceFrame.getWorldFrame(), 3.0, 3.0, -0.1));
        groundPlaneEstimator.compute(pointListB);
        groundPlaneEstimator.getPlane(plane3dB);
        Vector3D normalB = new Vector3D((Tuple3DReadOnly)plane3dB.getNormal());
        Assert.assertTrue(normalA.epsilonEquals((EuclidGeometry)normalB, 1.0E-7));
    }

    @Test
    public void testPointsWithSamePitchAndDifferentPositionGetSameAnswer2() {
        double epsilon = 0.001;
        Random random = new Random(123123L);
        GroundPlaneEstimator groundPlaneEstimator = new GroundPlaneEstimator();
        QuadrantDependentList contactPoints = new QuadrantDependentList();
        FramePose3D centerOfFeetPose = new FramePose3D(ReferenceFrame.getWorldFrame());
        PoseReferenceFrame centerOfFeetFrame = new PoseReferenceFrame("centerOfFeetFrame", (FramePose3DReadOnly)centerOfFeetPose);
        this.putFeetOnPlane(random, (QuadrantDependentList<FramePoint3D>)contactPoints, centerOfFeetFrame);
        double actualPitch = 0.25;
        centerOfFeetPose.getOrientation().setYawPitchRoll(centerOfFeetPose.getYaw(), actualPitch, centerOfFeetPose.getRoll());
        centerOfFeetFrame.setPoseAndUpdate((FramePose3DReadOnly)centerOfFeetPose);
        groundPlaneEstimator.compute(contactPoints);
        double computedPitch = groundPlaneEstimator.getPitch();
        Assert.assertEquals(actualPitch, computedPitch, epsilon);
        this.changeFrame((QuadrantDependentList<FramePoint3D>)contactPoints, centerOfFeetFrame);
        double x = (double)random.nextInt(1000) + random.nextDouble();
        double y = (double)random.nextInt(1000) + random.nextDouble();
        double z = (double)random.nextInt(1000) + random.nextDouble();
        centerOfFeetPose.getPosition().set(x, y, z);
        centerOfFeetFrame.setPoseAndUpdate((FramePose3DReadOnly)centerOfFeetPose);
        groundPlaneEstimator.compute(contactPoints);
        computedPitch = groundPlaneEstimator.getPitch();
        Assert.assertEquals(actualPitch, computedPitch, epsilon);
    }

    @Disabled
    @Test
    public void testGetPitchWithFeetOnPlane() {
        double epsilon = 1.0E-5;
        Random random = new Random();
        GroundPlaneEstimator groundPlaneEstimator = new GroundPlaneEstimator();
        QuadrantDependentList contactPoints = new QuadrantDependentList();
        FramePose3D centerOfFeetPose = new FramePose3D(ReferenceFrame.getWorldFrame());
        PoseReferenceFrame centerOfFeetFrame = new PoseReferenceFrame("centerOfFeetFrame", (FramePose3DReadOnly)centerOfFeetPose);
        this.putFeetOnPlane(random, (QuadrantDependentList<FramePoint3D>)contactPoints, centerOfFeetFrame);
        groundPlaneEstimator.compute(contactPoints);
        double actualPitch = centerOfFeetPose.getPitch();
        double computedPitch = groundPlaneEstimator.getPitch();
        Assert.assertTrue(MathTools.epsilonEquals((double)actualPitch, (double)computedPitch, (double)epsilon));
        this.changeFrame((QuadrantDependentList<FramePoint3D>)contactPoints, centerOfFeetFrame);
        centerOfFeetPose.getOrientation().setYawPitchRoll(centerOfFeetPose.getYaw(), 0.1, centerOfFeetPose.getRoll());
        centerOfFeetFrame.setPoseAndUpdate((FramePose3DReadOnly)centerOfFeetPose);
        groundPlaneEstimator.compute(contactPoints);
        computedPitch = groundPlaneEstimator.getPitch();
        Assert.assertFalse(MathTools.epsilonEquals((double)0.0, (double)computedPitch, (double)epsilon));
        this.changeFrame((QuadrantDependentList<FramePoint3D>)contactPoints, centerOfFeetFrame);
        actualPitch = random.nextDouble() * 0.5 - 0.25;
        centerOfFeetPose.getOrientation().setYawPitchRoll(centerOfFeetPose.getYaw(), actualPitch, centerOfFeetPose.getRoll());
        centerOfFeetFrame.setPoseAndUpdate((FramePose3DReadOnly)centerOfFeetPose);
        groundPlaneEstimator.compute(contactPoints);
        computedPitch = groundPlaneEstimator.getPitch();
        Assert.assertTrue(MathTools.epsilonEquals((double)actualPitch, (double)computedPitch, (double)epsilon));
        FrameVector3D normal = new FrameVector3D();
        FrameVector3D normal2 = new FrameVector3D();
        groundPlaneEstimator.getPlaneNormal((FixedFrameVector3DBasics)normal);
        this.changeFrame((QuadrantDependentList<FramePoint3D>)contactPoints, centerOfFeetFrame);
        double x = (double)random.nextInt(1000) + random.nextDouble();
        double y = (double)random.nextInt(1000) + random.nextDouble();
        double z = (double)random.nextInt(1000) + random.nextDouble();
        centerOfFeetPose.getPosition().set(x, y, z);
        centerOfFeetFrame.setPoseAndUpdate((FramePose3DReadOnly)centerOfFeetPose);
        groundPlaneEstimator.compute(contactPoints);
        computedPitch = groundPlaneEstimator.getPitch();
        groundPlaneEstimator.getPlaneNormal((FixedFrameVector3DBasics)normal2);
        Assert.assertTrue(normal.epsilonEquals((EuclidFrameGeometry)normal2, epsilon));
        Assert.assertTrue(MathTools.epsilonEquals((double)actualPitch, (double)computedPitch, (double)epsilon));
        groundPlaneEstimator.compute(contactPoints);
        groundPlaneEstimator.compute(contactPoints);
        groundPlaneEstimator.compute(contactPoints);
        groundPlaneEstimator.compute(contactPoints);
        groundPlaneEstimator.compute(contactPoints);
        groundPlaneEstimator.compute(contactPoints);
        computedPitch = groundPlaneEstimator.getPitch();
        Assert.assertTrue(MathTools.epsilonEquals((double)actualPitch, (double)computedPitch, (double)epsilon));
    }

    private void putFeetOnPlane(Random random, QuadrantDependentList<FramePoint3D> contactPoints, PoseReferenceFrame centerOfFeetFrame) {
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            FramePoint3D contactPoint = new FramePoint3D((ReferenceFrame)centerOfFeetFrame);
            int xSign = robotQuadrant.getEnd() == RobotEnd.FRONT ? 1 : -1;
            contactPoint.setX((double)xSign * random.nextDouble());
            int ySign = robotQuadrant.getSide() == RobotSide.LEFT ? 1 : -1;
            contactPoint.setY((double)ySign * random.nextDouble());
            contactPoints.set((Enum)robotQuadrant, (Object)contactPoint);
        }
    }

    private void changeFrame(QuadrantDependentList<FramePoint3D> contactPoints, PoseReferenceFrame centerOfFeetFrame) {
        for (RobotQuadrant robotQuadrant : RobotQuadrant.values) {
            ((FramePoint3D)contactPoints.get((Enum)robotQuadrant)).changeFrame((ReferenceFrame)centerOfFeetFrame);
        }
    }
}

