/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.Random;
import org.ejml.data.DMatrixRMaj;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.GeoregressionConversionTools;

public class GeoregressionConversionToolsTest {
    private static final double eps = 1.0E-7;

    @Test
    public void testTransformConversionFromGeoregressionToVecmath() {
        Random rand = new Random(123384L);
        for (int i = 0; i < 100000; ++i) {
            double x = rand.nextGaussian();
            double y = rand.nextGaussian();
            double z = rand.nextGaussian();
            Point3D vecmathPoint = new Point3D(x, y, z);
            Point3D_F64 georegressionPoint = new Point3D_F64(x, y, z);
            Se3_F64 georegressionTransform = new Se3_F64();
            RigidBodyTransform vecmathTransform = new RigidBodyTransform();
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)rand);
            georegressionTransform.setTranslation(rand.nextGaussian(), rand.nextGaussian(), rand.nextGaussian());
            georegressionTransform.setRotation(new DMatrixRMaj((double[][])new double[][]{{rotationMatrix.getM00(), rotationMatrix.getM01(), rotationMatrix.getM02()}, {rotationMatrix.getM10(), rotationMatrix.getM11(), rotationMatrix.getM12()}, {rotationMatrix.getM20(), rotationMatrix.getM21(), rotationMatrix.getM22()}}));
            GeoregressionConversionTools.setVecmathTransformFromGeoregressionTransform((RigidBodyTransform)vecmathTransform, (Se3_F64)georegressionTransform);
            vecmathTransform.transform((Point3DBasics)vecmathPoint);
            Point3D_F64 georegressionTransformResultPoint = new Point3D_F64();
            SePointOps_F64.transform((Se3_F64)georegressionTransform, (Point3D_F64)georegressionPoint, (Point3D_F64)georegressionTransformResultPoint);
            Assert.assertEquals(georegressionTransformResultPoint.x, vecmathPoint.getX(), 1.0E-7);
            Assert.assertEquals(georegressionTransformResultPoint.y, vecmathPoint.getY(), 1.0E-7);
            Assert.assertEquals(georegressionTransformResultPoint.z, vecmathPoint.getZ(), 1.0E-7);
        }
    }

    @Test
    public void testTransformConversionFromVecmathToGeoregression() {
        Random random = new Random(123384L);
        for (int i = 0; i < 100000; ++i) {
            double x = random.nextGaussian();
            double y = random.nextGaussian();
            double z = random.nextGaussian();
            Point3D vecmathPoint = new Point3D(x, y, z);
            Point3D_F64 georegressionPoint = new Point3D_F64(x, y, z);
            Se3_F64 georegressionTransform = new Se3_F64();
            RigidBodyTransform vecmathTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            GeoregressionConversionTools.setGeoregressionTransformFromVecmath((RigidBodyTransform)vecmathTransform, (Se3_F64)georegressionTransform);
            vecmathTransform.transform((Point3DBasics)vecmathPoint);
            Point3D_F64 georegressionTransformResultPoint = new Point3D_F64();
            SePointOps_F64.transform((Se3_F64)georegressionTransform, (Point3D_F64)georegressionPoint, (Point3D_F64)georegressionTransformResultPoint);
            Assert.assertEquals(georegressionTransformResultPoint.x, vecmathPoint.getX(), 1.0E-7);
            Assert.assertEquals(georegressionTransformResultPoint.y, vecmathPoint.getY(), 1.0E-7);
            Assert.assertEquals(georegressionTransformResultPoint.z, vecmathPoint.getZ(), 1.0E-7);
        }
    }
}

