/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.UnitVector3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.EuclidGeometryMissingTools;
import us.ihmc.robotics.geometry.GeometryTools;

public class GeometryToolsTest {
    private static final int ITERATIONS = 1000;
    private static final double EPSILON = 1.0E-6;

    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testGetDistanceBetweenPointAndPlane1() {
        FramePoint3D pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        FrameVector3D planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 0.0, 1.0);
        FramePoint3D point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 3.0);
        double actual = GeometryTools.distanceFromPointToPlane((FramePoint3D)point, (FramePoint3D)pointOnPlane, (FrameVector3D)planeNormal);
        double expected = 3.0;
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-6, (String)"FAILED: Distance from point to plane");
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 0.0, 1.0);
        point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 3.0, 3.0, -3.0);
        actual = GeometryTools.distanceFromPointToPlane((FramePoint3D)point, (FramePoint3D)pointOnPlane, (FrameVector3D)planeNormal);
        expected = 3.0;
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-6, (String)"FAILED: Distance from point to plane");
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 0.0, 1.0);
        point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, -3.0);
        actual = GeometryTools.distanceFromPointToPlane((FramePoint3D)point, (FramePoint3D)pointOnPlane, (FrameVector3D)planeNormal);
        expected = 3.0;
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-6, (String)"FAILED: Distance from point to plane");
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 3.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 0.0, 1.0);
        point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, -3.0);
        actual = GeometryTools.distanceFromPointToPlane((FramePoint3D)point, (FramePoint3D)pointOnPlane, (FrameVector3D)planeNormal);
        expected = 6.0;
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-6, (String)"FAILED: Distance from point to plane");
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 1.0, 0.0, 0.0);
        point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 3.0, 0.0, 0.0);
        actual = GeometryTools.distanceFromPointToPlane((FramePoint3D)point, (FramePoint3D)pointOnPlane, (FrameVector3D)planeNormal);
        expected = 3.0;
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-6, (String)"FAILED: Distance from point to plane");
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 1.0, 0.0);
        point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 3.0, 0.0);
        actual = GeometryTools.distanceFromPointToPlane((FramePoint3D)point, (FramePoint3D)pointOnPlane, (FrameVector3D)planeNormal);
        expected = 3.0;
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-6, (String)"FAILED: Distance from point to plane");
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 1.0, 1.0, 1.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 1.0, 0.0);
        point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 3.0, 0.0);
        actual = GeometryTools.distanceFromPointToPlane((FramePoint3D)point, (FramePoint3D)pointOnPlane, (FrameVector3D)planeNormal);
        expected = 2.0;
        Assertions.assertEquals((double)expected, (double)actual, (double)1.0E-6, (String)"FAILED: Distance from point to plane");
    }

    @Test
    public void testIsLineSegmentIntersectingPlane1() {
        FramePoint3D pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        FrameVector3D planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 0.0, 1.0);
        FramePoint3D lineStart = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, -1.0);
        FramePoint3D lineEnd = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 3.0);
        Assertions.assertTrue((boolean)GeometryTools.isLineSegmentIntersectingPlane((FramePoint3D)pointOnPlane, (FrameVector3D)planeNormal, (FramePoint3D)lineStart, (FramePoint3D)lineEnd));
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 1.0, 0.0, 0.0);
        lineStart = new FramePoint3D(ReferenceFrame.getWorldFrame(), -6.0, 3.0, -3.0);
        lineEnd = new FramePoint3D(ReferenceFrame.getWorldFrame(), 6.0, 3.0, 6.0);
        Assertions.assertTrue((boolean)GeometryTools.isLineSegmentIntersectingPlane((FramePoint3D)pointOnPlane, (FrameVector3D)planeNormal, (FramePoint3D)lineStart, (FramePoint3D)lineEnd));
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 1.0, 0.0);
        lineStart = new FramePoint3D(ReferenceFrame.getWorldFrame(), 6.0, -3.0, -3.0);
        lineEnd = new FramePoint3D(ReferenceFrame.getWorldFrame(), 6.0, 3.0, 6.0);
        Assertions.assertTrue((boolean)GeometryTools.isLineSegmentIntersectingPlane((FramePoint3D)pointOnPlane, (FrameVector3D)planeNormal, (FramePoint3D)lineStart, (FramePoint3D)lineEnd));
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 0.0, 1.0);
        lineStart = new FramePoint3D(ReferenceFrame.getWorldFrame(), 6.0, -3.0, 3.0);
        lineEnd = new FramePoint3D(ReferenceFrame.getWorldFrame(), 6.0, 3.0, 6.0);
        Assertions.assertFalse((boolean)GeometryTools.isLineSegmentIntersectingPlane((FramePoint3D)pointOnPlane, (FrameVector3D)planeNormal, (FramePoint3D)lineStart, (FramePoint3D)lineEnd));
        pointOnPlane = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        planeNormal = new FrameVector3D(pointOnPlane.getReferenceFrame(), 0.0, 0.0, 1.0);
        lineStart = new FramePoint3D(ReferenceFrame.getWorldFrame(), 6.0, -3.0, -3.0);
        lineEnd = new FramePoint3D(ReferenceFrame.getWorldFrame(), 6.0, 3.0, -1.0);
        Assertions.assertFalse((boolean)GeometryTools.isLineSegmentIntersectingPlane((FramePoint3D)pointOnPlane, (FrameVector3D)planeNormal, (FramePoint3D)lineStart, (FramePoint3D)lineEnd));
    }

    @Test
    public void testGetPerpendicularVectorFromLineToPoint1() {
        FramePoint3D point0 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        FramePoint3D lineStart0 = new FramePoint3D(ReferenceFrame.getWorldFrame(), -10.0, 10.0, 0.0);
        FramePoint3D lineEnd0 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 0.0);
        FramePoint3D intersectionPoint0 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 10.0, 0.0);
        FrameVector3D x0 = new FrameVector3D(point0.getReferenceFrame());
        x0.sub((FrameTuple3DReadOnly)point0, (FrameTuple3DReadOnly)intersectionPoint0);
        FrameVector3D expectedReturn0 = x0;
        FrameVector3D actualReturn0 = GeometryTools.getPerpendicularVectorFromLineToPoint((FramePoint3D)point0, (FramePoint3D)lineStart0, (FramePoint3D)lineEnd0, (FramePoint3D)intersectionPoint0);
        Assertions.assertTrue((boolean)expectedReturn0.epsilonEquals((EuclidFrameGeometry)actualReturn0, 1.0E-6), (String)"Test Failed");
        FramePoint3D point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 4.0, 2.0, 0.0);
        FramePoint3D lineStart = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        FramePoint3D lineEnd = new FramePoint3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 0.0);
        FramePoint3D intersectionPoint = new FramePoint3D(ReferenceFrame.getWorldFrame(), 3.0, 3.0, 0.0);
        FrameVector3D x = new FrameVector3D(point.getReferenceFrame());
        x.sub((FrameTuple3DReadOnly)point, (FrameTuple3DReadOnly)intersectionPoint);
        FrameVector3D expectedReturn = x;
        FrameVector3D actualReturn = GeometryTools.getPerpendicularVectorFromLineToPoint((FramePoint3D)point, (FramePoint3D)lineStart, (FramePoint3D)lineEnd, (FramePoint3D)intersectionPoint);
        Assertions.assertTrue((boolean)expectedReturn.epsilonEquals((EuclidFrameGeometry)actualReturn, 1.0E-6), (String)"Test Failed");
        FramePoint3D point1 = new FramePoint3D(ReferenceFrame.getWorldFrame(), -2.5, 1.5, 0.0);
        FramePoint3D lineStart1 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        FramePoint3D lineEnd1 = new FramePoint3D(ReferenceFrame.getWorldFrame(), -4.0, 4.0, 0.0);
        FramePoint3D intersectionPoint1 = new FramePoint3D(ReferenceFrame.getWorldFrame(), -2.0, 2.0, 0.0);
        EuclidGeometryTools.orthogonalProjectionOnLineSegment2D((Point2DReadOnly)new Point2D(-2.5, 1.5), (Point2DReadOnly)new Point2D(0.0, 0.0), (Point2DReadOnly)new Point2D(-4.0, 4.0));
        FrameVector3D x1 = new FrameVector3D(point1.getReferenceFrame());
        x1.sub((FrameTuple3DReadOnly)point1, (FrameTuple3DReadOnly)intersectionPoint1);
        FrameVector3D expectedReturn1 = x1;
        FrameVector3D actualReturn1 = GeometryTools.getPerpendicularVectorFromLineToPoint((FramePoint3D)point1, (FramePoint3D)lineStart1, (FramePoint3D)lineEnd1, (FramePoint3D)intersectionPoint1);
        Assertions.assertTrue((boolean)expectedReturn1.epsilonEquals((EuclidFrameGeometry)actualReturn1, 1.0E-6), (String)"Test Failed");
    }

    @Test
    public void testGetPlaneNormalGivenThreePoints() {
        FramePoint3D point1 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 5.0, 0.0);
        FramePoint3D point2 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 5.0, 0.0);
        FramePoint3D point3 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 5.0, 0.0);
        Object expectedReturn = null;
        FrameVector3D actualReturn = GeometryTools.getPlaneNormalGivenThreePoints((FramePoint3D)point1, (FramePoint3D)point2, (FramePoint3D)point3);
        Assertions.assertEquals(expectedReturn, (Object)actualReturn, (String)"test failed");
        FramePoint3D point91 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 3.0, 0.0);
        FramePoint3D point92 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 5.0, 0.0);
        FramePoint3D point93 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 1.0, 0.0);
        Object expectedReturn9 = null;
        FrameVector3D actualReturn9 = GeometryTools.getPlaneNormalGivenThreePoints((FramePoint3D)point91, (FramePoint3D)point92, (FramePoint3D)point93);
        Assertions.assertEquals(expectedReturn9, (Object)actualReturn9, (String)"test failed");
        FramePoint3D point81 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 9.0, 0.0, 0.0);
        FramePoint3D point82 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 7.0, 0.0, 0.0);
        FramePoint3D point83 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 4.0, 0.0, 0.0);
        Object expectedReturn8 = null;
        FrameVector3D actualReturn8 = GeometryTools.getPlaneNormalGivenThreePoints((FramePoint3D)point81, (FramePoint3D)point82, (FramePoint3D)point83);
        Assertions.assertEquals(expectedReturn8, (Object)actualReturn8, (String)"test failed");
        FramePoint3D point71 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 4.0);
        FramePoint3D point72 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 6.0);
        FramePoint3D point73 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 7.0);
        Object expectedReturn7 = null;
        FrameVector3D actualReturn7 = GeometryTools.getPlaneNormalGivenThreePoints((FramePoint3D)point71, (FramePoint3D)point72, (FramePoint3D)point73);
        Assertions.assertEquals(expectedReturn7, (Object)actualReturn7, (String)"test failed");
        FramePoint3D point11 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 5.0, 46.0);
        FramePoint3D point12 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 587.0, 3.0);
        FramePoint3D point13 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 18.0, 8.0);
        FramePoint3D p1 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 5.0, 5.0);
        FramePoint3D v1 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 1.0, 5.0, 5.0);
        FrameVector3D expectedReturn1 = new FrameVector3D(p1.getReferenceFrame());
        expectedReturn1.sub((FrameTuple3DReadOnly)p1, (FrameTuple3DReadOnly)v1);
        FrameVector3D actualReturn1 = GeometryTools.getPlaneNormalGivenThreePoints((FramePoint3D)point11, (FramePoint3D)point12, (FramePoint3D)point13);
        Assertions.assertTrue((boolean)expectedReturn1.epsilonEquals((EuclidFrameGeometry)actualReturn1, 1.0E-6), (String)"Test Failed");
        FramePoint3D point21 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 65.0, 0.0, 46.0);
        FramePoint3D point22 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 43.0, 0.0, 3.0);
        FramePoint3D point23 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 13.0, 0.0, 8.0);
        FramePoint3D p2 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 1.0, 5.0);
        FramePoint3D v2 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 5.0);
        FrameVector3D expectedReturn2 = new FrameVector3D(p2.getReferenceFrame());
        expectedReturn2.sub((FrameTuple3DReadOnly)p2, (FrameTuple3DReadOnly)v2);
        FrameVector3D actualReturn2 = GeometryTools.getPlaneNormalGivenThreePoints((FramePoint3D)point21, (FramePoint3D)point22, (FramePoint3D)point23);
        Assertions.assertTrue((boolean)expectedReturn2.epsilonEquals((EuclidFrameGeometry)actualReturn2, 1.0E-6), (String)"Test Failed");
        FramePoint3D point31 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 65.0, 56.0, 0.0);
        FramePoint3D point32 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 43.0, 3.0, 0.0);
        FramePoint3D point33 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 13.0, 87.0, 0.0);
        FramePoint3D p3 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 55.0, 0.0);
        FramePoint3D v3 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 55.0, 1.0);
        FrameVector3D expectedReturn3 = new FrameVector3D(p3.getReferenceFrame());
        expectedReturn3.sub((FrameTuple3DReadOnly)p3, (FrameTuple3DReadOnly)v3);
        FrameVector3D actualReturn3 = GeometryTools.getPlaneNormalGivenThreePoints((FramePoint3D)point31, (FramePoint3D)point32, (FramePoint3D)point33);
        Assertions.assertTrue((boolean)expectedReturn3.epsilonEquals((EuclidFrameGeometry)actualReturn3, 1.0E-6), (String)"Test Failed");
    }

    @Test
    public void testIsPointOnLeftSideOfLine() {
        FramePoint3D lineStart = new FramePoint3D(ReferenceFrame.getWorldFrame(), 5.0, 0.0, 0.0);
        FramePoint3D lineEnd = new FramePoint3D(ReferenceFrame.getWorldFrame(), 5.0, 10.0, 0.0);
        FramePoint3D point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 10.0, 5.0, 0.0);
        boolean expectedReturn = false;
        boolean actualReturn = GeometryTools.isPointOnLeftSideOfLine((FramePoint3D)point, (FramePoint3D)lineStart, (FramePoint3D)lineEnd);
        Assertions.assertEquals((Object)expectedReturn, (Object)actualReturn, (String)"return value");
    }

    @Test
    public void testClipToBoundingBox() {
        Point3D tuple3d = new Point3D(1.0, -1.0, 0.0);
        GeometryTools.clipToBoundingBox((Tuple3DBasics)tuple3d, (double)-0.5, (double)0.5, (double)0.5, (double)-0.5, (double)0.0, (double)0.0);
        EuclidCoreTestTools.assertEquals((String)"not equal", (EuclidGeometry)new Point3D(0.5, -0.5, 0.0), (EuclidGeometry)tuple3d, (double)0.0);
        tuple3d.set(1.0, -1.0, 0.0);
        GeometryTools.clipToBoundingBox((Tuple3DBasics)tuple3d, (double)0.5, (double)-0.5, (double)-0.5, (double)0.5, (double)-0.1, (double)0.1);
        EuclidCoreTestTools.assertEquals((String)"not equal", (EuclidGeometry)new Point3D(0.5, -0.5, 0.0), (EuclidGeometry)tuple3d, (double)0.0);
        tuple3d.set(1.0, -1.0, 2.0);
        GeometryTools.clipToBoundingBox((Tuple3DBasics)tuple3d, (double)0.5, (double)-0.5, (double)-0.5, (double)0.5, (double)-0.1, (double)1.0);
        EuclidCoreTestTools.assertEquals((String)"not equal", (EuclidGeometry)new Point3D(0.5, -0.5, 1.0), (EuclidGeometry)tuple3d, (double)0.0);
    }

    @Test
    public void testCombine() {
        double distance;
        Random random = new Random(1176L);
        ArrayList<Point2D> firstList = new ArrayList<Point2D>();
        for (int i = 0; i < 100; ++i) {
            firstList.add(new Point2D(random.nextDouble(), random.nextDouble()));
        }
        ConvexPolygon2D firstPolygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(firstList));
        ArrayList<Point2D> secondList = new ArrayList<Point2D>();
        for (int i = 0; i < 200; ++i) {
            secondList.add(new Point2D(random.nextDouble(), random.nextDouble()));
        }
        ConvexPolygon2D secondPolygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(secondList));
        ConvexPolygon2D result = new ConvexPolygon2D((Vertex2DSupplier)firstPolygon, (Vertex2DSupplier)secondPolygon);
        for (Point2D point : firstList) {
            if (result.isPointInside((Point2DReadOnly)point) || !((distance = result.distance((Point2DReadOnly)point)) > 1.0E-7)) continue;
            throw new RuntimeException("Not each point is inside the result. distance = " + distance);
        }
        for (Point2D point : secondList) {
            if (result.isPointInside((Point2DReadOnly)point) || !((distance = result.distance((Point2DReadOnly)point)) > 1.0E-7)) continue;
            throw new RuntimeException("Not each point is inside the result. distance = " + distance);
        }
    }

    @Test
    public void testNormalizeSafeZUp() throws Exception {
        Vector3D expectedVector = new Vector3D();
        Random random = new Random(1176L);
        for (int i = 0; i < 1000; ++i) {
            Vector3D actualVector = EuclidCoreRandomTools.nextVector3D((Random)random, (double)RandomNumbers.nextDouble((Random)random, (double)1.0E-12, (double)10.0));
            expectedVector.setAndNormalize((Tuple3DReadOnly)actualVector);
            GeometryTools.normalizeSafelyZUp((Vector3DBasics)actualVector);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)actualVector, (double)1.0E-12);
            actualVector = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)9.989999999999999E-13);
            expectedVector.set(0.0, 0.0, 1.0);
            GeometryTools.normalizeSafelyZUp((Vector3DBasics)actualVector);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)actualVector, (double)1.0E-12);
            actualVector = new Vector3D();
            expectedVector.set(0.0, 0.0, 1.0);
            GeometryTools.normalizeSafelyZUp((Vector3DBasics)actualVector);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)actualVector, (double)1.0E-12);
        }
    }

    @Test
    public void testIsZero() throws Exception {
        Random random = new Random(23423L);
        for (int i = 0; i < 1000; ++i) {
            double x = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)10.0);
            double y = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)10.0);
            double z = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)10.0);
            double epsilon = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)10.0);
            boolean isTuple2dZero = x < epsilon && y < epsilon;
            boolean isTuple3dZero = x < epsilon && y < epsilon && z < epsilon;
            Assertions.assertEquals((Object)isTuple2dZero, (Object)GeometryTools.isZero((Tuple2DReadOnly)new Point2D(x, y), (double)epsilon));
            Assertions.assertEquals((Object)isTuple2dZero, (Object)GeometryTools.isZero((Tuple2DReadOnly)new Point2D(-x, y), (double)epsilon));
            Assertions.assertEquals((Object)isTuple2dZero, (Object)GeometryTools.isZero((Tuple2DReadOnly)new Point2D(-x, -y), (double)epsilon));
            Assertions.assertEquals((Object)isTuple2dZero, (Object)GeometryTools.isZero((Tuple2DReadOnly)new Point2D(x, -y), (double)epsilon));
            Assertions.assertEquals((Object)isTuple2dZero, (Object)GeometryTools.isZero((Tuple2DReadOnly)new Point2D(x, y), (double)epsilon));
            Assertions.assertEquals((Object)isTuple2dZero, (Object)GeometryTools.isZero((Tuple2DReadOnly)new Point2D(-x, y), (double)epsilon));
            Assertions.assertEquals((Object)isTuple2dZero, (Object)GeometryTools.isZero((Tuple2DReadOnly)new Point2D(-x, -y), (double)epsilon));
            Assertions.assertEquals((Object)isTuple2dZero, (Object)GeometryTools.isZero((Tuple2DReadOnly)new Point2D(x, -y), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(x, y, z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(x, y, -z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(x, -y, z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(x, -y, -z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(-x, y, z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(-x, y, -z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(-x, -y, z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(-x, -y, -z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(x, y, z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(x, y, -z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(x, -y, z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(x, -y, -z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(-x, y, z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(-x, y, -z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(-x, -y, z), (double)epsilon));
            Assertions.assertEquals((Object)isTuple3dZero, (Object)GeometryTools.isZero((Tuple3DReadOnly)new Point3D(-x, -y, -z), (double)epsilon));
        }
    }

    @Test
    public void testConstructFrameFromPointAndAxis() {
        Random random = new Random(1776L);
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        FramePoint3D randomPoint = new FramePoint3D(worldFrame);
        FrameVector3D randomVector = new FrameVector3D(worldFrame);
        int numberOfTests = 100000;
        for (int i = 0; i < numberOfTests; ++i) {
            randomPoint.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)10.0, (double)10.0, (double)10.0));
            randomVector.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame, (double)-1.0, (double)1.0, (double)-1.0, (double)1.0, (double)-1.0, (double)1.0));
            ReferenceFrame frameA = GeometryTools.constructReferenceFrameFromPointAndZAxis((String)"frameA", (FramePoint3D)randomPoint, (FrameVector3D)randomVector);
            ReferenceFrame frameB = GeometryTools.constructReferenceFrameFromPointAndAxis((String)"frameB", (FramePoint3DReadOnly)randomPoint, (Axis3D)Axis3D.Z, (FrameVector3DReadOnly)randomVector);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)frameA.getTransformToRoot(), (EuclidGeometry)frameB.getTransformToRoot(), (double)0.01);
        }
    }

    @Test
    public void testYawAboutPointRegression() {
        double epsilon = 1.0E-10;
        Random r = new Random(2899234L);
        ReferenceFrame referenceFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"randomFrame", (Random)r, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        FramePoint3D pointToYawAbout = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        FramePoint3D point = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        double yaw = this.randomAngle(r);
        FramePoint3D result = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        GeometryTools.yawAboutPoint((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointToYawAbout, (double)yaw, (FramePoint3D)result);
        System.out.println(result);
        Assertions.assertEquals((double)-2681.624165883151, (double)result.getX(), (double)epsilon, (String)"not equal");
        Assertions.assertEquals((double)-1528.2007328131492, (double)result.getY(), (double)epsilon, (String)"not equal");
        Assertions.assertEquals((double)2998.298763316407, (double)result.getZ(), (double)epsilon, (String)"not equal");
        referenceFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"randomFrame", (Random)r, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        pointToYawAbout = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        point = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        yaw = this.randomAngle(r);
        result = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        GeometryTools.yawAboutPoint((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointToYawAbout, (double)yaw, (FramePoint3D)result);
        System.out.println(result);
        Assertions.assertEquals((double)2868.1077772133904, (double)result.getX(), (double)epsilon, (String)"not equal");
        Assertions.assertEquals((double)-3773.703916968001, (double)result.getY(), (double)epsilon, (String)"not equal");
        Assertions.assertEquals((double)-3313.247345650209, (double)result.getZ(), (double)epsilon, (String)"not equal");
        referenceFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"randomFrame", (Random)r, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        pointToYawAbout = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        point = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        yaw = this.randomAngle(r);
        result = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        GeometryTools.yawAboutPoint((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointToYawAbout, (double)yaw, (FramePoint3D)result);
        System.out.println(result);
        Assertions.assertEquals((double)9865.290784196699, (double)result.getX(), (double)epsilon, (String)"not equal");
        Assertions.assertEquals((double)1276.040690119471, (double)result.getY(), (double)epsilon, (String)"not equal");
        Assertions.assertEquals((double)-3096.5574256022164, (double)result.getZ(), (double)epsilon, (String)"not equal");
    }

    @Test
    public void testPitchAboutPointRegression() {
        double epsilon = 1.0E-10;
        Random r = new Random(689291994L);
        ReferenceFrame referenceFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"randomFrame", (Random)r, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        FramePoint3D pointToPitchAbout = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        FramePoint3D point = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        double pitch = this.randomAngle(r);
        FramePoint3D result = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        GeometryTools.pitchAboutPoint((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointToPitchAbout, (double)pitch, (FramePoint3D)result);
        System.out.println(result);
        Assertions.assertEquals((double)-256.24551976827297, (double)result.getX(), (double)epsilon, (String)"not equal");
        Assertions.assertEquals((double)1443.7013411938358, (double)result.getY(), (double)epsilon, (String)"not equal");
        Assertions.assertEquals((double)11103.259343203952, (double)result.getZ(), (double)epsilon, (String)"not equal");
        referenceFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"randomFrame", (Random)r, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        pointToPitchAbout = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        point = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        pitch = this.randomAngle(r);
        result = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        GeometryTools.pitchAboutPoint((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointToPitchAbout, (double)pitch, (FramePoint3D)result);
        System.out.println(result);
        Assertions.assertEquals((double)-2273.346187036131, (double)result.getX(), (double)epsilon, (String)"not equal");
        Assertions.assertEquals((double)3010.5651766598717, (double)result.getY(), (double)epsilon, (String)"not equal");
        Assertions.assertEquals((double)-3513.344540982049, (double)result.getZ(), (double)epsilon, (String)"not equal");
        referenceFrame = EuclidFrameRandomTools.nextReferenceFrame((String)"randomFrame", (Random)r, (ReferenceFrame)ReferenceFrame.getWorldFrame());
        pointToPitchAbout = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        point = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        pitch = this.randomAngle(r);
        result = new FramePoint3D(referenceFrame, this.randomScalar(r), this.randomScalar(r), this.randomScalar(r));
        GeometryTools.pitchAboutPoint((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointToPitchAbout, (double)pitch, (FramePoint3D)result);
        System.out.println(result);
        Assertions.assertEquals((double)3978.4131392851787, (double)result.getX(), (double)epsilon, (String)"not equal");
        Assertions.assertEquals((double)682.5708442089929, (double)result.getY(), (double)epsilon, (String)"not equal");
        Assertions.assertEquals((double)8214.605434738955, (double)result.getZ(), (double)epsilon, (String)"not equal");
    }

    @Test
    public void testYawAboutPoint() {
        ReferenceFrame theFrame = ReferenceFrameTools.constructARootFrame((String)"theFrame");
        double epsilon = 1.0E-10;
        FramePoint3D pointToYawAboutException = new FramePoint3D(theFrame, 0.0, 0.0, 0.0);
        FramePoint3D pointException = new FramePoint3D(ReferenceFrame.getWorldFrame(), 1.0, 1.0, 1.0);
        FramePoint3D resultException = new FramePoint3D();
        double yawException = Math.PI;
        Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> GeometryTools.yawAboutPoint((FramePoint3DReadOnly)pointException, (FramePoint3DReadOnly)pointToYawAboutException, (double)Math.PI, (FramePoint3D)resultException));
        FramePoint3D pointToYawAbout = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        FramePoint3D point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 1.0, 1.0, 1.0);
        double yaw = Math.PI;
        FramePoint3D result = new FramePoint3D();
        GeometryTools.yawAboutPoint((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointToYawAbout, (double)yaw, (FramePoint3D)result);
        Assertions.assertEquals((double)-1.0, (double)result.getX(), (double)epsilon, (String)"These should be equal");
        Assertions.assertEquals((double)-1.0, (double)result.getY(), (double)epsilon, (String)"These should be equal");
        Assertions.assertEquals((double)1.0, (double)result.getZ(), (double)epsilon, (String)"These should be equal");
        FramePoint3D point2 = new FramePoint3D(ReferenceFrame.getWorldFrame(), 1.0, 1.0, 1.0);
        GeometryTools.yawAboutPoint((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointToYawAbout, (double)yaw, (FramePoint3D)point2);
        pointToYawAbout = new FramePoint3D(ReferenceFrame.getWorldFrame(), 0.0, 0.0, 0.0);
        point = new FramePoint3D(ReferenceFrame.getWorldFrame(), 1.0, 0.0, 1.0);
        yaw = 1.5707963267948966;
        result = new FramePoint3D();
        GeometryTools.yawAboutPoint((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointToYawAbout, (double)yaw, (FramePoint3D)result);
        Assertions.assertEquals((double)0.0, (double)result.getX(), (double)epsilon, (String)"These should be equal");
        Assertions.assertEquals((double)1.0, (double)result.getY(), (double)epsilon, (String)"These should be equal");
        Assertions.assertEquals((double)1.0, (double)result.getZ(), (double)epsilon, (String)"These should be equal");
    }

    @Test
    public void testPitchAboutPoint() {
        ReferenceFrame theFrame = ReferenceFrameTools.constructARootFrame((String)"theFrame");
        double epsilon = 1.0E-10;
        FramePoint3D pointToPitchAboutException = new FramePoint3D(theFrame, 0.0, 0.0, 0.0);
        FramePoint3D pointException = new FramePoint3D(ReferenceFrame.getWorldFrame(), 1.0, 1.0, 1.0);
        FramePoint3D resultException = new FramePoint3D();
        double pitchException = Math.PI;
        Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> GeometryTools.yawAboutPoint((FramePoint3DReadOnly)pointException, (FramePoint3DReadOnly)pointToPitchAboutException, (double)Math.PI, (FramePoint3D)resultException));
        FramePoint3D pointToPitchAbout = new FramePoint3D(theFrame, 0.0, 0.0, 0.0);
        FramePoint3D point = new FramePoint3D(theFrame, 1.0, 1.0, 1.0);
        double pitch = Math.PI;
        FramePoint3D result = new FramePoint3D();
        GeometryTools.pitchAboutPoint((FramePoint3DReadOnly)point, (FramePoint3DReadOnly)pointToPitchAbout, (double)pitch, (FramePoint3D)result);
        Assertions.assertEquals((double)-1.0, (double)result.getX(), (double)epsilon, (String)"These should be equal");
        Assertions.assertEquals((double)1.0, (double)result.getY(), (double)epsilon, (String)"These should be equal");
        Assertions.assertEquals((double)-1.0, (double)result.getZ(), (double)epsilon, (String)"These should be equal");
    }

    private double randomScalar(Random random) {
        return (random.nextDouble() - 0.5) * 10000.0;
    }

    private double randomAngle(Random random) {
        return (random.nextDouble() - 0.5) * 2.0 * Math.PI;
    }

    @Test
    public void testYawAboutPoint_FramePoint2d_double() {
        ReferenceFrame theFrame = ReferenceFrameTools.constructARootFrame((String)"theFrame");
        ReferenceFrame aFrame = ReferenceFrameTools.constructARootFrame((String)"aFrame");
        double epsilon = 1.0E-10;
        FramePoint2D original = new FramePoint2D(theFrame, 5.0, 7.0);
        FramePoint2D pointToYawAbout = new FramePoint2D(theFrame);
        double yaw = Math.PI;
        FramePoint2D result = new FramePoint2D(theFrame);
        GeometryTools.yawAboutPoint((FramePoint2DReadOnly)original, (FramePoint2DReadOnly)pointToYawAbout, (double)yaw, (FramePoint2D)result);
        Assertions.assertEquals((double)result.getX(), (double)(-original.getX()), (double)epsilon, (String)"Should be equal");
        Assertions.assertEquals((double)result.getY(), (double)(-original.getY()), (double)epsilon, (String)"Should be equal");
        try {
            FramePoint2D pointToYawAbout2 = new FramePoint2D(aFrame);
            GeometryTools.yawAboutPoint((FramePoint2DReadOnly)original, (FramePoint2DReadOnly)pointToYawAbout2, (double)yaw, (FramePoint2D)result);
            Assertions.fail((String)"Should have thrown ReferenceFrameMismatchException");
        }
        catch (ReferenceFrameMismatchException referenceFrameMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testComputeBoundingBoxIntersection3D() {
        BoundingBox3D boundingBox1 = new BoundingBox3D(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        BoundingBox3D boundingBox2 = new BoundingBox3D(0.5, 0.0, 0.0, 1.5, 1.0, 1.0);
        Assertions.assertEquals((double)1.0, (double)EuclidGeometryMissingTools.computeBoundingBoxVolume3D((BoundingBox3DReadOnly)boundingBox1), (double)1.0E-6, (String)"[FAILED] Volume should be 1.0");
        Assertions.assertEquals((double)1.0, (double)EuclidGeometryMissingTools.computeBoundingBoxVolume3D((BoundingBox3DReadOnly)boundingBox2), (double)1.0E-6, (String)"[FAILED] Volume should be 1.0");
        Assertions.assertEquals((double)0.3333333333333333, (double)GeometryTools.computeIntersectionOverUnionOfTwoBoundingBoxes((BoundingBox3DReadOnly)boundingBox1, (BoundingBox3DReadOnly)boundingBox2), (double)1.0E-6, (String)"[FAILED] Intersection should be 1/3.0");
        Assertions.assertEquals((double)0.5, (double)GeometryTools.computeIntersectionOverSmallerOfTwoBoundingBoxes((BoundingBox3DReadOnly)boundingBox2, (BoundingBox3DReadOnly)boundingBox1), (double)1.0E-6, (String)"[FAILED] Intersection should be 0.5");
        boundingBox2 = new BoundingBox3D(0.5, 0.5, 0.5, 1.5, 1.5, 1.5);
        Assertions.assertEquals((double)1.0, (double)EuclidGeometryMissingTools.computeBoundingBoxVolume3D((BoundingBox3DReadOnly)boundingBox2), (double)1.0E-6, (String)"[FAILED] Volume should be 1.0");
        Assertions.assertEquals((double)0.06666666666666667, (double)GeometryTools.computeIntersectionOverUnionOfTwoBoundingBoxes((BoundingBox3DReadOnly)boundingBox1, (BoundingBox3DReadOnly)boundingBox2), (double)1.0E-6, (String)"[FAILED] Intersection should be 1/3.0");
        Assertions.assertEquals((double)0.125, (double)GeometryTools.computeIntersectionOverSmallerOfTwoBoundingBoxes((BoundingBox3DReadOnly)boundingBox2, (BoundingBox3DReadOnly)boundingBox1), (double)1.0E-6, (String)"[FAILED] Intersection should be 1/15.0");
    }

    @Test
    public void testPointProjectionsOntoPlane() {
        Point3D pointOnPlane = new Point3D(1.0, 1.0, 1.0);
        UnitVector3D planeNormal = new UnitVector3D(1.0, 1.0, 1.0);
        Vector4D plane = new Vector4D(planeNormal.getX(), planeNormal.getY(), planeNormal.getZ(), -pointOnPlane.dot((Tuple3DReadOnly)planeNormal));
        Point3D pointToProject = new Point3D(0.0, 0.0, 0.0);
        Point3D projectedPoint = GeometryTools.projectPointOntoPlane((Vector4DReadOnly)plane, (Point3DReadOnly)pointToProject);
        Point3D expectedProjection = new Point3D(1.0, 1.0, 1.0);
        LogTools.info((String)"Projected point: {} {} {}", (Object)projectedPoint.getX(), (Object)projectedPoint.getY(), (Object)projectedPoint.getZ());
        LogTools.info((String)"Expected projection: {} {} {}", (Object)expectedProjection.getX(), (Object)expectedProjection.getY(), (Object)expectedProjection.getZ());
        Assertions.assertEquals((double)0.0, (double)projectedPoint.distance((Point3DReadOnly)expectedProjection), (double)1.0E-6);
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(GeometryTools.class, GeometryToolsTest.class);
    }
}

