/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.commons.PrintTools;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Line2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DBasics;
import us.ihmc.euclid.geometry.interfaces.LineSegment2DReadOnly;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLineSegment2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FixedFrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.ConvexPolygon2dCalculator;
import us.ihmc.robotics.geometry.ConvexPolygon2dTestHelpers;
import us.ihmc.robotics.geometry.ConvexPolygonCutResult;
import us.ihmc.robotics.geometry.ConvexPolygonScaler;
import us.ihmc.robotics.geometry.ConvexPolygonTools;
import us.ihmc.robotics.geometry.FrameGeometry2dPlotter;
import us.ihmc.robotics.geometry.FrameGeometryTestFrame;

public class ConvexPolygonToolsTest {
    private static final boolean PLOT_RESULTS = false;
    private static final boolean WAIT_FOR_BUTTON_PUSH = false;
    private static final double epsilon = 1.0E-7;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testCombineDisjointPolygons() {
        Random random = new Random(1776L);
        ReferenceFrame zUpFrame = ReferenceFrameTools.constructARootFrame((String)"someFrame");
        double xMin1 = 0.0;
        double xMax1 = 1.0;
        double yMin1 = 0.0;
        double yMax1 = 1.0;
        ArrayList<FramePoint2D> points1 = ConvexPolygon2dTestHelpers.generateRandomCircularFramePoints(random, zUpFrame, xMin1, xMax1, yMin1, yMax1, 100);
        double xMin2 = 2.0;
        double xMax2 = 3.0;
        double yMin2 = 0.0;
        double yMax2 = 2.0;
        ArrayList<FramePoint2D> points2 = ConvexPolygon2dTestHelpers.generateRandomCircularFramePoints(random, zUpFrame, xMin2, xMax2, yMin2, yMax2, 100);
        FrameConvexPolygon2D polygon1 = new FrameConvexPolygon2D(FrameVertex2DSupplier.asFrameVertex2DSupplier(points1));
        FrameConvexPolygon2D polygon2 = new FrameConvexPolygon2D(FrameVertex2DSupplier.asFrameVertex2DSupplier(points2));
        ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
        FrameConvexPolygon2D combinedPolygon = new FrameConvexPolygon2D(zUpFrame);
        FrameLineSegment2D connectingEdge1 = new FrameLineSegment2D(zUpFrame);
        FrameLineSegment2D connectingEdge2 = new FrameLineSegment2D(zUpFrame);
        ArrayList<FramePoint2D> pointsThatShouldBeInCombinedPolygon = new ArrayList<FramePoint2D>();
        int numberOfPointsInCombinedPolygon = 10000;
        for (int i = 0; i < numberOfPointsInCombinedPolygon; ++i) {
            int randomIndex = random.nextInt(points1.size());
            FramePoint2D firstPoint = points1.get(randomIndex);
            randomIndex = random.nextInt(points1.size());
            FramePoint2D secondPoint = points2.get(randomIndex);
            double alpha = random.nextDouble();
            FramePoint2D morphedPoint = new FramePoint2D(zUpFrame);
            morphedPoint.interpolate((FrameTuple2DReadOnly)firstPoint, (FrameTuple2DReadOnly)secondPoint, alpha);
            pointsThatShouldBeInCombinedPolygon.add(morphedPoint);
        }
        int numTests = 1000;
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            convexPolygonTools.combineDisjointPolygons((FrameConvexPolygon2DReadOnly)polygon1, (FrameConvexPolygon2DReadOnly)polygon2, (FrameConvexPolygon2DBasics)combinedPolygon, (FrameLineSegment2DBasics)connectingEdge1, (FrameLineSegment2DBasics)connectingEdge2);
        }
        long endTime = System.currentTimeMillis();
        double timePer = (double)(endTime - startTime) / (double)numTests;
        PrintTools.info((String)("timePer = " + timePer + " milliseconds per test using combineDisjointPolygons."));
        Assertions.assertTrue((timePer < 1.5 ? 1 : 0) != 0);
        startTime = System.currentTimeMillis();
        for (int i = 0; i < numTests; ++i) {
            FrameConvexPolygon2D frameConvexPolygon2D = new FrameConvexPolygon2D((FrameVertex2DSupplier)polygon1, (FrameVertex2DSupplier)polygon2);
        }
        endTime = System.currentTimeMillis();
        timePer = (double)(endTime - startTime) / (double)numTests;
        PrintTools.info((String)("timePer = " + timePer + " milliseconds per test using combineWith."));
        Assertions.assertTrue((timePer < 2.0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)polygon1.isPointInside((FramePoint2DReadOnly)connectingEdge1.getFirstEndpoint()));
        Assertions.assertTrue((boolean)polygon2.isPointInside((FramePoint2DReadOnly)connectingEdge1.getSecondEndpoint()));
        Assertions.assertTrue((boolean)polygon1.isPointInside((FramePoint2DReadOnly)connectingEdge2.getSecondEndpoint()));
        Assertions.assertTrue((boolean)polygon2.isPointInside((FramePoint2DReadOnly)connectingEdge2.getFirstEndpoint()));
        ArrayList<FramePoint2D> pointsThatShouldNotBeInOriginals = new ArrayList<FramePoint2D>();
        FramePoint2D point1 = new FramePoint2D(zUpFrame);
        FramePoint2D point2 = new FramePoint2D(zUpFrame);
        FramePoint2D point3 = new FramePoint2D(zUpFrame);
        FramePoint2D point4 = new FramePoint2D(zUpFrame);
        FramePoint2D point5 = new FramePoint2D(zUpFrame);
        FramePoint2D point6 = new FramePoint2D(zUpFrame);
        FramePoint2D point7 = new FramePoint2D(zUpFrame);
        FramePoint2D point8 = new FramePoint2D(zUpFrame);
        point1.interpolate((FrameTuple2DReadOnly)connectingEdge1.getFirstEndpoint(), (FrameTuple2DReadOnly)connectingEdge1.getSecondEndpoint(), -1.0E-7);
        point2.interpolate((FrameTuple2DReadOnly)connectingEdge1.getFirstEndpoint(), (FrameTuple2DReadOnly)connectingEdge1.getSecondEndpoint(), 1.0E-7);
        point3.interpolate((FrameTuple2DReadOnly)connectingEdge1.getFirstEndpoint(), (FrameTuple2DReadOnly)connectingEdge1.getSecondEndpoint(), 0.9999999);
        point4.interpolate((FrameTuple2DReadOnly)connectingEdge1.getFirstEndpoint(), (FrameTuple2DReadOnly)connectingEdge1.getSecondEndpoint(), 1.0000001);
        point5.interpolate((FrameTuple2DReadOnly)connectingEdge1.getFirstEndpoint(), (FrameTuple2DReadOnly)connectingEdge1.getSecondEndpoint(), -1.0E-7);
        point6.interpolate((FrameTuple2DReadOnly)connectingEdge1.getFirstEndpoint(), (FrameTuple2DReadOnly)connectingEdge1.getSecondEndpoint(), 1.0E-7);
        point7.interpolate((FrameTuple2DReadOnly)connectingEdge1.getFirstEndpoint(), (FrameTuple2DReadOnly)connectingEdge1.getSecondEndpoint(), 0.9999999);
        point8.interpolate((FrameTuple2DReadOnly)connectingEdge1.getFirstEndpoint(), (FrameTuple2DReadOnly)connectingEdge1.getSecondEndpoint(), 1.0000001);
        pointsThatShouldNotBeInOriginals.add(point1);
        pointsThatShouldNotBeInOriginals.add(point2);
        pointsThatShouldNotBeInOriginals.add(point3);
        pointsThatShouldNotBeInOriginals.add(point4);
        pointsThatShouldNotBeInOriginals.add(point5);
        pointsThatShouldNotBeInOriginals.add(point6);
        pointsThatShouldNotBeInOriginals.add(point7);
        pointsThatShouldNotBeInOriginals.add(point8);
        ArrayList<FramePoint2D> pointsThatAreNotInCombinedPolygon = new ArrayList<FramePoint2D>();
        int numberOfPointsToCheck = 10000;
        double xMin3 = -0.5;
        double xMax3 = 3.5;
        double yMin3 = -0.5;
        double yMax3 = 2.5;
        ArrayList<FramePoint2D> pointsToCheck = ConvexPolygon2dTestHelpers.generateRandomRectangularFramePoints(random, zUpFrame, xMin3, xMax3, yMin3, yMax3, numberOfPointsToCheck);
        for (FramePoint2D pointToCheck : pointsToCheck) {
            if (combinedPolygon.isPointInside((FramePoint2DReadOnly)pointToCheck)) continue;
            pointsThatAreNotInCombinedPolygon.add(pointToCheck);
        }
        ConvexPolygon2dTestHelpers.verifyPointsAreClockwise(combinedPolygon);
        ConvexPolygon2dTestHelpers.verifyPointsAreInside(combinedPolygon, points1, 0.0);
        ConvexPolygon2dTestHelpers.verifyPointsAreInside(combinedPolygon, points2, 0.0);
        ConvexPolygon2dTestHelpers.verifyPointsAreInside(combinedPolygon, pointsThatShouldBeInCombinedPolygon, 1.0E-14);
        ConvexPolygon2dTestHelpers.verifyPointsAreNotInside(polygon1, pointsThatAreNotInCombinedPolygon, 0.0);
        ConvexPolygon2dTestHelpers.verifyPointsAreNotInside(polygon2, pointsThatAreNotInCombinedPolygon, 0.0);
        ConvexPolygon2dTestHelpers.verifyPointsAreNotInside(polygon1, pointsThatShouldNotBeInOriginals, 0.0);
        ConvexPolygon2dTestHelpers.verifyPointsAreNotInside(polygon2, pointsThatShouldNotBeInOriginals, 0.0);
    }

    @Test
    public void testCombineDisjointPolygons2() throws Exception {
        Random random = new Random(234234L);
        for (int i = 0; i < 1000; ++i) {
            List pointList = EuclidGeometryRandomTools.nextPointCloud2D((Random)random, (double)0.0, (double)1.0, (int)100);
            Point2D offset1 = new Point2D(-1.0, 0.0);
            Point2D offset2 = new Point2D(1.0, 0.0);
            ConvexPolygon2D polygon1 = new ConvexPolygon2D();
            ConvexPolygon2D polygon2 = new ConvexPolygon2D();
            for (int index = 0; index < pointList.size(); ++index) {
                Point2D vertex1 = new Point2D();
                vertex1.add((Tuple2DReadOnly)pointList.get(index), (Tuple2DReadOnly)offset1);
                polygon1.addVertex((Point2DReadOnly)vertex1);
                Point2D vertex2 = new Point2D();
                vertex2.add((Tuple2DReadOnly)pointList.get(index), (Tuple2DReadOnly)offset2);
                polygon2.addVertex((Point2DReadOnly)vertex2);
            }
            polygon1.update();
            polygon2.update();
            ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
            FrameConvexPolygon2D actualPolygon = new FrameConvexPolygon2D();
            FrameLineSegment2D connectingEdge1 = new FrameLineSegment2D();
            FrameLineSegment2D connectingEdge2 = new FrameLineSegment2D();
            convexPolygonTools.combineDisjointPolygons((ConvexPolygon2DReadOnly)polygon1, (ConvexPolygon2DReadOnly)polygon2, (ConvexPolygon2DBasics)actualPolygon, (LineSegment2DBasics)connectingEdge1, (LineSegment2DBasics)connectingEdge2);
            ConvexPolygon2D expectedPolygon = new ConvexPolygon2D((Vertex2DSupplier)polygon1, (Vertex2DSupplier)polygon2);
            Assertions.assertTrue((boolean)expectedPolygon.epsilonEquals((EuclidGeometry)actualPolygon, 1.0E-7), (String)("Iteration: " + i + ", expected\n" + String.valueOf(expectedPolygon) + "\nactual\n" + String.valueOf(actualPolygon)));
        }
    }

    @Test
    public void testLimitVerticesConservativeWithApproximateRectangle() {
        Random random = new Random(123821L);
        int tests = 1000;
        for (int i = 0; i < tests; ++i) {
            double rectangleHalfLength = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)1.0);
            double rectangleHalfWidth = EuclidCoreRandomTools.nextDouble((Random)random, (double)0.1, (double)1.0);
            FrameConvexPolygon2D polygon = new FrameConvexPolygon2D();
            polygon.addVertex(rectangleHalfLength, rectangleHalfWidth);
            polygon.addVertex(rectangleHalfLength, -rectangleHalfWidth);
            polygon.addVertex(-rectangleHalfLength, rectangleHalfWidth);
            polygon.addVertex(-rectangleHalfLength, -rectangleHalfWidth);
            polygon.update();
            double distanceEpsilon = 1.0E-10;
            int numberOfPolygonsAroundPerimeter = 1 + random.nextInt(10);
            for (int j = 0; j < numberOfPolygonsAroundPerimeter; ++j) {
                boolean epsilonMatchLength = random.nextBoolean();
                double epsilon = distanceEpsilon * (random.nextBoolean() ? 1.0 : -1.0);
                double px = epsilonMatchLength ? rectangleHalfLength + epsilon : EuclidCoreRandomTools.nextDouble((Random)random, (double)rectangleHalfLength);
                double py = !epsilonMatchLength ? rectangleHalfWidth + epsilon : EuclidCoreRandomTools.nextDouble((Random)random, (double)rectangleHalfWidth);
                polygon.addVertex(px, py);
            }
            polygon.update();
            FrameConvexPolygon2D originalPolygon = new FrameConvexPolygon2D((FrameVertex2DSupplier)polygon);
            ConvexPolygonTools.limitVerticesConservative((FixedFrameConvexPolygon2DBasics)polygon, (int)4);
            double area = polygon.getArea();
            double expectedArea = 4.0 * rectangleHalfLength * rectangleHalfWidth;
            System.out.println(polygon);
            Assertions.assertTrue((boolean)EuclidCoreTools.epsilonEquals((double)area, (double)expectedArea, (double)1.0E-6), (String)("Limiting number of vertices failed. Expected area = " + expectedArea + " computed area: " + area));
        }
    }

    @Test
    public void testLimitVerticesConservative() {
        Random random = new Random(123821L);
        int tests = 1000;
        for (int test = 0; test < tests; ++test) {
            FrameConvexPolygon2D polygon = new FrameConvexPolygon2D();
            int n = random.nextInt(29) + 2;
            for (int i = 0; i < n; ++i) {
                double x = random.nextDouble();
                double y = random.nextDouble();
                polygon.addVertex((Point2DReadOnly)new Point2D(x, y));
            }
            polygon.update();
            int desiredNumberOfVertices = random.nextInt(10);
            FrameConvexPolygon2D originalPolygon = new FrameConvexPolygon2D((FrameVertex2DSupplier)polygon);
            ConvexPolygonTools.limitVerticesConservative((FixedFrameConvexPolygon2DBasics)polygon, (int)desiredNumberOfVertices);
            Assert.assertTrue(desiredNumberOfVertices >= polygon.getNumberOfVertices());
            for (Point2DReadOnly vertex : polygon.getPolygonVerticesView()) {
                Assertions.assertTrue((originalPolygon.distance(vertex) <= 4.0E-7 ? 1 : 0) != 0, (String)("Expecting less than 3.0e-7: " + originalPolygon.distance(vertex)));
            }
        }
    }

    private void plotPolygon(FrameConvexPolygon2D polygonWithLimitedVertices, int desiredNumberOfVertices, FrameConvexPolygon2D originalPolygon) {
        int i;
        double minX = Math.min(polygonWithLimitedVertices.getMinX(), originalPolygon.getMinX()) - 0.2;
        double maxX = Math.min(polygonWithLimitedVertices.getMaxX(), originalPolygon.getMaxX()) + 0.2;
        double minY = Math.min(polygonWithLimitedVertices.getMinY(), originalPolygon.getMinY()) - 0.2;
        double maxY = Math.min(polygonWithLimitedVertices.getMaxY(), originalPolygon.getMaxY()) + 0.2;
        FrameGeometryTestFrame testFrame = new FrameGeometryTestFrame(minX, maxX, minY, maxY);
        FrameGeometry2dPlotter plotter = testFrame.getFrameGeometry2dPlotter();
        plotter.setDrawPointsLarge();
        plotter.addPolygon((FrameConvexPolygon2DReadOnly)originalPolygon, Color.BLUE);
        plotter.addPolygon((FrameConvexPolygon2DReadOnly)polygonWithLimitedVertices, Color.RED);
        for (i = 0; i < originalPolygon.getNumberOfVertices(); ++i) {
            plotter.addFramePoint2d((FramePoint2DReadOnly)new FramePoint2D(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)originalPolygon.getVertex(i)), Color.BLUE);
        }
        for (i = 0; i < polygonWithLimitedVertices.getNumberOfVertices(); ++i) {
            plotter.addFramePoint2d((FramePoint2DReadOnly)new FramePoint2D(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)polygonWithLimitedVertices.getVertex(i)), Color.RED);
        }
        System.out.println("Expecting " + desiredNumberOfVertices + " Vertices.");
        this.waitForButtonOrPause(testFrame);
        testFrame.dispose();
    }

    private void plotPolygons(ConvexPolygon2D polygonA, ConvexPolygon2D polygonB) {
        int i;
        FrameGeometryTestFrame testFrame = new FrameGeometryTestFrame(-1.0, 1.0, -1.0, 1.0);
        FrameGeometry2dPlotter plotter = testFrame.getFrameGeometry2dPlotter();
        plotter.setDrawPointsLarge();
        plotter.addPolygon((FrameConvexPolygon2DReadOnly)new FrameConvexPolygon2D(ReferenceFrame.getWorldFrame(), (Vertex2DSupplier)polygonA), Color.BLUE);
        plotter.addPolygon((FrameConvexPolygon2DReadOnly)new FrameConvexPolygon2D(ReferenceFrame.getWorldFrame(), (Vertex2DSupplier)polygonB), Color.RED);
        for (i = 0; i < polygonA.getNumberOfVertices(); ++i) {
            plotter.addFramePoint2d((FramePoint2DReadOnly)new FramePoint2D(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)polygonA.getVertex(i)), Color.BLUE);
        }
        for (i = 0; i < polygonB.getNumberOfVertices(); ++i) {
            plotter.addFramePoint2d((FramePoint2DReadOnly)new FramePoint2D(ReferenceFrame.getWorldFrame(), (Tuple2DReadOnly)polygonB.getVertex(i)), Color.RED);
        }
        this.waitForButtonOrPause(testFrame);
        testFrame.dispose();
    }

    @Test
    public void testDistanceBetweenPolygonsNegativeAngle() {
        this.assertMinimumDistancePointsMatchExpected(new double[]{0.0, 5.0, 2.0, -2.0, 2.0, 0.0}, new double[]{2.5, 1.0, 2.8, 1.0, 3.0, 0.9, 4.0, 0.0, 3.0, -1.0}, new double[]{2.0, 0.0, 2.7058823529411766, 0.17647058823529413}, 0.001);
    }

    @Test
    public void testDistanceBetweenPolygonsThirdQuadrant() {
        this.assertMinimumDistancePointsMatchExpected(new double[]{-2.0, -1.0, -1.0, -1.0, -1.0, -2.0}, new double[]{-2.0, -2.0, -2.0, -3.0, -4.0, -4.0, -4.0, -2.0}, new double[]{-1.5, -1.5, -2.0, -2.0}, 0.001);
    }

    @Test
    public void testDistanceBetweenPolygonsNegativeAngleAndTwoVisibleVerticesOnPolygon1() {
        this.assertMinimumDistancePointsMatchExpected(new double[]{0.0, 0.0, 1.0, 2.0, 1.0, 0.0}, new double[]{2.0, 2.0, 0.0, 3.0, -1.0, 4.0}, new double[]{1.0, 2.0, 1.2, 2.4}, 0.001);
    }

    @Test
    public void testDistanceBetweenPolygonsParalellEdges() {
        this.assertMinimumDistancePointsMatchExpected(new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 2.0, 1.0, 1.0, 2.0}, new double[]{0.0, 3.0, 2.0, 3.0, -1.0, 4.0, 3.0, 4.0}, new double[]{1.0, 2.0, 1.0, 3.0}, 0.001);
    }

    @Test
    public void testDistanceBetweenPolygonsMultiplePossibleAnswers() {
        this.assertMinimumDistancePointsMatchExpected(new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 2.0, 1.0, 1.0, 2.0}, new double[]{3.0, 2.0, 2.0, 3.0, 2.0, 4.0, 4.0, 2.0}, new double[]{1.0, 2.0, 2.0, 3.0}, 0.001);
    }

    @Disabled
    @Test
    public void testDistanceBetweenPolygonsTwoVisiblePoints() {
        this.assertMinimumDistancePointsMatchExpected(new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 2.0, 1.0, 1.0, 2.0}, new double[]{4.0, 1.0, 1.0, 4.0, 2.0, 4.0, 4.0, 2.0}, new double[]{2.0, 1.0, 3.0, 2.0}, 0.001);
    }

    @Test
    public void testDistanceBetweenPolygonsTwoVisiblePoints2() {
        this.assertMinimumDistancePointsMatchExpected(new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 2.0, 1.0, 1.0, 2.0}, new double[]{4.0, 1.0, 1.5, 4.0, 2.0, 4.0, 4.0, 2.0}, new double[]{2.0, 1.0, 3.180327868852459, 1.9836065573770492}, 0.001);
    }

    @Test
    public void testDistanceBetweenPolygonsOneOfTheAnglesIsZero() {
        this.assertMinimumDistancePointsMatchExpected(new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 2.0, 1.0, 1.0, 2.0}, new double[]{0.0, 2.0, 0.0, 3.0, 1.0, 3.0, 0.8, 2.0}, new double[]{0.9, 1.9, 0.8, 2.0}, 0.001);
    }

    @Test
    public void testDistanceBetweenPolygonsTriangles() {
        this.assertMinimumDistancePointsMatchExpected(new double[]{0.0, 1.0, 1.0, 0.0, 2.0, 0.0}, new double[]{0.0, 3.0, 4.0, 3.0, 1.0, 2.0}, new double[]{0.4, 0.8, 1.0, 2.0}, 0.001);
    }

    @Test
    public void testDistanceBetweenPolygonsSharedPoint() {
        this.assertMinimumDistancePointsMatchExpected(new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 2.0, 1.0, 1.0, 2.0}, new double[]{0.0, 2.0, 0.0, 3.0, 1.0, 3.0, 1.0, 2.0}, new double[]{1.0, 2.0, 1.0, 2.0}, 0.001);
    }

    @Test
    public void testDistanceBetweenPolygonsPointOnEdge() {
        this.assertMinimumDistancePointsMatchExpected(new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 2.0, 1.0, 1.0, 2.0}, new double[]{0.0, 2.0, 0.0, 3.0, 1.0, 3.0, 0.5, 1.5}, new double[]{0.5, 1.5, 0.5, 1.5}, 0.001);
    }

    @Test
    public void testDistanceBetweenPolygonsNegativeAngle2() {
        this.assertMinimumDistancePointsMatchExpected(new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 2.0, 1.0, 1.0, 2.0}, new double[]{0.0, 2.0, 0.0, 3.0, 1.0, 3.0, 0.4, 1.5}, new double[]{0.45, 1.45, 0.4, 1.5}, 0.001);
    }

    @Test
    public void testDistanceBetweenPolygonsSolutionIsTwoVertices() {
        this.assertMinimumDistancePointsMatchExpected(new double[]{0.0, 0.0, 2.0, 0.0, 2.0, 2.0}, new double[]{4.0, 3.0, 6.0, 3.0, 6.0, 7.0}, new double[]{2.0, 2.0, 4.0, 3.0}, 0.0);
    }

    @Test
    public void testDistanceBetweenPolygonsIntersectingPolygons() {
        ConvexPolygon2D polygon1 = this.ctreatePolygonFromListOfXYPoints(new double[]{0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 2.0, 1.0, 1.0, 2.0});
        ConvexPolygon2D polygon2 = this.ctreatePolygonFromListOfXYPoints(new double[]{1.0, 1.0, 0.0, 3.0, 2.0, 2.0, 3.0, 0.0});
        try {
            new ConvexPolygonTools().computeMinimumDistancePoints((ConvexPolygon2DReadOnly)polygon1, (ConvexPolygon2DReadOnly)polygon2, (Point2DBasics)new Point2D(), (Point2DBasics)new Point2D());
            Assert.fail();
        }
        catch (RuntimeException re) {
            Assert.assertEquals(re.getMessage(), "Cannot compute minimum distance between intersecting polygons.");
        }
        try {
            new ConvexPolygonTools().computeMinimumDistancePoints((ConvexPolygon2DReadOnly)polygon2, (ConvexPolygon2DReadOnly)polygon1, (Point2DBasics)new Point2D(), (Point2DBasics)new Point2D());
            Assert.fail();
        }
        catch (RuntimeException re) {
            Assert.assertEquals(re.getMessage(), "Cannot compute minimum distance between intersecting polygons.");
        }
    }

    @Test
    public void testAllMethodsForPolygonWithOnePoint() {
        int numberOfTrials = 100;
        double epsilon = 1.0E-7;
        Random random = new Random(756483920L);
        ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
        for (int i = 0; i < numberOfTrials; ++i) {
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            Point2D pointThatDefinesThePolygon = new Point2D(random.nextDouble(), random.nextDouble());
            points.add(pointThatDefinesThePolygon);
            ConvexPolygon2D polygonWithOnePoint = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points));
            points.clear();
            Point2D pointThatDefinesAnotherPolygon = new Point2D(random.nextDouble(), random.nextDouble());
            points.add(pointThatDefinesAnotherPolygon);
            ConvexPolygon2D anotherPolygonWithOnePoint = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points));
            points.clear();
            points.add(new Point2D(random.nextDouble(), random.nextDouble()));
            points.add(new Point2D(random.nextDouble(), random.nextDouble()));
            points.add(new Point2D(random.nextDouble(), random.nextDouble()));
            ConvexPolygon2D sparePolygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points));
            Point2D arbitraryPoint0 = new Point2D(random.nextDouble(), random.nextDouble());
            Point2D arbitraryPoint1 = new Point2D(random.nextDouble(), random.nextDouble());
            Line2D arbitraryLine = new Line2D((Point2DReadOnly)arbitraryPoint0, (Point2DReadOnly)arbitraryPoint1);
            LineSegment2D arbitraryLineSegment = new LineSegment2D((Point2DReadOnly)arbitraryPoint0, (Point2DReadOnly)arbitraryPoint1);
            ConvexPolygon2D intersectionPolygon = new ConvexPolygon2D();
            Assert.assertEquals(pointThatDefinesThePolygon.distance((Point2DReadOnly)arbitraryPoint0), polygonWithOnePoint.getClosestVertexCopy((Point2DReadOnly)arbitraryPoint0).distance((Point2DReadOnly)arbitraryPoint0), epsilon);
            Assert.assertEquals(0.0, polygonWithOnePoint.getArea(), epsilon);
            Assertions.assertTrue((boolean)polygonWithOnePoint.getBoundingBox().getMaxPoint().equals((EuclidGeometry)pointThatDefinesThePolygon));
            Assertions.assertTrue((boolean)polygonWithOnePoint.getBoundingBox().getMinPoint().equals((EuclidGeometry)pointThatDefinesThePolygon));
            Assertions.assertTrue((boolean)polygonWithOnePoint.getCentroid().equals((EuclidGeometry)pointThatDefinesThePolygon));
            Assert.assertEquals(1L, polygonWithOnePoint.getNumberOfVertices());
            Assertions.assertTrue((boolean)polygonWithOnePoint.getVertex(0).equals((EuclidGeometry)pointThatDefinesThePolygon));
            Assertions.assertTrue((polygonWithOnePoint.getClosestEdgeCopy((Point2DReadOnly)arbitraryPoint0) == null ? 1 : 0) != 0);
            Assertions.assertTrue((polygonWithOnePoint.getClosestEdgeIndex((Point2DReadOnly)arbitraryPoint0) == -1 ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)polygonWithOnePoint.getClosestVertexCopy((Line2DReadOnly)arbitraryLine).equals((EuclidGeometry)pointThatDefinesThePolygon));
            Assertions.assertTrue((boolean)polygonWithOnePoint.getClosestVertexCopy((Point2DReadOnly)arbitraryPoint0).equals((EuclidGeometry)pointThatDefinesThePolygon));
            Assert.assertEquals(1L, polygonWithOnePoint.getNumberOfVertices());
            Assertions.assertTrue((boolean)polygonWithOnePoint.getVertexCCW(0).equals((EuclidGeometry)pointThatDefinesThePolygon));
            Assertions.assertTrue((ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)arbitraryLine, (ConvexPolygon2DReadOnly)polygonWithOnePoint) == null ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)polygonWithOnePoint.getVertex(polygonWithOnePoint.lineOfSightStartIndex((Point2DReadOnly)arbitraryPoint0)).equals((EuclidGeometry)pointThatDefinesThePolygon));
            Assertions.assertTrue((boolean)polygonWithOnePoint.getVertex(polygonWithOnePoint.lineOfSightEndIndex((Point2DReadOnly)arbitraryPoint0)).equals((EuclidGeometry)pointThatDefinesThePolygon));
            Assertions.assertTrue((boolean)polygonWithOnePoint.getCentroid().equals((EuclidGeometry)pointThatDefinesThePolygon));
            Assert.assertEquals(1L, polygonWithOnePoint.getNumberOfVertices());
            Assert.assertEquals(1L, polygonWithOnePoint.getNumberOfVertices());
            Assertions.assertTrue((boolean)polygonWithOnePoint.getVertex(0).equals((EuclidGeometry)pointThatDefinesThePolygon));
            Assert.assertFalse(convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)polygonWithOnePoint, (ConvexPolygon2DReadOnly)sparePolygon, (ConvexPolygon2DBasics)intersectionPolygon));
            Assert.assertFalse(convexPolygonTools.doPolygonsIntersect((ConvexPolygon2DReadOnly)polygonWithOnePoint, (ConvexPolygon2DReadOnly)sparePolygon));
            Assertions.assertTrue((polygonWithOnePoint.intersectionWith((Line2DReadOnly)arbitraryLine) == null ? 1 : 0) != 0);
            Assert.assertFalse(polygonWithOnePoint.isPointInside((Point2DReadOnly)arbitraryPoint0));
            Assert.assertFalse(ConvexPolygon2dCalculator.isPolygonInside((ConvexPolygon2DReadOnly)sparePolygon, (ConvexPolygon2DReadOnly)polygonWithOnePoint));
            Assertions.assertTrue((boolean)polygonWithOnePoint.orthogonalProjectionCopy((Point2DReadOnly)arbitraryPoint0).equals((EuclidGeometry)pointThatDefinesThePolygon));
            Assertions.assertTrue((boolean)polygonWithOnePoint.pointIsOnPerimeter((Point2DReadOnly)pointThatDefinesThePolygon));
            Assert.assertFalse(polygonWithOnePoint.pointIsOnPerimeter((Point2DReadOnly)arbitraryPoint0));
            ConvexPolygon2DBasics polygonTranslation = polygonWithOnePoint.translateCopy((Tuple2DReadOnly)arbitraryPoint0);
            Assert.assertEquals(1L, polygonTranslation.getNumberOfVertices());
            Point2D pointTranslation = new Point2D((Tuple2DReadOnly)pointThatDefinesThePolygon);
            pointTranslation.add((Tuple2DReadOnly)arbitraryPoint0);
            Assert.assertEquals(polygonTranslation.getVertex(0), pointTranslation);
            ConvexPolygon2D combinedPolygons = new ConvexPolygon2D((Vertex2DSupplier)polygonWithOnePoint, (Vertex2DSupplier)anotherPolygonWithOnePoint);
            Assert.assertEquals(2L, combinedPolygons.getNumberOfVertices());
            Point2DReadOnly point0 = combinedPolygons.getVertex(0);
            Point2DReadOnly point1 = combinedPolygons.getVertex(1);
            this.assertEqualsInEitherOrder((Point2DReadOnly)pointThatDefinesThePolygon, (Point2DReadOnly)pointThatDefinesAnotherPolygon, point0, point1);
            ConvexPolygon2D combinedPolygon = new ConvexPolygon2D();
            LineSegment2D connectingEdge1 = new LineSegment2D();
            LineSegment2D connectingEdge2 = new LineSegment2D();
            convexPolygonTools.combineDisjointPolygons((ConvexPolygon2DReadOnly)polygonWithOnePoint, (ConvexPolygon2DReadOnly)anotherPolygonWithOnePoint, (ConvexPolygon2DBasics)combinedPolygon, (LineSegment2DBasics)connectingEdge1, (LineSegment2DBasics)connectingEdge2);
            Assert.assertEquals(2L, combinedPolygon.getNumberOfVertices());
            point0 = combinedPolygon.getVertex(0);
            point1 = combinedPolygon.getVertex(1);
            this.assertEqualsInEitherOrder((Point2DReadOnly)pointThatDefinesThePolygon, (Point2DReadOnly)pointThatDefinesAnotherPolygon, point0, point1);
            Assert.assertFalse(convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)polygonWithOnePoint, (ConvexPolygon2DReadOnly)anotherPolygonWithOnePoint, (ConvexPolygon2DBasics)new ConvexPolygon2D()));
            Assert.assertFalse(convexPolygonTools.doPolygonsIntersect((ConvexPolygon2DReadOnly)polygonWithOnePoint, (ConvexPolygon2DReadOnly)anotherPolygonWithOnePoint));
            ConvexPolygon2D intersection = new ConvexPolygon2D();
            convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)polygonWithOnePoint, (ConvexPolygon2DReadOnly)polygonWithOnePoint, (ConvexPolygon2DBasics)intersection);
            Assert.assertEquals(1L, intersection.getNumberOfVertices());
            convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)polygonWithOnePoint, (ConvexPolygon2DReadOnly)polygonWithOnePoint, (ConvexPolygon2DBasics)intersection);
            Assertions.assertTrue((boolean)intersection.getVertex(0).equals((EuclidGeometry)pointThatDefinesThePolygon));
            Assertions.assertTrue((polygonWithOnePoint.intersectionWith((LineSegment2DReadOnly)arbitraryLineSegment) == null ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)polygonWithOnePoint.intersectionWith((LineSegment2DReadOnly)new LineSegment2D((Point2DReadOnly)pointThatDefinesThePolygon, (Point2DReadOnly)arbitraryPoint0))[0].equals((EuclidGeometry)pointThatDefinesThePolygon));
            ConvexPolygonScaler shrinker = new ConvexPolygonScaler();
            ConvexPolygon2D shrunkenOnePointPolygon = new ConvexPolygon2D();
            shrinker.scaleConvexPolygon((ConvexPolygon2DReadOnly)polygonWithOnePoint, random.nextDouble(), (ConvexPolygon2DBasics)shrunkenOnePointPolygon);
            Assertions.assertTrue((boolean)shrunkenOnePointPolygon.epsilonEquals((EuclidGeometry)polygonWithOnePoint, 1.0E-7));
        }
    }

    @Test
    public void testAllMethodsForPolygonWithTwoPoints() {
        int numberOfTrials = 100;
        double epsilon = 1.0E-7;
        Random random = new Random(756483920L);
        ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
        for (int i = 0; i < numberOfTrials; ++i) {
            Point2DBasics[] intersection;
            Point2D rightPoint;
            Point2D leftPoint;
            ArrayList<Point2D> points = new ArrayList<Point2D>();
            Point2D pointThatDefinesThePolygon0 = new Point2D(random.nextDouble(), random.nextDouble());
            Point2D pointThatDefinesThePolygon1 = new Point2D(random.nextDouble(), random.nextDouble());
            LineSegment2D lineSegmentThatDefinesThePolygon = new LineSegment2D((Point2DReadOnly)pointThatDefinesThePolygon0, (Point2DReadOnly)pointThatDefinesThePolygon1);
            points.add(pointThatDefinesThePolygon0);
            points.add(pointThatDefinesThePolygon1);
            ConvexPolygon2D polygonWithTwoPoints = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points));
            points.clear();
            Point2D pointThatDefinesAnotherPolygon = new Point2D(random.nextDouble(), random.nextDouble());
            points.add(pointThatDefinesAnotherPolygon);
            ConvexPolygon2D polygonWithOnePointx = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points));
            points.clear();
            points.add(new Point2D(random.nextDouble(), random.nextDouble()));
            points.add(new Point2D(random.nextDouble(), random.nextDouble()));
            points.add(new Point2D(random.nextDouble(), random.nextDouble()));
            ConvexPolygon2D sparePolygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(points));
            Point2D arbitraryPoint0 = new Point2D(random.nextDouble(), random.nextDouble());
            Point2D arbitraryPoint1 = new Point2D(random.nextDouble(), random.nextDouble());
            Line2D arbitraryLine = new Line2D((Point2DReadOnly)arbitraryPoint0, (Point2DReadOnly)arbitraryPoint1);
            LineSegment2D arbitraryLineSegment = new LineSegment2D((Point2DReadOnly)arbitraryPoint0, (Point2DReadOnly)arbitraryPoint1);
            Assert.assertEquals(Math.min(pointThatDefinesThePolygon0.distance((Point2DReadOnly)arbitraryPoint0), pointThatDefinesThePolygon1.distance((Point2DReadOnly)arbitraryPoint0)), polygonWithTwoPoints.getClosestVertexCopy((Point2DReadOnly)arbitraryPoint0).distance((Point2DReadOnly)arbitraryPoint0), epsilon);
            Assert.assertEquals(0.0, polygonWithTwoPoints.getArea(), epsilon);
            Point2D minPoint = new Point2D(Math.min(pointThatDefinesThePolygon0.getX(), pointThatDefinesThePolygon1.getX()), Math.min(pointThatDefinesThePolygon0.getY(), pointThatDefinesThePolygon1.getY()));
            Point2D maxPoint = new Point2D(Math.max(pointThatDefinesThePolygon0.getX(), pointThatDefinesThePolygon1.getX()), Math.max(pointThatDefinesThePolygon0.getY(), pointThatDefinesThePolygon1.getY()));
            Assertions.assertTrue((boolean)polygonWithTwoPoints.getBoundingBox().getMinPoint().equals((EuclidGeometry)minPoint));
            Assertions.assertTrue((boolean)polygonWithTwoPoints.getBoundingBox().getMaxPoint().equals((EuclidGeometry)maxPoint));
            Assertions.assertTrue((boolean)polygonWithTwoPoints.getCentroid().equals((EuclidGeometry)lineSegmentThatDefinesThePolygon.midpoint()));
            Assert.assertEquals(2L, polygonWithTwoPoints.getNumberOfVertices());
            this.assertEqualsInEitherOrder((Point2DReadOnly)pointThatDefinesThePolygon0, (Point2DReadOnly)pointThatDefinesThePolygon1, polygonWithTwoPoints.getVertex(0), polygonWithTwoPoints.getVertex(1));
            Assert.assertFalse(polygonWithTwoPoints.isPointInside((Point2DReadOnly)arbitraryPoint0));
            Assert.assertFalse(ConvexPolygon2dCalculator.isPolygonInside((ConvexPolygon2DReadOnly)sparePolygon, (ConvexPolygon2DReadOnly)polygonWithTwoPoints));
            Assert.assertEquals(2L, polygonWithTwoPoints.getNumberOfVertices());
            Assertions.assertTrue((polygonWithTwoPoints.getCentroid().getX() == 0.5 * (pointThatDefinesThePolygon0.getX() + pointThatDefinesThePolygon1.getX()) ? 1 : 0) != 0);
            Assertions.assertTrue((polygonWithTwoPoints.getCentroid().getY() == 0.5 * (pointThatDefinesThePolygon0.getY() + pointThatDefinesThePolygon1.getY()) ? 1 : 0) != 0);
            Assert.assertEquals(2L, polygonWithTwoPoints.getNumberOfVertices());
            LineSegment2DBasics closestEdge = polygonWithTwoPoints.getClosestEdgeCopy((Point2DReadOnly)arbitraryPoint0);
            Point2DReadOnly[] closestEdgeEndpoints = new Point2DReadOnly[]{closestEdge.getFirstEndpoint(), closestEdge.getSecondEndpoint()};
            this.assertEqualsInEitherOrder(closestEdgeEndpoints[0], closestEdgeEndpoints[1], (Point2DReadOnly)pointThatDefinesThePolygon0, (Point2DReadOnly)pointThatDefinesThePolygon1);
            int edgeIndex = polygonWithTwoPoints.getClosestEdgeIndex((Point2DReadOnly)arbitraryPoint0);
            this.assertEqualsInEitherOrder(edgeIndex, polygonWithTwoPoints.getNextVertexIndex(edgeIndex), 0.0, 1.0);
            this.assertEqualsInEitherOrder(polygonWithTwoPoints.getVertexCCW(0), polygonWithTwoPoints.getVertexCCW(1), (Point2DReadOnly)pointThatDefinesThePolygon0, (Point2DReadOnly)pointThatDefinesThePolygon1);
            Point2D[] lineOfSightPoints = new Point2D[]{polygonWithTwoPoints.getVertex(polygonWithTwoPoints.lineOfSightStartIndex((Point2DReadOnly)arbitraryPoint0)), polygonWithTwoPoints.getVertex(polygonWithTwoPoints.lineOfSightEndIndex((Point2DReadOnly)arbitraryPoint0))};
            this.assertEqualsInEitherOrder((Point2DReadOnly)lineOfSightPoints[0], (Point2DReadOnly)lineOfSightPoints[1], (Point2DReadOnly)pointThatDefinesThePolygon0, (Point2DReadOnly)pointThatDefinesThePolygon1);
            Point2DBasics expectedProjection = lineSegmentThatDefinesThePolygon.orthogonalProjectionCopy((Point2DReadOnly)arbitraryPoint0);
            Point2DBasics actualProjection = polygonWithTwoPoints.orthogonalProjectionCopy((Point2DReadOnly)arbitraryPoint0);
            Assertions.assertTrue((boolean)expectedProjection.epsilonEquals((EuclidGeometry)actualProjection, epsilon));
            Point2DBasics closestVertexToLine = polygonWithTwoPoints.getClosestVertexCopy((Line2DReadOnly)arbitraryLine);
            if (arbitraryLine.distance((Point2DReadOnly)pointThatDefinesThePolygon0) < arbitraryLine.distance((Point2DReadOnly)pointThatDefinesThePolygon1)) {
                Assert.assertEquals(closestVertexToLine, pointThatDefinesThePolygon0);
            } else {
                Assert.assertEquals(closestVertexToLine, pointThatDefinesThePolygon1);
            }
            Point2DBasics closestVertexToPoint = polygonWithTwoPoints.getClosestVertexCopy((Point2DReadOnly)arbitraryPoint0);
            if (arbitraryPoint0.distance((Point2DReadOnly)pointThatDefinesThePolygon0) < arbitraryPoint0.distance((Point2DReadOnly)pointThatDefinesThePolygon1)) {
                Assert.assertEquals(closestVertexToPoint, pointThatDefinesThePolygon0);
            } else {
                Assert.assertEquals(closestVertexToPoint, pointThatDefinesThePolygon1);
            }
            LineSegment2D[] intersectingEdges = ConvexPolygon2dCalculator.getIntersectingEdgesCopy((Line2DReadOnly)arbitraryLine, (ConvexPolygon2DReadOnly)polygonWithTwoPoints);
            boolean isLineAbovePoint0 = (pointThatDefinesThePolygon0.getX() - arbitraryLine.getPoint().getX()) * arbitraryLine.slope() + arbitraryLine.getPoint().getY() >= pointThatDefinesThePolygon0.getY();
            boolean isLineAbovePoint1 = (pointThatDefinesThePolygon1.getX() - arbitraryLine.getPoint().getX()) * arbitraryLine.slope() + arbitraryLine.getPoint().getY() >= pointThatDefinesThePolygon1.getY();
            boolean lineCrossesThroughPolygon = isLineAbovePoint0 ^ isLineAbovePoint1;
            if (!lineCrossesThroughPolygon) {
                Assertions.assertTrue((intersectingEdges == null ? 1 : 0) != 0);
            } else {
                for (int j : new int[]{0, 1}) {
                    Point2DReadOnly[] endPoints = new Point2DReadOnly[]{intersectingEdges[j].getFirstEndpoint(), intersectingEdges[j].getSecondEndpoint()};
                    this.assertEqualsInEitherOrder(endPoints[0], endPoints[1], (Point2DReadOnly)pointThatDefinesThePolygon0, (Point2DReadOnly)pointThatDefinesThePolygon1);
                }
            }
            Assert.assertEquals(2L, polygonWithTwoPoints.getNumberOfVertices());
            if (pointThatDefinesThePolygon0.getX() <= pointThatDefinesThePolygon1.getX()) {
                leftPoint = pointThatDefinesThePolygon0;
                rightPoint = pointThatDefinesThePolygon1;
            } else {
                leftPoint = pointThatDefinesThePolygon1;
                rightPoint = pointThatDefinesThePolygon0;
            }
            Assertions.assertTrue((leftPoint.getX() == polygonWithTwoPoints.getVertex(0).getX() && leftPoint.getY() == polygonWithTwoPoints.getVertex(0).getY() ? 1 : 0) != 0);
            Assertions.assertTrue((rightPoint.getX() == polygonWithTwoPoints.getVertex(1).getX() && rightPoint.getY() == polygonWithTwoPoints.getVertex(1).getY() ? 1 : 0) != 0);
            Point2DBasics[] expectedIntersectionWithSparePolygon = sparePolygon.intersectionWith((LineSegment2DReadOnly)new LineSegment2D((Point2DReadOnly)pointThatDefinesThePolygon0, (Point2DReadOnly)pointThatDefinesThePolygon1));
            ConvexPolygon2D actualIntersectionWithSparePolygon = new ConvexPolygon2D();
            boolean success = convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)sparePolygon, (ConvexPolygon2DReadOnly)polygonWithTwoPoints, (ConvexPolygon2DBasics)actualIntersectionWithSparePolygon);
            Assert.assertEquals(convexPolygonTools.doPolygonsIntersect((ConvexPolygon2DReadOnly)sparePolygon, (ConvexPolygon2DReadOnly)polygonWithTwoPoints), success);
            if (expectedIntersectionWithSparePolygon == null) {
                Assert.assertFalse(success);
            } else if (expectedIntersectionWithSparePolygon.length == 1) {
                Assertions.assertTrue((actualIntersectionWithSparePolygon.getNumberOfVertices() == 2 ? 1 : 0) != 0);
                this.assertEqualsAEqualsBOrC((Point2DReadOnly)expectedIntersectionWithSparePolygon[0], actualIntersectionWithSparePolygon.getVertex(0), actualIntersectionWithSparePolygon.getVertex(1));
            } else if (expectedIntersectionWithSparePolygon.length == 2) {
                Assertions.assertTrue((actualIntersectionWithSparePolygon.getNumberOfVertices() == 2 ? 1 : 0) != 0);
                this.assertEqualsInEitherOrder((Point2DReadOnly)expectedIntersectionWithSparePolygon[0], (Point2DReadOnly)expectedIntersectionWithSparePolygon[1], actualIntersectionWithSparePolygon.getVertex(0), actualIntersectionWithSparePolygon.getVertex(1));
            } else {
                Assert.fail();
            }
            double randomFraction = random.nextDouble();
            Point2D scaledPoint0 = new Point2D((Tuple2DReadOnly)pointThatDefinesThePolygon0);
            Point2D scaledPoint1 = new Point2D((Tuple2DReadOnly)pointThatDefinesThePolygon1);
            scaledPoint0.scale(randomFraction);
            scaledPoint1.scale(1.0 - randomFraction);
            Point2D randomLinearCombination = new Point2D();
            randomLinearCombination.add((Tuple2DReadOnly)scaledPoint0, (Tuple2DReadOnly)scaledPoint1);
            Assertions.assertTrue((boolean)polygonWithTwoPoints.pointIsOnPerimeter((Point2DReadOnly)randomLinearCombination));
            ConvexPolygon2DBasics polygonTranslation = polygonWithTwoPoints.translateCopy((Tuple2DReadOnly)arbitraryPoint0);
            Assert.assertEquals(2L, polygonTranslation.getNumberOfVertices());
            Point2D pointTranslation0 = new Point2D((Tuple2DReadOnly)pointThatDefinesThePolygon0);
            Point2D pointTranslation1 = new Point2D((Tuple2DReadOnly)pointThatDefinesThePolygon1);
            pointTranslation0.add((Tuple2DReadOnly)arbitraryPoint0);
            pointTranslation1.add((Tuple2DReadOnly)arbitraryPoint0);
            this.assertEqualsInEitherOrder(polygonTranslation.getVertex(0), polygonTranslation.getVertex(1), (Point2DReadOnly)pointTranslation0, (Point2DReadOnly)pointTranslation1);
            ConvexPolygon2D combinedPolygons = new ConvexPolygon2D((Vertex2DSupplier)polygonWithTwoPoints, (Vertex2DSupplier)polygonWithOnePointx);
            Assert.assertEquals(3L, combinedPolygons.getNumberOfVertices());
            Point2DReadOnly point0 = combinedPolygons.getVertex(0);
            Point2DReadOnly point1 = combinedPolygons.getVertex(1);
            Point2DReadOnly point2 = combinedPolygons.getVertex(2);
            this.assertEqualsInAnyOrder(point0, point1, point2, (Point2DReadOnly)pointThatDefinesThePolygon0, (Point2DReadOnly)pointThatDefinesThePolygon1, (Point2DReadOnly)pointThatDefinesAnotherPolygon);
            ConvexPolygon2D polygonIntersection = new ConvexPolygon2D();
            success = convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)polygonWithTwoPoints, (ConvexPolygon2DReadOnly)sparePolygon, (ConvexPolygon2DBasics)polygonIntersection);
            Assert.assertEquals(convexPolygonTools.doPolygonsIntersect((ConvexPolygon2DReadOnly)sparePolygon, (ConvexPolygon2DReadOnly)polygonWithTwoPoints), success);
            if (!success) {
                Assertions.assertTrue((sparePolygon.intersectionWith((LineSegment2DReadOnly)lineSegmentThatDefinesThePolygon) == null ? 1 : 0) != 0);
            } else if (polygonIntersection.getNumberOfVertices() == 1) {
                Assertions.assertTrue((boolean)sparePolygon.intersectionWith((LineSegment2DReadOnly)lineSegmentThatDefinesThePolygon)[0].epsilonEquals((EuclidGeometry)polygonIntersection.getVertex(0), epsilon));
            } else if (polygonIntersection.getNumberOfVertices() == 2) {
                intersection = sparePolygon.intersectionWith((LineSegment2DReadOnly)lineSegmentThatDefinesThePolygon);
                this.assertEqualsAEqualsBOrC((Point2DReadOnly)intersection[0], polygonIntersection.getVertex(0), polygonIntersection.getVertex(1));
            } else {
                Assert.fail();
            }
            intersection = polygonWithTwoPoints.intersectionWith((LineSegment2DReadOnly)arbitraryLineSegment);
            if (intersection == null) {
                Assertions.assertTrue((arbitraryLineSegment.intersectionWith((LineSegment2DReadOnly)lineSegmentThatDefinesThePolygon) == null ? 1 : 0) != 0);
            } else if (intersection.length == 1) {
                Assertions.assertTrue((intersection[0].distance((Point2DReadOnly)arbitraryLineSegment.intersectionWith((LineSegment2DReadOnly)lineSegmentThatDefinesThePolygon)) < epsilon ? 1 : 0) != 0);
            } else if (intersection.length == 2) {
                Assertions.assertTrue((intersection[0].distance((Point2DReadOnly)arbitraryLineSegment.intersectionWith((LineSegment2DReadOnly)lineSegmentThatDefinesThePolygon)) < epsilon ? 1 : 0) != 0);
                Assertions.assertTrue((intersection[1].distance((Point2DReadOnly)arbitraryLineSegment.intersectionWith((LineSegment2DReadOnly)lineSegmentThatDefinesThePolygon)) < epsilon ? 1 : 0) != 0);
                Assert.assertFalse(intersection[0].epsilonEquals((EuclidGeometry)intersection[1], epsilon));
            } else {
                Assert.fail();
            }
            double shrinkDistance = random.nextDouble() * lineSegmentThatDefinesThePolygon.length() / 2.0;
            ConvexPolygonScaler shrinker = new ConvexPolygonScaler();
            ConvexPolygon2D shrunkenPolygon = new ConvexPolygon2D();
            shrinker.scaleConvexPolygon((ConvexPolygon2DReadOnly)polygonWithTwoPoints, shrinkDistance, (ConvexPolygon2DBasics)shrunkenPolygon);
            shrinkDistance = lineSegmentThatDefinesThePolygon.length() / 2.0 + random.nextDouble();
            shrinker.scaleConvexPolygon((ConvexPolygon2DReadOnly)polygonWithTwoPoints, shrinkDistance, (ConvexPolygon2DBasics)shrunkenPolygon);
            Assertions.assertTrue((shrunkenPolygon.getNumberOfVertices() == 1 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testIntersectionWhenFullyInside() {
        ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
        ArrayList<Point2D> listOfPoints = new ArrayList<Point2D>();
        listOfPoints.add(new Point2D(0.0, 0.0));
        listOfPoints.add(new Point2D(1.0, 0.0));
        listOfPoints.add(new Point2D(0.0, 1.0));
        listOfPoints.add(new Point2D(1.0, 1.0));
        ConvexPolygon2D convexPolygon2dA = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(listOfPoints));
        listOfPoints.clear();
        listOfPoints.add(new Point2D(-1.0, -1.0));
        listOfPoints.add(new Point2D(2.0, -1.0));
        listOfPoints.add(new Point2D(-1.0, 2.0));
        listOfPoints.add(new Point2D(2.0, 2.0));
        ConvexPolygon2D convexPolygon2dB = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(listOfPoints));
        ConvexPolygon2D intersection = new ConvexPolygon2D();
        boolean success = convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)convexPolygon2dA, (ConvexPolygon2DReadOnly)convexPolygon2dB, (ConvexPolygon2DBasics)intersection);
        Assert.assertEquals(convexPolygonTools.doPolygonsIntersect((ConvexPolygon2DReadOnly)convexPolygon2dA, (ConvexPolygon2DReadOnly)convexPolygon2dB), success);
        boolean epsilonEquals = intersection.epsilonEquals((EuclidGeometry)convexPolygon2dA, 1.0E-7);
        Assertions.assertTrue((boolean)epsilonEquals);
        success = convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)convexPolygon2dB, (ConvexPolygon2DReadOnly)convexPolygon2dA, (ConvexPolygon2DBasics)intersection);
        Assert.assertEquals(convexPolygonTools.doPolygonsIntersect((ConvexPolygon2DReadOnly)convexPolygon2dA, (ConvexPolygon2DReadOnly)convexPolygon2dB), success);
        epsilonEquals = intersection.epsilonEquals((EuclidGeometry)convexPolygon2dA, 1.0E-7);
        Assertions.assertTrue((boolean)epsilonEquals);
        listOfPoints.clear();
        listOfPoints.add(new Point2D(0.1904001452623111, 0.07922536690619195));
        listOfPoints.add(new Point2D(0.1923482408479345, 0.5736513188711437));
        listOfPoints.add(new Point2D(0.24837080387208538, 0.5533707067242215));
        listOfPoints.add(new Point2D(0.2560381177005394, 0.550093244819894));
        listOfPoints.add(new Point2D(0.3021057612864858, 0.5276338625408057));
        listOfPoints.add(new Point2D(0.35302325196142154, 0.49669456810449586));
        listOfPoints.add(new Point2D(0.4006211967955147, 0.4608579046936889));
        listOfPoints.add(new Point2D(0.4444302495375464, 0.42047724478458476));
        listOfPoints.add(new Point2D(0.4840184248413931, 0.3759507675720234));
        listOfPoints.add(new Point2D(0.5189953579184864, 0.3277175326673503));
        listOfPoints.add(new Point2D(0.5490161537848919, 0.27625315068916595));
        listOfPoints.add(new Point2D(0.5737847881469639, 0.2220650934377122));
        listOfPoints.add(new Point2D(0.5930570263906623, 0.16568768989757945));
        listOfPoints.add(new Point2D(0.606642831891427, 0.10767685741135981));
        listOfPoints.add(new Point2D(0.1904001452623111, 0.07922536690619195));
        convexPolygon2dA = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(listOfPoints));
        listOfPoints.clear();
        listOfPoints.add(new Point2D(-0.26792484945022277, 0.5164452162023662));
        listOfPoints.add(new Point2D(-0.21938799685279367, 0.5422255592213991));
        listOfPoints.add(new Point2D(-0.1686958167513698, 0.5634565512568254));
        listOfPoints.add(new Point2D(-0.11627362387979798, 0.5799600612101443));
        listOfPoints.add(new Point2D(-0.06256124802966133, 0.591597622242303));
        listOfPoints.add(new Point2D(-0.008009343814616467, 0.5982715935305327));
        listOfPoints.add(new Point2D(0.04692439038709253, 0.5999259794889963));
        listOfPoints.add(new Point2D(0.10177905258832422, 0.5965468995798632));
        listOfPoints.add(new Point2D(0.1560944042274756, 0.5881627047730331));
        listOfPoints.add(new Point2D(0.20941473163667895, 0.5748437396773916));
        listOfPoints.add(new Point2D(0.26129266954548536, 0.5567017523393519));
        listOfPoints.add(new Point2D(0.3112929545402855, 0.5338889566605598));
        listOfPoints.add(new Point2D(0.3589960769873979, 0.5065967553012091));
        listOfPoints.add(new Point2D(0.40400180077966186, 0.4750541337839984));
        listOfPoints.add(new Point2D(0.4459325213753508, 0.43952573927242716));
        listOfPoints.add(new Point2D(0.48443643395497327, 0.4003096601427597));
        listOfPoints.add(new Point2D(0.5191904851146687, 0.3577349249793695));
        listOfPoints.add(new Point2D(0.5499030833310595, 0.31215874197725635));
        listOfPoints.add(new Point2D(0.5763165454563693, 0.26396350191354906));
        listOfPoints.add(new Point2D(0.5982092587173592, 0.2135535698334953));
        listOfPoints.add(new Point2D(0.6153975400785948, 0.16135189236915945));
        listOfPoints.add(new Point2D(0.6277371773697216, 0.10779644915591552));
        listOfPoints.add(new Point2D(0.6351246392464617, 0.05333657811986491));
        listOfPoints.add(new Point2D(0.6374979438335908, -0.00157079453245079));
        listOfPoints.add(new Point2D(0.634837178761848, -0.056464987991108585));
        listOfPoints.add(new Point2D(0.0, 0.06));
        convexPolygon2dB = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(listOfPoints));
        success = convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)convexPolygon2dB, (ConvexPolygon2DReadOnly)convexPolygon2dA, (ConvexPolygon2DBasics)intersection);
        Assert.assertEquals(convexPolygonTools.doPolygonsIntersect((ConvexPolygon2DReadOnly)convexPolygon2dA, (ConvexPolygon2DReadOnly)convexPolygon2dB), success);
        epsilonEquals = intersection.epsilonEquals((EuclidGeometry)convexPolygon2dA, 1.0E-14);
        Assertions.assertTrue((boolean)epsilonEquals);
        success = convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)convexPolygon2dA, (ConvexPolygon2DReadOnly)convexPolygon2dB, (ConvexPolygon2DBasics)intersection);
        Assert.assertEquals(convexPolygonTools.doPolygonsIntersect((ConvexPolygon2DReadOnly)convexPolygon2dA, (ConvexPolygon2DReadOnly)convexPolygon2dB), success);
        epsilonEquals = intersection.epsilonEquals((EuclidGeometry)convexPolygon2dA, 1.0E-14);
        Assertions.assertTrue((boolean)epsilonEquals);
    }

    @Test
    public void testIntersectionWhenFullyInsideWithRepeatedPoint() {
        ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
        ArrayList<Point2D> listOfPoints = new ArrayList<Point2D>();
        listOfPoints.add(new Point2D(0.19, 0.0));
        listOfPoints.add(new Point2D(0.192, 0.6));
        listOfPoints.add(new Point2D(0.25, 0.5));
        listOfPoints.add(new Point2D(0.19, 0.0));
        ConvexPolygon2D convexPolygon2dA = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(listOfPoints));
        listOfPoints.clear();
        listOfPoints.add(new Point2D(-1.0, -1.0));
        listOfPoints.add(new Point2D(2.0, -1.0));
        listOfPoints.add(new Point2D(-1.0, 2.0));
        listOfPoints.add(new Point2D(2.0, 2.0));
        ConvexPolygon2D convexPolygon2dB = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(listOfPoints));
        ConvexPolygon2D intersection = new ConvexPolygon2D();
        boolean success = convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)convexPolygon2dA, (ConvexPolygon2DReadOnly)convexPolygon2dB, (ConvexPolygon2DBasics)intersection);
        Assert.assertEquals(convexPolygonTools.doPolygonsIntersect((ConvexPolygon2DReadOnly)convexPolygon2dA, (ConvexPolygon2DReadOnly)convexPolygon2dB), success);
        boolean epsilonEquals = intersection.epsilonEquals((EuclidGeometry)convexPolygon2dA, 1.0E-14);
        Assertions.assertTrue((boolean)epsilonEquals);
        success = convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)convexPolygon2dB, (ConvexPolygon2DReadOnly)convexPolygon2dA, (ConvexPolygon2DBasics)intersection);
        Assert.assertEquals(convexPolygonTools.doPolygonsIntersect((ConvexPolygon2DReadOnly)convexPolygon2dA, (ConvexPolygon2DReadOnly)convexPolygon2dB), success);
        epsilonEquals = intersection.epsilonEquals((EuclidGeometry)convexPolygon2dA, 1.0E-14);
        Assertions.assertTrue((boolean)epsilonEquals);
    }

    @Test
    public void testIntersectTwoPolygonsWhereOneIsALine() {
        ConvexPolygon2D simpleSquare = new ConvexPolygon2D();
        simpleSquare.addVertex(0.5, 0.5);
        simpleSquare.addVertex(0.5, -0.5);
        simpleSquare.addVertex(-0.5, -0.5);
        simpleSquare.addVertex(-0.5, 0.5);
        simpleSquare.update();
        ConvexPolygon2D simpleLine = new ConvexPolygon2D();
        simpleLine.addVertex(0.25, 0.25);
        simpleLine.addVertex(-0.75, 0.25);
        simpleLine.update();
        ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
        ConvexPolygon2D simplerLine = new ConvexPolygon2D();
        ConvexPolygon2D simplerLineExpected = new ConvexPolygon2D();
        simplerLineExpected.addVertex(0.25, 0.25);
        simplerLineExpected.addVertex(-0.5, 0.25);
        simplerLineExpected.update();
        convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)simpleSquare, (ConvexPolygon2DReadOnly)simpleLine, (ConvexPolygon2DBasics)simplerLine);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)simplerLineExpected, (EuclidGeometry)simplerLine, (double)1.0E-5);
    }

    @Disabled(value="Broken. Have a smoking gun test to fix.")
    @Test
    public void testComputeMinimumDistancePointsSimpleCases() {
        double[][] verticesOne = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 1.0}, {1.0, 0.0}};
        double[][] verticesTwo = new double[][]{{2.0, 0.0}, {2.0, 1.0}, {3.0, 1.0}, {3.0, 0.0}};
        ConvexPolygon2D polygonOne = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesOne));
        ConvexPolygon2D polygonTwo = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesTwo));
        ConvexPolygonTools tools = new ConvexPolygonTools();
        Point2D closestPointOnOne = new Point2D();
        Point2D closestPointOnTwo = new Point2D();
        tools.computeMinimumDistancePoints((ConvexPolygon2DReadOnly)polygonOne, (ConvexPolygon2DReadOnly)polygonTwo, (Point2DBasics)closestPointOnOne, (Point2DBasics)closestPointOnTwo);
        Assert.assertEquals(1.0, closestPointOnOne.getX(), 1.0E-7);
        Assert.assertEquals(2.0, closestPointOnTwo.getX(), 1.0E-7);
        Assert.assertEquals(closestPointOnOne.getY(), closestPointOnTwo.getY(), 1.0E-7);
        Assertions.assertTrue((closestPointOnOne.getY() >= 0.0 ? 1 : 0) != 0);
        Assertions.assertTrue((closestPointOnOne.getY() <= 1.0 ? 1 : 0) != 0);
        verticesOne = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.00001, 1.0}, {1.0, 0.0}};
        polygonOne = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesOne));
        tools.computeMinimumDistancePoints((ConvexPolygon2DReadOnly)polygonOne, (ConvexPolygon2DReadOnly)polygonTwo, (Point2DBasics)closestPointOnOne, (Point2DBasics)closestPointOnTwo);
        Assertions.assertTrue((boolean)closestPointOnOne.epsilonEquals((EuclidGeometry)new Point2D(1.00001, 1.0), 1.0E-7));
        Assertions.assertTrue((boolean)closestPointOnTwo.epsilonEquals((EuclidGeometry)new Point2D(2.0, 1.0), 1.0E-7));
        verticesOne = new double[][]{{0.0, 0.0}, {0.0, 1.0}, {1.0, 1.0}, {1.0001, 0.0}};
        polygonOne = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesOne));
        tools.computeMinimumDistancePoints((ConvexPolygon2DReadOnly)polygonOne, (ConvexPolygon2DReadOnly)polygonTwo, (Point2DBasics)closestPointOnOne, (Point2DBasics)closestPointOnTwo);
        Assertions.assertTrue((boolean)closestPointOnOne.epsilonEquals((EuclidGeometry)new Point2D(1.0001, 0.0), 1.0E-7));
        Assertions.assertTrue((boolean)closestPointOnTwo.epsilonEquals((EuclidGeometry)new Point2D(2.0, 0.0), 1.0E-7));
        verticesOne = new double[][]{{0.0, 0.0}, {1.0, 1.0}, {1.0, 0.0}};
        verticesTwo = new double[][]{{1.0, 2.0}, {2.0, 2.0}, {2.0, 1.0}};
        polygonOne = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesOne));
        polygonTwo = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesTwo));
        tools.computeMinimumDistancePoints((ConvexPolygon2DReadOnly)polygonOne, (ConvexPolygon2DReadOnly)polygonTwo, (Point2DBasics)closestPointOnOne, (Point2DBasics)closestPointOnTwo);
        Assertions.assertTrue((boolean)closestPointOnOne.epsilonEquals((EuclidGeometry)new Point2D(1.0, 1.0), 1.0E-7));
        Assertions.assertTrue((boolean)closestPointOnTwo.epsilonEquals((EuclidGeometry)new Point2D(1.5, 1.5), 1.0E-7));
        verticesOne = new double[][]{{1.0, 1.0}, {1.001, 0.0}, {0.0, 0.0}};
        polygonOne = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesOne));
        tools.computeMinimumDistancePoints((ConvexPolygon2DReadOnly)polygonOne, (ConvexPolygon2DReadOnly)polygonTwo, (Point2DBasics)closestPointOnOne, (Point2DBasics)closestPointOnTwo);
        Assertions.assertTrue((boolean)closestPointOnOne.epsilonEquals((EuclidGeometry)new Point2D(1.0, 1.0), 1.0E-7));
        Assertions.assertTrue((boolean)closestPointOnTwo.epsilonEquals((EuclidGeometry)new Point2D(1.5, 1.5), 1.0E-7), (String)("closestPointOnTwo = " + String.valueOf(closestPointOnTwo)));
    }

    @Disabled
    @Test
    public void testComputeMinimumDistancePointsTroublesomeOneNotCorrectAnswer() {
        double[][] verticesOne = new double[][]{{0.597, 0.111}, {0.746, 0.846}, {0.728, 0.219}};
        double[][] verticesTwo = new double[][]{{2.23, 0.972}, {2.467, 0.955}, {2.313, 0.369}};
        ConvexPolygon2D polygonOne = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesOne));
        ConvexPolygon2D polygonTwo = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesTwo));
        ConvexPolygonTools tools = new ConvexPolygonTools();
        Point2D closestPointOnOne = new Point2D();
        Point2D closestPointOnTwo = new Point2D();
        tools.computeMinimumDistancePoints((ConvexPolygon2DReadOnly)polygonOne, (ConvexPolygon2DReadOnly)polygonTwo, (Point2DBasics)closestPointOnOne, (Point2DBasics)closestPointOnTwo);
        double minimumDistancePointsDistance = closestPointOnOne.distance((Point2DReadOnly)closestPointOnTwo);
        Point2D midPoint = this.computeMidpoint((Point2DBasics)closestPointOnOne, (Point2DBasics)closestPointOnTwo);
        Point2D projectionOnOne = new Point2D((Tuple2DReadOnly)midPoint);
        polygonOne.orthogonalProjection((Point2DBasics)projectionOnOne);
        Point2D projectionOnTwo = new Point2D((Tuple2DReadOnly)midPoint);
        polygonTwo.orthogonalProjection((Point2DBasics)projectionOnTwo);
        double projectionDistance = projectionOnOne.distance((Point2DReadOnly)projectionOnTwo);
        boolean success = true;
        if (Math.abs(minimumDistancePointsDistance - projectionDistance) > 1.0E-7) {
            System.err.println("minimumDistancePointsDistance = " + minimumDistancePointsDistance + ", projectionDistance =  " + projectionDistance);
            System.err.println("polygonOne = " + String.valueOf(polygonOne));
            System.err.println("polygonOne Area = " + polygonOne.getArea());
            System.err.println("polygonTwo = " + String.valueOf(polygonTwo));
            System.err.println("polygonTwo Area = " + polygonTwo.getArea());
            System.err.println();
            success = false;
        }
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        Assertions.assertTrue((boolean)success);
    }

    @Disabled
    @Test
    public void testComputeMinimumDistancePointsWithRandomExamples() {
        Random random = new Random(1234L);
        double centerXMin = 0.0;
        double centerXMax = 1.0;
        double centerYMin = 0.0;
        double centerYMax = 1.0;
        double widthMax = 2.0;
        double heightMax = 2.0;
        int numberOfPoints = 3;
        int numberOfPolygons = 30;
        ArrayList<FrameConvexPolygon2D> randomPolygonsOne = ConvexPolygon2dTestHelpers.generateRandomPolygons(random, ReferenceFrame.getWorldFrame(), centerXMin, centerXMax, centerYMin, centerYMax, widthMax, heightMax, numberOfPoints, numberOfPolygons);
        centerXMin = 1.5;
        centerXMax = 2.0;
        ArrayList<FrameConvexPolygon2D> randomPolygonsTwo = ConvexPolygon2dTestHelpers.generateRandomPolygons(random, ReferenceFrame.getWorldFrame(), centerXMin, centerXMax, centerYMin, centerYMax, widthMax, heightMax, numberOfPoints, numberOfPolygons);
        ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
        boolean success = true;
        for (FrameConvexPolygon2D polygonOne : randomPolygonsOne) {
            polygonOne.update();
            if (polygonOne.getNumberOfVertices() < 3) continue;
            for (FrameConvexPolygon2D polygonTwo : randomPolygonsTwo) {
                polygonTwo.update();
                if (polygonTwo.getNumberOfVertices() < 3) continue;
                Point2D closestPointOnOne = new Point2D();
                Point2D closestPointOnTwo = new Point2D();
                convexPolygonTools.computeMinimumDistancePoints((ConvexPolygon2DReadOnly)polygonOne, (ConvexPolygon2DReadOnly)polygonTwo, (Point2DBasics)closestPointOnOne, (Point2DBasics)closestPointOnTwo);
                double minimumDistancePointsDistance = closestPointOnOne.distance((Point2DReadOnly)closestPointOnTwo);
                Point2D midPoint = this.computeMidpoint((Point2DBasics)closestPointOnOne, (Point2DBasics)closestPointOnTwo);
                Point2D projectionOnOne = new Point2D((Tuple2DReadOnly)midPoint);
                polygonOne.orthogonalProjection((Point2DBasics)projectionOnOne);
                Point2D projectionOnTwo = new Point2D((Tuple2DReadOnly)midPoint);
                polygonTwo.orthogonalProjection((Point2DBasics)projectionOnTwo);
                double projectionDistance = projectionOnOne.distance((Point2DReadOnly)projectionOnTwo);
                if (!(Math.abs(minimumDistancePointsDistance - projectionDistance) > 1.0E-7)) continue;
                System.err.println("minimumDistancePointsDistance = " + minimumDistancePointsDistance + ", projectionDistance =  " + projectionDistance);
                System.err.println("polygonOne = " + String.valueOf(polygonOne));
                System.err.println("polygonOne Area = " + polygonOne.getArea());
                System.err.println("polygonTwo = " + String.valueOf(polygonTwo));
                System.err.println("polygonTwo Area = " + polygonTwo.getArea());
                System.err.println();
                success = false;
            }
        }
        Assertions.assertTrue((boolean)success);
    }

    private Point2D computeMidpoint(Point2DBasics closestPointOnOne, Point2DBasics closestPointOnTwo) {
        Point2D midPoint = new Point2D((Tuple2DReadOnly)closestPointOnOne);
        midPoint.add((Tuple2DReadOnly)closestPointOnTwo);
        midPoint.scale(0.5);
        return midPoint;
    }

    @Disabled
    @Test
    public void testComputeMinimumDistancePointsTroublesomeOneWithOutOfBoundsException() {
        double[][] verticesOne = new double[][]{{5.147, -1.271}, {5.215, -1.234}, {7.149, -0.379}, {7.375, -0.379}, {7.48, -0.403}, {9.429, -1.753}, {9.436, -1.83}, {9.444, -1.988}, {9.277, -1.991}, {7.778, -1.994}, {5.346, -1.992}, {5.248, -1.99}, {5.212, -1.913}};
        double[][] verticesTwo = new double[][]{{3.09, -1.211}, {3.564, -1.185}, {4.693, -1.185}, {4.924, -1.214}, {4.985, -1.225}, {4.995, -1.289}, {4.073, -1.29}, {3.177, -1.29}};
        ConvexPolygon2D polygonOne = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesOne));
        ConvexPolygon2D polygonTwo = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])verticesTwo));
        ConvexPolygonTools tools = new ConvexPolygonTools();
        Point2D pointOneToPack = new Point2D();
        Point2D pointTwoToPack = new Point2D();
        tools.computeMinimumDistancePoints((ConvexPolygon2DReadOnly)polygonOne, (ConvexPolygon2DReadOnly)polygonTwo, (Point2DBasics)pointOneToPack, (Point2DBasics)pointTwoToPack);
    }

    @Test
    public void testCutSimpleConvexPolygonAbove() {
        ConvexPolygon2D size2square0center = new ConvexPolygon2D();
        size2square0center.addVertex(1.0, 1.0);
        size2square0center.addVertex(1.0, -1.0);
        size2square0center.addVertex(-1.0, -1.0);
        size2square0center.addVertex(-1.0, 1.0);
        size2square0center.update();
        LogTools.info((String)"{}", (Object)size2square0center.getVertex(0));
        Line2D yAxis = new Line2D(0.0, 0.0, 0.0, -1.0);
        ConvexPolygon2D croppedResult = new ConvexPolygon2D();
        ConvexPolygonCutResult result = ConvexPolygonTools.cutPolygonToLeftOfLine((ConvexPolygon2DReadOnly)size2square0center, (Line2DReadOnly)yAxis, (ConvexPolygon2DBasics)croppedResult);
        Assertions.assertEquals((Object)result, (Object)ConvexPolygonCutResult.CUT, (String)"supposed to cut");
        ConvexPolygon2D aboveYAxisRectangle = new ConvexPolygon2D();
        aboveYAxisRectangle.addVertex(1.0, 1.0);
        aboveYAxisRectangle.addVertex(1.0, -1.0);
        aboveYAxisRectangle.addVertex(0.0, -1.0);
        aboveYAxisRectangle.addVertex(0.0, 1.0);
        aboveYAxisRectangle.update();
        Assertions.assertTrue((boolean)croppedResult.geometricallyEquals((EuclidGeometry)aboveYAxisRectangle, 1.0E-7));
    }

    @Test
    public void testCutSimpleConvexPolygonBelow() {
        ConvexPolygon2D size2square0center = new ConvexPolygon2D();
        size2square0center.addVertex(1.0, 1.0);
        size2square0center.addVertex(1.0, -1.0);
        size2square0center.addVertex(-1.0, -1.0);
        size2square0center.addVertex(-1.0, 1.0);
        size2square0center.update();
        Line2D yAxis = new Line2D(0.0, 0.0, 0.0, 1.0);
        ConvexPolygon2D croppedResult = new ConvexPolygon2D();
        ConvexPolygonCutResult result = ConvexPolygonTools.cutPolygonToLeftOfLine((ConvexPolygon2DReadOnly)size2square0center, (Line2DReadOnly)yAxis, (ConvexPolygon2DBasics)croppedResult);
        Assertions.assertEquals((Object)result, (Object)ConvexPolygonCutResult.CUT, (String)"supposed to cut");
        ConvexPolygon2D aboveYAxisRectangle = new ConvexPolygon2D();
        aboveYAxisRectangle.addVertex(-1.0, 1.0);
        aboveYAxisRectangle.addVertex(0.0, 1.0);
        aboveYAxisRectangle.addVertex(0.0, -1.0);
        aboveYAxisRectangle.addVertex(-1.0, -1.0);
        aboveYAxisRectangle.update();
        Assertions.assertTrue((boolean)croppedResult.geometricallyEquals((EuclidGeometry)aboveYAxisRectangle, 1.0E-7));
    }

    @Test
    public void testPolygonIntersections() {
        ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
        Random random = new Random(1886L);
        ReferenceFrame zUpFrame = ReferenceFrameTools.constructARootFrame((String)"someFrame");
        double xMin = 0.0;
        double xMax = 1.0;
        double yMin = 0.0;
        double yMax = 1.0;
        double widthMax = 0.5;
        double heightMax = 0.5;
        int numberOfPoints = 20;
        int numberOfPolygons = 30;
        ArrayList<FrameConvexPolygon2D> randomPolygons = ConvexPolygon2dTestHelpers.generateRandomPolygons(random, zUpFrame, xMin, xMax, yMin, yMax, widthMax, heightMax, numberOfPoints, numberOfPolygons);
        Object testFrame = null;
        Object plotter = null;
        ConvexPolygon2D[][] intersectingPolygons = new ConvexPolygon2D[randomPolygons.size()][randomPolygons.size()];
        int n = randomPolygons.size();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                FrameConvexPolygon2D polygon1 = randomPolygons.get(i);
                FrameConvexPolygon2D polygon2 = randomPolygons.get(j);
                ConvexPolygon2D convexPolygon1 = new ConvexPolygon2D((Vertex2DSupplier)polygon1);
                ConvexPolygon2D convexPolygon2 = new ConvexPolygon2D((Vertex2DSupplier)polygon2);
                ConvexPolygon2D intersectingPolygon = new ConvexPolygon2D();
                boolean success = convexPolygonTools.computeIntersectionOfPolygons((ConvexPolygon2DReadOnly)convexPolygon1, (ConvexPolygon2DReadOnly)convexPolygon2, (ConvexPolygon2DBasics)intersectingPolygon);
                Assert.assertEquals(convexPolygonTools.doPolygonsIntersect((ConvexPolygon2DReadOnly)convexPolygon1, (ConvexPolygon2DReadOnly)convexPolygon2), success);
                if (!success) {
                    intersectingPolygon = null;
                }
                intersectingPolygons[i][j] = intersectingPolygon;
                if (success && i == j) continue;
            }
        }
        ArrayList<FramePoint2D> testPoints = ConvexPolygon2dTestHelpers.generateRandomRectangularFramePoints(random, zUpFrame, xMin, xMax, yMin, yMax, 10000);
        for (FramePoint2D testPoint : testPoints) {
            boolean insideAnyIntersection = false;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    boolean insideIntersection;
                    FrameConvexPolygon2D polygon1 = randomPolygons.get(i);
                    FrameConvexPolygon2D polygon2 = randomPolygons.get(j);
                    boolean inside1 = polygon1.isPointInside((FramePoint2DReadOnly)testPoint);
                    boolean inside2 = polygon2.isPointInside((FramePoint2DReadOnly)testPoint);
                    ConvexPolygon2D intersectionPolygon = intersectingPolygons[i][j];
                    if (i == j) {
                        Assert.assertNotNull(intersectionPolygon);
                    }
                    boolean bl = insideIntersection = intersectionPolygon != null && intersectionPolygon.isPointInside((Point2DReadOnly)testPoint);
                    if (insideIntersection) {
                        insideAnyIntersection = true;
                    }
                    if (inside1 && inside2) {
                        Assertions.assertTrue((boolean)insideIntersection, (String)"inside1 and inside2, but not inside intersection");
                    }
                    if (!insideIntersection) continue;
                    Assertions.assertTrue((boolean)inside1, (String)"insideIntersection, but not inside1");
                    Assertions.assertTrue((boolean)inside2, (String)"insideIntersection, but not inside2");
                }
            }
        }
    }

    @Test
    public void testComputeMinimumDistancePointsBug() {
        Point2D polygon1MinPoint = new Point2D();
        Point2D polygon2MinPoint = new Point2D();
        ConvexPolygon2D polygon1 = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[]{new Point2D(-0.964173902597, 0.063152759605), new Point2D(1.035825870746, 0.062200589754), new Point2D(0.742755947614, -0.308890986251), new Point2D(0.035576039489, -0.462323265823), new Point2D(-0.671457454488, -0.308217700493)}));
        ConvexPolygon2D polygon2 = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((Point2DReadOnly[])new Point2DReadOnly[]{new Point2D(-2.343969106435, -1.557740484682), new Point2D(-2.343472477274, -0.507264050627), new Point2D(-0.542724054207, -0.508121359902), new Point2D(-0.543220683369, -1.558597793958)}));
        double epsilon = 0.01;
        new ConvexPolygonTools().computeMinimumDistancePoints((ConvexPolygon2DReadOnly)polygon1, (ConvexPolygon2DReadOnly)polygon2, epsilon, (Point2DBasics)polygon1MinPoint, (Point2DBasics)polygon2MinPoint);
        Assertions.assertTrue((boolean)polygon1.pointIsOnPerimeter((Point2DReadOnly)polygon1MinPoint));
        Assertions.assertTrue((boolean)polygon2.pointIsOnPerimeter((Point2DReadOnly)polygon2MinPoint));
        Assertions.assertTrue((polygon1MinPoint.distance((Point2DReadOnly)polygon2MinPoint) < polygon1.getVertex(0).distance(polygon2.getVertex(0)) ? 1 : 0) != 0);
    }

    private void assertEqualsInEitherOrder(double expected0, double expected1, double actual0, double actual1) {
        if (expected0 == actual0) {
            Assertions.assertTrue((expected1 == actual1 ? 1 : 0) != 0);
        } else if (expected0 == actual1) {
            Assertions.assertTrue((expected1 == actual0 ? 1 : 0) != 0);
        } else {
            System.out.println(expected0);
            System.out.println(expected1);
            System.out.println(actual0);
            System.out.println(actual1);
            Assert.fail("Doubles are not equal in either order.");
        }
    }

    private void assertEqualsAEqualsBOrC(Point2DReadOnly a, Point2DReadOnly b, Point2DReadOnly c) {
        Assertions.assertTrue((a.epsilonEquals((EuclidGeometry)b, 1.0E-7) || a.epsilonEquals((EuclidGeometry)c, 1.0E-7) ? 1 : 0) != 0);
    }

    private void assertEqualsInEitherOrder(Point2DReadOnly expected0, Point2DReadOnly expected1, Point2DReadOnly actual0, Point2DReadOnly actual1) {
        if (expected0.epsilonEquals((EuclidGeometry)actual0, 1.0E-7)) {
            Assertions.assertTrue((boolean)expected1.epsilonEquals((EuclidGeometry)actual1, 1.0E-7));
        } else if (expected0.epsilonEquals((EuclidGeometry)actual1, 1.0E-7)) {
            Assertions.assertTrue((boolean)expected1.epsilonEquals((EuclidGeometry)actual0, 1.0E-7));
        } else {
            Assert.fail("Points are not equal in either order.");
        }
    }

    private void assertEqualsInAnyOrder(Point2DReadOnly expected0, Point2DReadOnly expected1, Point2DReadOnly expected2, Point2DReadOnly actual0, Point2DReadOnly actual1, Point2DReadOnly actual2) {
        if (expected0.equals((EuclidGeometry)actual0) && expected1.equals((EuclidGeometry)actual1)) {
            Assertions.assertTrue((boolean)expected2.equals((EuclidGeometry)actual2));
        } else if (expected0.equals((EuclidGeometry)actual0) && expected1.equals((EuclidGeometry)actual2)) {
            Assertions.assertTrue((boolean)expected2.equals((EuclidGeometry)actual1));
        } else if (expected0.equals((EuclidGeometry)actual1) && expected1.equals((EuclidGeometry)actual0)) {
            Assertions.assertTrue((boolean)expected2.equals((EuclidGeometry)actual2));
        } else if (expected0.equals((EuclidGeometry)actual1) && expected1.equals((EuclidGeometry)actual2)) {
            Assertions.assertTrue((boolean)expected2.equals((EuclidGeometry)actual0));
        } else if (expected0.equals((EuclidGeometry)actual2) && expected1.equals((EuclidGeometry)actual0)) {
            Assertions.assertTrue((boolean)expected2.equals((EuclidGeometry)actual1));
        } else if (expected0.equals((EuclidGeometry)actual2) && expected1.equals((EuclidGeometry)actual1)) {
            Assertions.assertTrue((boolean)expected2.equals((EuclidGeometry)actual0));
        } else {
            Assert.fail("Points are not equal in any order");
        }
    }

    private void assertMinimumDistancePointsMatchExpected(double[] p1, double[] p2, double[] expectedSolution, double epsilon) {
        if (expectedSolution.length != 4) {
            throw new RuntimeException("Invalid input.");
        }
        ConvexPolygon2D polygon1 = this.ctreatePolygonFromListOfXYPoints(p1);
        ConvexPolygon2D polygon2 = this.ctreatePolygonFromListOfXYPoints(p2);
        Point2D[] closestPoints = new Point2D[]{new Point2D(), new Point2D()};
        Point2D[] closestPointsReversed = new Point2D[]{new Point2D(), new Point2D()};
        ConvexPolygonTools convexPolygonTools = new ConvexPolygonTools();
        convexPolygonTools.computeMinimumDistancePoints((ConvexPolygon2DReadOnly)polygon1, (ConvexPolygon2DReadOnly)polygon2, (Point2DBasics)closestPoints[0], (Point2DBasics)closestPoints[1]);
        convexPolygonTools.computeMinimumDistancePoints((ConvexPolygon2DReadOnly)polygon2, (ConvexPolygon2DReadOnly)polygon1, (Point2DBasics)closestPointsReversed[0], (Point2DBasics)closestPointsReversed[1]);
        Assert.assertEquals(closestPoints[0].distance((Point2DReadOnly)closestPoints[1]), closestPointsReversed[0].distance((Point2DReadOnly)closestPointsReversed[1]), epsilon);
        Assert.assertEquals(expectedSolution[0], closestPoints[0].getX(), epsilon);
        Assert.assertEquals(expectedSolution[1], closestPoints[0].getY(), epsilon);
        Assert.assertEquals(expectedSolution[2], closestPoints[1].getX(), epsilon);
        Assert.assertEquals(expectedSolution[3], closestPoints[1].getY(), epsilon);
    }

    private ConvexPolygon2D ctreatePolygonFromListOfXYPoints(double[] polygon) {
        if (polygon.length % 2 != 0) {
            throw new RuntimeException("Invalid input.");
        }
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        for (int i = 0; i < polygon.length; i += 2) {
            list.add(new Point2D(polygon[i], polygon[i + 1]));
        }
        return new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier(list));
    }

    private void waitForButtonOrPause(FrameGeometryTestFrame testFrame) {
        this.pauseOneSecond();
    }

    private void pauseOneSecond() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(ConvexPolygonTools.class, ConvexPolygonToolsTest.class);
    }
}

