/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.lists.ListWrappingIndexTools;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DBasics;
import us.ihmc.euclid.geometry.interfaces.ConvexPolygon2DReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.ConvexPolygonScaler;

public class ConvexPolygonScalerTest {
    @Test
    public void testScaleSquareExteriorPolygonToContainSquareInteriorPolygon() {
        ConvexPolygonScaler scaler = new ConvexPolygonScaler();
        ConvexPolygon2D exteriorPolygon = new ConvexPolygon2D();
        ConvexPolygon2D interiorPolygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledPolygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledPolygonExpected = new ConvexPolygon2D();
        Point2D exteriorVertex0 = new Point2D(1.0, 1.0);
        Point2D exteriorVertex1 = new Point2D(-1.0, 1.0);
        Point2D exteriorVertex2 = new Point2D(1.0, -1.0);
        Point2D exteriorVertex3 = new Point2D(-1.0, -1.0);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex0);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex1);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex2);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex3);
        exteriorPolygon.update();
        Point2D interiorVertex0 = new Point2D(0.25, 0.25);
        Point2D interiorVertex1 = new Point2D(-0.25, 0.25);
        Point2D interiorVertex2 = new Point2D(0.25, -0.25);
        Point2D interiorVertex3 = new Point2D(-0.25, -0.25);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex0);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex1);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex2);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex3);
        interiorPolygon.update();
        Point2D expectedVertex0 = new Point2D(0.75, 0.75);
        Point2D expectedVertex1 = new Point2D(-0.75, 0.75);
        Point2D expectedVertex2 = new Point2D(0.75, -0.75);
        Point2D expectedVertex3 = new Point2D(-0.75, -0.75);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex2);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex3);
        scaledPolygonExpected.update();
        boolean success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, 0.0, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertTrue(success);
        scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, 0.2, (ConvexPolygon2DBasics)scaledPolygon);
        expectedVertex0 = new Point2D(0.55, 0.55);
        expectedVertex1 = new Point2D(-0.55, 0.55);
        expectedVertex2 = new Point2D(0.55, -0.55);
        expectedVertex3 = new Point2D(-0.55, -0.55);
        scaledPolygonExpected.clear();
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex2);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex3);
        scaledPolygonExpected.update();
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, -0.2, (ConvexPolygon2DBasics)scaledPolygon);
        expectedVertex0 = new Point2D(0.95, 0.95);
        expectedVertex1 = new Point2D(-0.95, 0.95);
        expectedVertex2 = new Point2D(0.95, -0.95);
        expectedVertex3 = new Point2D(-0.95, -0.95);
        scaledPolygonExpected.clear();
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex2);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex3);
        scaledPolygonExpected.update();
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertTrue(success);
        interiorVertex0 = new Point2D(1.1, 1.1);
        interiorVertex1 = new Point2D(-1.1, 1.1);
        interiorVertex2 = new Point2D(1.1, -1.1);
        interiorVertex3 = new Point2D(-1.1, -1.1);
        interiorPolygon.clear();
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex0);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex1);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex2);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex3);
        interiorPolygon.update();
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, 0.2, (ConvexPolygon2DBasics)scaledPolygon);
        scaledPolygonExpected.clear();
        scaledPolygonExpected.addVertex((Point2DReadOnly)new Point2D(0.0, 0.0));
        scaledPolygonExpected.update();
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertFalse(success);
        exteriorVertex0 = new Point2D(2.5, 2.5);
        exteriorVertex1 = new Point2D(2.5, 0.5);
        exteriorVertex2 = new Point2D(0.5, 0.5);
        exteriorVertex3 = new Point2D(0.5, 2.5);
        exteriorPolygon.clear();
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex0);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex1);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex2);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex3);
        exteriorPolygon.update();
        interiorVertex0 = new Point2D(0.25, 0.25);
        interiorVertex1 = new Point2D(-0.25, 0.25);
        interiorVertex2 = new Point2D(0.25, -0.25);
        interiorVertex3 = new Point2D(-0.25, -0.25);
        interiorPolygon.clear();
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex0);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex1);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex2);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex3);
        interiorPolygon.update();
        expectedVertex0 = new Point2D(2.25, 2.25);
        expectedVertex1 = new Point2D(2.25, 0.75);
        expectedVertex2 = new Point2D(0.75, 0.75);
        expectedVertex3 = new Point2D(0.75, 2.25);
        scaledPolygonExpected.clear();
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex2);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex3);
        scaledPolygonExpected.update();
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, 0.0, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertTrue(success);
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, 0.2, (ConvexPolygon2DBasics)scaledPolygon);
        expectedVertex0 = new Point2D(2.05, 2.05);
        expectedVertex1 = new Point2D(2.05, 0.95);
        expectedVertex2 = new Point2D(0.95, 0.95);
        expectedVertex3 = new Point2D(0.95, 2.05);
        scaledPolygonExpected.clear();
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex2);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex3);
        scaledPolygonExpected.update();
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertTrue(success);
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, -0.2, (ConvexPolygon2DBasics)scaledPolygon);
        expectedVertex0 = new Point2D(2.45, 2.45);
        expectedVertex1 = new Point2D(2.45, 0.55);
        expectedVertex2 = new Point2D(0.55, 0.55);
        expectedVertex3 = new Point2D(0.55, 2.45);
        scaledPolygonExpected.clear();
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex2);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex3);
        scaledPolygonExpected.update();
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertTrue(success);
        interiorVertex0 = new Point2D(1.1, 1.1);
        interiorVertex1 = new Point2D(-1.1, 1.1);
        interiorVertex2 = new Point2D(1.1, -1.1);
        interiorVertex3 = new Point2D(-1.1, -1.1);
        interiorPolygon.clear();
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex0);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex1);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex2);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex3);
        interiorPolygon.update();
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, 0.2, (ConvexPolygon2DBasics)scaledPolygon);
        scaledPolygonExpected.clear();
        scaledPolygonExpected.addVertex(exteriorPolygon.getCentroid());
        scaledPolygonExpected.update();
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertFalse(success);
    }

    @Test
    public void testScaleSquareExteriorPolygonToContainQuadrulateralInteriorPolygon() {
        ConvexPolygonScaler scaler = new ConvexPolygonScaler();
        ConvexPolygon2D exteriorPolygon = new ConvexPolygon2D();
        ConvexPolygon2D interiorPolygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledPolygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledPolygonExpected = new ConvexPolygon2D();
        Point2D exteriorVertex0 = new Point2D(1.0, 1.0);
        Point2D exteriorVertex1 = new Point2D(-1.0, 1.0);
        Point2D exteriorVertex2 = new Point2D(1.0, -1.0);
        Point2D exteriorVertex3 = new Point2D(-1.0, -1.0);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex0);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex1);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex2);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex3);
        exteriorPolygon.update();
        Point2D interiorVertex0 = new Point2D(0.25, 0.25);
        Point2D interiorVertex1 = new Point2D(-0.5, 0.5);
        Point2D interiorVertex2 = new Point2D(0.25, -0.25);
        Point2D interiorVertex3 = new Point2D(-0.5, -0.5);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex0);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex1);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex2);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex3);
        interiorPolygon.update();
        Point2D expectedVertex0 = new Point2D(0.75, 0.5);
        Point2D expectedVertex1 = new Point2D(-0.5, 0.5);
        Point2D expectedVertex2 = new Point2D(0.75, -0.5);
        Point2D expectedVertex3 = new Point2D(-0.5, -0.5);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex2);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex3);
        scaledPolygonExpected.update();
        boolean success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, 0.0, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertTrue(success);
        expectedVertex0 = new Point2D(0.55, 0.3);
        expectedVertex1 = new Point2D(-0.3, 0.3);
        expectedVertex2 = new Point2D(0.55, -0.3);
        expectedVertex3 = new Point2D(-0.3, -0.3);
        scaledPolygonExpected.clear();
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex2);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex3);
        scaledPolygonExpected.update();
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, 0.2, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertTrue(success);
    }

    @Test
    public void testScaleHexagonExteriorPolygonToContainSquareInteriorPolygon() {
        ConvexPolygonScaler scaler = new ConvexPolygonScaler();
        ConvexPolygon2D exteriorPolygon = new ConvexPolygon2D();
        ConvexPolygon2D interiorPolygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledPolygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledPolygonExpected = new ConvexPolygon2D();
        Point2D exteriorVertex0 = new Point2D(1.0, 1.0);
        Point2D exteriorVertex1 = new Point2D(-1.0, 1.0);
        Point2D exteriorVertex2 = new Point2D(1.0, -1.0);
        Point2D exteriorVertex3 = new Point2D(-1.0, -1.0);
        Point2D exteriorVertex4 = new Point2D(0.0, 2.0);
        Point2D exteriorVertex5 = new Point2D(0.0, -2.0);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex0);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex1);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex2);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex3);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex4);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex5);
        exteriorPolygon.update();
        Point2D interiorVertex0 = new Point2D(0.5, 0.5);
        Point2D interiorVertex1 = new Point2D(-0.5, 0.5);
        Point2D interiorVertex2 = new Point2D(0.5, -0.5);
        Point2D interiorVertex3 = new Point2D(-0.5, -0.5);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex0);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex1);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex2);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex3);
        interiorPolygon.update();
        Point2D expectedVertex0 = new Point2D(0.5, 0.5);
        Point2D expectedVertex1 = new Point2D(-0.5, 0.5);
        Point2D expectedVertex2 = new Point2D(0.5, -0.5);
        Point2D expectedVertex3 = new Point2D(-0.5, -0.5);
        Point2D expectedVertex4 = new Point2D(0.0, 1.0);
        Point2D expectedVertex5 = new Point2D(0.0, -1.0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex2);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex3);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex4);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex5);
        scaledPolygonExpected.update();
        boolean success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, 0.0, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertTrue(success);
    }

    @Test
    public void testWithPointScaleExteriorPolygon() {
        ConvexPolygonScaler scaler = new ConvexPolygonScaler();
        ConvexPolygon2D exteriorPolygon = new ConvexPolygon2D();
        ConvexPolygon2D interiorPolygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledPolygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledPolygonExpected = new ConvexPolygon2D();
        Point2D exteriorVertex0 = new Point2D(0.5, 0.5);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex0);
        exteriorPolygon.update();
        Point2D interiorVertex0 = new Point2D(0.5, 0.5);
        Point2D interiorVertex1 = new Point2D(-0.5, 0.5);
        Point2D interiorVertex2 = new Point2D(0.5, -0.5);
        Point2D interiorVertex3 = new Point2D(-0.5, -0.5);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex0);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex1);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex2);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex3);
        interiorPolygon.update();
        Point2D expectedVertex0 = new Point2D(0.5, 0.5);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.update();
        boolean success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, 0.0, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertFalse(success);
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, 0.2, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertFalse(success);
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, -0.2, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertFalse(success);
        expectedVertex0 = new Point2D(0.6, 0.6);
        Point2D expectedVertex1 = new Point2D(0.4, 0.6);
        Point2D expectedVertex2 = new Point2D(0.6, 0.4);
        Point2D expectedVertex3 = new Point2D(0.4, 0.4);
        scaledPolygonExpected.clear();
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex2);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex3);
        scaledPolygonExpected.update();
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, -0.6, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertTrue(success);
        interiorVertex0 = new Point2D(0.2, 0.2);
        interiorVertex1 = new Point2D(-0.5, 0.5);
        interiorVertex2 = new Point2D(0.2, -0.2);
        interiorVertex3 = new Point2D(-0.5, -0.5);
        interiorPolygon.clear();
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex0);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex1);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex2);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex3);
        interiorPolygon.update();
        expectedVertex0 = new Point2D(0.9, 0.6);
        expectedVertex1 = new Point2D(0.4, 0.6);
        expectedVertex2 = new Point2D(0.9, 0.4);
        expectedVertex3 = new Point2D(0.4, 0.4);
        scaledPolygonExpected.clear();
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex2);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex3);
        scaledPolygonExpected.update();
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, -0.6, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertTrue(success);
    }

    @Test
    public void testWithLineScaleExteriorPolygon() {
        ConvexPolygonScaler scaler = new ConvexPolygonScaler();
        ConvexPolygon2D exteriorPolygon = new ConvexPolygon2D();
        ConvexPolygon2D interiorPolygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledPolygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledPolygonExpected = new ConvexPolygon2D();
        Point2D exteriorVertex0 = new Point2D(0.5, 0.5);
        Point2D exteriorVertex1 = new Point2D(0.5, 1.0);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex0);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex1);
        exteriorPolygon.update();
        Point2D interiorVertex0 = new Point2D(0.5, 0.5);
        Point2D interiorVertex1 = new Point2D(-0.5, 0.5);
        Point2D interiorVertex2 = new Point2D(0.5, -0.5);
        Point2D interiorVertex3 = new Point2D(-0.5, -0.5);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex0);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex1);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex2);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex3);
        interiorPolygon.update();
        Point2D expectedVertex0 = new Point2D(0.5, 0.75);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.update();
        boolean success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, 0.0, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertFalse(success);
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, 0.2, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertFalse(success);
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, -0.2, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertFalse(success);
        exteriorVertex0.set(0.5, 0.25);
        exteriorVertex1.set(0.5, 1.35);
        exteriorPolygon.clear();
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex0);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex1);
        exteriorPolygon.update();
        expectedVertex0 = new Point2D(0.6, 0.75);
        Point2D expectedVertex1 = new Point2D(0.6, 0.85);
        Point2D expectedVertex2 = new Point2D(0.5, 0.95);
        Point2D expectedVertex3 = new Point2D(0.5, 0.65);
        Point2D expectedVertex4 = new Point2D(0.4, 0.75);
        Point2D expectedVertex5 = new Point2D(0.4, 0.85);
        scaledPolygonExpected.clear();
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex2);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex3);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex4);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex5);
        scaledPolygonExpected.update();
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, -0.6, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertTrue(success);
        exteriorVertex0.set(0.5, 0.25);
        exteriorVertex1.set(0.5, 1.25);
        exteriorPolygon.clear();
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex0);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex1);
        exteriorPolygon.update();
        expectedVertex0 = new Point2D(0.6, 0.75);
        expectedVertex1 = new Point2D(0.5, 0.85);
        expectedVertex2 = new Point2D(0.5, 0.65);
        expectedVertex3 = new Point2D(0.4, 0.75);
        scaledPolygonExpected.clear();
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex2);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex3);
        scaledPolygonExpected.update();
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, -0.6, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertTrue(success);
        exteriorVertex0.set(0.5, 0.25);
        exteriorVertex1.set(0.5, 1.35);
        exteriorPolygon.clear();
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex0);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex1);
        exteriorPolygon.update();
        interiorVertex0 = new Point2D(0.5, 0.5);
        interiorVertex1 = new Point2D(-0.5, 0.5);
        interiorVertex2 = new Point2D(0.5, -0.5);
        interiorVertex3 = new Point2D(-0.5, -0.5);
        interiorPolygon.clear();
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex0);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex1);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex2);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex3);
        interiorPolygon.update();
        expectedVertex0 = new Point2D(0.4, 0.85);
        expectedVertex1 = new Point2D(0.5, 0.95);
        expectedVertex2 = new Point2D(0.6, 0.85);
        expectedVertex3 = new Point2D(0.6, 0.75);
        expectedVertex4 = new Point2D(0.5, 0.65);
        expectedVertex5 = new Point2D(0.4, 0.75);
        scaledPolygonExpected.clear();
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex2);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex3);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex4);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex5);
        scaledPolygonExpected.update();
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, -0.6, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertTrue(success);
        exteriorVertex0.set(0.5, 0.25);
        exteriorVertex1.set(0.5, 1.25);
        exteriorPolygon.clear();
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex0);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex1);
        exteriorPolygon.update();
        interiorVertex0 = new Point2D(0.5, 0.5);
        interiorVertex1 = new Point2D(-0.5, 0.5);
        interiorVertex2 = new Point2D(0.5, -0.5);
        interiorVertex3 = new Point2D(-0.5, -0.5);
        interiorPolygon.clear();
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex0);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex1);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex2);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex3);
        interiorPolygon.update();
        expectedVertex0 = new Point2D(0.5, 0.75);
        scaledPolygonExpected.clear();
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.update();
        success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, -0.2, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertFalse(success);
    }

    @Disabled
    @Test
    public void testTroublingCollapseExteriorRectangleToLine() {
        ConvexPolygonScaler scaler = new ConvexPolygonScaler();
        ConvexPolygon2D exteriorPolygon = new ConvexPolygon2D();
        ConvexPolygon2D interiorPolygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledPolygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledPolygonExpected = new ConvexPolygon2D();
        Point2D exteriorVertex0 = new Point2D(0.7, -0.5);
        Point2D exteriorVertex1 = new Point2D(0.7, -0.4);
        Point2D exteriorVertex2 = new Point2D(-0.3, -0.5);
        Point2D exteriorVertex3 = new Point2D(-0.3, -0.5);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex0);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex1);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex2);
        exteriorPolygon.addVertex((Point2DReadOnly)exteriorVertex3);
        exteriorPolygon.update();
        Point2D interiorVertex0 = new Point2D(0.11, -0.0425);
        Point2D interiorVertex1 = new Point2D(0.11, 0.0425);
        Point2D interiorVertex2 = new Point2D(-0.11, 0.055);
        Point2D interiorVertex3 = new Point2D(-0.11, 0.055);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex0);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex1);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex2);
        interiorPolygon.addVertex((Point2DReadOnly)interiorVertex3);
        interiorPolygon.update();
        Point2D expectedVertex0 = new Point2D(-0.19, -0.45);
        Point2D expectedVertex1 = new Point2D(0.59, -0.45);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex0);
        scaledPolygonExpected.addVertex((Point2DReadOnly)expectedVertex1);
        scaledPolygonExpected.update();
        boolean success = scaler.scaleConvexPolygonToContainInteriorPolygon((ConvexPolygon2DReadOnly)exteriorPolygon, (ConvexPolygon2DReadOnly)interiorPolygon, 0.0, (ConvexPolygon2DBasics)scaledPolygon);
        Assert.assertTrue(scaledPolygonExpected.epsilonEquals((EuclidGeometry)scaledPolygon, 1.0E-7));
        Assert.assertTrue(success);
    }

    @Disabled
    @Test
    public void testCaseScalingRedundantPolygon() {
        ArrayList<Point3D> fewerPoints = new ArrayList<Point3D>();
        fewerPoints.add(new Point3D(0.2, 0.2, 0.0));
        fewerPoints.add(new Point3D(0.2, 0.1, 0.0));
        fewerPoints.add(new Point3D(0.2, 0.0, 0.0));
        fewerPoints.add(new Point3D(0.2, -0.1, 0.0));
        fewerPoints.add(new Point3D(0.2, -0.2, 0.0));
        fewerPoints.add(new Point3D(0.1, -0.2, 0.0));
        fewerPoints.add(new Point3D(0.0, -0.2, 0.0));
        fewerPoints.add(new Point3D(-0.1, -0.2, 0.0));
        fewerPoints.add(new Point3D(-0.2, -0.2, 0.0));
        fewerPoints.add(new Point3D(-0.2, -0.1, 0.0));
        fewerPoints.add(new Point3D(-0.2, 0.0, 0.0));
        fewerPoints.add(new Point3D(-0.2, 0.1, 0.0));
        fewerPoints.add(new Point3D(-0.2, 0.2, 0.0));
        fewerPoints.add(new Point3D(-0.1, 0.2, 0.0));
        fewerPoints.add(new Point3D(0.0, 0.2, 0.0));
        fewerPoints.add(new Point3D(0.1, 0.2, 0.0));
        ArrayList<Point3D> essentialPoints = new ArrayList<Point3D>();
        essentialPoints.add(new Point3D(0.2, 0.2, 0.0));
        essentialPoints.add(new Point3D(0.2, -0.2, 0.0));
        essentialPoints.add(new Point3D(-0.2, -0.2, 0.0));
        essentialPoints.add(new Point3D(-0.2, 0.2, 0.0));
        ConvexPolygon2D polygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledPolygon = new ConvexPolygon2D();
        fewerPoints.forEach(arg_0 -> ((ConvexPolygon2D)polygon).addVertex(arg_0));
        polygon.update();
        ConvexPolygon2D essentialPolygon = new ConvexPolygon2D();
        ConvexPolygon2D scaledEssentialPolygon = new ConvexPolygon2D();
        essentialPoints.forEach(arg_0 -> ((ConvexPolygon2D)essentialPolygon).addVertex(arg_0));
        essentialPolygon.update();
        List polygonVertices = polygon.getPolygonVerticesView();
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)((Point2DReadOnly)polygonVertices.get(i)), (Point2DReadOnly)polygon.getVertex(i), (double)1.0E-8);
            int nextIndex = ListWrappingIndexTools.next((int)i, (List)polygonVertices);
            EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)((Point2DReadOnly)polygonVertices.get(nextIndex)), (Point2DReadOnly)polygon.getNextVertex(i), (double)1.0E-8);
        }
        ConvexPolygonScaler scaler = new ConvexPolygonScaler();
        scaler.scaleConvexPolygon((ConvexPolygon2DReadOnly)polygon, 0.15, (ConvexPolygon2DBasics)scaledPolygon);
        scaler.scaleConvexPolygon((ConvexPolygon2DReadOnly)essentialPolygon, 0.15, (ConvexPolygon2DBasics)scaledEssentialPolygon);
        for (int i = 0; i < scaledPolygon.getNumberOfVertices(); ++i) {
            Assert.assertTrue("Point " + String.valueOf(scaledPolygon.getVertex(i)) + " is outside.", scaledEssentialPolygon.isPointInside(scaledPolygon.getVertex(i)));
        }
    }
}

