/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.Random;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FrameLineSegment2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.FrameVector2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameConvexPolygon2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLineSegment2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVertex2DSupplier;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;

public class ConvexPolygon2dTestHelpers {
    public static FrameConvexPolygon2D constructPolygon(ReferenceFrame referenceFrame, double[][] points) {
        FrameConvexPolygon2D ret = new FrameConvexPolygon2D(referenceFrame, Vertex2DSupplier.asVertex2DSupplier((double[][])points));
        ConvexPolygon2dTestHelpers.verifyPointsAreClockwise(ret);
        return ret;
    }

    public static void verifyPointsAreClockwise(FrameConvexPolygon2D polygon) {
        int numPoints = polygon.getNumberOfVertices();
        for (int i = 0; i < numPoints; ++i) {
            FramePoint2DReadOnly point1 = polygon.getVertex(i);
            FramePoint2DReadOnly point2 = polygon.getVertex((i + 1) % numPoints);
            FramePoint2DReadOnly point3 = polygon.getVertex((i + 2) % numPoints);
            FrameVector2D vector1 = new FrameVector2D((FrameTuple2DReadOnly)point2);
            vector1.sub((FrameTuple2DReadOnly)point1);
            FrameVector2D vector2 = new FrameVector2D((FrameTuple2DReadOnly)point3);
            vector2.sub((FrameTuple2DReadOnly)point2);
            double cross = vector1.cross((FrameTuple2DReadOnly)vector2);
            if (!(cross >= 0.0)) continue;
            throw new RuntimeException("Points are not in clockwise order! FrameConvexPolygon2d:" + String.valueOf(polygon));
        }
    }

    public static void verifyPointsAreClockwise(ArrayList<FramePoint2D> clockwisePoints) {
        int numPoints = clockwisePoints.size();
        for (int i = 0; i < numPoints; ++i) {
            FramePoint2D point1 = clockwisePoints.get(i);
            FramePoint2D point2 = clockwisePoints.get((i + 1) % numPoints);
            FramePoint2D point3 = clockwisePoints.get((i + 2) % numPoints);
            FrameVector2D vector1 = new FrameVector2D((FrameTuple2DReadOnly)point2);
            vector1.sub((FrameTuple2DReadOnly)point1);
            FrameVector2D vector2 = new FrameVector2D((FrameTuple2DReadOnly)point3);
            vector2.sub((FrameTuple2DReadOnly)point2);
            double cross = vector1.cross((FrameTuple2DReadOnly)vector2);
            if (!(cross >= 0.0)) continue;
            throw new RuntimeException("Points are not in clockwise order! Points:" + String.valueOf(clockwisePoints));
        }
    }

    public static void verifyListContains(ArrayList<FramePoint2D> framePoints, FramePoint2D framePointToTest, double epsilon) {
        for (FramePoint2D framePoint : framePoints) {
            if (!framePoint.epsilonEquals((EuclidFrameGeometry)framePointToTest, epsilon)) continue;
            return;
        }
        throw new RuntimeException("List doesn't contain " + String.valueOf(framePointToTest));
    }

    public static void verifyPolygonContains(FrameConvexPolygon2D convexPolygon2d, FramePoint2D framePointToTest, double epsilon) {
        for (int i = 0; i < convexPolygon2d.getNumberOfVertices(); ++i) {
            if (!convexPolygon2d.getVertex(i).epsilonEquals((EuclidFrameGeometry)framePointToTest, epsilon)) continue;
            return;
        }
        throw new RuntimeException("List doesn't contain " + String.valueOf(framePointToTest));
    }

    public static ArrayList<FrameConvexPolygon2D> generateRandomPolygons(Random random, ReferenceFrame zUpFrame, double centerXMin, double centerXMax, double centerYMin, double centerYMax, double widthMax, double heightMax, int numberOfPoints, int numberOfPolygons) {
        ArrayList<FrameConvexPolygon2D> ret = new ArrayList<FrameConvexPolygon2D>(numberOfPolygons);
        for (int i = 0; i < numberOfPolygons; ++i) {
            FramePoint2D center = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)zUpFrame, (double)centerXMin, (double)centerXMax, (double)centerYMin, (double)centerYMax);
            double xMin2 = center.getX() - widthMax / 2.0;
            double xMax2 = center.getX() + widthMax / 2.0;
            double yMin2 = center.getY() - heightMax / 2.0;
            double yMax2 = center.getY() + heightMax / 2.0;
            FrameConvexPolygon2D polygon = ConvexPolygon2dTestHelpers.generateRandomPolygon(random, zUpFrame, xMin2, xMax2, yMin2, yMax2, numberOfPoints);
            ret.add(polygon);
        }
        return ret;
    }

    public static FrameConvexPolygon2D generateRandomPolygon(Random random, ReferenceFrame zUpFrame, double xMin, double xMax, double yMin, double yMax, int numberOfPoints) {
        FramePoint2D randomExtents1 = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)zUpFrame, (double)xMin, (double)xMax, (double)yMin, (double)yMax);
        FramePoint2D randomExtents2 = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)zUpFrame, (double)xMin, (double)xMax, (double)yMin, (double)yMax);
        double xMin2 = Math.min(randomExtents1.getX(), randomExtents2.getX());
        double xMax2 = Math.max(randomExtents1.getX(), randomExtents2.getX());
        double yMin2 = Math.min(randomExtents1.getY(), randomExtents2.getY());
        double yMax2 = Math.max(randomExtents1.getY(), randomExtents2.getY());
        ArrayList<FramePoint2D> points = ConvexPolygon2dTestHelpers.generateRandomCircularFramePoints(random, zUpFrame, xMin2, xMax2, yMin2, yMax2, numberOfPoints);
        return new FrameConvexPolygon2D(FrameVertex2DSupplier.asFrameVertex2DSupplier(points));
    }

    public static ArrayList<FramePoint2D> generateRandomCircularFramePoints(Random random, ReferenceFrame zUpFrame, double xMin, double xMax, double yMin, double yMax, int numberOfPoints) {
        ArrayList<FramePoint2D> points = new ArrayList<FramePoint2D>();
        FramePoint2D zeroFramePoint = new FramePoint2D(zUpFrame, (xMax + xMin) / 2.0, (yMax + yMin) / 2.0);
        for (int i = 0; i < numberOfPoints; ++i) {
            FramePoint2D randomPoint = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)zUpFrame, (double)xMin, (double)xMax, (double)yMin, (double)yMax);
            if (randomPoint.distance((FramePoint2DReadOnly)zeroFramePoint) > Math.max((xMax - xMin) / 2.0, (yMax - yMin) / 2.0)) continue;
            points.add(randomPoint);
        }
        return points;
    }

    public static ArrayList<FramePoint2D> generateRandomRectangularFramePoints(Random random, ReferenceFrame zUpFrame, double xMin, double xMax, double yMin, double yMax, int numberOfPoints) {
        ArrayList<FramePoint2D> points = new ArrayList<FramePoint2D>();
        for (int i = 0; i < numberOfPoints; ++i) {
            FramePoint2D randomPoint = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)zUpFrame, (double)xMin, (double)xMax, (double)yMin, (double)yMax);
            points.add(randomPoint);
        }
        return points;
    }

    public static final void verifyAroundTheCornerEdges(FrameConvexPolygon2D polygon, FramePoint2D observingPoint, FramePoint2D[] lineOfSightVertices, FrameLineSegment2D[] aroundTheCornerEdges) {
        FramePoint2D lineOfSightPoint1 = lineOfSightVertices[0];
        FramePoint2D lineOfSightPoint2 = lineOfSightVertices[1];
        FrameLineSegment2D edge1 = aroundTheCornerEdges[0];
        FrameLineSegment2D edge2 = aroundTheCornerEdges[1];
        if (lineOfSightPoint1.distance((FramePoint2DReadOnly)edge1.pointBetweenEndpointsGivenPercentage(0.0)) > 1.0E-7) {
            throw new RuntimeException("aroundTheCornerEdge[0] does not start with the left line of sight point!");
        }
        if (lineOfSightPoint2.distance((FramePoint2DReadOnly)edge2.pointBetweenEndpointsGivenPercentage(0.0)) > 1.0E-7) {
            throw new RuntimeException("aroundTheCornerEdge[1] does not start with the left line of sight point!");
        }
        FramePoint2DBasics leftPointAroundEdge = edge1.pointBetweenEndpointsGivenPercentage(1.0);
        FramePoint2DBasics rightPointAroundEdge = edge2.pointBetweenEndpointsGivenPercentage(1.0);
        double epsilon = 1.0E-5;
        FrameVector2D observingToLeftPoint = new FrameVector2D((FrameTuple2DReadOnly)leftPointAroundEdge);
        observingToLeftPoint.sub((FrameTuple2DReadOnly)observingPoint);
        observingToLeftPoint.normalize();
        observingToLeftPoint.scale(epsilon);
        FrameVector2D observingToRightPoint = new FrameVector2D((FrameTuple2DReadOnly)rightPointAroundEdge);
        observingToRightPoint.sub((FrameTuple2DReadOnly)observingPoint);
        observingToRightPoint.normalize();
        observingToRightPoint.scale(epsilon);
        FramePoint2D testPoint = new FramePoint2D((FrameTuple2DReadOnly)leftPointAroundEdge);
        testPoint.sub((FrameTuple2DReadOnly)observingToLeftPoint);
        if (!polygon.isPointInside((FramePoint2DReadOnly)testPoint)) {
            throw new RuntimeException(String.valueOf(leftPointAroundEdge) + " can be seen from the observing point! It's not around the edge!. testPoint = " + String.valueOf(testPoint) + " is not Inside the polygon!");
        }
        testPoint = new FramePoint2D((FrameTuple2DReadOnly)rightPointAroundEdge);
        testPoint.sub((FrameTuple2DReadOnly)observingToRightPoint);
        if (!polygon.isPointInside((FramePoint2DReadOnly)testPoint)) {
            throw new RuntimeException(String.valueOf(rightPointAroundEdge) + " can be seen from the observing point! It's not around the edge!. testPoint = " + String.valueOf(testPoint) + " is not Inside the polygon!");
        }
    }

    public static void verifyLineOfSightVertices(FrameConvexPolygon2D polygon, FramePoint2D observingPoint, FramePoint2D[] lineOfSightVertices) {
        double epsilon = 1.0E-5;
        FrameVector2D observingToLineOfSight1 = new FrameVector2D((FrameTuple2DReadOnly)lineOfSightVertices[0]);
        observingToLineOfSight1.sub((FrameTuple2DReadOnly)observingPoint);
        observingToLineOfSight1.normalize();
        observingToLineOfSight1.scale(epsilon);
        FrameVector2D observingToLineOfSight2 = new FrameVector2D((FrameTuple2DReadOnly)lineOfSightVertices[1]);
        observingToLineOfSight2.sub((FrameTuple2DReadOnly)observingPoint);
        observingToLineOfSight2.normalize();
        observingToLineOfSight2.scale(epsilon);
        FramePoint2D testPoint = new FramePoint2D((FrameTuple2DReadOnly)lineOfSightVertices[0]);
        testPoint.add((FrameTuple2DReadOnly)observingToLineOfSight1);
        if (polygon.isPointInside((FramePoint2DReadOnly)testPoint)) {
            throw new RuntimeException(String.valueOf(lineOfSightVertices[0]) + " is not a line of sight vertex!");
        }
        testPoint = new FramePoint2D((FrameTuple2DReadOnly)lineOfSightVertices[0]);
        testPoint.sub((FrameTuple2DReadOnly)observingToLineOfSight1);
        if (polygon.isPointInside((FramePoint2DReadOnly)testPoint)) {
            throw new RuntimeException(String.valueOf(lineOfSightVertices[0]) + " is not a line of sight vertex!. testPoint = " + String.valueOf(testPoint) + " is Inside the polygon!");
        }
        testPoint = new FramePoint2D((FrameTuple2DReadOnly)lineOfSightVertices[1]);
        testPoint.add((FrameTuple2DReadOnly)observingToLineOfSight2);
        if (polygon.isPointInside((FramePoint2DReadOnly)testPoint)) {
            throw new RuntimeException(String.valueOf(lineOfSightVertices[1]) + " is not a line of sight vertex!");
        }
        testPoint = new FramePoint2D((FrameTuple2DReadOnly)lineOfSightVertices[1]);
        testPoint.sub((FrameTuple2DReadOnly)observingToLineOfSight2);
        if (polygon.isPointInside((FramePoint2DReadOnly)testPoint)) {
            throw new RuntimeException(String.valueOf(lineOfSightVertices[1]) + " is not a line of sight vertex!");
        }
    }

    public static void verifyLineDoesNotIntersectPolygon(FrameLine2D frameLine2d, FrameConvexPolygon2D polygon) {
        FramePoint2D point = new FramePoint2D((FrameTuple2DReadOnly)frameLine2d.getPoint());
        FramePoint2DBasics[] lineOfSightVertices = polygon.lineOfSightVertices((FramePoint2DReadOnly)point);
        if (lineOfSightVertices == null) {
            throw new RuntimeException();
        }
        if (ConvexPolygon2dTestHelpers.isLineStrictlyBetweenVertices((FrameLine2DReadOnly)frameLine2d, (FramePoint2DReadOnly)lineOfSightVertices[0], (FramePoint2DReadOnly)lineOfSightVertices[1])) {
            throw new RuntimeException();
        }
    }

    public static void verifyLineIntersectsEdge(FrameLine2D frameLine2d, FrameLineSegment2D[] intersectingEdges) {
        FramePoint2DReadOnly[] enteringVertices;
        FrameLineSegment2D leavingEdge;
        FrameLineSegment2D enteringEdge;
        if (intersectingEdges.length == 2) {
            enteringEdge = intersectingEdges[0];
            leavingEdge = intersectingEdges[1];
        } else {
            enteringEdge = null;
            leavingEdge = intersectingEdges[0];
        }
        if (enteringEdge != null && !ConvexPolygon2dTestHelpers.isLineBetweenOrIntersectingVertices(frameLine2d, (enteringVertices = new FramePoint2DReadOnly[]{enteringEdge.getFirstEndpoint(), enteringEdge.getSecondEndpoint()})[1], enteringVertices[0]) && !ConvexPolygon2dTestHelpers.isLineBetweenOrIntersectingVertices(frameLine2d, enteringVertices[0], enteringVertices[1])) {
            throw new RuntimeException();
        }
        FramePoint2DReadOnly[] leavingVertices = new FramePoint2DReadOnly[]{leavingEdge.getFirstEndpoint(), leavingEdge.getSecondEndpoint()};
        if (!ConvexPolygon2dTestHelpers.isLineBetweenOrIntersectingVertices(frameLine2d, leavingVertices[0], leavingVertices[1]) && !ConvexPolygon2dTestHelpers.isLineBetweenOrIntersectingVertices(frameLine2d, leavingVertices[1], leavingVertices[0])) {
            throw new RuntimeException();
        }
    }

    public static boolean isLineBetweenOrIntersectingVertices(FrameLine2D frameLine2d, FramePoint2DReadOnly leftVertex, FramePoint2DReadOnly rightVertex) {
        boolean mustBeStrictlyBetween = false;
        return ConvexPolygon2dTestHelpers.isLineBetweenVertices((FrameLine2DReadOnly)frameLine2d, leftVertex, rightVertex, mustBeStrictlyBetween);
    }

    public static boolean isLineStrictlyBetweenVertices(FrameLine2DReadOnly frameLine2d, FramePoint2DReadOnly leftVertex, FramePoint2DReadOnly rightVertex) {
        boolean mustBeStrictlyBetween = true;
        return ConvexPolygon2dTestHelpers.isLineBetweenVertices(frameLine2d, leftVertex, rightVertex, mustBeStrictlyBetween);
    }

    public static boolean isLineBetweenVertices(FrameLine2DReadOnly frameLine2d, FramePoint2DReadOnly leftVertex, FramePoint2DReadOnly rightVertex, boolean mustBeStrictlyBetween) {
        FramePoint2D lineStart = new FramePoint2D((FrameTuple2DReadOnly)frameLine2d.getPoint());
        FrameVector2D lineDirection = new FrameVector2D((FrameTuple2DReadOnly)frameLine2d.getDirection());
        double startToLeftVertexX = leftVertex.getX() - lineStart.getX();
        double startToLeftVertexY = leftVertex.getY() - lineStart.getY();
        double startToRightVertexX = rightVertex.getX() - lineStart.getX();
        double startToRightVertexY = rightVertex.getY() - lineStart.getY();
        double leftCrossProduct = lineDirection.getX() * startToLeftVertexY - lineDirection.getY() * startToLeftVertexX;
        double rightCrossProduct = lineDirection.getX() * startToRightVertexY - lineDirection.getY() * startToRightVertexX;
        return mustBeStrictlyBetween ? leftCrossProduct > 0.0 && rightCrossProduct < 0.0 : leftCrossProduct >= 0.0 && rightCrossProduct <= 0.0;
    }

    public static void verifyPointsAreInside(FrameConvexPolygon2D polygon, ArrayList<FramePoint2D> pointsThatShouldBeInside, double epsilon) {
        for (FramePoint2D point : pointsThatShouldBeInside) {
            if (polygon.isPointInside((FramePoint2DReadOnly)point, epsilon)) continue;
            throw new RuntimeException("Point is not inside polygon. Point = " + String.valueOf(point));
        }
    }

    public static void verifyPointsAreNotInside(FrameConvexPolygon2D polygon, ArrayList<FramePoint2D> pointsThatShouldNotBeInside, double epsilon) {
        for (FramePoint2D point : pointsThatShouldNotBeInside) {
            if (!polygon.isPointInside((FramePoint2DReadOnly)point, epsilon)) continue;
            throw new RuntimeException("Point is inside polygon. Point = " + String.valueOf(point));
        }
    }

    public static void verifyLinesIntersectPolygon(FrameConvexPolygon2D polygon, ArrayList<FrameLine2D> lines) {
        for (FrameLine2D line : lines) {
            ConvexPolygon2dTestHelpers.verifyLineIntersectsPolygon(polygon, line);
        }
    }

    public static void verifyLineSegmentsIntersectPolygon(FrameConvexPolygon2D polygon, ArrayList<FrameLineSegment2D> lineSegments) {
        for (FrameLineSegment2D lineSegment : lineSegments) {
            ConvexPolygon2dTestHelpers.verifyLineSegmentIntersectsPolygon((FrameConvexPolygon2DReadOnly)polygon, (FrameLineSegment2DReadOnly)lineSegment);
        }
    }

    public static void verifyLinesDoNotIntersectPolygon(FrameConvexPolygon2D polygon, ArrayList<FrameLine2D> lines) {
        for (FrameLine2D line : lines) {
            ConvexPolygon2dTestHelpers.verifyLineDoesNotIntersectsPolygon((FrameConvexPolygon2DReadOnly)polygon, (FrameLine2DReadOnly)line);
        }
    }

    public static void verifyLineSegmentsDoNotIntersectPolygon(FrameConvexPolygon2D polygon, ArrayList<FrameLineSegment2D> lineSegments) {
        for (FrameLineSegment2D lineSegment : lineSegments) {
            ConvexPolygon2dTestHelpers.verifyLineSegmentDoesNotIntersectsPolygon(polygon, lineSegment);
        }
    }

    public static void verifyLineIntersectsPolygon(FrameConvexPolygon2D polygon, FrameLine2D line) {
        FramePoint2DBasics[] intersectingPoints = polygon.intersectionWith((FrameLine2DReadOnly)line);
        ConvexPolygon2dTestHelpers.verifyPointsAreNotEmpty((FramePoint2DReadOnly[])intersectingPoints);
        ConvexPolygon2dTestHelpers.verifyPointsAreOnLine((FramePoint2DReadOnly[])intersectingPoints, line);
        ConvexPolygon2dTestHelpers.verifyPointsAreOnPolygon((FramePoint2DReadOnly[])intersectingPoints, (FrameConvexPolygon2DReadOnly)polygon);
    }

    private static void verifyPointsAreOnPolygon(FramePoint2DReadOnly[] intersectingPoints, FrameConvexPolygon2DReadOnly polygon) {
        for (FramePoint2DReadOnly point : intersectingPoints) {
            if (!(polygon.distance(point) > 1.0E-10)) continue;
            throw new RuntimeException("Point is not on polygon. Point = " + String.valueOf(point));
        }
    }

    private static void verifyPointsAreNotEmpty(FramePoint2DReadOnly[] points) {
        if (points == null || points.length == 0) {
            throw new RuntimeException("Points are empty!");
        }
    }

    public static void verifyPointsAreOnLine(FramePoint2DReadOnly[] intersectingPoints, FrameLine2D line) {
        for (FramePoint2DReadOnly point : intersectingPoints) {
            if (!(line.distance(point) > 1.0E-5)) continue;
            throw new RuntimeException("Point is not on line. Point = " + String.valueOf(point) + ". Distance = " + line.distance(point));
        }
    }

    public static void verifyPointsAreOnLineSegment(FramePoint2DReadOnly[] intersectingPoints, FrameLineSegment2DReadOnly lineSegment) {
        for (FramePoint2DReadOnly point : intersectingPoints) {
            if (!(lineSegment.distance(point) > 1.0E-5)) continue;
            throw new RuntimeException("Point is not on lineSegment. Point = " + String.valueOf(point) + ". Distance = " + lineSegment.distance(point));
        }
    }

    public static void verifyLineSegmentIntersectsPolygon(FrameConvexPolygon2DReadOnly polygon, FrameLineSegment2DReadOnly lineSegment) {
        FramePoint2DBasics[] intersectingPoints = polygon.intersectionWith(lineSegment);
        ConvexPolygon2dTestHelpers.verifyPointsAreNotEmpty((FramePoint2DReadOnly[])intersectingPoints);
        ConvexPolygon2dTestHelpers.verifyPointsAreOnLineSegment((FramePoint2DReadOnly[])intersectingPoints, lineSegment);
        ConvexPolygon2dTestHelpers.verifyPointsAreOnPolygon((FramePoint2DReadOnly[])intersectingPoints, polygon);
    }

    public static void verifyLineDoesNotIntersectsPolygon(FrameConvexPolygon2DReadOnly polygon, FrameLine2DReadOnly line) {
        if (ConvexPolygon2dTestHelpers.doesLineIntersectPolygon(polygon, line)) {
            throw new RuntimeException("Line intersects polygon since polygon points are on different sides of the line! line = " + String.valueOf(line));
        }
    }

    public static boolean doesLineIntersectPolygon(FrameConvexPolygon2DReadOnly polygon, FrameLine2DReadOnly line) {
        boolean onLeft = line.isPointOnLeftSideOfLine(polygon.getVertex(0));
        for (int i = 0; i < polygon.getNumberOfVertices(); ++i) {
            if (onLeft == line.isPointOnLeftSideOfLine(polygon.getVertex(i))) continue;
            return true;
        }
        return false;
    }

    public static void verifyLineSegmentDoesNotIntersectsPolygon(FrameConvexPolygon2D polygon, FrameLineSegment2D lineSegment) {
        FramePoint2DBasics[] intersections;
        FrameLine2D line = new FrameLine2D((FrameLineSegment2DReadOnly)lineSegment);
        if (!ConvexPolygon2dTestHelpers.doesLineIntersectPolygon((FrameConvexPolygon2DReadOnly)polygon, (FrameLine2DReadOnly)line)) {
            return;
        }
        for (FramePoint2DBasics intersection : intersections = polygon.intersectionWith((FrameLine2DReadOnly)line)) {
            if (!(lineSegment.distance((FramePoint2DReadOnly)intersection) < 1.0E-10)) continue;
            throw new RuntimeException("Line segment intersects polygon at " + String.valueOf(intersection));
        }
    }
}

