/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.geometry;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.transform.interfaces.Transform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.Capsule;

public class CapsuleTest {
    private void transformAndCheck(RigidBodyTransform trans, Point3D expected, Point3D result) {
        double epsilon = 1.0E-5;
        Point3D exp = new Point3D((Tuple3DReadOnly)expected);
        trans.transform((Point3DBasics)exp);
        Assert.assertTrue(result.epsilonEquals((EuclidGeometry)exp, epsilon));
    }

    @Test
    public void test() {
        Point3D res1 = new Point3D();
        Point3D res2 = new Point3D();
        RigidBodyTransform tr_base = new RigidBodyTransform();
        RigidBodyTransform tr_other = new RigidBodyTransform();
        tr_base.setIdentity();
        ArrayList<RigidBodyTransform> transforms = new ArrayList<RigidBodyTransform>();
        transforms.add(new RigidBodyTransform((RigidBodyTransformReadOnly)tr_base));
        tr_other.getTranslation().set((Tuple3DReadOnly)new Vector3D(1.0, 1.0, 1.0));
        tr_base.multiply((RigidBodyTransformReadOnly)tr_other);
        transforms.add(new RigidBodyTransform((RigidBodyTransformReadOnly)tr_base));
        tr_other.setRotationPitchAndZeroTranslation(1.2);
        tr_base.multiply((RigidBodyTransformReadOnly)tr_other);
        tr_other.setRotationYawAndZeroTranslation(-0.6);
        tr_other.getTranslation().set((Tuple3DReadOnly)new Vector3D(0.0, -2.0, 3.0));
        tr_base.multiply((RigidBodyTransformReadOnly)tr_other);
        transforms.add(new RigidBodyTransform((RigidBodyTransformReadOnly)tr_base));
        for (int i = 0; i < transforms.size(); ++i) {
            RigidBodyTransform trans = (RigidBodyTransform)transforms.get(i);
            Capsule c1 = new Capsule((Point3DReadOnly)new Point3D(-1.0, 0.0, 0.0), (Point3DReadOnly)new Point3D(1.0, 0.0, 0.0), 0.0);
            Capsule c2 = new Capsule((Point3DReadOnly)new Point3D(0.2, 0.3, 0.0), (Point3DReadOnly)new Point3D(0.5, 0.9, 0.0), 0.0);
            Capsule c3 = new Capsule((Point3DReadOnly)new Point3D(-1.5, 0.0, 0.0), (Point3DReadOnly)new Point3D(-1.5, 1.0, 0.0), 0.0);
            Capsule c4 = new Capsule((Point3DReadOnly)new Point3D(0.0, -1.0, 0.5), (Point3DReadOnly)new Point3D(0.0, 1.0, 0.5), 0.0);
            c1.transform((Transform)trans);
            c2.transform((Transform)trans);
            c3.transform((Transform)trans);
            c4.transform((Transform)trans);
            Capsule.distanceQuery((Capsule)c1, (Capsule)c2, (Point3DBasics)res1, (Point3DBasics)res2);
            this.transformAndCheck(trans, new Point3D(0.2, 0.0, 0.0), res1);
            this.transformAndCheck(trans, new Point3D(0.2, 0.3, 0.0), res2);
            Capsule.distanceQuery((Capsule)c1, (Capsule)c3, (Point3DBasics)res1, (Point3DBasics)res2);
            this.transformAndCheck(trans, new Point3D(-1.0, 0.0, 0.0), res1);
            this.transformAndCheck(trans, new Point3D(-1.5, 0.0, 0.0), res2);
            Capsule.distanceQuery((Capsule)c1, (Capsule)c4, (Point3DBasics)res1, (Point3DBasics)res2);
            this.transformAndCheck(trans, new Point3D(0.0, 0.0, 0.0), res1);
            this.transformAndCheck(trans, new Point3D(0.0, 0.0, 0.5), res2);
            c1.radius = 0.1;
            c2.radius = 0.05;
            c3.radius = 0.07;
            c4.radius = 0.15;
            Capsule.distanceQuery((Capsule)c1, (Capsule)c2, (Point3DBasics)res1, (Point3DBasics)res2);
            this.transformAndCheck(trans, new Point3D(0.2, 0.1, 0.0), res1);
            this.transformAndCheck(trans, new Point3D(0.2, 0.25, 0.0), res2);
            Capsule.distanceQuery((Capsule)c1, (Capsule)c3, (Point3DBasics)res1, (Point3DBasics)res2);
            this.transformAndCheck(trans, new Point3D(-1.1, 0.0, 0.0), res1);
            this.transformAndCheck(trans, new Point3D(-1.43, 0.0, 0.0), res2);
            Capsule.distanceQuery((Capsule)c1, (Capsule)c4, (Point3DBasics)res1, (Point3DBasics)res2);
            this.transformAndCheck(trans, new Point3D(0.0, 0.0, 0.1), res1);
            this.transformAndCheck(trans, new Point3D(0.0, 0.0, 0.35), res2);
        }
    }

    @Test
    public void testOther() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            Point3D point1 = new Point3D(-rand.nextDouble() * 10.0, -rand.nextDouble() * 10.0, -rand.nextDouble() * 10.0);
            Point3D point2 = new Point3D(point1.getX() + 10.0, point1.getY() + 10.0, point1.getZ() + 10.0);
            Capsule c1 = new Capsule((Point3DReadOnly)point1, (Point3DReadOnly)point2, 0.0);
            Capsule other = new Capsule(c1);
            Assert.assertEquals(c1.p1.getX(), other.p1.getX(), 1.0E-7);
            Assert.assertEquals(c1.p1.getY(), other.p1.getY(), 1.0E-7);
            Assert.assertEquals(c1.p1.getZ(), other.p1.getZ(), 1.0E-7);
        }
    }

    @Test
    public void testOther_2() {
        Random rand = new Random();
        for (int i = 0; i < 1000; ++i) {
            Point3D point1 = new Point3D(-rand.nextDouble() * 10.0, -rand.nextDouble() * 10.0, -rand.nextDouble() * 10.0);
            Point3D point2 = new Point3D(point1.getX() + 10.0, point1.getY() + 10.0, point1.getZ() + 10.0);
            Capsule c1 = new Capsule((Point3DReadOnly)point1, (Point3DReadOnly)point2, 0.0);
            Capsule other = new Capsule(c1);
            other.set(c1);
            Assert.assertEquals(c1.p1.getX(), other.p1.getX(), 1.0E-7);
            Assert.assertEquals(c1.p1.getY(), other.p1.getY(), 1.0E-7);
            Assert.assertEquals(c1.p1.getZ(), other.p1.getZ(), 1.0E-7);
        }
    }
}

