/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.functionApproximation;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.functionApproximation.OnlineLinearRegression;

public class OnlineLinearRegressionTest {
    @Test
    public void toyExample() {
        int testSize = 100;
        int inputDim = 10;
        Random rnd = new Random(0L);
        double[] trueCoefficient = new double[inputDim];
        for (int i = 0; i < inputDim; ++i) {
            trueCoefficient[i] = rnd.nextDouble();
        }
        OnlineLinearRegression solver = new OnlineLinearRegression(100, inputDim);
        for (int i = 0; i < testSize; ++i) {
            double y = 0.0;
            double[] x = new double[inputDim];
            for (int j = 0; j < inputDim; ++j) {
                x[j] = rnd.nextDouble();
                y += trueCoefficient[j] * x[j];
            }
            solver.addEntry(y, x);
        }
        double[] resultCoefficient = solver.getCoefficient();
        Assert.assertArrayEquals(trueCoefficient, resultCoefficient, 1.0E-10);
    }
}

