/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.functionApproximation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.MathTools;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.geometry.Line2D;
import us.ihmc.euclid.geometry.tools.EuclidGeometryRandomTools;
import us.ihmc.euclid.geometry.tools.EuclidGeometryTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.functionApproximation.OnlineLine2DLinearRegression;
import us.ihmc.yoVariables.registry.YoRegistry;

public class OnlineLine2DLinearRegressionTest {
    private static final int iters = 100;
    private static final double epsilon = 1.0E-8;

    @Test
    public void testLineFinding() {
        Random random = new Random(1738L);
        int pointsInEstimate = 10;
        OnlineLine2DLinearRegression linearRegression = new OnlineLine2DLinearRegression("", new YoRegistry("test"));
        for (int i = 0; i < 100; ++i) {
            Line2D lineActual = EuclidGeometryRandomTools.nextLine2D((Random)random);
            linearRegression.reset();
            ArrayList<Point2DReadOnly> pointsOnLine = new ArrayList<Point2DReadOnly>();
            for (int pointIdx = 0; pointIdx < pointsInEstimate; ++pointIdx) {
                double distanceOnLine = RandomNumbers.nextDouble((Random)random, (double)10.0);
                Point2D pointOnLine = new Point2D();
                pointOnLine.scaleAdd(distanceOnLine, (Tuple2DReadOnly)lineActual.getDirection(), (Tuple2DReadOnly)lineActual.getPoint());
                pointsOnLine.add((Point2DReadOnly)pointOnLine);
                linearRegression.update((Point2DReadOnly)pointOnLine);
                Assert.assertTrue(lineActual.isPointOnLine((Point2DReadOnly)pointOnLine));
            }
            Assert.assertTrue(lineActual.isPointOnLine(linearRegression.getMeanLine().getPoint()));
            Point2DReadOnly meanPoint = OnlineLine2DLinearRegressionTest.computeMeanPoint(pointsOnLine);
            EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)meanPoint, (Point2DReadOnly)linearRegression.getMeanLine().getPoint(), (double)1.0E-8);
            Assert.assertEquals(OnlineLine2DLinearRegressionTest.computeXStandardDeviation(meanPoint, pointsOnLine), linearRegression.getXStandardDeviation(), 1.0E-8);
            Assert.assertEquals(OnlineLine2DLinearRegressionTest.computeYStandardDeviation(meanPoint, pointsOnLine), linearRegression.getYStandardDeviation(), 1.0E-8);
            if (!lineActual.getDirection().epsilonEquals((EuclidGeometry)linearRegression.getMeanLine().getDirection(), 1.0E-8)) {
                Vector2D direction = new Vector2D((Tuple2DReadOnly)linearRegression.getMeanLine().getDirection());
                direction.negate();
                EuclidCoreTestTools.assertVector2DGeometricallyEquals((Vector2DReadOnly)lineActual.getDirection(), (Vector2DReadOnly)direction, (double)1.0E-8);
            }
            Assert.assertEquals("Iter " + i + " failed.", 0.0, linearRegression.getTransverseStandardDeviation(), 1.0E-8);
            Assert.assertEquals("Iter " + i + " failed.", OnlineLine2DLinearRegressionTest.computeInlineStandardDeviation(meanPoint, pointsOnLine), linearRegression.getInlineStandardDeviation(), 1.0E-8);
        }
    }

    @Test
    public void testNoisyLineFinding() {
        Random random = new Random(1738L);
        int pointsInEstimate = 10000;
        OnlineLine2DLinearRegression linearRegression = new OnlineLine2DLinearRegression("", new YoRegistry("test"));
        for (int i = 0; i < 10; ++i) {
            Line2D lineActual = EuclidGeometryRandomTools.nextLine2D((Random)random);
            linearRegression.reset();
            double transverseDeviation = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)0.05);
            double inlineDeviation = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)0.6);
            ArrayList<Point2DReadOnly> pointsOnLine = new ArrayList<Point2DReadOnly>();
            for (int pointIdx = 0; pointIdx < pointsInEstimate; ++pointIdx) {
                double transverseTranslation = transverseDeviation * random.nextGaussian();
                double inlineTranslation = inlineDeviation * random.nextGaussian();
                Vector2D transverseOffset = EuclidGeometryTools.perpendicularVector2D((Vector2DReadOnly)lineActual.getDirection());
                transverseOffset.scale(transverseTranslation / transverseOffset.length());
                Vector2D inlineOffset = new Vector2D((Tuple2DReadOnly)lineActual.getDirection());
                inlineOffset.scale(inlineTranslation / inlineOffset.length());
                Point2D pointOnLine = new Point2D((Tuple2DReadOnly)lineActual.getPoint());
                pointOnLine.add((Tuple2DReadOnly)inlineOffset);
                pointOnLine.add((Tuple2DReadOnly)transverseOffset);
                linearRegression.update((Point2DReadOnly)pointOnLine);
                pointsOnLine.add((Point2DReadOnly)pointOnLine);
            }
            Point2DReadOnly meanPoint = OnlineLine2DLinearRegressionTest.computeMeanPoint(pointsOnLine);
            EuclidCoreTestTools.assertPoint2DGeometricallyEquals((Point2DReadOnly)meanPoint, (Point2DReadOnly)linearRegression.getMeanLine().getPoint(), (double)1.0E-8);
            Assert.assertEquals(OnlineLine2DLinearRegressionTest.computeXStandardDeviation(meanPoint, pointsOnLine), linearRegression.getXStandardDeviation(), 1.0E-8);
            Assert.assertEquals(OnlineLine2DLinearRegressionTest.computeYStandardDeviation(meanPoint, pointsOnLine), linearRegression.getYStandardDeviation(), 1.0E-8);
            double angle = lineActual.getDirection().angle((Vector2DReadOnly)linearRegression.getMeanLine().getDirection());
            Assert.assertEquals("Iter " + i + " failed.", transverseDeviation, linearRegression.getTransverseStandardDeviation(), 0.04);
            Assert.assertEquals("Iter " + i + " failed.", inlineDeviation, linearRegression.getInlineStandardDeviation(), 0.03);
        }
    }

    private static Point2DReadOnly computeMeanPoint(List<Point2DReadOnly> points) {
        Point2D meanPoint = new Point2D();
        for (Point2DReadOnly point : points) {
            meanPoint.add((Tuple2DReadOnly)point);
        }
        meanPoint.scale(1.0 / (double)points.size());
        return meanPoint;
    }

    private static double computeXStandardDeviation(Point2DReadOnly meanPoint, List<Point2DReadOnly> points) {
        double variance = 0.0;
        for (Point2DReadOnly point : points) {
            variance += MathTools.square((double)(point.getX() - meanPoint.getX()));
        }
        return Math.sqrt(variance /= (double)points.size());
    }

    private static double computeYStandardDeviation(Point2DReadOnly meanPoint, List<Point2DReadOnly> points) {
        double variance = 0.0;
        for (Point2DReadOnly point : points) {
            variance += MathTools.square((double)(point.getY() - meanPoint.getY()));
        }
        return Math.sqrt(variance /= (double)points.size());
    }

    private static double computeInlineStandardDeviation(Point2DReadOnly meanPoint, List<Point2DReadOnly> points) {
        double variance = 0.0;
        for (Point2DReadOnly point : points) {
            variance += point.distanceSquared(meanPoint);
        }
        return Math.sqrt(variance /= (double)points.size());
    }
}

