/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.filters;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.filters.ZeroLagLowPassFilter;

public class ZeroLagLowPassFilterTest {
    @Test
    public void testZeroFiltering() {
        double[] list = new double[10];
        for (int i = 0; i < 10; ++i) {
            list[i] = i + 1;
        }
        double[] filteredList = ZeroLagLowPassFilter.getFilteredArray((double[])list, (double)0.0);
        Assert.assertEquals(list.length, filteredList.length);
        for (int i = 0; i < list.length; ++i) {
            Assert.assertEquals(list[i], filteredList[i], 1.0E-8);
        }
    }

    @Test
    public void testZeroNonZeroAlpha() {
        double[] list = new double[10];
        for (int i = 0; i < 10; ++i) {
            list[i] = i + 1;
        }
        double[] filteredList = ZeroLagLowPassFilter.getFilteredArray((double[])list, (double)0.5);
        Assert.assertEquals(list.length, filteredList.length);
        double[] answer = new double[]{1.08308919519186, 2.04117839038372, 3.019856780767441, 4.008463561534882, 5.001302123069763, 5.994791746139526, 6.985677242279053, 7.969401359558106, 8.937826156616211, 9.875164031982422};
        Assert.assertEquals(answer.length, filteredList.length);
        for (int i = 0; i < list.length; ++i) {
            Assert.assertEquals(answer[i], filteredList[i], 1.0E-8);
        }
    }

    @Test
    public void testZeroNonZeroAlpha2() {
        double[] list = new double[10];
        for (int i = 0; i < 10; ++i) {
            list[i] = i + 1;
        }
        double[] filteredList = ZeroLagLowPassFilter.getFilteredArray((double[])list, (double)0.3);
        Assert.assertEquals(list.length, filteredList.length);
        double[] answer = new double[]{1.008900871140671, 2.002669570468903, 3.000798568229678, 4.000231894098929, 5.000043980329763, 5.999927901099211, 6.999694060330704, 7.998960518102349, 8.996529155441165, 9.988428746667216};
        Assert.assertEquals(answer.length, filteredList.length);
        for (int i = 0; i < list.length; ++i) {
            Assert.assertEquals(answer[i], filteredList[i], 1.0E-8);
        }
    }
}

