/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.controllers.PDController;
import us.ihmc.yoVariables.registry.YoRegistry;

public class PDControllerTest {
    @Test
    public void testComputerForAngles() {
        double desired;
        double current;
        int i;
        PDController pdController = new PDController("suffix", new YoRegistry("testRegistry"));
        pdController.setDerivativeGain(0.0);
        pdController.setProportionalGain(0.0);
        double value = pdController.computeForAngles(0.0, Math.toRadians(90.0), 0.0, 0.0);
        Assert.assertEquals(0.0, value, 1.0E-6);
        pdController.setDerivativeGain(1.0);
        pdController.setProportionalGain(1.0);
        Random random = new Random();
        for (i = 0; i < 100; ++i) {
            current = 0.0;
            desired = random.nextDouble() * Math.PI;
            value = pdController.computeForAngles(current, desired, 0.0, 0.0);
            Assert.assertEquals(desired, value, 1.0E-6);
        }
        for (i = 0; i < 100; ++i) {
            current = Math.PI;
            desired = random.nextDouble() * Math.PI + Math.PI;
            value = pdController.computeForAngles(current, desired, 0.0, 0.0);
            Assert.assertEquals(desired - Math.PI, value, 1.0E-6);
        }
    }

    @Test
    public void testAngleBoundaries() {
        PDController pdController = new PDController("suffix", new YoRegistry("testRegistry"));
        pdController.setDerivativeGain(1.0);
        pdController.setProportionalGain(1.0);
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            double current = Math.PI - random.nextDouble() * Math.toRadians(89.0);
            double desired = -(Math.PI - random.nextDouble() * Math.toRadians(89.0));
            double value = pdController.computeForAngles(current, desired, 0.0, 0.0);
            double error = Math.PI - current + (Math.PI - Math.abs(desired));
            Assert.assertEquals(Math.PI - current + (Math.PI - Math.abs(desired)), value, 1.0E-6);
        }
    }
}

