/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.controllers;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.controllers.pidGains.GainCalculator;

public class GainCalculatorTest {
    @Test
    public void testComputeDerivativeGain() {
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            double derivativeGain = GainCalculator.computeDerivativeGain((double)(random.nextDouble() * 100.0 * -1.0), (double)(random.nextDouble() * 100.0));
            Assert.assertTrue(Double.isNaN(derivativeGain));
            derivativeGain = GainCalculator.computeDerivativeGain((double)(random.nextDouble() * 100.0), (double)(random.nextDouble() * 100.0 * -1.0));
            Assert.assertTrue(derivativeGain < 0.0);
        }
    }

    @Test
    public void testComputeDampingRatio() {
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            double dampingRatio = GainCalculator.computeDampingRatio((double)(random.nextDouble() * 100.0 * -1.0), (double)(random.nextDouble() * 100.0));
            Assert.assertTrue(Double.isNaN(dampingRatio));
            dampingRatio = GainCalculator.computeDerivativeGain((double)(random.nextDouble() * 100.0), (double)(random.nextDouble() * 100.0 * -1.0));
            Assert.assertTrue(dampingRatio < 0.0);
            double proportionalGain = random.nextDouble() * 100.0;
            double derivativeGain = random.nextDouble() * 10.0;
            dampingRatio = GainCalculator.computeDampingRatio((double)proportionalGain, (double)derivativeGain);
            Assert.assertEquals(derivativeGain / (2.0 * Math.sqrt(proportionalGain)), dampingRatio, 1.0E-4);
        }
    }

    @Test
    public void testComputeDampingForSecondOrderSystem() {
        double dampingCoeff = GainCalculator.computeDampingForSecondOrderSystem((double)1.0, (double)1.0, (double)1.0);
        Assert.assertEquals(2.0, dampingCoeff, 1.0E-6);
        dampingCoeff = GainCalculator.computeDampingForSecondOrderSystem((double)0.0, (double)1.0, (double)1.0);
        Assert.assertEquals(0.0, dampingCoeff, 1.0E-6);
        Random random = new Random();
        for (int i = 0; i < 1000; ++i) {
            dampingCoeff = GainCalculator.computeDampingForSecondOrderSystem((double)(random.nextDouble() * 1000.0 * -1.0), (double)1.0, (double)1.0);
            Assert.assertTrue(Double.isNaN(dampingCoeff));
            dampingCoeff = GainCalculator.computeDampingForSecondOrderSystem((double)1.0, (double)(random.nextDouble() * 1000.0 * -1.0), (double)1.0);
            Assert.assertTrue(Double.isNaN(dampingCoeff));
            dampingCoeff = GainCalculator.computeDampingForSecondOrderSystem((double)0.0, (double)(random.nextDouble() * 1000.0 * -1.0), (double)1.0);
            Assert.assertTrue(dampingCoeff == 0.0);
            dampingCoeff = GainCalculator.computeDampingForSecondOrderSystem((double)1.0, (double)1.0, (double)(random.nextDouble() * 1000.0 * -1.0));
            Assert.assertTrue(dampingCoeff < 0.0);
        }
    }
}

