/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.alphaToAlpha;

import java.util.ArrayList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.alphaToAlpha.StretchedSlowInMiddleAlphaToAlphaFunction;

public class StretchedSlowInMiddleAlphaToAlphaFunctionTest {
    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testDerivative() {
        double derivatesAtStartAndEnd = 10.0;
        StretchedSlowInMiddleAlphaToAlphaFunction stretchedSlowInMiddleAlphaToAlphaFunction = new StretchedSlowInMiddleAlphaToAlphaFunction(derivatesAtStartAndEnd);
        double alphaStart = -0.5;
        double alphaEnd = 1.5;
        double stepSize = 0.001;
        int numberOfSteps = (int)((alphaEnd - alphaStart) / stepSize);
        double[] alpha = new double[numberOfSteps];
        double[][] alphaPrime = new double[1][numberOfSteps];
        double[][] derivatives = new double[2][numberOfSteps];
        double[][] secondDerivatives = new double[2][numberOfSteps];
        for (int i = 0; i < numberOfSteps; ++i) {
            double currentAlpha;
            alpha[i] = currentAlpha = alphaStart + stepSize * (double)i;
            alphaPrime[0][i] = stretchedSlowInMiddleAlphaToAlphaFunction.getAlphaPrime(currentAlpha);
            derivatives[0][i] = stretchedSlowInMiddleAlphaToAlphaFunction.getDerivativeAtAlpha(currentAlpha);
            secondDerivatives[0][i] = stretchedSlowInMiddleAlphaToAlphaFunction.getSecondDerivativeAtAlpha(currentAlpha);
        }
        derivatives[1] = this.getNumericalDerivative(alphaPrime[0], stepSize);
        secondDerivatives[1] = this.getNumericalDerivative(derivatives[0], stepSize);
        String nameSuffix = " for a stretchedSlowInMiddleAlphaToAlphaFunction with end derivatives " + derivatesAtStartAndEnd;
        this.plot(alpha, alphaPrime, "AlphaPrime" + nameSuffix);
        this.plot(alpha, derivatives, "Analytical and numerical derivative" + nameSuffix);
        this.plot(alpha, secondDerivatives, "Analytical and numerical second derivative" + nameSuffix);
    }

    private double[] getNumericalDerivative(double[] array, double stepSize) {
        int n = array.length;
        double[] ret = new double[n];
        for (int i = 0; i < n - 1; ++i) {
            ret[i] = (array[i + 1] - array[i]) / stepSize;
        }
        ret[n - 1] = Double.NaN;
        return ret;
    }

    private void plot(double[] abscissa, double[][] ordinate, String name) {
        double numberOfTrajectories = ordinate.length;
        ArrayList<double[][]> listOfCurves1 = new ArrayList<double[][]>();
        int i = 0;
        while ((double)i < numberOfTrajectories) {
            listOfCurves1.add(new double[][]{abscissa, ordinate[i]});
            ++i;
        }
    }

    private void sleepForever() {
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

