/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.time;

import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.time.YoStopwatch;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoStopwatchTest {
    @Test
    public void testStopwatch() {
        YoRegistry registry = new YoRegistry("test");
        YoDouble yoTime = new YoDouble("t", registry);
        this.testStopwatch(yoTime, new YoStopwatch(yoTime));
        this.testStopwatch(yoTime, new YoStopwatch("timerTest", yoTime, registry));
    }

    private void testStopwatch(YoDouble yoTime, YoStopwatch stopwatch) {
        yoTime.set(0.0);
        double averageLap = stopwatch.averageLap();
        Assert.assertEquals("averageLap incorrect", Double.NaN, averageLap, 0.01);
        stopwatch.start();
        double lapElapsed = stopwatch.lapElapsed();
        double totalElapsed = stopwatch.totalElapsed();
        averageLap = stopwatch.averageLap();
        Assert.assertEquals("lapElapsed incorrect", 0.0, lapElapsed, 0.01);
        Assert.assertEquals("totalElapsed incorrect", 0.0, totalElapsed, 0.01);
        Assert.assertEquals("averageLap incorrect", Double.NaN, averageLap, 0.01);
        double sleepTime1 = 0.5;
        yoTime.add(sleepTime1);
        double lap = stopwatch.lap();
        averageLap = stopwatch.averageLap();
        Assert.assertEquals("lap incorrect", sleepTime1, lap, 0.01);
        Assert.assertEquals("averageLap incorrect", sleepTime1, averageLap, 0.01);
        double sleepTime2 = 1.0;
        yoTime.add(sleepTime2);
        lap = stopwatch.lap();
        averageLap = stopwatch.averageLap();
        Assert.assertEquals("lap incorrect", sleepTime2, lap, 0.01);
        Assert.assertEquals("averageLap incorrect", (sleepTime1 + sleepTime2) / 2.0, averageLap, 0.01);
        stopwatch.resetLap();
        lapElapsed = stopwatch.lapElapsed();
        Assert.assertEquals("lapElapsed incorrect", 0.0, lapElapsed, 0.01);
        lap = stopwatch.lap();
        averageLap = stopwatch.averageLap();
        Assert.assertEquals("lap incorrect", 0.0, lap, 0.01);
        Assert.assertEquals("averageLap incorrect", (sleepTime1 + sleepTime2) / 3.0, averageLap, 0.01);
        double sleepTime3 = 0.3;
        yoTime.add(sleepTime3);
        stopwatch.suspend();
        yoTime.add(1000.0);
        stopwatch.resume();
        lapElapsed = stopwatch.lapElapsed();
        totalElapsed = stopwatch.totalElapsed();
        Assert.assertEquals("lapElapsed incorrect", sleepTime3, lapElapsed, 0.01);
        Assert.assertEquals("totalElapsed incorrect", sleepTime1 + sleepTime2 + sleepTime3, totalElapsed, 0.01);
        stopwatch.reset();
        lapElapsed = stopwatch.lapElapsed();
        totalElapsed = stopwatch.totalElapsed();
        averageLap = stopwatch.averageLap();
        Assert.assertEquals("lapElapsed incorrect", 0.0, lapElapsed, 0.01);
        Assert.assertEquals("totalElapsed incorrect", 0.0, totalElapsed, 0.01);
        Assert.assertEquals("averageLap incorrect", Double.NaN, averageLap, 0.01);
        double sleepTime4 = 0.3;
        yoTime.add(sleepTime4);
        stopwatch.resetLap();
        lapElapsed = stopwatch.lapElapsed();
        Assert.assertEquals("lapElapsed incorrect", 0.0, lapElapsed, 0.01);
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForClass(YoStopwatch.class, YoStopwatchTest.class);
    }
}

