/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.time;

import java.time.Duration;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Conversions;
import us.ihmc.robotics.time.TimeTools;

public class TimeToolsTest {
    private static final double EPSILON = 1.0E-9;

    @Test
    public void testUnitConversions() {
        for (long millis = 0L; millis < 10000L; ++millis) {
            Assertions.assertEquals((double)((double)millis / 1000.0), (double)TimeTools.toDoubleSeconds((Duration)Duration.ofMillis(millis)), (double)1.0E-9);
        }
        for (int seconds = 0; seconds < 10; ++seconds) {
            for (int nanos = 0; nanos < 1000000000; nanos += 1000) {
                Duration duration = Duration.ofSeconds(seconds, nanos);
                double doubleSeconds = (double)seconds + Conversions.nanosecondsToSeconds((long)nanos);
                Assertions.assertEquals((double)doubleSeconds, (double)TimeTools.toDoubleSeconds((Duration)duration), (double)1.0E-9);
            }
        }
        for (long seconds = 0L; seconds < 100L; ++seconds) {
            for (long millis = 0L; millis < 10000L; ++millis) {
                double doubleSeconds = (double)seconds + Conversions.millisecondsToSeconds((double)millis);
                Assertions.assertEquals((double)doubleSeconds, (double)TimeTools.secondsMillisToDoubleSeconds((long)seconds, (long)millis), (double)1.0E-9);
            }
        }
        Duration twoPointFiveSeconds = TimeTools.durationOfSeconds((double)2.5);
        Assertions.assertEquals((long)2L, (long)twoPointFiveSeconds.getSeconds());
        Assertions.assertEquals((double)5.0E8, (double)twoPointFiveSeconds.getNano());
        for (double seconds = 0.0; seconds < 50.0; seconds += 0.05) {
            Duration duration = TimeTools.durationOfSeconds((double)seconds);
            long durationSeconds = duration.getSeconds();
            long durationNanos = duration.getNano();
            long trueSeconds = (long)seconds;
            long trueNanos = (long)((seconds - (double)trueSeconds) * 1.0E9);
            Assertions.assertEquals((long)trueSeconds, (long)durationSeconds);
            Assertions.assertEquals((long)trueNanos, (long)durationNanos);
        }
    }
}

