/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.time;

import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.time.TimeInterval;
import us.ihmc.robotics.time.TimeIntervalTools;
import us.ihmc.robotics.time.TimedValue;

public class TimeIntervalToolsTest {
    @Test
    public void testSortMethods() {
        int i;
        double epsilon = 1.0E-6;
        int size = 10;
        ArrayList<TimedValue> arrayValues = new ArrayList<TimedValue>(size);
        for (i = 0; i < size; ++i) {
            TimedValue tv = new TimedValue(i, new TimeInterval((double)i, (double)(i + 1)));
            arrayValues.add(tv);
        }
        TimeIntervalTools.sortByReverseStartTime(arrayValues);
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)((TimedValue)arrayValues.get(i)).getValue(), (double)(size - 1 - i), epsilon);
        }
        TimeIntervalTools.sortByStartTime(arrayValues);
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)((TimedValue)arrayValues.get(i)).getValue(), (double)i, epsilon);
        }
        TimeIntervalTools.sortByReverseEndTime(arrayValues);
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)((TimedValue)arrayValues.get(i)).getValue(), (double)(size - 1 - i), epsilon);
        }
        TimeIntervalTools.sortByEndTime(arrayValues);
        for (i = 0; i < arrayValues.size(); ++i) {
            Assert.assertEquals((double)((TimedValue)arrayValues.get(i)).getValue(), (double)i, epsilon);
        }
    }

    @Test
    public void testRemoveMethods() {
        int i;
        double epsilon = 1.0E-6;
        int size = 10;
        ArrayList<TimedValue> arrayValues = new ArrayList<TimedValue>(size);
        for (i = 0; i < size; ++i) {
            TimedValue tv = new TimedValue(i, new TimeInterval((double)i, (double)(i + 1)));
            arrayValues.add(tv);
        }
        TimeIntervalTools.removeEndTimesGreaterThan((double)8.5, arrayValues);
        size = 8;
        Assert.assertEquals(arrayValues.size(), size);
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)((TimedValue)arrayValues.get(i)).getValue(), (double)i, epsilon);
        }
        TimeIntervalTools.removeStartTimesGreaterThan((double)6.5, arrayValues);
        size = 7;
        Assert.assertEquals(arrayValues.size(), size);
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)((TimedValue)arrayValues.get(i)).getValue(), (double)i, epsilon);
        }
        TimeIntervalTools.removeStartTimesLessThan((double)1.5, arrayValues);
        size = 5;
        Assert.assertEquals(arrayValues.size(), size);
        for (i = 0; i < size; ++i) {
            Assert.assertEquals((double)((TimedValue)arrayValues.get(i)).getValue(), (double)(i + 2), epsilon);
        }
        TimeIntervalTools.removeEndTimesLessThan((double)6.5, arrayValues);
        Assert.assertEquals(arrayValues.size(), 1L);
        Assert.assertEquals((double)((TimedValue)arrayValues.get(0)).getValue(), 6.0, epsilon);
    }
}

