/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.testExecutor;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.taskExecutor.NullState;
import us.ihmc.robotics.taskExecutor.StateExecutor;
import us.ihmc.robotics.testExecutor.CountActionsTask;

public class TaskExecutorTest {
    @Test
    public void testEmptyExecutor() {
        StateExecutor taskExecutor = new StateExecutor();
        Assert.assertTrue(taskExecutor.isDone());
        State currentTask = taskExecutor.getCurrentTask();
        Assert.assertTrue(currentTask.isDone(Double.NaN));
        State nextTask = taskExecutor.getNextTask();
        Assert.assertNull(nextTask);
        State lastTask = taskExecutor.getLastTask();
        Assert.assertNull(lastTask);
    }

    @Test
    public void testWithOneNullTask() {
        StateExecutor taskExecutor = new StateExecutor();
        Assert.assertTrue(taskExecutor.isDone());
        NullState nullTask0 = new NullState();
        taskExecutor.submit((State)nullTask0);
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(nullTask0 == taskExecutor.getNextTask());
        Assert.assertTrue(nullTask0 == taskExecutor.getLastTask());
        taskExecutor.doControl();
        Assert.assertTrue(nullTask0 == taskExecutor.getCurrentTask());
        Assert.assertNull(taskExecutor.getNextTask());
        Assert.assertNull(taskExecutor.getLastTask());
        Assert.assertFalse(taskExecutor.isDone());
        taskExecutor.doControl();
        Assert.assertTrue(taskExecutor.getCurrentTask() instanceof NullState);
        Assert.assertNull(taskExecutor.getNextTask());
        Assert.assertNull(taskExecutor.getLastTask());
        Assert.assertTrue(taskExecutor.isDone());
    }

    @Test
    public void testWithSeveralNullTasks() {
        StateExecutor taskExecutor = new StateExecutor();
        NullState nullTask0 = new NullState();
        NullState nullTask1 = new NullState();
        NullState nullTask2 = new NullState();
        NullState nullTask3 = new NullState();
        NullState nullTask4 = new NullState();
        taskExecutor.submit((State)nullTask0);
        taskExecutor.submit((State)nullTask1);
        taskExecutor.submit((State)nullTask2);
        taskExecutor.submit((State)nullTask3);
        taskExecutor.submit((State)nullTask4);
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(taskExecutor.getCurrentTask() instanceof NullState);
        Assert.assertTrue(nullTask0 == taskExecutor.getNextTask());
        Assert.assertTrue(nullTask4 == taskExecutor.getLastTask());
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(nullTask0 == taskExecutor.getCurrentTask());
        Assert.assertTrue(nullTask1 == taskExecutor.getNextTask());
        Assert.assertTrue(nullTask4 == taskExecutor.getLastTask());
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(nullTask1 == taskExecutor.getCurrentTask());
        Assert.assertTrue(nullTask2 == taskExecutor.getNextTask());
        Assert.assertTrue(nullTask4 == taskExecutor.getLastTask());
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(nullTask2 == taskExecutor.getCurrentTask());
        Assert.assertTrue(nullTask3 == taskExecutor.getNextTask());
        Assert.assertTrue(nullTask4 == taskExecutor.getLastTask());
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(nullTask3 == taskExecutor.getCurrentTask());
        Assert.assertTrue(nullTask4 == taskExecutor.getNextTask());
        Assert.assertTrue(nullTask4 == taskExecutor.getLastTask());
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(nullTask4 == taskExecutor.getCurrentTask());
        Assert.assertNull(taskExecutor.getNextTask());
        Assert.assertNull(taskExecutor.getLastTask());
        taskExecutor.doControl();
        Assert.assertTrue(taskExecutor.isDone());
        Assert.assertFalse(nullTask4 == taskExecutor.getCurrentTask());
        Assert.assertNull(taskExecutor.getNextTask());
        Assert.assertNull(taskExecutor.getLastTask());
        Assert.assertTrue(taskExecutor.getCurrentTask() instanceof NullState);
    }

    @Test
    public void testSomeTasks() {
        int[] doActionsPerTask = new int[]{1};
        this.runATest(doActionsPerTask);
        doActionsPerTask = new int[]{1, 2};
        this.runATest(doActionsPerTask);
        doActionsPerTask = new int[]{2, 3, 7, 10, 1, 3};
        this.runATest(doActionsPerTask);
        doActionsPerTask = new int[]{2, 3, 7, 10, 1, 1};
        this.runATest(doActionsPerTask);
    }

    @Test
    public void testAddingTasksOnTheFly() {
        StateExecutor taskExecutor = new StateExecutor();
        CountActionsTask exampleTask0 = new CountActionsTask(2);
        taskExecutor.submit((State)exampleTask0);
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(exampleTask0.checkNumberOfCalls(0, 0, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(exampleTask0.checkNumberOfCalls(1, 1, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(exampleTask0.checkNumberOfCalls(1, 2, 0));
        taskExecutor.doControl();
        Assert.assertTrue(taskExecutor.isDone());
        Assert.assertTrue(exampleTask0.checkNumberOfCalls(1, 2, 1));
        CountActionsTask exampleTask1 = new CountActionsTask(2);
        taskExecutor.submit((State)exampleTask1);
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(exampleTask0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTask1.checkNumberOfCalls(0, 0, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(exampleTask0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTask1.checkNumberOfCalls(1, 1, 0));
        CountActionsTask exampleTask2 = new CountActionsTask(3);
        taskExecutor.submit((State)exampleTask2);
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(exampleTask0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTask1.checkNumberOfCalls(1, 2, 0));
        Assert.assertTrue(exampleTask2.checkNumberOfCalls(0, 0, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(exampleTask0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTask1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTask2.checkNumberOfCalls(1, 1, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(exampleTask0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTask1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTask2.checkNumberOfCalls(1, 2, 0));
        taskExecutor.doControl();
        Assert.assertFalse(taskExecutor.isDone());
        Assert.assertTrue(exampleTask0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTask1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTask2.checkNumberOfCalls(1, 3, 0));
        taskExecutor.doControl();
        Assert.assertTrue(taskExecutor.isDone());
        Assert.assertTrue(exampleTask0.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTask1.checkNumberOfCalls(1, 2, 1));
        Assert.assertTrue(exampleTask2.checkNumberOfCalls(1, 3, 1));
    }

    private void runATest(int[] doActionsPerTask) {
        StateExecutor taskExecutor = new StateExecutor();
        CountActionsTask[] exampleTasks = new CountActionsTask[doActionsPerTask.length];
        for (int i = 0; i < doActionsPerTask.length; ++i) {
            CountActionsTask exampleTask;
            exampleTasks[i] = exampleTask = new CountActionsTask(doActionsPerTask[i]);
            taskExecutor.submit((State)exampleTask);
            Assert.assertEquals(exampleTask, taskExecutor.getLastTask());
        }
        int currentTaskIndex = -1;
        int currentTaskDoActionCount = 0;
        while (!taskExecutor.isDone()) {
            State lastTask;
            taskExecutor.doControl();
            if (currentTaskIndex == -1 || ++currentTaskDoActionCount > doActionsPerTask[currentTaskIndex]) {
                ++currentTaskIndex;
                currentTaskDoActionCount = 1;
            }
            if (!taskExecutor.isDone()) {
                Assert.assertEquals(exampleTasks[currentTaskIndex], taskExecutor.getCurrentTask());
                Assert.assertTrue(exampleTasks[currentTaskIndex].checkNumberOfCalls(1, currentTaskDoActionCount, 0));
            }
            if (currentTaskIndex < exampleTasks.length - 1) {
                Assert.assertEquals(exampleTasks[currentTaskIndex + 1], taskExecutor.getNextTask());
            }
            if ((lastTask = taskExecutor.getLastTask()) != null) {
                Assert.assertEquals(exampleTasks[exampleTasks.length - 1], lastTask);
            }
            for (int i = 0; i < exampleTasks.length; ++i) {
                if (i < currentTaskIndex) {
                    Assert.assertTrue(exampleTasks[i].isDone(Double.NaN));
                    Assert.assertTrue(exampleTasks[i].checkNumberOfCalls(1, doActionsPerTask[i], 1));
                    continue;
                }
                if (currentTaskDoActionCount >= doActionsPerTask[currentTaskIndex]) continue;
                Assert.assertFalse(exampleTasks[i].isDone(Double.NaN));
            }
            if (currentTaskIndex >= doActionsPerTask.length) continue;
            if (currentTaskDoActionCount >= doActionsPerTask[currentTaskIndex]) {
                exampleTasks[currentTaskIndex].checkNumberOfCalls(1, currentTaskDoActionCount, 1);
                Assert.assertTrue(exampleTasks[currentTaskIndex].isDone(Double.NaN));
                continue;
            }
            exampleTasks[currentTaskIndex].checkNumberOfCalls(1, currentTaskDoActionCount, 0);
            Assert.assertFalse(exampleTasks[currentTaskIndex].isDone(Double.NaN));
        }
        Assert.assertEquals(exampleTasks.length, currentTaskIndex);
    }
}

