/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine;

import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.State;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateChangedListener;
import us.ihmc.robotics.stateMachine.old.conditionBasedStateMachine.StateMachine;
import us.ihmc.robotics.trajectories.providers.SettableDoubleProvider;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoEnum;

public class StateMachineExampleOneTest {
    @Test
    public void testConstructionOfSimpleTimeBasedStateMachine() {
        YoRegistry registry = new YoRegistry("registry");
        SettableDoubleProvider time = new SettableDoubleProvider();
        StateMachine stateMachine = new StateMachine("stateMachine", "switchTime", ExampleStateName.class, (DoubleProvider)time, registry);
        SimpleExampleState startingState = new SimpleExampleState(ExampleStateName.Starting);
        startingState.addDelayBasedStateTransition(ExampleStateName.StateOne, 1.0);
        stateMachine.addState((State)startingState);
        SimpleExampleState stateOne = new SimpleExampleState(ExampleStateName.StateOne);
        stateOne.addDelayBasedStateTransition(ExampleStateName.StateTwo, 1.0);
        stateMachine.addState((State)stateOne);
        SimpleExampleState stateTwo = new SimpleExampleState(ExampleStateName.StateTwo);
        stateTwo.addDelayBasedStateTransition(ExampleStateName.Stopped, 1.0);
        stateMachine.addState((State)stateTwo);
        SimpleExampleState stoppedState = new SimpleExampleState(ExampleStateName.Stopped);
        stateMachine.addState((State)stoppedState);
        stateMachine.setCurrentState((Enum)ExampleStateName.Starting);
        do {
            ExampleStateName currentStateEnum = (ExampleStateName)stateMachine.getCurrentStateEnum();
            if (time.getValue() < 1.01) {
                Assert.assertEquals((Object)ExampleStateName.Starting, (Object)currentStateEnum);
                Assert.assertFalse(stateMachine.inCurrentStateForDuration(1.01));
            } else if (time.getValue() < 2.01) {
                Assert.assertEquals((Object)ExampleStateName.StateOne, (Object)currentStateEnum);
            } else if (time.getValue() < 3.01) {
                Assert.assertEquals((Object)ExampleStateName.StateTwo, (Object)currentStateEnum);
            } else {
                Assert.assertEquals((Object)ExampleStateName.Stopped, (Object)currentStateEnum);
            }
            SimpleExampleState currentState = (SimpleExampleState)stateMachine.getCurrentState();
            if (stateMachine.timeInCurrentState() < 0.001) {
                Assert.assertTrue(currentState.didTransitionIntoAction);
                Assert.assertFalse(currentState.didAction);
                Assert.assertFalse(currentState.didTransitionOutOfAction);
            }
            boolean wontTransition = stateMachine.timeInCurrentState() < 1.0;
            stateMachine.doAction();
            stateMachine.checkTransitionConditions();
            time.setValue(time.getValue() + 0.01);
            double timeInCurrentState = stateMachine.timeInCurrentState();
            Assert.assertTrue(stateMachine.inCurrentStateForDuration(timeInCurrentState));
            Assert.assertFalse(stateMachine.inCurrentStateForDuration(timeInCurrentState + 1.0E-5));
            Assert.assertTrue(currentState.didTransitionIntoAction);
            Assert.assertTrue(currentState.didAction);
            if (wontTransition) {
                Assert.assertFalse(currentState.didTransitionOutOfAction);
            } else if (currentState != stoppedState) {
                Assert.assertTrue(currentState.didTransitionOutOfAction);
            }
            Assert.assertEquals(currentState.getStateEnum(), (Object)currentStateEnum);
        } while (time.getValue() < 10.0);
    }

    @Test
    public void testConstructionOfSimpleEventBasedStateMachine() {
        YoRegistry registry = new YoRegistry("registry");
        SettableDoubleProvider time = new SettableDoubleProvider();
        StateMachine stateMachine = new StateMachine("stateMachine", "switchTime", ExampleStateName.class, (DoubleProvider)time, registry);
        SimpleExampleState startingState = new SimpleExampleState(ExampleStateName.Starting);
        startingState.setDefaultNextState(ExampleStateName.StateOne);
        stateMachine.addState((State)startingState);
        SimpleExampleState stateOne = new SimpleExampleState(ExampleStateName.StateOne);
        stateOne.setDefaultNextState(ExampleStateName.StateTwo);
        stateMachine.addState((State)stateOne);
        SimpleExampleState stateTwo = new SimpleExampleState(ExampleStateName.StateTwo);
        stateTwo.setDefaultNextState(ExampleStateName.Stopped);
        stateMachine.addState((State)stateTwo);
        SimpleExampleState stoppedState = new SimpleExampleState(ExampleStateName.Stopped);
        stateMachine.addState((State)stoppedState);
        stateMachine.setCurrentState((Enum)ExampleStateName.Starting);
        Assert.assertEquals((Object)startingState, stateMachine.getState((Enum)ExampleStateName.Starting));
        Assert.assertEquals((Object)stateOne, stateMachine.getState((Enum)ExampleStateName.StateOne));
        Assert.assertEquals((Object)stateTwo, stateMachine.getState((Enum)ExampleStateName.StateTwo));
        Assert.assertEquals((Object)stoppedState, stateMachine.getState((Enum)ExampleStateName.Stopped));
        Assert.assertEquals("switchTime", stateMachine.getSwitchTimeName());
        Assert.assertEquals("stateMachine", stateMachine.getStateYoVariableName());
        Assert.assertTrue(stateMachine.isCurrentState((Enum)ExampleStateName.Starting));
        Assert.assertEquals((Object)startingState, stateMachine.getState((Enum)ExampleStateName.Starting));
        Assert.assertEquals((Object)stateOne, stateMachine.getState((Enum)ExampleStateName.StateOne));
        Assert.assertEquals((Object)stateTwo, stateMachine.getState((Enum)ExampleStateName.StateTwo));
        Assert.assertEquals((Object)stoppedState, stateMachine.getState((Enum)ExampleStateName.Stopped));
        RememberStateChangedListener listener = new RememberStateChangedListener();
        stateMachine.attachStateChangedListener((StateChangedListener)listener);
        RememberStateChangedListener listenerTwo = new RememberStateChangedListener();
        stateMachine.attachStateChangedListener((StateChangedListener)listenerTwo);
        ExampleStateName currentStateEnum = (ExampleStateName)stateMachine.getCurrentStateEnum();
        SimpleExampleState currentState = (SimpleExampleState)stateMachine.getCurrentState();
        Assert.assertEquals((Object)currentState, (Object)startingState);
        Assert.assertEquals((Object)currentStateEnum, (Object)ExampleStateName.Starting);
        Assert.assertEquals(currentState.getPreviousState(), (Object)startingState);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertFalse(currentState.didAction);
        Assert.assertFalse(currentState.didTransitionOutOfAction);
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        time.setValue(time.getValue() + 0.01);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertFalse(currentState.didTransitionOutOfAction);
        Assert.assertNull(listener.oldState);
        Assert.assertNull(listener.newState);
        Assert.assertEquals(0.0, listener.time, 1.0E-7);
        Assert.assertTrue(stateMachine.isCurrentState((Enum)ExampleStateName.Starting));
        currentState.transitionToDefaultNextState();
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertTrue(stateMachine.isCurrentState((Enum)ExampleStateName.StateOne));
        Assert.assertEquals((Object)startingState, listener.oldState);
        Assert.assertEquals((Object)stateOne, listener.newState);
        Assert.assertEquals(time.getValue(), listener.time, 1.0E-7);
        time.setValue(time.getValue() + 0.01);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertTrue(currentState.didTransitionOutOfAction);
        currentStateEnum = (ExampleStateName)stateMachine.getCurrentStateEnum();
        currentState = (SimpleExampleState)stateMachine.getCurrentState();
        Assert.assertEquals((Object)currentState, (Object)stateOne);
        Assert.assertEquals((Object)currentStateEnum, (Object)ExampleStateName.StateOne);
        Assert.assertEquals(currentState.getPreviousState(), (Object)startingState);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertFalse(currentState.didAction);
        Assert.assertFalse(currentState.didTransitionOutOfAction);
        Assert.assertEquals((Object)startingState, listener.oldState);
        Assert.assertEquals((Object)stateOne, listener.newState);
        Assert.assertTrue(stateMachine.isCurrentState((Enum)ExampleStateName.StateOne));
        currentState.transitionToDefaultNextState();
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertFalse(stateMachine.isCurrentState((Enum)ExampleStateName.StateOne));
        Assert.assertTrue(stateMachine.isCurrentState((Enum)ExampleStateName.StateTwo));
        Assert.assertEquals((Object)stateOne, listener.oldState);
        Assert.assertEquals((Object)stateTwo, listener.newState);
        Assert.assertEquals((Object)stateOne, listenerTwo.oldState);
        Assert.assertEquals((Object)stateTwo, listenerTwo.newState);
        Assert.assertEquals(time.getValue(), listener.time, 1.0E-7);
        time.setValue(time.getValue() + 0.01);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertTrue(currentState.didTransitionOutOfAction);
        currentStateEnum = (ExampleStateName)stateMachine.getCurrentStateEnum();
        currentState = (SimpleExampleState)stateMachine.getCurrentState();
        Assert.assertTrue(stateMachine.isCurrentState((Enum)ExampleStateName.StateTwo));
        Assert.assertEquals((Object)currentState, (Object)stateTwo);
        Assert.assertEquals((Object)currentStateEnum, (Object)ExampleStateName.StateTwo);
        Assert.assertEquals(currentState.getPreviousState(), (Object)stateOne);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertFalse(currentState.didAction);
        Assert.assertFalse(currentState.didTransitionOutOfAction);
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        time.setValue(time.getValue() + 0.01);
        Assert.assertEquals((Object)stateTwo, stateMachine.getCurrentState());
        Assert.assertEquals((Object)ExampleStateName.StateTwo, stateMachine.getCurrentStateEnum());
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertFalse(currentState.didTransitionOutOfAction);
        Assert.assertEquals((Object)stateOne, listener.oldState);
        Assert.assertEquals((Object)stateTwo, listener.newState);
        Assert.assertTrue(stateMachine.isCurrentState((Enum)ExampleStateName.StateTwo));
        currentState.transitionToDefaultNextState();
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        Assert.assertTrue(stateMachine.isCurrentState((Enum)ExampleStateName.Stopped));
        Assert.assertEquals((Object)stateTwo, listener.oldState);
        Assert.assertEquals((Object)stoppedState, listener.newState);
        Assert.assertEquals(time.getValue(), listener.time, 1.0E-7);
        time.setValue(time.getValue() + 0.01);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertTrue(currentState.didTransitionOutOfAction);
        currentStateEnum = (ExampleStateName)stateMachine.getCurrentStateEnum();
        currentState = (SimpleExampleState)stateMachine.getCurrentState();
        Assert.assertEquals((Object)currentState, (Object)stoppedState);
        Assert.assertEquals((Object)currentStateEnum, (Object)ExampleStateName.Stopped);
        Assert.assertEquals(currentState.getPreviousState(), (Object)stateTwo);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertFalse(currentState.didAction);
        Assert.assertFalse(currentState.didTransitionOutOfAction);
        stateMachine.doAction();
        stateMachine.checkTransitionConditions();
        time.setValue(time.getValue() + 0.01);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertFalse(currentState.didTransitionOutOfAction);
    }

    @Test
    public void testSomeStateMachineExceptions() {
        YoRegistry registry = new YoRegistry("registry");
        SettableDoubleProvider time = new SettableDoubleProvider();
        StateMachine stateMachine = new StateMachine("stateMachine", "switchTime", ExampleStateName.class, (DoubleProvider)time, registry);
        Assert.assertNull(stateMachine.getState((Enum)ExampleStateName.Starting));
        SimpleExampleState startingState = new SimpleExampleState(ExampleStateName.Starting);
        startingState.setDefaultNextState(ExampleStateName.StateOne);
        stateMachine.addState((State)startingState);
        try {
            stateMachine.addState((State)startingState);
            Assert.fail("Repeat State");
        }
        catch (RuntimeException e) {
            Assert.assertEquals("Duplicate state enums, name: Starting, already in use.", e.getMessage());
        }
        try {
            stateMachine.setCurrentState((Enum)ExampleStateName.StateOne);
            Assert.fail("State not added yet");
        }
        catch (RuntimeException e) {
            Assert.assertEquals("Need to add state StateOne to the state machine. Can't transition into the state unless it is added!", e.getMessage());
        }
        SimpleExampleState stateOne = new SimpleExampleState(ExampleStateName.StateOne);
        stateOne.setDefaultNextState(ExampleStateName.StateTwo);
        stateMachine.addState((State)stateOne);
        try {
            stateOne.setDefaultNextState(ExampleStateName.StateTwo);
            Assert.fail("Already set default next state.");
        }
        catch (RuntimeException e) {
            Assert.assertEquals("Have already set default next state for StateOne", e.getMessage());
        }
        try {
            stateMachine.addState((State)stateOne);
            Assert.fail("Repeat State");
        }
        catch (RuntimeException e) {
            Assert.assertEquals("Duplicate state enums, name: StateOne, already in use.", e.getMessage());
        }
        try {
            stateMachine.setCurrentState((Enum)ExampleStateName.Stopped);
            Assert.fail("Cannot set current state that is not added to the state machine.");
        }
        catch (RuntimeException e) {
            Assert.assertEquals("Need to add state Stopped to the state machine. Can't transition into the state unless it is added!", e.getMessage());
        }
        SimpleExampleState stateTwo = new SimpleExampleState(ExampleStateName.StateTwo);
        stateMachine.addState((State)stateTwo);
        stateMachine.setCurrentState((Enum)ExampleStateName.StateTwo);
        try {
            stateTwo.transitionToDefaultNextState();
            stateMachine.checkTransitionConditions();
            Assert.fail("DefaultNextState not set");
        }
        catch (RuntimeException e) {
            Assert.assertEquals("DefaultNextState was not set for currentState=StateTwo: ()", e.getMessage());
        }
        YoEnum stateYoVariable = stateMachine.getStateYoVariable();
        try {
            stateYoVariable.set(null);
            Assert.fail("Can't set null!");
        }
        catch (Exception e) {
            Assert.assertEquals("Setting YoEnum stateMachine to null. Must set allowNullValue to true in the constructor if you ever want to set it to null.", e.getMessage());
        }
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForPackage(StateMachineExampleOneTest.class);
    }

    private static enum ExampleStateName {
        Starting,
        StateOne,
        StateTwo,
        Stopped;

    }

    private class SimpleExampleState
    extends State<ExampleStateName> {
        public boolean didTransitionIntoAction;
        public boolean didAction;
        public boolean didTransitionOutOfAction;

        public SimpleExampleState(ExampleStateName stateEnum) {
            super((Enum)stateEnum);
            this.didTransitionIntoAction = false;
            this.didAction = false;
            this.didTransitionOutOfAction = false;
        }

        public void doAction() {
            this.didAction = true;
        }

        public void doTransitionIntoAction() {
            this.didTransitionIntoAction = true;
        }

        public void doTransitionOutOfAction() {
            this.didTransitionOutOfAction = true;
        }
    }

    private class RememberStateChangedListener
    implements StateChangedListener<ExampleStateName> {
        public State<ExampleStateName> oldState;
        public State<ExampleStateName> newState;
        public double time;

        private RememberStateChangedListener() {
        }

        public void stateChanged(State<ExampleStateName> oldState, State<ExampleStateName> newState, double time) {
            this.oldState = oldState;
            this.newState = newState;
            this.time = time;
        }
    }
}

