/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.stateMachine;

import org.junit.jupiter.api.Test;
import us.ihmc.commons.MutationTestFacilitator;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.stateMachine.core.State;
import us.ihmc.robotics.stateMachine.core.StateChangedListener;
import us.ihmc.robotics.stateMachine.core.StateMachine;
import us.ihmc.robotics.stateMachine.factories.StateMachineFactory;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class StateMachineExampleOneTest {
    @Test
    public void testConstructionOfSimpleTimeBasedStateMachine() {
        YoRegistry registry = new YoRegistry("registry");
        YoDouble time = new YoDouble("time", registry);
        StateMachineFactory factory = new StateMachineFactory(ExampleStateName.class);
        factory.setNamePrefix("blah");
        factory.setRegistry(registry);
        factory.buildClock((DoubleProvider)time);
        SimpleExampleState startingState = new SimpleExampleState(ExampleStateName.Starting);
        SimpleExampleState stateOne = new SimpleExampleState(ExampleStateName.StateOne);
        SimpleExampleState stateTwo = new SimpleExampleState(ExampleStateName.StateTwo);
        SimpleExampleState stoppedState = new SimpleExampleState(ExampleStateName.Stopped);
        factory.addState((Enum)ExampleStateName.Starting, (State)startingState);
        factory.addState((Enum)ExampleStateName.StateOne, (State)stateOne);
        factory.addState((Enum)ExampleStateName.StateTwo, (State)stateTwo);
        factory.addState((Enum)ExampleStateName.Stopped, (State)stoppedState);
        factory.addTimeBasedTransition((Enum)ExampleStateName.Starting, (Enum)ExampleStateName.StateOne, 1.0);
        factory.addTimeBasedTransition((Enum)ExampleStateName.StateOne, (Enum)ExampleStateName.StateTwo, 1.0);
        factory.addTimeBasedTransition((Enum)ExampleStateName.StateTwo, (Enum)ExampleStateName.Stopped, 1.0);
        StateMachine stateMachine = factory.build((Enum)ExampleStateName.Starting);
        stateMachine.resetToInitialState();
        do {
            ExampleStateName currentStateEnum = (ExampleStateName)stateMachine.getCurrentStateKey();
            if (time.getValue() < 1.01) {
                Assert.assertEquals((Object)ExampleStateName.Starting, (Object)currentStateEnum);
                Assert.assertFalse(stateMachine.getTimeInCurrentState() >= 1.01);
            } else if (time.getValue() < 2.01) {
                Assert.assertEquals((Object)ExampleStateName.StateOne, (Object)currentStateEnum);
            } else if (time.getValue() < 3.01) {
                Assert.assertEquals((Object)ExampleStateName.StateTwo, (Object)currentStateEnum);
            } else {
                Assert.assertEquals((Object)ExampleStateName.Stopped, (Object)currentStateEnum);
            }
            SimpleExampleState currentState = (SimpleExampleState)stateMachine.getCurrentState();
            if (stateMachine.getTimeInCurrentState() < 0.001) {
                Assert.assertTrue(currentState.didTransitionIntoAction);
                Assert.assertFalse(currentState.didAction);
                Assert.assertFalse(currentState.didTransitionOutOfAction);
            }
            boolean wontTransition = stateMachine.getTimeInCurrentState() < 1.0;
            stateMachine.doActionAndTransition();
            time.set(time.getValue() + 0.01);
            double timeInCurrentState = stateMachine.getTimeInCurrentState();
            Assert.assertTrue(stateMachine.getTimeInCurrentState() >= timeInCurrentState);
            Assert.assertFalse(stateMachine.getTimeInCurrentState() >= timeInCurrentState + 1.0E-5);
            Assert.assertTrue(currentState.didTransitionIntoAction);
            Assert.assertTrue(currentState.didAction);
            if (wontTransition) {
                Assert.assertFalse(currentState.didTransitionOutOfAction);
            } else if (currentState != stoppedState) {
                Assert.assertTrue(currentState.didTransitionOutOfAction);
            }
            Assert.assertEquals((Object)currentState.getStateEnum(), (Object)currentStateEnum);
        } while (time.getValue() < 10.0);
    }

    @Test
    public void testConstructionOfSimpleEventBasedStateMachine() {
        YoRegistry registry = new YoRegistry("registry");
        YoDouble time = new YoDouble("time", registry);
        StateMachineFactory factory = new StateMachineFactory(ExampleStateName.class);
        factory.setNamePrefix("bop");
        factory.setRegistry(registry);
        SimpleExampleState startingState = new SimpleExampleState(ExampleStateName.Starting);
        SimpleExampleState stateOne = new SimpleExampleState(ExampleStateName.StateOne);
        SimpleExampleState stateTwo = new SimpleExampleState(ExampleStateName.StateTwo);
        SimpleExampleState stoppedState = new SimpleExampleState(ExampleStateName.Stopped);
        factory.addStateAndDoneTransition((Enum)ExampleStateName.Starting, (State)startingState, (Enum)ExampleStateName.StateOne);
        factory.addStateAndDoneTransition((Enum)ExampleStateName.StateOne, (State)stateOne, (Enum)ExampleStateName.StateTwo);
        factory.addStateAndDoneTransition((Enum)ExampleStateName.StateTwo, (State)stateTwo, (Enum)ExampleStateName.Stopped);
        factory.addState((Enum)ExampleStateName.Stopped, (State)stoppedState);
        StateMachine stateMachine = factory.build((Enum)ExampleStateName.Starting);
        Assert.assertEquals(startingState, stateMachine.getState((Enum)ExampleStateName.Starting));
        Assert.assertEquals(stateOne, stateMachine.getState((Enum)ExampleStateName.StateOne));
        Assert.assertEquals(stateTwo, stateMachine.getState((Enum)ExampleStateName.StateTwo));
        Assert.assertEquals(stoppedState, stateMachine.getState((Enum)ExampleStateName.Stopped));
        stateMachine.resetToInitialState();
        Assert.assertEquals((Object)ExampleStateName.Starting, stateMachine.getCurrentStateKey());
        Assert.assertEquals(startingState, stateMachine.getState((Enum)ExampleStateName.Starting));
        Assert.assertEquals(stateOne, stateMachine.getState((Enum)ExampleStateName.StateOne));
        Assert.assertEquals(stateTwo, stateMachine.getState((Enum)ExampleStateName.StateTwo));
        Assert.assertEquals(stoppedState, stateMachine.getState((Enum)ExampleStateName.Stopped));
        RememberStateChangedListener listener = new RememberStateChangedListener();
        stateMachine.addStateChangedListener((StateChangedListener)listener);
        RememberStateChangedListener listenerTwo = new RememberStateChangedListener();
        stateMachine.addStateChangedListener((StateChangedListener)listenerTwo);
        ExampleStateName currentStateEnum = (ExampleStateName)stateMachine.getCurrentStateKey();
        SimpleExampleState currentState = (SimpleExampleState)stateMachine.getCurrentState();
        Assert.assertEquals(currentState, startingState);
        Assert.assertEquals((Object)currentStateEnum, (Object)ExampleStateName.Starting);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertFalse(currentState.didAction);
        Assert.assertFalse(currentState.didTransitionOutOfAction);
        stateMachine.doActionAndTransition();
        time.set(time.getValue() + 0.01);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertFalse(currentState.didTransitionOutOfAction);
        Assert.assertNull((Object)listener.oldState);
        Assert.assertNull((Object)listener.newState);
        Assert.assertEquals((Object)ExampleStateName.Starting, stateMachine.getCurrentStateKey());
        currentState.isDone = true;
        stateMachine.doActionAndTransition();
        Assert.assertEquals((Object)ExampleStateName.StateOne, stateMachine.getCurrentStateKey());
        Assert.assertEquals((Object)startingState.getStateEnum(), (Object)listener.oldState);
        Assert.assertEquals((Object)stateOne.getStateEnum(), (Object)listener.newState);
        time.set(time.getValue() + 0.01);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertTrue(currentState.didTransitionOutOfAction);
        currentStateEnum = (ExampleStateName)stateMachine.getCurrentStateKey();
        currentState = (SimpleExampleState)stateMachine.getCurrentState();
        Assert.assertEquals(currentState, stateOne);
        Assert.assertEquals((Object)ExampleStateName.StateOne, (Object)currentStateEnum);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertFalse(currentState.didTransitionOutOfAction);
        Assert.assertEquals((Object)startingState.getStateEnum(), (Object)listener.oldState);
        Assert.assertEquals((Object)stateOne.getStateEnum(), (Object)listener.newState);
        Assert.assertEquals((Object)ExampleStateName.StateOne, stateMachine.getCurrentStateKey());
        currentState.isDone = true;
        stateMachine.doActionAndTransition();
        Assert.assertEquals((Object)ExampleStateName.StateTwo, stateMachine.getCurrentStateKey());
        Assert.assertEquals((Object)stateOne.getStateEnum(), (Object)listener.oldState);
        Assert.assertEquals((Object)stateTwo.getStateEnum(), (Object)listener.newState);
        Assert.assertEquals((Object)stateOne.getStateEnum(), (Object)listenerTwo.oldState);
        Assert.assertEquals((Object)stateTwo.getStateEnum(), (Object)listenerTwo.newState);
        time.set(time.getValue() + 0.01);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertTrue(currentState.didTransitionOutOfAction);
        currentStateEnum = (ExampleStateName)stateMachine.getCurrentStateKey();
        currentState = (SimpleExampleState)stateMachine.getCurrentState();
        Assert.assertEquals((Object)ExampleStateName.StateTwo, stateMachine.getCurrentStateKey());
        Assert.assertEquals(currentState, stateTwo);
        Assert.assertEquals((Object)currentStateEnum, (Object)ExampleStateName.StateTwo);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertFalse(currentState.didTransitionOutOfAction);
        stateMachine.doActionAndTransition();
        time.set(time.getValue() + 0.01);
        Assert.assertEquals(stateTwo, stateMachine.getCurrentState());
        Assert.assertEquals((Object)ExampleStateName.StateTwo, stateMachine.getCurrentStateKey());
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertFalse(currentState.didTransitionOutOfAction);
        Assert.assertEquals((Object)stateOne.getStateEnum(), (Object)listener.oldState);
        Assert.assertEquals((Object)stateTwo.getStateEnum(), (Object)listener.newState);
        Assert.assertEquals((Object)ExampleStateName.StateTwo, stateMachine.getCurrentStateKey());
        currentState.isDone = true;
        stateMachine.doActionAndTransition();
        Assert.assertEquals((Object)ExampleStateName.Stopped, stateMachine.getCurrentStateKey());
        Assert.assertEquals((Object)stateTwo.getStateEnum(), (Object)listener.oldState);
        Assert.assertEquals((Object)stoppedState.getStateEnum(), (Object)listener.newState);
        time.set(time.getValue() + 0.01);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertTrue(currentState.didTransitionOutOfAction);
        currentStateEnum = (ExampleStateName)stateMachine.getCurrentStateKey();
        currentState = (SimpleExampleState)stateMachine.getCurrentState();
        Assert.assertEquals(currentState, stoppedState);
        Assert.assertEquals((Object)currentStateEnum, (Object)ExampleStateName.Stopped);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertFalse(currentState.didTransitionOutOfAction);
        stateMachine.doActionAndTransition();
        time.set(time.getValue() + 0.01);
        Assert.assertTrue(currentState.didTransitionIntoAction);
        Assert.assertTrue(currentState.didAction);
        Assert.assertFalse(currentState.didTransitionOutOfAction);
    }

    public static void main(String[] args) {
        MutationTestFacilitator.facilitateMutationTestForPackage(StateMachineExampleOneTest.class);
    }

    private static enum ExampleStateName {
        Starting,
        StateOne,
        StateTwo,
        Stopped;

    }

    private class SimpleExampleState
    implements State {
        public boolean didTransitionIntoAction = false;
        public boolean didAction = false;
        public boolean didTransitionOutOfAction = false;
        private final ExampleStateName stateEnum;
        private boolean isDone = false;

        public SimpleExampleState(ExampleStateName stateEnum) {
            this.stateEnum = stateEnum;
        }

        public void doAction(double timeInState) {
            this.didAction = true;
        }

        public void onEntry() {
            this.didTransitionIntoAction = true;
        }

        public void onExit(double timeInState) {
            this.didTransitionOutOfAction = true;
        }

        public boolean isDone(double timeInState) {
            return this.isDone;
        }

        public ExampleStateName getStateEnum() {
            return this.stateEnum;
        }
    }

    private class RememberStateChangedListener
    implements StateChangedListener<ExampleStateName> {
        public ExampleStateName oldState;
        public ExampleStateName newState;

        private RememberStateChangedListener() {
        }

        public void stateChanged(ExampleStateName oldState, ExampleStateName newState) {
            this.oldState = oldState;
            this.newState = newState;
        }
    }
}

