/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.ReferenceFrameHolder;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple4D.Vector4D;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DBasics;
import us.ihmc.euclid.tuple4D.interfaces.Vector4DReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.Joint;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.PrismaticJoint;
import us.ihmc.mecano.multiBodySystem.RevoluteJoint;
import us.ihmc.mecano.multiBodySystem.SixDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.FloatingJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.SixDoFJointReadOnly;
import us.ihmc.mecano.multiBodySystem.iterators.SubtreeStreams;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoRandomTools;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemFactories;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.mecano.tools.MultiBodySystemTools;
import us.ihmc.robotics.math.QuaternionCalculus;
import us.ihmc.robotics.screwTheory.TwistCalculator;

public class TwistCalculatorTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testWithChainComposedOfPrismaticJoints() {
        Random random = new Random(234234L);
        int numberOfJoints = 20;
        List prismaticJoints = MultiBodySystemRandomTools.nextPrismaticJointChain((Random)random, (int)numberOfJoints);
        TwistCalculator twistCalculator = new TwistCalculator(worldFrame, ((PrismaticJoint)prismaticJoints.get(random.nextInt(numberOfJoints))).getPredecessor());
        for (int i = 0; i < 100; ++i) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-10.0, (double)10.0, (Iterable)prismaticJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (double)-10.0, (double)10.0, (Iterable)prismaticJoints);
            twistCalculator.compute();
            FrameVector3D cumulatedLinearVelocity = new FrameVector3D(worldFrame);
            for (PrismaticJoint joint : prismaticJoints) {
                RigidBodyBasics body = joint.getSuccessor();
                Twist actualTwist = new Twist();
                twistCalculator.getTwistOfBody(body, actualTwist);
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                Twist expectedTwist = new Twist((ReferenceFrame)bodyFrame, worldFrame, (ReferenceFrame)bodyFrame);
                FrameVector3D jointAxis = new FrameVector3D((FrameTuple3DReadOnly)joint.getJointAxis());
                cumulatedLinearVelocity.changeFrame(jointAxis.getReferenceFrame());
                cumulatedLinearVelocity.scaleAdd(joint.getQd(), (FrameTuple3DReadOnly)jointAxis, (FrameTuple3DReadOnly)cumulatedLinearVelocity);
                cumulatedLinearVelocity.changeFrame((ReferenceFrame)bodyFrame);
                expectedTwist.getLinearPart().set((FrameTuple3DReadOnly)cumulatedLinearVelocity);
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-12);
            }
        }
    }

    @Test
    public void testWithChainComposedOfRevoluteJointsAssertAngularVelocityOnly() {
        Random random = new Random(234234L);
        int numberOfJoints = 20;
        List revoluteJoints = MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (int)numberOfJoints);
        TwistCalculator twistCalculator = new TwistCalculator(worldFrame, ((RevoluteJoint)revoluteJoints.get(random.nextInt(numberOfJoints))).getPredecessor());
        for (int i = 0; i < 100; ++i) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.5707963267948966, (double)1.5707963267948966, (Iterable)revoluteJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (double)-10.0, (double)10.0, (Iterable)revoluteJoints);
            twistCalculator.compute();
            FrameVector3D cumulatedAngularVelocity = new FrameVector3D(worldFrame);
            for (RevoluteJoint joint : revoluteJoints) {
                RigidBodyBasics body = joint.getSuccessor();
                Twist actualTwist = new Twist();
                twistCalculator.getTwistOfBody(body, actualTwist);
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                Twist expectedTwist = new Twist((ReferenceFrame)bodyFrame, worldFrame, (ReferenceFrame)bodyFrame);
                FrameVector3D jointAxis = new FrameVector3D((FrameTuple3DReadOnly)joint.getJointAxis());
                cumulatedAngularVelocity.changeFrame(jointAxis.getReferenceFrame());
                cumulatedAngularVelocity.scaleAdd(joint.getQd(), (FrameTuple3DReadOnly)jointAxis, (FrameTuple3DReadOnly)cumulatedAngularVelocity);
                cumulatedAngularVelocity.changeFrame((ReferenceFrame)bodyFrame);
                expectedTwist.getAngularPart().set((FrameTuple3DReadOnly)cumulatedAngularVelocity);
                expectedTwist.checkReferenceFrameMatch((SpatialMotionReadOnly)actualTwist);
                EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedTwist.getAngularPart(), (EuclidFrameGeometry)actualTwist.getAngularPart(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void testWithTreeComposedOfPrismaticJoints() {
        Random random = new Random(234234L);
        int numberOfJoints = 100;
        List prismaticJoints = MultiBodySystemRandomTools.nextPrismaticJointTree((Random)random, (int)numberOfJoints);
        TwistCalculator twistCalculator = new TwistCalculator(worldFrame, ((PrismaticJoint)prismaticJoints.get(random.nextInt(numberOfJoints))).getPredecessor());
        for (int i = 0; i < 100; ++i) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-10.0, (double)10.0, (Iterable)prismaticJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (double)-10.0, (double)10.0, (Iterable)prismaticJoints);
            twistCalculator.compute();
            for (PrismaticJoint joint : prismaticJoints) {
                RigidBodyBasics body = joint.getSuccessor();
                Twist actualTwist = new Twist();
                twistCalculator.getTwistOfBody(body, actualTwist);
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                Twist expectedTwist = new Twist((ReferenceFrame)bodyFrame, worldFrame, (ReferenceFrame)bodyFrame);
                RigidBodyBasics currentBody = body;
                FrameVector3D cumulatedLinearVelocity = new FrameVector3D(worldFrame);
                while (currentBody.getParentJoint() != null) {
                    PrismaticJoint parentJoint = (PrismaticJoint)currentBody.getParentJoint();
                    FrameVector3D jointAxis = new FrameVector3D((FrameTuple3DReadOnly)parentJoint.getJointAxis());
                    cumulatedLinearVelocity.changeFrame(jointAxis.getReferenceFrame());
                    cumulatedLinearVelocity.scaleAdd(parentJoint.getQd(), (FrameTuple3DReadOnly)jointAxis, (FrameTuple3DReadOnly)cumulatedLinearVelocity);
                    currentBody = parentJoint.getPredecessor();
                }
                cumulatedLinearVelocity.changeFrame((ReferenceFrame)bodyFrame);
                expectedTwist.getLinearPart().set((FrameTuple3DReadOnly)cumulatedLinearVelocity);
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-12);
            }
        }
    }

    @Test
    public void testWithTreeComposedOfRevoluteJointsAssertAngularVelocity() {
        Random random = new Random(234234L);
        int numberOfJoints = 100;
        List revoluteJoints = MultiBodySystemRandomTools.nextRevoluteJointTree((Random)random, (int)numberOfJoints);
        TwistCalculator twistCalculator = new TwistCalculator(worldFrame, ((RevoluteJoint)revoluteJoints.get(random.nextInt(numberOfJoints))).getPredecessor());
        for (int i = 0; i < 100; ++i) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-10.0, (double)10.0, (Iterable)revoluteJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (double)-10.0, (double)10.0, (Iterable)revoluteJoints);
            twistCalculator.compute();
            for (RevoluteJoint joint : revoluteJoints) {
                RigidBodyBasics body = joint.getSuccessor();
                Twist actualTwist = new Twist();
                twistCalculator.getTwistOfBody(body, actualTwist);
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                Twist expectedTwist = new Twist((ReferenceFrame)bodyFrame, worldFrame, (ReferenceFrame)bodyFrame);
                RigidBodyBasics currentBody = body;
                FrameVector3D cumulatedAngularVelocity = new FrameVector3D(worldFrame);
                while (currentBody.getParentJoint() != null) {
                    RevoluteJoint parentJoint = (RevoluteJoint)currentBody.getParentJoint();
                    FrameVector3D jointAxis = new FrameVector3D((FrameTuple3DReadOnly)parentJoint.getJointAxis());
                    cumulatedAngularVelocity.changeFrame(jointAxis.getReferenceFrame());
                    cumulatedAngularVelocity.scaleAdd(parentJoint.getQd(), (FrameTuple3DReadOnly)jointAxis, (FrameTuple3DReadOnly)cumulatedAngularVelocity);
                    currentBody = parentJoint.getPredecessor();
                }
                cumulatedAngularVelocity.changeFrame((ReferenceFrame)bodyFrame);
                expectedTwist.getAngularPart().set((FrameTuple3DReadOnly)cumulatedAngularVelocity);
                expectedTwist.checkReferenceFrameMatch((SpatialMotionReadOnly)actualTwist);
                EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)expectedTwist.getAngularPart(), (EuclidFrameGeometry)actualTwist.getAngularPart(), (double)1.0E-12);
            }
        }
    }

    @Test
    public void testWithChainRobotAgainstFiniteDifference() {
        Random random = new Random(234234L);
        int numberOfJoints = 10;
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        List<OneDoFJointBasics> jointsInFuture = Arrays.asList(MultiBodySystemFactories.cloneOneDoFJointKinematicChain((OneDoFJointBasics[])joints.toArray(new OneDoFJointBasics[numberOfJoints])));
        TwistCalculator twistCalculator = new TwistCalculator(worldFrame, ((OneDoFJoint)joints.get(0)).getPredecessor());
        double dt = 1.0E-8;
        for (int i = 0; i < 100; ++i) {
            int jointIndex;
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.0, (double)1.0, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (double)-1.0, (double)1.0, (Iterable)joints);
            for (jointIndex = 0; jointIndex < numberOfJoints; ++jointIndex) {
                double q = ((OneDoFJoint)joints.get(jointIndex)).getQ() + dt * ((OneDoFJoint)joints.get(jointIndex)).getQd();
                jointsInFuture.get(jointIndex).setQ(q);
            }
            ((OneDoFJoint)joints.get(0)).updateFramesRecursively();
            jointsInFuture.get(0).updateFramesRecursively();
            twistCalculator.compute();
            for (jointIndex = 0; jointIndex < numberOfJoints; ++jointIndex) {
                OneDoFJointBasics joint = (OneDoFJointBasics)joints.get(jointIndex);
                RigidBodyBasics body = joint.getSuccessor();
                Twist actualTwist = new Twist();
                twistCalculator.getTwistOfBody(body, actualTwist);
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                MovingReferenceFrame bodyFrameInFuture = jointsInFuture.get(jointIndex).getSuccessor().getBodyFixedFrame();
                Twist expectedTwist = TwistCalculatorTest.computeExpectedTwistByFiniteDifference(dt, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrameInFuture);
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-5);
            }
        }
    }

    @Test
    public void testWithTreeRobotAgainstFiniteDifference() {
        Random random = new Random(234234L);
        int numberOfJoints = 100;
        List joints = MultiBodySystemRandomTools.nextOneDoFJointTree((Random)random, (int)numberOfJoints);
        RigidBodyBasics rootBody = MultiBodySystemTools.getRootBody((RigidBodyBasics)((OneDoFJoint)joints.get(0)).getPredecessor());
        RigidBodyBasics rootBodyInFuture = MultiBodySystemFactories.cloneMultiBodySystem((RigidBodyReadOnly)rootBody, (ReferenceFrame)worldFrame, (String)"Test");
        List jointsInFuture = SubtreeStreams.fromChildren(OneDoFJointBasics.class, (RigidBodyReadOnly)rootBodyInFuture).collect(Collectors.toList());
        TwistCalculator twistCalculator = new TwistCalculator(worldFrame, rootBody);
        double dt = 1.0E-8;
        for (int i = 0; i < 100; ++i) {
            int jointIndex;
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.0, (double)1.0, (Iterable)joints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (double)-1.0, (double)1.0, (Iterable)joints);
            for (jointIndex = 0; jointIndex < numberOfJoints; ++jointIndex) {
                double q = ((OneDoFJoint)joints.get(jointIndex)).getQ() + dt * ((OneDoFJoint)joints.get(jointIndex)).getQd();
                ((OneDoFJointBasics)jointsInFuture.get(jointIndex)).setQ(q);
            }
            ((OneDoFJoint)joints.get(0)).updateFramesRecursively();
            ((OneDoFJointBasics)jointsInFuture.get(0)).updateFramesRecursively();
            twistCalculator.compute();
            for (jointIndex = 0; jointIndex < numberOfJoints; ++jointIndex) {
                OneDoFJointBasics joint = (OneDoFJointBasics)joints.get(jointIndex);
                RigidBodyBasics body = joint.getSuccessor();
                Twist actualTwist = new Twist();
                twistCalculator.getTwistOfBody(body, actualTwist);
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                MovingReferenceFrame bodyFrameInFuture = ((OneDoFJointBasics)jointsInFuture.get(jointIndex)).getSuccessor().getBodyFixedFrame();
                Twist expectedTwist = TwistCalculatorTest.computeExpectedTwistByFiniteDifference(dt, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrameInFuture);
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-5);
            }
        }
    }

    @Test
    public void testWithFloatingJointRobotAgainstFiniteDifference() {
        Random random = new Random(435345L);
        int numberOfRevoluteJoints = 100;
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain floatingChain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, numberOfRevoluteJoints);
        SixDoFJoint floatingJoint = floatingChain.getRootJoint();
        List revoluteJoints = floatingChain.getRevoluteJoints();
        List joints = floatingChain.getJoints();
        List<JointBasics> jointsInFuture = Arrays.asList(MultiBodySystemFactories.cloneKinematicChain((JointReadOnly[])((JointReadOnly[])joints.toArray(new JointBasics[numberOfRevoluteJoints + 1]))));
        SixDoFJoint floatingJointInFuture = (SixDoFJoint)jointsInFuture.get(0);
        List revoluteJointsInFuture = MultiBodySystemTools.filterJoints(jointsInFuture, RevoluteJoint.class);
        TwistCalculator twistCalculator = new TwistCalculator(worldFrame, ((Joint)joints.get(0)).getPredecessor());
        double dt = 1.0E-8;
        MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(dt);
        for (int i = 0; i < 100; ++i) {
            int jointIndex;
            floatingJoint.setJointOrientation((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            floatingJoint.setJointPosition((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)-10.0, (double)10.0));
            Twist floatingJointTwist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)floatingJoint.getFrameAfterJoint(), (ReferenceFrame)floatingJoint.getFrameBeforeJoint(), (ReferenceFrame)floatingJoint.getFrameAfterJoint());
            floatingJoint.setJointTwist((TwistReadOnly)floatingJointTwist);
            floatingJointInFuture.setJointConfiguration((SixDoFJointReadOnly)floatingJoint);
            floatingJointInFuture.setJointTwist((SixDoFJointReadOnly)floatingJoint);
            floatingJointInFuture.setJointAcceleration((SixDoFJointReadOnly)floatingJoint);
            integrator.integrateFromVelocity((FloatingJointBasics)floatingJointInFuture);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.0, (double)1.0, (Iterable)revoluteJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (double)-1.0, (double)1.0, (Iterable)revoluteJoints);
            for (jointIndex = 0; jointIndex < numberOfRevoluteJoints; ++jointIndex) {
                double q = ((RevoluteJoint)revoluteJoints.get(jointIndex)).getQ() + dt * ((RevoluteJoint)revoluteJoints.get(jointIndex)).getQd();
                ((RevoluteJoint)revoluteJointsInFuture.get(jointIndex)).setQ(q);
            }
            floatingJoint.updateFramesRecursively();
            floatingJointInFuture.updateFramesRecursively();
            twistCalculator.compute();
            for (jointIndex = 0; jointIndex < numberOfRevoluteJoints + 1; ++jointIndex) {
                JointBasics joint = (JointBasics)joints.get(jointIndex);
                RigidBodyBasics body = joint.getSuccessor();
                Twist actualTwist = new Twist();
                twistCalculator.getTwistOfBody(body, actualTwist);
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                MovingReferenceFrame bodyFrameInFuture = jointsInFuture.get(jointIndex).getSuccessor().getBodyFixedFrame();
                Twist expectedTwist = TwistCalculatorTest.computeExpectedTwistByFiniteDifference(dt, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrameInFuture);
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-5);
                Point3D bodyFixedPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                FramePoint3D frameBodyFixedPoint = new FramePoint3D((ReferenceFrame)bodyFrame, (Tuple3DReadOnly)bodyFixedPoint);
                FrameVector3D actualLinearVelocity = new FrameVector3D();
                twistCalculator.getLinearVelocityOfBodyFixedPoint(body, frameBodyFixedPoint, actualLinearVelocity);
                FrameVector3D expectedLinearVelocity = TwistCalculatorTest.computeExpectedLinearVelocityByFiniteDifference(dt, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrameInFuture, bodyFixedPoint);
                expectedLinearVelocity.checkReferenceFrameMatch((ReferenceFrameHolder)actualLinearVelocity);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLinearVelocity, (EuclidGeometry)actualLinearVelocity, (double)2.0E-5);
                FrameVector3D expectedAngularVelocity = TwistCalculatorTest.computeAngularVelocityByFiniteDifference(dt, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrameInFuture);
                FrameVector3D actualAngularVelocity = new FrameVector3D();
                twistCalculator.getAngularVelocityOfBody(body, actualAngularVelocity);
                expectedAngularVelocity.checkReferenceFrameMatch((ReferenceFrameHolder)actualAngularVelocity);
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularVelocity, (EuclidGeometry)actualAngularVelocity, (double)1.0E-5);
            }
        }
    }

    @Test
    public void testRelativeTwistWithFloatingJointRobotAgainstFiniteDifference() {
        Random random = new Random(435345L);
        int numberOfRevoluteJoints = 100;
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain floatingChain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, numberOfRevoluteJoints);
        SixDoFJoint floatingJoint = floatingChain.getRootJoint();
        List revoluteJoints = floatingChain.getRevoluteJoints();
        List joints = floatingChain.getJoints();
        List<JointBasics> jointsInFuture = Arrays.asList(MultiBodySystemFactories.cloneKinematicChain((JointReadOnly[])((JointReadOnly[])joints.toArray(new JointBasics[numberOfRevoluteJoints + 1]))));
        SixDoFJoint floatingJointInFuture = (SixDoFJoint)jointsInFuture.get(0);
        List revoluteJointsInFuture = MultiBodySystemTools.filterJoints(jointsInFuture, RevoluteJoint.class);
        TwistCalculator twistCalculator = new TwistCalculator(worldFrame, ((Joint)joints.get(random.nextInt(numberOfRevoluteJoints))).getPredecessor());
        double dt = 1.0E-8;
        MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(dt);
        for (int i = 0; i < 50; ++i) {
            int jointIndex;
            floatingJoint.setJointOrientation((Orientation3DReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
            floatingJoint.setJointPosition((Tuple3DReadOnly)EuclidCoreRandomTools.nextPoint3D((Random)random, (double)-10.0, (double)10.0));
            Twist floatingJointTwist = MecanoRandomTools.nextTwist((Random)random, (ReferenceFrame)floatingJoint.getFrameAfterJoint(), (ReferenceFrame)floatingJoint.getFrameBeforeJoint(), (ReferenceFrame)floatingJoint.getFrameAfterJoint());
            floatingJoint.setJointTwist((TwistReadOnly)floatingJointTwist);
            floatingJointInFuture.setJointConfiguration((SixDoFJointReadOnly)floatingJoint);
            floatingJointInFuture.setJointTwist((SixDoFJointReadOnly)floatingJoint);
            floatingJointInFuture.setJointAcceleration((SixDoFJointReadOnly)floatingJoint);
            integrator.integrateFromVelocity((FloatingJointBasics)floatingJointInFuture);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.0, (double)1.0, (Iterable)revoluteJoints);
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (double)-1.0, (double)1.0, (Iterable)revoluteJoints);
            for (jointIndex = 0; jointIndex < numberOfRevoluteJoints; ++jointIndex) {
                double q = ((RevoluteJoint)revoluteJoints.get(jointIndex)).getQ() + dt * ((RevoluteJoint)revoluteJoints.get(jointIndex)).getQd();
                ((RevoluteJoint)revoluteJointsInFuture.get(jointIndex)).setQ(q);
            }
            floatingJoint.updateFramesRecursively();
            floatingJointInFuture.updateFramesRecursively();
            twistCalculator.compute();
            for (jointIndex = 0; jointIndex < numberOfRevoluteJoints + 1; ++jointIndex) {
                JointBasics joint = (JointBasics)joints.get(jointIndex);
                RigidBodyBasics body = joint.getSuccessor();
                Twist actualTwist = new Twist();
                twistCalculator.getTwistOfBody(body, actualTwist);
                MovingReferenceFrame bodyFrame = body.getBodyFixedFrame();
                MovingReferenceFrame bodyFrameInFuture = jointsInFuture.get(jointIndex).getSuccessor().getBodyFixedFrame();
                Twist expectedTwist = TwistCalculatorTest.computeExpectedTwistByFiniteDifference(dt, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrameInFuture);
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-5);
                for (int baseJointIndex = 0; baseJointIndex < numberOfRevoluteJoints + 1; ++baseJointIndex) {
                    RigidBodyBasics base = ((Joint)joints.get(baseJointIndex)).getSuccessor();
                    Twist actualRelativeTwist = new Twist();
                    twistCalculator.getRelativeTwist(base, body, actualRelativeTwist);
                    MovingReferenceFrame baseFrame = base.getBodyFixedFrame();
                    MovingReferenceFrame baseFrameInFuture = jointsInFuture.get(baseJointIndex).getSuccessor().getBodyFixedFrame();
                    Twist expectedRelativeTwist = TwistCalculatorTest.computeExpectedRelativeTwistByFiniteDifference(dt, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrameInFuture, (ReferenceFrame)baseFrame, (ReferenceFrame)baseFrameInFuture);
                    MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedRelativeTwist, (TwistReadOnly)actualRelativeTwist, (double)1.0E-5);
                    Point3D bodyFixedPoint = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)10.0);
                    FramePoint3D frameBodyFixedPoint = new FramePoint3D((ReferenceFrame)bodyFrame, (Tuple3DReadOnly)bodyFixedPoint);
                    FrameVector3D actualLinearVelocity = new FrameVector3D();
                    twistCalculator.getLinearVelocityOfBodyFixedPoint(base, body, frameBodyFixedPoint, actualLinearVelocity);
                    FrameVector3D expectedLinearVelocity = TwistCalculatorTest.computeExpectedLinearVelocityByFiniteDifference(dt, (ReferenceFrame)bodyFrame, (ReferenceFrame)bodyFrameInFuture, (ReferenceFrame)baseFrame, (ReferenceFrame)baseFrameInFuture, bodyFixedPoint);
                    expectedLinearVelocity.checkReferenceFrameMatch((ReferenceFrameHolder)actualLinearVelocity);
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedLinearVelocity, (EuclidGeometry)actualLinearVelocity, (double)2.0E-5);
                    FrameVector3D expectedAngularVelocity = new FrameVector3D();
                    expectedAngularVelocity.setIncludingFrame((FrameTuple3DReadOnly)expectedRelativeTwist.getAngularPart());
                    FrameVector3D actualAngularVelocity = new FrameVector3D();
                    twistCalculator.getRelativeAngularVelocity(base, body, actualAngularVelocity);
                    expectedAngularVelocity.checkReferenceFrameMatch((ReferenceFrameHolder)actualAngularVelocity);
                    EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedAngularVelocity, (EuclidGeometry)actualAngularVelocity, (double)1.0E-5);
                }
            }
        }
    }

    public static FrameVector3D computeExpectedLinearVelocityByFiniteDifference(double dt, ReferenceFrame bodyFrame, ReferenceFrame bodyFrameInFuture, Point3D bodyFixedPoint) {
        return TwistCalculatorTest.computeExpectedLinearVelocityByFiniteDifference(dt, bodyFrame, bodyFrameInFuture, worldFrame, worldFrame, bodyFixedPoint);
    }

    public static FrameVector3D computeExpectedLinearVelocityByFiniteDifference(double dt, ReferenceFrame bodyFrame, ReferenceFrame bodyFrameInFuture, ReferenceFrame baseFrame, ReferenceFrame baseFrameInFuture, Point3D bodyFixedPoint) {
        FramePoint3D point = new FramePoint3D(bodyFrame, (Tuple3DReadOnly)bodyFixedPoint);
        FramePoint3D pointInFuture = new FramePoint3D(bodyFrameInFuture, (Tuple3DReadOnly)bodyFixedPoint);
        point.changeFrame(baseFrame);
        pointInFuture.changeFrame(baseFrameInFuture);
        FrameVector3D pointLinearVelocity = new FrameVector3D(baseFrame);
        pointLinearVelocity.sub((Tuple3DReadOnly)pointInFuture, (FrameTuple3DReadOnly)point);
        pointLinearVelocity.scale(1.0 / dt);
        return pointLinearVelocity;
    }

    public static Twist computeExpectedTwistByFiniteDifference(double dt, ReferenceFrame bodyFrame, ReferenceFrame bodyFrameInFuture) {
        Twist expectedTwist = new Twist(bodyFrame, worldFrame, bodyFrame);
        FrameVector3D bodyLinearVelocity = TwistCalculatorTest.computeLinearVelocityByFiniteDifference(dt, bodyFrame, bodyFrameInFuture);
        expectedTwist.getLinearPart().set((FrameTuple3DReadOnly)bodyLinearVelocity);
        FrameVector3D bodyAngularVelocity = TwistCalculatorTest.computeAngularVelocityByFiniteDifference(dt, bodyFrame, bodyFrameInFuture);
        expectedTwist.getAngularPart().set((FrameTuple3DReadOnly)bodyAngularVelocity);
        return expectedTwist;
    }

    public static Twist computeExpectedRelativeTwistByFiniteDifference(double dt, ReferenceFrame bodyFrame, ReferenceFrame bodyFrameInFuture, ReferenceFrame baseFrame, ReferenceFrame baseFrameInFuture) {
        Twist bodyTwist = TwistCalculatorTest.computeExpectedTwistByFiniteDifference(dt, bodyFrame, bodyFrameInFuture);
        bodyTwist.changeFrame(bodyFrame);
        Twist baseTwist = TwistCalculatorTest.computeExpectedTwistByFiniteDifference(dt, baseFrame, baseFrameInFuture);
        baseTwist.changeFrame(bodyFrame);
        Twist relativeTwist = new Twist(bodyFrame, baseFrame, bodyFrame);
        relativeTwist.setIncludingFrame((SpatialMotionReadOnly)bodyTwist);
        relativeTwist.sub((TwistReadOnly)baseTwist);
        return relativeTwist;
    }

    public static FrameVector3D computeAngularVelocityByFiniteDifference(double dt, ReferenceFrame bodyFrame, ReferenceFrame bodyFrameInFuture) {
        FrameQuaternion bodyOrientation = new FrameQuaternion(bodyFrame);
        bodyOrientation.changeFrame(worldFrame);
        FrameQuaternion bodyOrientationInFuture = new FrameQuaternion(bodyFrameInFuture);
        bodyOrientationInFuture.changeFrame(worldFrame);
        FrameVector3D bodyAngularVelocity = new FrameVector3D(worldFrame);
        QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
        Vector4D qDot = new Vector4D();
        quaternionCalculus.computeQDotByFiniteDifferenceCentral((QuaternionReadOnly)bodyOrientation, (QuaternionReadOnly)bodyOrientationInFuture, 0.5 * dt, (Vector4DBasics)qDot);
        quaternionCalculus.computeAngularVelocityInWorldFrame((QuaternionReadOnly)bodyOrientation, (Vector4DReadOnly)qDot, (Vector3DBasics)bodyAngularVelocity);
        bodyAngularVelocity.changeFrame(bodyFrame);
        return bodyAngularVelocity;
    }

    public static FrameVector3D computeLinearVelocityByFiniteDifference(double dt, ReferenceFrame bodyFrame, ReferenceFrame bodyFrameInFuture) {
        FramePoint3D bodyPosition = new FramePoint3D(bodyFrame);
        bodyPosition.changeFrame(worldFrame);
        FramePoint3D bodyPositionInFuture = new FramePoint3D(bodyFrameInFuture);
        bodyPositionInFuture.changeFrame(worldFrame);
        FrameVector3D bodyLinearVelocity = new FrameVector3D(worldFrame);
        bodyLinearVelocity.sub((FrameTuple3DReadOnly)bodyPositionInFuture, (FrameTuple3DReadOnly)bodyPosition);
        bodyLinearVelocity.scale(1.0 / dt);
        bodyLinearVelocity.changeFrame(bodyFrame);
        return bodyLinearVelocity;
    }

    public static void main(String[] args) {
        Random random = new Random();
        int numberOfJoints = 5;
        List randomChainRobot = MultiBodySystemRandomTools.nextRevoluteJointChain((Random)random, (int)numberOfJoints);
        TwistCalculator twistCalculator = new TwistCalculator(worldFrame, ((RevoluteJoint)randomChainRobot.get(0)).getPredecessor());
        Twist dummyTwist = new Twist();
        block0: while (true) {
            twistCalculator.compute();
            int i = 0;
            while (true) {
                if (i >= 100) continue block0;
                twistCalculator.getTwistOfBody(((RevoluteJoint)randomChainRobot.get(random.nextInt(numberOfJoints))).getSuccessor(), dummyTwist);
                ++i;
            }
            break;
        }
    }
}

