/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.euclid.yawPitchRoll.interfaces.YawPitchRollReadOnly;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.mecano.multiBodySystem.OneDoFJoint;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.spatial.Twist;
import us.ihmc.mecano.spatial.interfaces.SpatialMotionReadOnly;
import us.ihmc.mecano.spatial.interfaces.TwistBasics;
import us.ihmc.mecano.spatial.interfaces.TwistReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MecanoTestTools;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.mecano.tools.MultiBodySystemStateIntegrator;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.RotationTools;
import us.ihmc.robotics.referenceFrames.ZUpFrame;
import us.ihmc.robotics.screwTheory.MovingZUpFrame;
import us.ihmc.robotics.screwTheory.NumericalMovingReferenceFrame;

public class MovingZUpFrameTest {
    private static final double EPSILON = 1.0E-7;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testYawShortcut() throws Exception {
        int i;
        Random random = new Random(5646L);
        for (i = 0; i < 5000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            RotationMatrix expectedZUp = new RotationMatrix();
            expectedZUp.setToYawOrientation(rotationMatrix.getYaw());
            RotationMatrix actualZUp = new RotationMatrix();
            double sinPitch = -rotationMatrix.getM20();
            double cosPitch = Math.sqrt(1.0 - sinPitch * sinPitch);
            double cosYaw = rotationMatrix.getM00() / cosPitch;
            double sinYaw = rotationMatrix.getM10() / cosPitch;
            actualZUp.set(cosYaw, -sinYaw, 0.0, sinYaw, cosYaw, 0.0, 0.0, 0.0, 1.0);
            EuclidCoreTestTools.assertMatrix3DEquals((Matrix3DReadOnly)expectedZUp, (Matrix3DReadOnly)actualZUp, (double)1.0E-7);
        }
        for (i = 0; i < 5000; ++i) {
            final RigidBodyTransform originalTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            MovingReferenceFrame randomMovingFrame = new MovingReferenceFrame("blop", ReferenceFrame.getWorldFrame()){

                protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                    transformToParent.set(originalTransform);
                }

                protected void updateTwistRelativeToParent(Twist twistRelativeToParentToPack) {
                }
            };
            MovingZUpFrame zUpFrame = new MovingZUpFrame(randomMovingFrame, "blopButZUp");
            randomMovingFrame.update();
            zUpFrame.update();
            RigidBodyTransform expectedTransform = new RigidBodyTransform();
            expectedTransform.getTranslation().set((Tuple3DReadOnly)originalTransform.getTranslation());
            expectedTransform.getRotation().setToYawOrientation(originalTransform.getRotation().getYaw());
            EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTransform, (EuclidGeometry)zUpFrame.getTransformToWorldFrame(), (double)1.0E-7);
        }
    }

    @Test
    public void testYawRateShortcut() {
        int i;
        Random random = new Random(234523L);
        for (i = 0; i < 5000; ++i) {
            RotationMatrix rotationMatrix = EuclidCoreRandomTools.nextRotationMatrix((Random)random);
            Vector3D angularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
            YawPitchRoll yawPitchRoll = new YawPitchRoll();
            yawPitchRoll.set((Orientation3DReadOnly)rotationMatrix);
            double sinPitch = -rotationMatrix.getM20();
            double cosPitch = Math.sqrt(1.0 - sinPitch * sinPitch);
            double cosYaw = rotationMatrix.getM00() / cosPitch;
            double sinYaw = rotationMatrix.getM10() / cosPitch;
            double cosRoll = rotationMatrix.getM22() / cosPitch;
            double sinRoll = rotationMatrix.getM21() / cosPitch;
            Assert.assertEquals(sinPitch, Math.sin(yawPitchRoll.getPitch()), 1.0E-7);
            Assert.assertEquals(cosPitch, Math.cos(yawPitchRoll.getPitch()), 1.0E-7);
            Assert.assertEquals(sinYaw, Math.sin(yawPitchRoll.getYaw()), 1.0E-7);
            Assert.assertEquals(cosYaw, Math.cos(yawPitchRoll.getYaw()), 1.0E-7);
            Assert.assertEquals(sinRoll, Math.sin(yawPitchRoll.getRoll()), 1.0E-7);
            Assert.assertEquals(cosRoll, Math.cos(yawPitchRoll.getRoll()), 1.0E-7);
            double actuaYawRate = (sinRoll * angularVelocity.getY() + cosRoll * angularVelocity.getZ()) / cosPitch;
            double expectedYawRate = RotationTools.computeYawRate((YawPitchRollReadOnly)yawPitchRoll, (Vector3DReadOnly)angularVelocity, (boolean)true);
            Assert.assertEquals(expectedYawRate, actuaYawRate, 1.0E-7);
        }
        for (i = 0; i < 5000; ++i) {
            final RigidBodyTransform originalTransform = EuclidCoreRandomTools.nextRigidBodyTransform((Random)random);
            final Vector3D originalAngularVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
            final Vector3D originalLinearVelocity = EuclidCoreRandomTools.nextVector3D((Random)random);
            MovingReferenceFrame randomMovingFrame = new MovingReferenceFrame("blop", ReferenceFrame.getWorldFrame()){

                protected void updateTransformToParent(RigidBodyTransform transformToParent) {
                    transformToParent.set(originalTransform);
                }

                protected void updateTwistRelativeToParent(Twist twistRelativeToParentToPack) {
                    twistRelativeToParentToPack.setToZero((ReferenceFrame)this, this.getParent(), (ReferenceFrame)this);
                    twistRelativeToParentToPack.getAngularPart().set((Tuple3DReadOnly)originalAngularVelocity);
                    twistRelativeToParentToPack.getLinearPart().set((Tuple3DReadOnly)originalLinearVelocity);
                }
            };
            MovingZUpFrame zUpFrame = new MovingZUpFrame(randomMovingFrame, "blopButZUp");
            randomMovingFrame.update();
            zUpFrame.update();
            YawPitchRoll yawPitchRoll = new YawPitchRoll();
            yawPitchRoll.set((Orientation3DReadOnly)originalTransform.getRotation());
            Twist expectedTwist = new Twist((ReferenceFrame)zUpFrame, ReferenceFrame.getWorldFrame(), (ReferenceFrame)randomMovingFrame);
            expectedTwist.getLinearPart().set((Tuple3DReadOnly)originalLinearVelocity);
            expectedTwist.changeFrame((ReferenceFrame)zUpFrame);
            expectedTwist.setAngularPartZ(RotationTools.computeYawRate((YawPitchRollReadOnly)yawPitchRoll, (Vector3DReadOnly)originalAngularVelocity, (boolean)true));
            Assert.assertTrue(expectedTwist.epsilonEquals((SpatialMotionReadOnly)zUpFrame.getTwistOfFrame(), 1.0E-7));
        }
    }

    @Test
    public void testAgainstFiniteDifferenceWithChainRobot() {
        Random random = new Random(3452345L);
        int numberOfJoints = 20;
        double updateDT = 1.0E-8;
        MultiBodySystemStateIntegrator integrator = new MultiBodySystemStateIntegrator(updateDT);
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        HashMap<MovingZUpFrame, NumericalMovingReferenceFrame> jointFramesToFDFrames = new HashMap<MovingZUpFrame, NumericalMovingReferenceFrame>();
        for (OneDoFJointBasics joint : joints) {
            MovingReferenceFrame frameAfterJoint = joint.getFrameAfterJoint();
            MovingZUpFrame zupFrameAfterJoint = new MovingZUpFrame(frameAfterJoint, frameAfterJoint.getName() + "ZUp");
            NumericalMovingReferenceFrame frameAfterJointFD = new NumericalMovingReferenceFrame((ReferenceFrame)zupFrameAfterJoint, updateDT);
            jointFramesToFDFrames.put(zupFrameAfterJoint, frameAfterJointFD);
        }
        Twist actualTwist = new Twist();
        Twist expectedTwist = new Twist();
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.5707963267948966, (double)1.5707963267948966, (Iterable)joints);
        MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.VELOCITY, (Iterable)joints);
        ((OneDoFJoint)joints.get(0)).getPredecessor().updateFramesRecursively();
        jointFramesToFDFrames.keySet().forEach(MovingReferenceFrame::update);
        jointFramesToFDFrames.values().forEach(MovingReferenceFrame::update);
        for (int i = 0; i < 100; ++i) {
            integrator.integrateFromVelocity(joints);
            ((OneDoFJoint)joints.get(0)).getPredecessor().updateFramesRecursively();
            jointFramesToFDFrames.keySet().forEach(MovingReferenceFrame::update);
            jointFramesToFDFrames.values().forEach(MovingReferenceFrame::update);
            Set entrySet = jointFramesToFDFrames.entrySet();
            for (Map.Entry entry : entrySet) {
                ((MovingZUpFrame)entry.getKey()).getTwistOfFrame((TwistBasics)expectedTwist);
                ((NumericalMovingReferenceFrame)entry.getValue()).getTwistOfFrame((TwistBasics)actualTwist);
                expectedTwist.setBodyFrame((ReferenceFrame)entry.getValue());
                expectedTwist.changeFrame((ReferenceFrame)entry.getValue());
                MecanoTestTools.assertTwistEquals((TwistReadOnly)expectedTwist, (TwistReadOnly)actualTwist, (double)1.0E-5);
            }
        }
    }

    @Test
    public void testConsistencyWithZUpFrameWithChainRobot() {
        Random random = new Random(3452345L);
        int numberOfJoints = 20;
        List joints = MultiBodySystemRandomTools.nextOneDoFJointChain((Random)random, (int)numberOfJoints);
        HashMap<ZUpFrame, MovingZUpFrame> zUpFramesToMovingZUpFrames = new HashMap<ZUpFrame, MovingZUpFrame>();
        for (OneDoFJointBasics joint : joints) {
            MovingReferenceFrame frameAfterJoint = joint.getFrameAfterJoint();
            ZUpFrame zUpFrameAfterJoint = new ZUpFrame((ReferenceFrame)frameAfterJoint, frameAfterJoint.getName() + "ZUp");
            MovingZUpFrame movingZUpFrameAfterJoint = new MovingZUpFrame(frameAfterJoint, frameAfterJoint.getName() + "ZUp");
            zUpFramesToMovingZUpFrames.put(zUpFrameAfterJoint, movingZUpFrameAfterJoint);
        }
        RigidBodyTransform actualTransform = new RigidBodyTransform();
        RigidBodyTransform expectedTransform = new RigidBodyTransform();
        for (int i = 0; i < 100; ++i) {
            MultiBodySystemRandomTools.nextState((Random)random, (JointStateType)JointStateType.CONFIGURATION, (double)-1.5707963267948966, (double)1.5707963267948966, (Iterable)joints);
            ((OneDoFJoint)joints.get(0)).getPredecessor().updateFramesRecursively();
            zUpFramesToMovingZUpFrames.keySet().forEach(ReferenceFrame::update);
            zUpFramesToMovingZUpFrames.values().forEach(ReferenceFrame::update);
            Set entrySet = zUpFramesToMovingZUpFrames.entrySet();
            for (Map.Entry entry : entrySet) {
                expectedTransform.set(((ZUpFrame)entry.getKey()).getTransformToRoot());
                actualTransform.set(((MovingZUpFrame)entry.getValue()).getTransformToRoot());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedTransform, (EuclidGeometry)actualTransform, (double)1.0E-12);
            }
        }
    }
}

