/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.screwTheory;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.BitSet;
import java.util.Random;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.screwTheory.GenericCRC32;

public class GenericCRC32Test {
    private final int CRC_32_POLYNOMIAL = 79764919;
    private final ByteBuffer CRC_32_BYTE_BUFFER = ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN);
    private BitSet CRC_32_BITSET;

    @BeforeEach
    public void initialize() {
        this.CRC_32_BYTE_BUFFER.putInt(79764919);
        this.CRC_32_BYTE_BUFFER.rewind();
        this.CRC_32_BITSET = BitSet.valueOf(this.CRC_32_BYTE_BUFFER);
    }

    @Test
    public void testUpdateLong() {
        Random random = new Random(4271L);
        GenericCRC32 genericCRC32 = new GenericCRC32();
        genericCRC32.reset();
        ByteBuffer buffer = ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN);
        genericCRC32.update(79764919);
        System.out.println(genericCRC32.getValue());
    }

    private BitSet calculateCRCForLittleEndianBitSet(BitSet bitSet, BitSet crc) {
        int bitSetLength = bitSet.length();
        BitSet resultBitSet = this.createResultBitSet(bitSet, crc.length());
        for (int i = bitSetLength - 1; i >= 0; --i) {
            if (!bitSet.get(i)) continue;
            BitSet temp2 = resultBitSet.get(i, i + crc.length());
            temp2.xor(crc);
            for (int j = crc.length() - 1; j >= 0; --j) {
                if (temp2.get(j)) {
                    resultBitSet.set(i + j);
                    continue;
                }
                resultBitSet.clear(i + j);
            }
            bitSet = resultBitSet.get(crc.length() - 1, crc.length() + bitSetLength);
        }
        return resultBitSet.get(0, crc.length());
    }

    private BitSet createResultBitSet(BitSet sourceBitSet, int crcLength) {
        BitSet ret = new BitSet();
        for (int i = 0; i < sourceBitSet.length(); ++i) {
            if (!sourceBitSet.get(i)) continue;
            ret.set(i + crcLength - 1);
        }
        return ret;
    }

    private void printBitSet(BitSet bitSet) {
        Object ret = "";
        for (int i = 0; i < bitSet.length(); ++i) {
            ret = (String)ret + (bitSet.get(i) ? "1" : "0");
        }
        System.out.println((String)ret);
    }
}

