/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.robotSide;

import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.robotSide.RobotQuadrant;

public class RobotQuadrantTest {
    private RobotQuadrant frontLeft = RobotQuadrant.FRONT_LEFT;
    private RobotQuadrant frontRight = RobotQuadrant.FRONT_RIGHT;
    private RobotQuadrant hindRight = RobotQuadrant.HIND_RIGHT;
    private RobotQuadrant hindLeft = RobotQuadrant.HIND_LEFT;

    @Test
    public void testGetAcrossBodyLeg() {
        Assert.assertEquals(this.frontLeft, this.frontRight.getAcrossBodyQuadrant());
        Assert.assertEquals(this.frontRight, this.frontLeft.getAcrossBodyQuadrant());
        Assert.assertEquals(this.hindLeft, this.hindRight.getAcrossBodyQuadrant());
        Assert.assertEquals(this.hindRight, this.hindLeft.getAcrossBodyQuadrant());
    }

    @Test
    public void testGetAllLegs() {
        ArrayList actualReturn = RobotQuadrant.getAllQuadrants();
        Assert.assertEquals("Number of legs", 4L, actualReturn.size());
        Assert.assertEquals(this.frontLeft, actualReturn.get(0));
        Assert.assertEquals(this.frontRight, actualReturn.get(1));
        Assert.assertEquals(this.hindRight, actualReturn.get(2));
        Assert.assertEquals(this.hindLeft, actualReturn.get(3));
    }

    @Test
    public void testGetDiagonalOppositeLeg() {
        Assert.assertEquals(this.hindRight, this.frontLeft.getDiagonalOppositeQuadrant());
        Assert.assertEquals(this.hindLeft, this.frontRight.getDiagonalOppositeQuadrant());
        Assert.assertEquals(this.frontLeft, this.hindRight.getDiagonalOppositeQuadrant());
        Assert.assertEquals(this.frontRight, this.hindLeft.getDiagonalOppositeQuadrant());
    }

    @Test
    public void testGetLegName() {
        Assert.assertEquals(this.frontLeft, RobotQuadrant.getQuadrantName((String)"FRONT_LEFT"));
        Assert.assertEquals(this.frontRight, RobotQuadrant.getQuadrantName((String)"FRONT_RIGHT"));
        Assert.assertEquals(this.hindLeft, RobotQuadrant.getQuadrantName((String)"HIND_LEFT"));
        Assert.assertEquals(this.hindRight, RobotQuadrant.getQuadrantName((String)"HIND_RIGHT"));
    }

    @Test
    public void testGetLegName1() {
        Assert.assertEquals(this.frontLeft, RobotQuadrant.getQuadrantNameFromOrdinal((int)0));
        Assert.assertEquals(this.frontRight, RobotQuadrant.getQuadrantNameFromOrdinal((int)1));
        Assert.assertEquals(this.hindRight, RobotQuadrant.getQuadrantNameFromOrdinal((int)2));
        Assert.assertEquals(this.hindLeft, RobotQuadrant.getQuadrantNameFromOrdinal((int)3));
    }

    @Test
    public void testGetSameSideLeg() {
        Assert.assertEquals(this.hindLeft, this.frontLeft.getSameSideQuadrant());
        Assert.assertEquals(this.hindRight, this.frontRight.getSameSideQuadrant());
        Assert.assertEquals(this.frontRight, this.hindRight.getSameSideQuadrant());
        Assert.assertEquals(this.frontLeft, this.hindLeft.getSameSideQuadrant());
    }

    @Test
    public void testGetShortName() {
        Assert.assertEquals("FL", this.frontLeft.getShortName());
        Assert.assertEquals("FR", this.frontRight.getShortName());
        Assert.assertEquals("HR", this.hindRight.getShortName());
        Assert.assertEquals("HL", this.hindLeft.getShortName());
    }

    @Test
    public void testIsLegAFrontLeg() {
        Assert.assertTrue(this.frontLeft.isQuadrantInFront());
        Assert.assertTrue(this.frontRight.isQuadrantInFront());
        Assert.assertFalse(this.hindRight.isQuadrantInFront());
        Assert.assertFalse(this.hindLeft.isQuadrantInFront());
    }

    @Test
    public void testIsLegAHindLeg() {
        Assert.assertFalse(this.frontLeft.isQuadrantInHind());
        Assert.assertFalse(this.frontRight.isQuadrantInHind());
        Assert.assertTrue(this.hindRight.isQuadrantInHind());
        Assert.assertTrue(this.hindLeft.isQuadrantInHind());
    }

    @Test
    public void testIsLegALeftSideLeg() {
        Assert.assertTrue(this.frontLeft.isQuadrantOnLeftSide());
        Assert.assertFalse(this.frontRight.isQuadrantOnLeftSide());
        Assert.assertFalse(this.hindRight.isQuadrantOnLeftSide());
        Assert.assertTrue(this.hindLeft.isQuadrantOnLeftSide());
    }

    @Test
    public void testIsLegARightSideLeg() {
        Assert.assertFalse(this.frontLeft.isQuadrantOnRightSide());
        Assert.assertTrue(this.frontRight.isQuadrantOnRightSide());
        Assert.assertTrue(this.hindRight.isQuadrantOnRightSide());
        Assert.assertFalse(this.hindLeft.isQuadrantOnRightSide());
    }
}

