/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.quadTree;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.robotics.quadTree.Box;
import us.ihmc.robotics.quadTree.QuadTreeForGround;
import us.ihmc.robotics.quadTree.QuadTreeForGroundNode;
import us.ihmc.robotics.quadTree.QuadTreeForGroundParameters;

public class QuadTreeForGroundTest {
    @Disabled
    @Test
    public void testGetAllPoints() {
        QuadTreeForGroundParameters quadTreeParameters = new QuadTreeForGroundParameters(0.01, Double.MAX_VALUE, Double.MAX_VALUE, Integer.MAX_VALUE, 0.0, -1);
        QuadTreeForGround tree = new QuadTreeForGround(new Box(-1.0, -1.0, 1.0, 1.0), quadTreeParameters);
        ArrayList<Point3D> points = new ArrayList<Point3D>();
        for (double x = -0.5; x < 0.5; x += quadTreeParameters.getResolution() * 2.0) {
            for (double y = -0.5; y < 0.5; y += quadTreeParameters.getResolution() * 2.0) {
                double z = 0.1;
                Point3D p = new Point3D(x, y, 0.1);
                points.add(p);
                tree.put(x, y, 0.1);
            }
        }
        ArrayList retrievedPoints = new ArrayList();
        tree.getStoredPoints(retrievedPoints);
        Assertions.assertTrue((boolean)points.containsAll(retrievedPoints));
    }

    @Test
    public void testCommonCaseWithNoFilteringOrPointAveraging() {
        Random random = new Random(1178L);
        Box bounds = new Box(-10.0, -8.0, 10.0, 12.0);
        double resolution = 0.0;
        double heightThreshold = 0.1f;
        double maxMultiLevelZChangeToFilterNoise = Double.POSITIVE_INFINITY;
        int maxSameHeightPointsPerNode = Integer.MAX_VALUE;
        double maxAllowableXYDistanceForAPointToBeConsideredClose = Double.POSITIVE_INFINITY;
        QuadTreeForGroundParameters quadTreeParameters = new QuadTreeForGroundParameters(resolution, heightThreshold, maxMultiLevelZChangeToFilterNoise, maxSameHeightPointsPerNode, maxAllowableXYDistanceForAPointToBeConsideredClose, -1);
        QuadTreeForGround quadTree = new QuadTreeForGround(bounds, quadTreeParameters);
        Assertions.assertEquals((double)bounds.maxX, (double)quadTree.getMaxX(), (double)1.0E-7);
        Assertions.assertEquals((double)bounds.maxY, (double)quadTree.getMaxY(), (double)1.0E-7);
        Assertions.assertEquals((double)bounds.minX, (double)quadTree.getMinX(), (double)1.0E-7);
        Assertions.assertEquals((double)bounds.minY, (double)quadTree.getMinY(), (double)1.0E-7);
        Assertions.assertTrue((quadTreeParameters == quadTree.getQuadTreeParameters() ? 1 : 0) != 0);
        quadTree.setHeightThreshold(0.33);
        Assertions.assertEquals((double)0.33, (double)quadTree.getQuadTreeParameters().getHeightThreshold(), (double)1.0E-7);
        quadTree.setHeightThreshold(0.1);
        int numberOfPoints = 1000;
        double minZ = -1.0;
        double maxZ = 1.0;
        ArrayList<Point3D> points = this.generateRandomPoints(random, numberOfPoints, bounds, minZ, maxZ);
        for (Point3D point : points) {
            quadTree.put(point.getX(), point.getY(), point.getZ());
            Box boundsAroundPoint = new Box(point.getX() - resolution / 2.0, point.getY() - resolution / 2.0, point.getX() + resolution / 2.0, point.getY() + resolution / 2.0);
            ArrayList<Point3D> pointsToCheck = new ArrayList<Point3D>();
            quadTree.getAllPointsWithinBounds(boundsAroundPoint, pointsToCheck);
            Assertions.assertTrue((boolean)this.isPointValueInList(point, pointsToCheck));
            Point3D closestPoint = new Point3D();
            quadTree.getClosestPoint(point.getX(), point.getY(), closestPoint);
            Assertions.assertFalse((point == closestPoint ? 1 : 0) != 0);
            EuclidCoreTestTools.assertEquals((String)("point = " + point + ", closestPoint = " + closestPoint), (EuclidGeometry)point, (EuclidGeometry)closestPoint, (double)1.0E-7);
        }
    }

    @Test
    public void testPointLimiter() {
        int i;
        int j;
        int i2;
        int j2;
        Box bounds = new Box(-10.0, -10.0, 10.0, 10.0);
        QuadTreeForGroundParameters parameters = new QuadTreeForGroundParameters((double)0.49f, (double)0.001f, 0.2, 4, Double.POSITIVE_INFINITY, 32);
        QuadTreeForGround quadTree = new QuadTreeForGround(bounds, parameters);
        for (j2 = 1; j2 < 5; ++j2) {
            for (i2 = 0; i2 < 4; ++i2) {
                quadTree.put((double)j2, (double)j2, (double)i2 * 0.01);
            }
        }
        for (j2 = 1; j2 < 5; ++j2) {
            for (i2 = 0; i2 < 4; ++i2) {
                quadTree.put((double)(-j2), (double)(-j2), (double)i2 * 0.01);
            }
        }
        ArrayList childrenToPack = new ArrayList();
        quadTree.getRootNode().getChildrenNodes(childrenToPack);
        QuadTreeForGroundNode NW = (QuadTreeForGroundNode)childrenToPack.get(0);
        QuadTreeForGroundNode NE = (QuadTreeForGroundNode)childrenToPack.get(1);
        QuadTreeForGroundNode SE = (QuadTreeForGroundNode)childrenToPack.get(2);
        QuadTreeForGroundNode SW = (QuadTreeForGroundNode)childrenToPack.get(3);
        Assertions.assertTrue((boolean)NE.hasChildren());
        Assertions.assertTrue((boolean)SW.hasChildren());
        Assertions.assertFalse((boolean)NW.hasChildren());
        Assertions.assertFalse((boolean)SE.hasChildren());
        for (j = 1; j < 5; ++j) {
            for (i = 0; i < 4; ++i) {
                quadTree.put(-1.5, (double)(-j), (double)i * 0.01);
                Assertions.assertEquals((int)parameters.getMaximumNumberOfPoints(), (int)quadTree.getNumberOfPoints());
            }
        }
        Assertions.assertFalse((boolean)NE.hasChildren());
        Assertions.assertTrue((boolean)SW.hasChildren());
        Assertions.assertFalse((boolean)NW.hasChildren());
        Assertions.assertFalse((boolean)SE.hasChildren());
        for (j = 1; j < 5; ++j) {
            for (i = 0; i < 4; ++i) {
                quadTree.put((double)j, (double)(-j), (double)i * 0.01);
                Assertions.assertEquals((int)parameters.getMaximumNumberOfPoints(), (int)quadTree.getNumberOfPoints());
            }
        }
        Assertions.assertTrue((boolean)SE.hasChildren());
        Assertions.assertTrue((boolean)SW.hasChildren());
        Assertions.assertFalse((boolean)NW.hasChildren());
        Assertions.assertFalse((boolean)NE.hasChildren());
    }

    @Test
    public void testSimpleCasesOne() {
        float minX = -10.0f;
        float minY = -10.0f;
        float maxX = 10.0f;
        float maxY = 10.0f;
        float resolution = 0.49f;
        float heightThreshold = 0.001f;
        double maxMultiLevelZChangeToFilterNoise = 0.2;
        int maxSameHeightPointsPerNode = 20;
        double maxAllowableXYDistanceForAPointToBeConsideredClose = Double.POSITIVE_INFINITY;
        QuadTreeForGround quadTree = new QuadTreeForGround((double)minX, (double)minY, (double)maxX, (double)maxY, (double)resolution, (double)heightThreshold, maxMultiLevelZChangeToFilterNoise, maxSameHeightPointsPerNode, maxAllowableXYDistanceForAPointToBeConsideredClose);
        Assertions.assertEquals((int)1, (int)quadTree.getNumberOfQuads());
        quadTree.checkRepInvarients();
        Assertions.assertFalse((boolean)quadTree.getRootNode().hasChildren());
        double returnNullObject = quadTree.getHeightAtPoint(0.0, 0.0);
        Assertions.assertTrue((boolean)Double.isNaN(returnNullObject));
        Double valueAtZero = new Double(1.5);
        quadTree.put(0.0, 0.0, valueAtZero.doubleValue());
        Assertions.assertEquals((int)1, (int)quadTree.getNumberOfQuads());
        quadTree.checkRepInvarients();
        Assertions.assertFalse((boolean)quadTree.getRootNode().hasChildren());
        Double returnValueAtZero = quadTree.getHeightAtPoint(0.0, 0.0);
        Assertions.assertEquals((double)valueAtZero, (double)returnValueAtZero, (double)1.0E-7);
        quadTree.checkRepInvarients();
        Double returnValueOutOfBounds = quadTree.getHeightAtPoint(100.0, -720.0);
        Assertions.assertTrue((boolean)Double.isNaN(returnValueOutOfBounds));
        Double returnValueAwayFromZero = quadTree.getHeightAtPoint(3.0, (double)-7.2f);
        Assertions.assertEquals((double)valueAtZero, (double)returnValueAwayFromZero, (double)1.0E-7);
        Double valueAtNegativeOneOne = new Double(2.7);
        quadTree.put(-1.0, 1.0, valueAtNegativeOneOne.doubleValue());
        Assertions.assertEquals((int)4, (int)quadTree.getNumberOfQuads());
        quadTree.checkRepInvarients();
        Assertions.assertTrue((boolean)quadTree.getRootNode().hasChildren());
        returnValueAtZero = quadTree.getHeightAtPoint(0.0, 0.0);
        Assertions.assertEquals((double)valueAtZero, (double)returnValueAtZero, (double)1.0E-7);
        quadTree.checkRepInvarients();
        Double returnValueAtNegativeOneOne = quadTree.getHeightAtPoint(-1.0, 1.0);
        Assertions.assertEquals((double)valueAtNegativeOneOne, (double)returnValueAtNegativeOneOne, (double)1.0E-7);
        quadTree.clear();
        quadTree.checkRepInvarients();
        returnValueAtZero = quadTree.getHeightAtPoint(0.0, 0.0);
        returnValueAtNegativeOneOne = quadTree.getHeightAtPoint(-1.0, 1.0);
        Assertions.assertTrue((boolean)Double.isNaN(returnValueAtZero));
        Assertions.assertTrue((boolean)Double.isNaN(returnValueAtNegativeOneOne));
        quadTree.checkRepInvarients();
        Assertions.assertEquals((int)1, (int)quadTree.getNumberOfQuads());
    }

    @Test
    public void testWithFilteringAndPointAveraging() {
        Random random = new Random(1398L);
        Box bounds = new Box(-5.0, -5.0, 5.0, 5.0);
        double resolution = 0.1;
        double heightThreshold = 0.1f;
        double maxMultiLevelZChangeToFilterNoise = 0.2;
        int maxSameHeightPointsPerNode = 5;
        double maxAllowableXYDistanceForAPointToBeConsideredClose = 0.2;
        QuadTreeForGroundParameters quadTreeParameters = new QuadTreeForGroundParameters(resolution, heightThreshold, maxMultiLevelZChangeToFilterNoise, maxSameHeightPointsPerNode, maxAllowableXYDistanceForAPointToBeConsideredClose, -1);
        QuadTreeForGround quadTree = new QuadTreeForGround(bounds, quadTreeParameters);
        double minZ = -1.0;
        double maxZ = 1.0;
        double x = 3.3;
        double y = -1.7;
        Assertions.assertEquals((int)1, (int)quadTree.getNumberOfQuads());
        double z1 = 1.0;
        quadTree.put(x, y, z1);
        Assertions.assertEquals((double)z1, (double)quadTree.getHeightAtPoint(x, y), (double)1.0E-7);
        Assertions.assertEquals((int)1, (int)quadTree.getNumberOfQuads());
        ArrayList allPoints = new ArrayList();
        quadTree.getStoredPoints(allPoints);
        Assertions.assertEquals((int)1, (int)allPoints.size());
        Point3D firstPoint = (Point3D)allPoints.get(0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(x, y, z1), (EuclidGeometry)firstPoint, (double)1.0E-7);
        double z2 = 1.01;
        quadTree.put(x + 0.001, y, z2);
        Assertions.assertEquals((double)((z1 + z2) / 2.0), (double)quadTree.getHeightAtPoint(x, y), (double)1.0E-7);
        Assertions.assertEquals((int)16, (int)quadTree.getNumberOfQuads());
        allPoints.clear();
        quadTree.getStoredPoints(allPoints);
        Assertions.assertEquals((int)2, (int)allPoints.size());
        Point3D firstPointAgain = (Point3D)allPoints.get(0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point3D(x, y, z1), (EuclidGeometry)firstPointAgain, (double)1.0E-7);
        double z3 = 1.02;
        quadTree.put(x, y, z3);
        Assertions.assertEquals((double)((z1 + z2 + z3) / 3.0), (double)quadTree.getHeightAtPoint(x, y), (double)1.0E-7);
        allPoints.clear();
        quadTree.getStoredPoints(allPoints);
        Assertions.assertEquals((int)3, (int)allPoints.size());
        double z4 = 1.03;
        quadTree.put(x, y, z4);
        Assertions.assertEquals((double)((z1 + z2 + z3 + z4) / 4.0), (double)quadTree.getHeightAtPoint(x, y), (double)1.0E-7);
        allPoints.clear();
        quadTree.getStoredPoints(allPoints);
        Assertions.assertEquals((int)4, (int)allPoints.size());
        double z5 = 1.04;
        quadTree.put(x, y, z5);
        Assertions.assertEquals((double)((z1 + z2 + z3 + z4 + z5) / 5.0), (double)quadTree.getHeightAtPoint(x, y), (double)1.0E-7);
        allPoints.clear();
        quadTree.getStoredPoints(allPoints);
        Assertions.assertEquals((int)5, (int)allPoints.size());
        Assertions.assertEquals((int)16, (int)quadTree.getNumberOfQuads());
        double z6 = 1.03;
        quadTree.put(x, y, z6);
        double average = (z1 + z2 + z3 + z4 + z5 + z6) / 6.0;
        double heightAt = quadTree.getHeightAtPoint(x, y);
        Assertions.assertTrue((Math.abs(average - heightAt) > 0.001 ? 1 : 0) != 0);
        allPoints.clear();
        quadTree.getStoredPoints(allPoints);
        Assertions.assertEquals((int)5, (int)allPoints.size());
        Assertions.assertEquals((int)16, (int)quadTree.getNumberOfQuads());
    }

    @Test
    public void testGetClosestPoint() {
        Random random = new Random(1776L);
        Box bounds = new Box(-10.0, -10.0, 10.0, 10.0);
        double minZ = -5.0;
        double maxZ = 5.0;
        double resolution = 0.02;
        double heightThreshold = 0.002;
        double maxMultiLevelZChangeToFilterNoise = 0.2;
        int maxSameHeightPointsPerNode = 20;
        double maxAllowableXYDistanceForAPointToBeConsideredClose = 0.2;
        QuadTreeForGroundParameters parameters = new QuadTreeForGroundParameters(resolution, heightThreshold, maxMultiLevelZChangeToFilterNoise, maxSameHeightPointsPerNode, maxAllowableXYDistanceForAPointToBeConsideredClose, -1);
        int numberOfPoints = 1000;
        QuadTreeForGround quadTree = this.generateRandomQuadTree(random, bounds, parameters, minZ, maxZ, numberOfPoints);
        ArrayList points = new ArrayList();
        quadTree.getStoredPoints(points);
        int numberOfTests = 100;
        Point3D closestPoint = new Point3D();
        for (int i = 0; i < numberOfTests; ++i) {
            double xQuery = RandomNumbers.nextDouble((Random)random, (double)bounds.minX, (double)bounds.maxX);
            double yQuery = RandomNumbers.nextDouble((Random)random, (double)bounds.minY, (double)bounds.maxY);
            quadTree.getClosestPoint(xQuery, yQuery, closestPoint);
            double distanceSquared = this.distanceXYSquared(xQuery, yQuery, closestPoint);
            for (Point3D point : points) {
                if (point == closestPoint || !(this.distanceXYSquared(xQuery, yQuery, point) < distanceSquared)) continue;
                Assertions.fail((String)("Not closest point! Query = " + xQuery + ", " + yQuery + " thinks closest point is " + closestPoint + " but a closer point is " + point));
            }
        }
    }

    @Test
    public void testGetAllPointsWithinBounds() {
        Random random = new Random(1178L);
        Box bounds = new Box(-20.0, -0.0, 20.0, 3.0);
        double minZ = -7.0;
        double maxZ = 3.0;
        double resolution = 0.05;
        double heightThreshold = 0.1f;
        double maxMultiLevelZChangeToFilterNoise = 0.2;
        int maxSameHeightPointsPerNode = 3;
        double maxAllowableXYDistanceForAPointToBeConsideredClose = 0.2;
        QuadTreeForGroundParameters quadTreeParameters = new QuadTreeForGroundParameters(resolution, heightThreshold, maxMultiLevelZChangeToFilterNoise, maxSameHeightPointsPerNode, maxAllowableXYDistanceForAPointToBeConsideredClose, -1);
        int numberOfPoints = 1000;
        QuadTreeForGround quadTree = this.generateRandomQuadTree(random, bounds, quadTreeParameters, minZ, maxZ, numberOfPoints);
        ArrayList allPoints = new ArrayList();
        quadTree.getStoredPoints(allPoints);
        ArrayList<Point3D> pointsToCheck = new ArrayList<Point3D>();
        quadTree.getAllPointsWithinBounds(bounds, pointsToCheck);
        Assertions.assertEquals((int)allPoints.size(), (int)pointsToCheck.size());
        for (Point3D point : allPoints) {
            Box boundsAroundPoint = new Box(point.getX() - resolution / 2.0, point.getY() - resolution / 2.0, point.getX() + resolution / 2.0, point.getY() + resolution / 2.0);
            pointsToCheck.clear();
            quadTree.getAllPointsWithinBounds(boundsAroundPoint, pointsToCheck);
            boolean pointValueInList = this.isPointValueInList(point, pointsToCheck);
            Assertions.assertTrue((boolean)pointValueInList);
        }
    }

    @Test
    public void testGetAllPointsWithinDistance() {
        Random random = new Random(1984L);
        Box bounds = new Box(-10.0, -10.0, 10.0, 10.0);
        double minZ = -5.0;
        double maxZ = 5.0;
        double resolution = 0.02;
        double heightThreshold = 0.002;
        double maxMultiLevelZChangeToFilterNoise = 0.2;
        int maxSameHeightPointsPerNode = 20;
        double maxAllowableXYDistanceForAPointToBeConsideredClose = 0.2;
        QuadTreeForGroundParameters parameters = new QuadTreeForGroundParameters(resolution, heightThreshold, maxMultiLevelZChangeToFilterNoise, maxSameHeightPointsPerNode, maxAllowableXYDistanceForAPointToBeConsideredClose, -1);
        int numberOfPoints = 1000;
        QuadTreeForGround quadTree = this.generateRandomQuadTree(random, bounds, parameters, minZ, maxZ, numberOfPoints);
        ArrayList<Point3D> allPoints = new ArrayList<Point3D>();
        quadTree.getStoredPoints(allPoints);
        ArrayList pointsWithinDistance = new ArrayList();
        quadTree.getAllPointsWithinDistance(bounds.centreX, bounds.centreY, -0.01, pointsWithinDistance);
        Assertions.assertTrue((boolean)pointsWithinDistance.isEmpty());
        quadTree.getAllPointsWithinDistance(bounds.centreX, bounds.centreY, Double.POSITIVE_INFINITY, pointsWithinDistance);
        Assertions.assertEquals((int)allPoints.size(), (int)pointsWithinDistance.size());
        int numberOfTests = 100;
        for (int i = 0; i < numberOfTests; ++i) {
            pointsWithinDistance.clear();
            double xQuery = RandomNumbers.nextDouble((Random)random, (double)bounds.minX, (double)bounds.maxX);
            double yQuery = RandomNumbers.nextDouble((Random)random, (double)bounds.minY, (double)bounds.maxY);
            double distance = RandomNumbers.nextDouble((Random)random, (double)0.0, (double)5.0);
            quadTree.getAllPointsWithinDistance(xQuery, yQuery, distance, pointsWithinDistance);
            ArrayList<Point3D> checkPointsWithinDistance = this.naiiveGetAllPointsWithinDistance(allPoints, xQuery, yQuery, distance);
            if (pointsWithinDistance.size() != checkPointsWithinDistance.size()) {
                Assertions.fail((String)"pointsWithinDistance.size() != checkPointsWithinDistance.size()");
            }
            for (Point3D pointWithinDistance : pointsWithinDistance) {
                if (checkPointsWithinDistance.contains(pointWithinDistance)) continue;
                Assertions.fail((String)("Doesn't contain point! Query = " + xQuery + ", " + yQuery + " pointWithinDistance = " + pointWithinDistance));
            }
        }
    }

    private boolean isPointValueInList(Point3D pointToCheck, ArrayList<Point3D> pointList) {
        for (Point3D pointInList : pointList) {
            if (!(pointToCheck.distanceSquared((Point3DReadOnly)pointInList) < 1.0E-10)) continue;
            return true;
        }
        return false;
    }

    private ArrayList<Point3D> naiiveGetAllPointsWithinDistance(ArrayList<Point3D> inputPoints, double x, double y, double distance) {
        ArrayList<Point3D> pointsToReturn = new ArrayList<Point3D>();
        for (Point3D inputPoint : inputPoints) {
            if (!(this.distanceXYSquared(x, y, inputPoint) < distance * distance)) continue;
            pointsToReturn.add(inputPoint);
        }
        return pointsToReturn;
    }

    private QuadTreeForGround generateRandomQuadTree(Random random, Box bounds, QuadTreeForGroundParameters parameters, double minZ, double maxZ, int numberOfPoints) {
        QuadTreeForGround quadTree = new QuadTreeForGround(bounds, parameters);
        this.addRandomPointsToQuadTree(random, numberOfPoints, bounds, minZ, maxZ, quadTree);
        return quadTree;
    }

    private void addRandomPointsToQuadTree(Random random, int numberOfPoints, Box bounds, double minZ, double maxZ, QuadTreeForGround quadTree) {
        for (int i = 0; i < numberOfPoints; ++i) {
            Point3D point = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)bounds.minX, (double)bounds.maxX, (double)bounds.minY, (double)bounds.maxY, (double)minZ, (double)maxZ);
            quadTree.put(point.getX(), point.getY(), point.getZ());
        }
    }

    private ArrayList<Point3D> generateRandomPoints(Random random, int numberOfPoints, Box bounds, double minZ, double maxZ) {
        ArrayList<Point3D> pointsToReturn = new ArrayList<Point3D>();
        for (int i = 0; i < numberOfPoints; ++i) {
            Point3D point = EuclidCoreRandomTools.nextPoint3D((Random)random, (double)bounds.minX, (double)bounds.maxX, (double)bounds.minY, (double)bounds.maxY, (double)minZ, (double)maxZ);
            pointsToReturn.add(point);
        }
        return pointsToReturn;
    }

    private double distanceXYSquared(double x, double y, Point3D point) {
        if (point == null) {
            return Double.POSITIVE_INFINITY;
        }
        return (x - point.getX()) * (x - point.getX()) + (y - point.getY()) * (y - point.getY());
    }
}

