/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.physics;

import java.util.Random;
import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.robotics.physics.LinearComplementarityProblemSolver;

public class LinearComplementarityProblemSolverTest {
    private static final double EPSILON = 1.0E-12;
    private static final int ITERATIONS = 1000;

    @Test
    public void testSingleton() {
        Random random = new Random(32457L);
        for (int i = 0; i < 1000; ++i) {
            String prefix = "Iteration: " + i + ": ";
            DMatrixRMaj A = new DMatrixRMaj(1, 1);
            DMatrixRMaj b = new DMatrixRMaj(1, 1);
            A.set(0, EuclidCoreRandomTools.nextDouble((Random)random, (double)0.0, (double)10.0));
            b.set(0, EuclidCoreRandomTools.nextDouble((Random)random, (double)10.0));
            LinearComplementarityProblemSolver solver = new LinearComplementarityProblemSolver();
            DMatrixRMaj f = solver.solve(A, b);
            DMatrixRMaj a = new DMatrixRMaj(1, 1);
            CommonOps_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)f, (DMatrix1Row)a);
            CommonOps_DDRM.addEquals((DMatrixD1)a, (DMatrixD1)b);
            double a_i = a.get(0);
            double f_i = f.get(0);
            Assertions.assertTrue((a_i > -1.0E-12 ? 1 : 0) != 0, (String)(prefix + "the contact acceleration is negative: " + a_i));
            Assertions.assertTrue((f_i > -1.0E-12 ? 1 : 0) != 0, (String)(prefix + "the contact force is negative: " + f_i));
            Assertions.assertEquals((double)0.0, (double)(f_i * a_i), (double)1.0E-12, (String)(prefix + "the contact force x acceleration is non-zero."));
        }
    }

    @Test
    public void testRandomProblems() {
        Random random = new Random(43536L);
        for (int i = 0; i < 1000; ++i) {
            int numberOfContacts = random.nextInt(50) + 1;
            DMatrixRMaj A = RandomMatrices_DDRM.symmetricPosDef((int)numberOfContacts, (Random)random);
            DMatrixRMaj b = RandomMatrices_DDRM.rectangle((int)numberOfContacts, (int)1, (double)-1.0, (double)1.0, (Random)random);
            LinearComplementarityProblemSolver solver = new LinearComplementarityProblemSolver();
            DMatrixRMaj f = solver.solve(A, b);
            DMatrixRMaj a = new DMatrixRMaj(numberOfContacts, 1);
            CommonOps_DDRM.mult((DMatrix1Row)A, (DMatrix1Row)f, (DMatrix1Row)a);
            CommonOps_DDRM.addEquals((DMatrixD1)a, (DMatrixD1)b);
            for (int contactIndex = 0; contactIndex < numberOfContacts; ++contactIndex) {
                double a_i = a.get(contactIndex);
                double f_i = f.get(contactIndex);
                String prefix = "Iteration: " + i + ": ";
                Assertions.assertTrue((a_i > -1.0E-12 ? 1 : 0) != 0, (String)(prefix + contactIndex + "th contact acceleration is negative: " + a_i));
                Assertions.assertTrue((f_i > -1.0E-12 ? 1 : 0) != 0, (String)(prefix + contactIndex + "th contact force is negative: " + f_i));
                Assertions.assertEquals((double)0.0, (double)(f_i * a_i), (double)1.0E-12, (String)(prefix + contactIndex + "th contact force x acceleration is non-zero."));
            }
        }
    }
}

