/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.occupancyGrid;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FrameConvexPolygon2D;
import us.ihmc.euclid.referenceFrame.FrameLine2D;
import us.ihmc.euclid.referenceFrame.FramePoint2D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FrameLine2DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint2DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.occupancyGrid.OccupancyGrid;
import us.ihmc.robotics.occupancyGrid.OccupancyGridTools;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.yoVariables.registry.YoRegistry;

public class OccupancyGridToolsTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();

    @Test
    public void testRegisteringFourPoints() {
        int ticks;
        FramePoint2D pointA = new FramePoint2D(worldFrame, 1.0, 1.0);
        FramePoint2D pointB = new FramePoint2D(worldFrame, -1.0, 1.0);
        FramePoint2D pointC = new FramePoint2D(worldFrame, -1.0, -1.0);
        FramePoint2D pointD = new FramePoint2D(worldFrame, 1.0, -1.0);
        ConvexPolygon2D expectedHull = new ConvexPolygon2D();
        expectedHull.addVertex((Point2DReadOnly)pointA);
        expectedHull.addVertex((Point2DReadOnly)pointB);
        expectedHull.addVertex((Point2DReadOnly)pointC);
        expectedHull.addVertex((Point2DReadOnly)pointD);
        expectedHull.update();
        OccupancyGrid occupancyGrid = new OccupancyGrid("", worldFrame, new YoRegistry("test"));
        occupancyGrid.registerPoint((FramePoint2DReadOnly)pointA);
        occupancyGrid.registerPoint((FramePoint2DReadOnly)pointA);
        occupancyGrid.registerPoint((FramePoint2DReadOnly)pointB);
        occupancyGrid.registerPoint((FramePoint2DReadOnly)pointC);
        occupancyGrid.registerPoint((FramePoint2DReadOnly)pointC);
        occupancyGrid.registerPoint((FramePoint2DReadOnly)pointD);
        FrameConvexPolygon2D hull = new FrameConvexPolygon2D();
        OccupancyGridTools.computeConvexHullOfOccupancyGrid((OccupancyGrid)occupancyGrid, (FrameConvexPolygon2D)hull);
        Assert.assertEquals(4L, occupancyGrid.getNumberOfOccupiedCells());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedHull, (EuclidGeometry)hull, (double)1.0E-8);
        double decayRate = 0.1;
        int ticksToBarelyOccupied = (int)Math.floor(Math.log(0.5) / Math.log(1.0 - decayRate));
        int ticksToHalfOccupied = (int)Math.floor(Math.log(1.0) / Math.log(1.0 - decayRate));
        occupancyGrid.setOccupancyDecayRate(decayRate);
        for (ticks = 0; ticks < ticksToHalfOccupied; ++ticks) {
            occupancyGrid.update();
        }
        OccupancyGridTools.computeConvexHullOfOccupancyGrid((OccupancyGrid)occupancyGrid, (FrameConvexPolygon2D)hull);
        Assert.assertEquals(4L, occupancyGrid.getNumberOfOccupiedCells());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedHull, (EuclidGeometry)hull, (double)1.0E-8);
        expectedHull.clear();
        expectedHull.addVertex((Point2DReadOnly)pointA);
        expectedHull.addVertex((Point2DReadOnly)pointC);
        expectedHull.update();
        occupancyGrid.update();
        ++ticks;
        OccupancyGridTools.computeConvexHullOfOccupancyGrid((OccupancyGrid)occupancyGrid, (FrameConvexPolygon2D)hull);
        Assert.assertEquals(2L, occupancyGrid.getNumberOfOccupiedCells());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedHull, (EuclidGeometry)hull, (double)1.0E-8);
        while (ticks < ticksToBarelyOccupied) {
            occupancyGrid.update();
            ++ticks;
        }
        OccupancyGridTools.computeConvexHullOfOccupancyGrid((OccupancyGrid)occupancyGrid, (FrameConvexPolygon2D)hull);
        Assert.assertEquals(2L, occupancyGrid.getNumberOfOccupiedCells());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedHull, (EuclidGeometry)hull, (double)1.0E-8);
        occupancyGrid.update();
        expectedHull.clear();
        OccupancyGridTools.computeConvexHullOfOccupancyGrid((OccupancyGrid)occupancyGrid, (FrameConvexPolygon2D)hull);
        Assert.assertEquals(0L, occupancyGrid.getNumberOfOccupiedCells());
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedHull, (EuclidGeometry)hull, (double)1.0E-8);
    }

    @Test
    public void testRandomHull() {
        OccupancyGrid occupancyGrid = new OccupancyGrid("", worldFrame, new YoRegistry("test"));
        ConvexPolygon2D polygon2D = new ConvexPolygon2D();
        Random random = new Random(1738L);
        int pointsToAdd = 100;
        for (int i = 0; i < pointsToAdd; ++i) {
            FramePoint2D point = EuclidFrameRandomTools.nextFramePoint2D((Random)random, (ReferenceFrame)worldFrame);
            point.setX((double)OccupancyGrid.findIndex((double)point.getX(), (double)0.01));
            point.setY((double)OccupancyGrid.findIndex((double)point.getY(), (double)0.01));
            polygon2D.addVertex((Point2DReadOnly)point);
            occupancyGrid.registerPoint((FramePoint2DReadOnly)point);
        }
        polygon2D.update();
        FrameConvexPolygon2D hull = new FrameConvexPolygon2D();
        OccupancyGridTools.computeConvexHullOfOccupancyGrid((OccupancyGrid)occupancyGrid, (FrameConvexPolygon2D)hull);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)polygon2D, (EuclidGeometry)hull, (double)1.0E-8);
    }

    @Test
    public void testCellsOnSideOfLine() {
        OccupancyGrid occupancyGrid = new OccupancyGrid("", worldFrame, new YoRegistry("test"));
        FrameLine2D verticalLine = new FrameLine2D();
        FrameLine2D horizontalLine = new FrameLine2D();
        verticalLine.getDirection().set(1.0, 0.0);
        horizontalLine.getDirection().set(0.0, 1.0);
        occupancyGrid.registerPoint((FramePoint2DReadOnly)new FramePoint2D(worldFrame, 0.0, 1.0));
        int onLeftSide = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)verticalLine, (RobotSide)RobotSide.LEFT, (double)0.0);
        int onRightSide = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)verticalLine, (RobotSide)RobotSide.RIGHT, (double)0.0);
        int above = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)horizontalLine, (RobotSide)RobotSide.RIGHT, (double)0.0);
        int below = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)horizontalLine, (RobotSide)RobotSide.LEFT, (double)0.0);
        Assert.assertEquals(1L, onLeftSide);
        Assert.assertEquals(0L, onRightSide);
        Assert.assertEquals(0L, above);
        Assert.assertEquals(0L, below);
        occupancyGrid.registerPoint((FramePoint2DReadOnly)new FramePoint2D(worldFrame, 0.0, -1.0));
        onLeftSide = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)verticalLine, (RobotSide)RobotSide.LEFT, (double)0.0);
        onRightSide = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)verticalLine, (RobotSide)RobotSide.RIGHT, (double)0.0);
        above = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)horizontalLine, (RobotSide)RobotSide.RIGHT, (double)0.0);
        below = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)horizontalLine, (RobotSide)RobotSide.LEFT, (double)0.0);
        Assert.assertEquals(1L, onLeftSide);
        Assert.assertEquals(1L, onRightSide);
        Assert.assertEquals(0L, above);
        Assert.assertEquals(0L, below);
        occupancyGrid.registerPoint((FramePoint2DReadOnly)new FramePoint2D(worldFrame, 1.0, 0.0));
        onLeftSide = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)verticalLine, (RobotSide)RobotSide.LEFT, (double)0.0);
        onRightSide = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)verticalLine, (RobotSide)RobotSide.RIGHT, (double)0.0);
        above = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)horizontalLine, (RobotSide)RobotSide.RIGHT, (double)0.0);
        below = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)horizontalLine, (RobotSide)RobotSide.LEFT, (double)0.0);
        Assert.assertEquals(1L, onLeftSide);
        Assert.assertEquals(1L, onRightSide);
        Assert.assertEquals(1L, above);
        Assert.assertEquals(0L, below);
        occupancyGrid.registerPoint((FramePoint2DReadOnly)new FramePoint2D(worldFrame, -1.0, 0.0));
        onLeftSide = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)verticalLine, (RobotSide)RobotSide.LEFT, (double)0.0);
        onRightSide = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)verticalLine, (RobotSide)RobotSide.RIGHT, (double)0.0);
        above = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)horizontalLine, (RobotSide)RobotSide.RIGHT, (double)0.0);
        below = OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)horizontalLine, (RobotSide)RobotSide.LEFT, (double)0.0);
        Assert.assertEquals(1L, onLeftSide);
        Assert.assertEquals(1L, onRightSide);
        Assert.assertEquals(1L, above);
        Assert.assertEquals(1L, below);
        Assert.assertEquals(1L, OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)verticalLine, (RobotSide)RobotSide.LEFT, (double)0.95));
        Assert.assertEquals(1L, OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)verticalLine, (RobotSide)RobotSide.LEFT, (double)0.99));
        Assert.assertEquals(1L, OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)verticalLine, (RobotSide)RobotSide.LEFT, (double)0.9999));
        Assert.assertEquals(0L, OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)verticalLine, (RobotSide)RobotSide.LEFT, (double)1.0));
        Assert.assertEquals(0L, OccupancyGridTools.computeNumberOfCellsOccupiedOnSideOfLine((OccupancyGrid)occupancyGrid, (FrameLine2DReadOnly)verticalLine, (RobotSide)RobotSide.LEFT, (double)1.5));
    }
}

