/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories.trajectorypoints.lists;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.robotics.math.trajectories.trajectorypoints.FrameEuclideanTrajectoryPoint;
import us.ihmc.robotics.math.trajectories.trajectorypoints.lists.FrameEuclideanTrajectoryPointList;
import us.ihmc.robotics.math.trajectories.trajectorypoints.lists.FrameSE3TrajectoryPointList;

public class FrameEuclideanTrajectoryPointListTest {
    @Test
    public void testSetReferenceFrame() {
        FrameEuclideanTrajectoryPointList frameEuclideanTrajectoryPointList = new FrameEuclideanTrajectoryPointList();
        ReferenceFrame referenceFrameNotWorld = ReferenceFrameTools.constructARootFrame((String)"testFrame");
        frameEuclideanTrajectoryPointList.setReferenceFrame(referenceFrameNotWorld);
        Assertions.assertEquals((Object)referenceFrameNotWorld, (Object)frameEuclideanTrajectoryPointList.getReferenceFrame());
    }

    @Test
    public void testSetIncludingFrame() {
        FrameEuclideanTrajectoryPointList frameEuclideanTrajectoryPointList = new FrameEuclideanTrajectoryPointList();
        ReferenceFrame referenceFrameNotWorld = ReferenceFrameTools.constructARootFrame((String)"testFrame");
        frameEuclideanTrajectoryPointList.setReferenceFrame(referenceFrameNotWorld);
        FrameSE3TrajectoryPointList frameSE3TrajectoryPointList = new FrameSE3TrajectoryPointList();
        FrameEuclideanTrajectoryPoint frameEuclideanTrajectoryPoint = new FrameEuclideanTrajectoryPoint(ReferenceFrame.getWorldFrame());
        frameSE3TrajectoryPointList.addPositionTrajectoryPoint(frameEuclideanTrajectoryPoint);
        frameEuclideanTrajectoryPointList.setIncludingFrame(frameSE3TrajectoryPointList);
        Assertions.assertThrows(ReferenceFrameMismatchException.class, () -> frameEuclideanTrajectoryPointList.getReferenceFrame().checkReferenceFrameMatch(referenceFrameNotWorld));
    }
}

