/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoMinimumJerkTrajectory {
    public static final boolean DEBUG = false;
    private final YoDouble X0;
    private final YoDouble V0;
    private final YoDouble A0;
    private final YoDouble Xf;
    private final YoDouble Vf;
    private final YoDouble Af;
    private final YoDouble T0;
    private final YoDouble Tf;
    private double C0;
    private double C1;
    private double C2;
    private double C3;
    private double C4;
    private double C5;
    public double pos;
    public double vel;
    public double acc;
    private final int maxFindIterations = 10;
    private final int maxTimeIterations = 20;
    private final double minTimeWindow = 0.005;

    public YoMinimumJerkTrajectory(String name, YoRegistry registry) {
        this.X0 = new YoDouble(name + "_x0", registry);
        this.V0 = new YoDouble(name + "_v0", registry);
        this.A0 = new YoDouble(name + "_a0", registry);
        this.T0 = new YoDouble(name + "_t0", registry);
        this.Xf = new YoDouble(name + "_xf", registry);
        this.Vf = new YoDouble(name + "_vf", registry);
        this.Af = new YoDouble(name + "_af", registry);
        this.Tf = new YoDouble(name + "_tf", registry);
    }

    public double getStartTime() {
        return this.T0.getDoubleValue();
    }

    public double getFinalTime() {
        return this.Tf.getDoubleValue();
    }

    public double getPosition() {
        return this.pos;
    }

    public double getVelocity() {
        return this.vel;
    }

    public double getAcceleration() {
        return this.acc;
    }

    public void setParams(double X0, double V0, double A0, double Xf, double Vf, double Af, double T0, double Tf) {
        this.X0.set(X0);
        this.V0.set(V0);
        this.A0.set(A0);
        this.Xf.set(Xf);
        this.Vf.set(Vf);
        this.Af.set(Af);
        this.T0.set(T0);
        this.Tf.set(Tf);
        this.computeConstants();
    }

    private void computeConstants() {
        double DT = this.Tf.getDoubleValue() - this.T0.getDoubleValue();
        double DT2 = DT * DT;
        this.C0 = 1.0 * this.X0.getDoubleValue();
        this.C1 = 1.0 * this.V0.getDoubleValue() * DT;
        this.C2 = 0.5 * this.A0.getDoubleValue() * DT2;
        this.C3 = -10.0 * this.X0.getDoubleValue() - 6.0 * this.V0.getDoubleValue() * DT - 1.5 * this.A0.getDoubleValue() * DT2 + 10.0 * this.Xf.getDoubleValue() - 4.0 * this.Vf.getDoubleValue() * DT + 0.5 * this.Af.getDoubleValue() * DT2;
        this.C4 = 15.0 * this.X0.getDoubleValue() + 8.0 * this.V0.getDoubleValue() * DT + 1.5 * this.A0.getDoubleValue() * DT2 - 15.0 * this.Xf.getDoubleValue() + 7.0 * this.Vf.getDoubleValue() * DT - 1.0 * this.Af.getDoubleValue() * DT2;
        this.C5 = -6.0 * this.X0.getDoubleValue() - 3.0 * this.V0.getDoubleValue() * DT - 0.5 * this.A0.getDoubleValue() * DT2 + 6.0 * this.Xf.getDoubleValue() - 3.0 * this.Vf.getDoubleValue() * DT + 0.5 * this.Af.getDoubleValue() * DT2;
    }

    public void computeTrajectoryDoubles(double t, double[] vals) {
        this.computeTrajectory(t);
        vals[0] = this.pos;
        vals[1] = this.vel;
        vals[2] = this.acc;
    }

    public void computeTrajectory(double t, YoDouble pos) {
        this.computeTrajectory(t);
        pos.set(this.pos);
    }

    public void computeTrajectory(double t, YoDouble pos, YoDouble vel) {
        this.computeTrajectory(t);
        pos.set(this.pos);
        vel.set(this.vel);
    }

    public void computeTrajectory(double t, YoDouble pos, YoDouble vel, YoDouble acc) {
        this.computeTrajectory(t);
        pos.set(this.pos);
        vel.set(this.vel);
        acc.set(this.acc);
    }

    public void computeTrajectory(double t) {
        this.computeConstants();
        double DT = this.Tf.getDoubleValue() - this.T0.getDoubleValue();
        double DT2 = DT * DT;
        if (t < this.T0.getDoubleValue()) {
            this.pos = this.X0.getDoubleValue();
            this.vel = this.V0.getDoubleValue();
            this.acc = this.A0.getDoubleValue();
            return;
        }
        if (t > this.Tf.getDoubleValue()) {
            this.pos = this.Xf.getDoubleValue();
            this.vel = this.Vf.getDoubleValue();
            this.acc = this.Af.getDoubleValue();
            return;
        }
        double tau = (t - this.T0.getDoubleValue()) / DT;
        double tau2 = tau * tau;
        double tau3 = tau * tau2;
        double tau4 = tau * tau3;
        double tau5 = tau * tau4;
        this.pos = this.C0 + this.C1 * tau + this.C2 * tau2 + this.C3 * tau3 + this.C4 * tau4 + this.C5 * tau5;
        this.vel = (this.C1 + 2.0 * this.C2 * tau + 3.0 * this.C3 * tau2 + 4.0 * this.C4 * tau3 + 5.0 * this.C5 * tau4) / DT;
        this.acc = (2.0 * this.C2 + 6.0 * this.C3 * tau + 12.0 * this.C4 * tau2 + 20.0 * this.C5 * tau3) / DT2;
    }

    public void findMaxVelocityAndAccel(double currentTime, double[] maximums) {
        if (currentTime >= this.Tf.getDoubleValue()) {
            maximums[0] = this.Vf.getDoubleValue();
            maximums[1] = this.Af.getDoubleValue();
        }
        this.computeConstants();
        double DT = this.Tf.getDoubleValue() - this.T0.getDoubleValue();
        double DT2 = DT * DT;
        double deltaTime = (this.Tf.getDoubleValue() - this.T0.getDoubleValue()) / 10.0;
        double maxvel = Double.NEGATIVE_INFINITY;
        double maxacc = Double.NEGATIVE_INFINITY;
        double time = currentTime;
        do {
            double tau = (time - this.T0.getDoubleValue()) / DT;
            double tau2 = tau * tau;
            double tau3 = tau * tau2;
            double tau4 = tau * tau3;
            double currvel = Math.abs((this.C1 + 2.0 * this.C2 * tau + 3.0 * this.C3 * tau2 + 4.0 * this.C4 * tau3 + 5.0 * this.C5 * tau4) / DT);
            double curracc = Math.abs((2.0 * this.C2 + 6.0 * this.C3 * tau + 12.0 * this.C4 * tau2 + 20.0 * this.C5 * tau3) / DT2);
            if (currvel > maxvel) {
                maxvel = currvel;
            }
            if (!(curracc > maxacc)) continue;
            maxacc = curracc;
        } while ((time += deltaTime) <= this.Tf.getDoubleValue());
        maximums[0] = maxvel;
        maximums[1] = maxacc;
    }

    public double timeExtension(double currentTime, double maxV, double maxA, boolean Fix) {
        int timeIterations;
        if (Fix) {
            if (maxV < Math.abs(this.V0.getDoubleValue())) {
                this.V0.set(this.V0.getDoubleValue() * Math.abs(maxV / this.V0.getDoubleValue()) * 0.95);
            }
            if (maxV < Math.abs(this.Vf.getDoubleValue())) {
                this.Vf.set(this.Vf.getDoubleValue() * Math.abs(maxV / this.Vf.getDoubleValue()) * 0.95);
            }
            if (maxA < Math.abs(this.A0.getDoubleValue())) {
                this.A0.set(this.A0.getDoubleValue() * Math.abs(maxA / this.A0.getDoubleValue()) * 0.95);
            }
            if (maxA < Math.abs(this.Af.getDoubleValue())) {
                this.Af.set(this.Af.getDoubleValue() * Math.abs(maxA / this.Af.getDoubleValue()) * 0.95);
            }
        } else if (maxV < Math.abs(this.V0.getDoubleValue()) || maxA < Math.abs(this.A0.getDoubleValue()) || maxV < Math.abs(this.Vf.getDoubleValue()) || maxA < Math.abs(this.Af.getDoubleValue())) {
            return 0.0;
        }
        double[] maxs = new double[2];
        this.findMaxVelocityAndAccel(currentTime, maxs);
        if (maxs[0] <= maxV && maxs[1] <= maxA) {
            return 0.0;
        }
        double TForig = this.Tf.getDoubleValue();
        double timeadd = 0.5;
        double lowerbound = Math.max(currentTime, this.Tf.getDoubleValue());
        double upperbound = lowerbound + timeadd;
        boolean withinBounds = false;
        for (timeIterations = 1; !withinBounds && timeIterations < 20; ++timeIterations) {
            upperbound = lowerbound + timeadd;
            this.Tf.set(upperbound);
            this.findMaxVelocityAndAccel(currentTime, maxs);
            withinBounds = maxs[0] < maxV && maxs[1] <= maxA;
            timeadd *= 2.0;
        }
        while (timeIterations < 20 && upperbound - lowerbound > 0.005) {
            double middle = (lowerbound + upperbound) / 2.0;
            this.Tf.set(middle);
            this.findMaxVelocityAndAccel(currentTime, maxs);
            if (maxs[0] <= maxV && maxs[1] <= maxA) {
                upperbound = middle;
            } else {
                lowerbound = middle;
            }
            ++timeIterations;
        }
        this.Tf.set(TForig);
        return upperbound;
    }

    @Deprecated
    public void updateToFinalPosition(double currentTime, double Xf) {
        this.computeTrajectory(currentTime);
        this.T0.set(currentTime);
        this.Xf.set(Xf);
        this.X0.set(this.getPosition());
        this.V0.set(this.getVelocity());
        this.A0.set(this.getAcceleration());
        this.computeConstants();
    }

    @Deprecated
    public void setFinalPosition(double Xf) {
        this.Xf.set(Xf);
        this.computeConstants();
    }
}

