/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import java.util.Random;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.robotics.math.interpolators.OrientationInterpolationCalculator;
import us.ihmc.robotics.math.trajectories.StraightLinePoseTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.core.Polynomial;
import us.ihmc.robotics.referenceFrames.PoseReferenceFrame;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class StraightLinePoseTrajectoryGeneratorTest {
    private static final Random random = new Random(1516351L);
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final ReferenceFrame frameA = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"frameA", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
    private String namePrefix = "namePrefixTEST";
    private static double trajectoryTime = 10.0;
    private static final double EPSILON = 1.0E-4;

    @Test
    public void testCompareWithSingleFrameTrajectoryGenerators() {
        YoRegistry registry = new YoRegistry("youpiloup");
        StraightLinePoseTrajectoryGenerator trajToTest = new StraightLinePoseTrajectoryGenerator("blop", worldFrame, registry);
        DoubleProvider trajectoryTimeProvider = () -> 10.0;
        FramePoint3D initialPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)100.0, (double)100.0, (double)100.0);
        FramePoint3D finalPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)100.0, (double)100.0, (double)100.0);
        FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        Polynomial interpolationPolynomial = new Polynomial(6);
        interpolationPolynomial.setQuintic(0.0, trajectoryTimeProvider.getValue(), 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        trajToTest.setInitialPose((FramePoint3DReadOnly)initialPosition, (FrameOrientation3DReadOnly)initialOrientation);
        trajToTest.setFinalPose((FramePoint3DReadOnly)finalPosition, (FrameOrientation3DReadOnly)finalOrientation);
        trajToTest.setTrajectoryTime(trajectoryTimeProvider.getValue());
        trajToTest.initialize();
        double dt = 0.001;
        FramePoint3D position1 = new FramePoint3D();
        FrameVector3D velocity1 = new FrameVector3D();
        FrameVector3D acceleration1 = new FrameVector3D();
        FrameQuaternion orientation1 = new FrameQuaternion();
        FrameVector3D angularVelocity1 = new FrameVector3D();
        FrameVector3D angularAcceleration1 = new FrameVector3D();
        FramePoint3D position2 = new FramePoint3D();
        FrameVector3D velocity2 = new FrameVector3D();
        FrameVector3D acceleration2 = new FrameVector3D();
        FrameQuaternion orientation2 = new FrameQuaternion();
        FrameVector3D angularVelocity2 = new FrameVector3D();
        FrameVector3D angularAcceleration2 = new FrameVector3D();
        for (double t = 0.0; t <= trajectoryTimeProvider.getValue(); t += dt) {
            interpolationPolynomial.compute(t);
            boolean isDone = t >= trajectoryTimeProvider.getValue();
            double parameter = isDone ? 1.0 : interpolationPolynomial.getValue();
            double parameterd = isDone ? 0.0 : interpolationPolynomial.getVelocity();
            double parameterdd = isDone ? 0.0 : interpolationPolynomial.getAcceleration();
            OrientationInterpolationCalculator orientationInterpolationCalculator = new OrientationInterpolationCalculator();
            FrameVector3D differenceVector = new FrameVector3D(worldFrame);
            differenceVector.sub((FrameTuple3DReadOnly)finalPosition, (FrameTuple3DReadOnly)initialPosition);
            position1.interpolate((FrameTuple3DReadOnly)initialPosition, (FrameTuple3DReadOnly)finalPosition, parameter);
            velocity1.setAndScale(parameterd, (FrameTuple3DReadOnly)differenceVector);
            acceleration1.setAndScale(parameterdd, (FrameTuple3DReadOnly)differenceVector);
            orientation1.interpolate((FrameQuaternionReadOnly)initialOrientation, (FrameQuaternionReadOnly)finalOrientation, parameter);
            orientationInterpolationCalculator.computeAngularVelocity((FrameVector3DBasics)angularVelocity1, (FrameQuaternionBasics)initialOrientation, (FrameQuaternionBasics)finalOrientation, parameterd);
            orientationInterpolationCalculator.computeAngularAcceleration((FrameVector3DBasics)angularAcceleration1, (FrameQuaternionBasics)initialOrientation, (FrameQuaternionBasics)finalOrientation, parameterdd);
            trajToTest.compute(t);
            trajToTest.getLinearData((FramePoint3DBasics)position2, (FrameVector3DBasics)velocity2, (FrameVector3DBasics)acceleration2);
            trajToTest.getAngularData((FrameOrientation3DBasics)orientation2, (FrameVector3DBasics)angularVelocity2, (FrameVector3DBasics)angularAcceleration2);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)position1, (EuclidFrameGeometry)position2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)position1, (EuclidFrameGeometry)trajToTest.getPosition(), (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)velocity1, (EuclidFrameGeometry)velocity2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)velocity1, (EuclidFrameGeometry)trajToTest.getVelocity(), (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)acceleration1, (EuclidFrameGeometry)acceleration2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)acceleration1, (EuclidFrameGeometry)trajToTest.getAcceleration(), (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)orientation1, (EuclidFrameGeometry)orientation2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)angularVelocity1, (EuclidFrameGeometry)angularVelocity2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)angularAcceleration1, (EuclidFrameGeometry)angularAcceleration2, (double)1.0E-4);
        }
    }

    @Test
    public void testNegativeTime() {
        YoRegistry registry = new YoRegistry("youpiloup");
        StraightLinePoseTrajectoryGenerator trajToTest = new StraightLinePoseTrajectoryGenerator("blop", worldFrame, registry);
        DoubleProvider trajectoryTimeProvider = () -> 10.0;
        FramePoint3D initialPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)100.0, (double)100.0, (double)100.0);
        FramePoint3D finalPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)100.0, (double)100.0, (double)100.0);
        FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        trajToTest.setInitialPose((FramePoint3DReadOnly)initialPosition, (FrameOrientation3DReadOnly)initialOrientation);
        trajToTest.setFinalPose((FramePose3DReadOnly)new FramePose3D((FrameTuple3DReadOnly)finalPosition, (FrameOrientation3DReadOnly)finalOrientation));
        trajToTest.setTrajectoryTime(trajectoryTimeProvider.getValue());
        trajToTest.initialize();
        trajToTest.compute(-5.0);
        FramePoint3D position1 = new FramePoint3D((FrameTuple3DReadOnly)initialPosition);
        FrameVector3D velocity1 = new FrameVector3D(worldFrame);
        FrameVector3D acceleration1 = new FrameVector3D(worldFrame);
        FrameQuaternion orientation1 = new FrameQuaternion((FrameQuaternionReadOnly)initialOrientation);
        FrameVector3D angularVelocity1 = new FrameVector3D(worldFrame);
        FrameVector3D angularAcceleration1 = new FrameVector3D(worldFrame);
        FramePoint3D position2 = new FramePoint3D();
        FrameVector3D velocity2 = new FrameVector3D();
        FrameVector3D acceleration2 = new FrameVector3D();
        FrameQuaternion orientation2 = new FrameQuaternion();
        FrameVector3D angularVelocity2 = new FrameVector3D();
        FrameVector3D angularAcceleration2 = new FrameVector3D();
        trajToTest.getLinearData((FramePoint3DBasics)position2, (FrameVector3DBasics)velocity2, (FrameVector3DBasics)acceleration2);
        trajToTest.getAngularData((FrameOrientation3DBasics)orientation2, (FrameVector3DBasics)angularVelocity2, (FrameVector3DBasics)angularAcceleration2);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)position1, (EuclidFrameGeometry)position2, (double)1.0E-4);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)velocity1, (EuclidFrameGeometry)velocity2, (double)1.0E-4);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)acceleration1, (EuclidFrameGeometry)acceleration2, (double)1.0E-4);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)orientation1, (EuclidFrameGeometry)orientation2, (double)1.0E-4);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)angularVelocity1, (EuclidFrameGeometry)angularVelocity2, (double)1.0E-4);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)angularAcceleration1, (EuclidFrameGeometry)angularAcceleration2, (double)1.0E-4);
    }

    @Test
    public void testTooBigTime() {
        YoRegistry registry = new YoRegistry("youpiloup");
        StraightLinePoseTrajectoryGenerator trajToTest = new StraightLinePoseTrajectoryGenerator("blop", worldFrame, registry);
        DoubleProvider trajectoryTimeProvider = () -> 10.0;
        FramePoint3D initialPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)100.0, (double)100.0, (double)100.0);
        FramePoint3D finalPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)100.0, (double)100.0, (double)100.0);
        FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        trajToTest.setInitialPose((FramePoint3DReadOnly)initialPosition, (FrameOrientation3DReadOnly)initialOrientation);
        trajToTest.setFinalPose((FramePose3DReadOnly)new FramePose3D((FrameTuple3DReadOnly)finalPosition, (FrameOrientation3DReadOnly)finalOrientation));
        trajToTest.setTrajectoryTime(trajectoryTimeProvider.getValue());
        trajToTest.initialize();
        trajToTest.compute(15.0);
        FramePoint3D position1 = new FramePoint3D((FrameTuple3DReadOnly)finalPosition);
        FrameVector3D velocity1 = new FrameVector3D(worldFrame);
        FrameVector3D acceleration1 = new FrameVector3D(worldFrame);
        FrameQuaternion orientation1 = new FrameQuaternion((FrameQuaternionReadOnly)finalOrientation);
        FrameVector3D angularVelocity1 = new FrameVector3D(worldFrame);
        FrameVector3D angularAcceleration1 = new FrameVector3D(worldFrame);
        FramePoint3D position2 = new FramePoint3D();
        FrameVector3D velocity2 = new FrameVector3D();
        FrameVector3D acceleration2 = new FrameVector3D();
        FrameQuaternion orientation2 = new FrameQuaternion();
        FrameVector3D angularVelocity2 = new FrameVector3D();
        FrameVector3D angularAcceleration2 = new FrameVector3D();
        trajToTest.getLinearData((FramePoint3DBasics)position2, (FrameVector3DBasics)velocity2, (FrameVector3DBasics)acceleration2);
        trajToTest.getAngularData((FrameOrientation3DBasics)orientation2, (FrameVector3DBasics)angularVelocity2, (FrameVector3DBasics)angularAcceleration2);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)position1, (EuclidFrameGeometry)position2, (double)1.0E-4);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)velocity1, (EuclidFrameGeometry)velocity2, (double)1.0E-4);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)acceleration1, (EuclidFrameGeometry)acceleration2, (double)1.0E-4);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)orientation1, (EuclidFrameGeometry)orientation2, (double)1.0E-4);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)angularVelocity1, (EuclidFrameGeometry)angularVelocity2, (double)1.0E-4);
        EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)angularAcceleration1, (EuclidFrameGeometry)angularAcceleration2, (double)1.0E-4);
    }

    @Test
    public void testMultipleFramesWithSingleFrameTrajectoryGenerators() {
        FrameVector3D differenceVector;
        OrientationInterpolationCalculator orientationInterpolationCalculator;
        double parameterdd;
        double parameterd;
        double parameter;
        boolean isDone;
        double t;
        YoRegistry registry = new YoRegistry("youpiloup");
        StraightLinePoseTrajectoryGenerator trajToTest = new StraightLinePoseTrajectoryGenerator("blop", worldFrame, registry);
        DoubleProvider trajectoryTimeProvider = () -> 10.0;
        FramePoint3D initialPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)100.0, (double)100.0, (double)100.0);
        FramePoint3D finalPosition = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)worldFrame, (double)100.0, (double)100.0, (double)100.0);
        FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        Polynomial interpolationPolynomial = new Polynomial(6);
        interpolationPolynomial.setQuintic(0.0, trajectoryTimeProvider.getValue(), 0.0, 0.0, 0.0, 1.0, 0.0, 0.0);
        trajToTest.setInitialPose((FramePoint3DReadOnly)initialPosition, (FrameOrientation3DReadOnly)initialOrientation);
        trajToTest.setFinalPose((FramePose3DReadOnly)new FramePose3D((FrameTuple3DReadOnly)finalPosition, (FrameOrientation3DReadOnly)finalOrientation));
        trajToTest.setTrajectoryTime(trajectoryTimeProvider.getValue());
        trajToTest.initialize();
        double dt = 0.001;
        FramePoint3D position1 = new FramePoint3D();
        FrameVector3D velocity1 = new FrameVector3D();
        FrameVector3D acceleration1 = new FrameVector3D();
        FrameQuaternion orientation1 = new FrameQuaternion();
        FrameVector3D angularVelocity1 = new FrameVector3D();
        FrameVector3D angularAcceleration1 = new FrameVector3D();
        FramePoint3D position2 = new FramePoint3D();
        FrameVector3D velocity2 = new FrameVector3D();
        FrameVector3D acceleration2 = new FrameVector3D();
        FrameQuaternion orientation2 = new FrameQuaternion();
        FrameVector3D angularVelocity2 = new FrameVector3D();
        FrameVector3D angularAcceleration2 = new FrameVector3D();
        for (t = 0.0; t <= trajectoryTimeProvider.getValue(); t += dt) {
            interpolationPolynomial.compute(t);
            isDone = t >= trajectoryTimeProvider.getValue();
            parameter = isDone ? 1.0 : interpolationPolynomial.getValue();
            parameterd = isDone ? 0.0 : interpolationPolynomial.getVelocity();
            parameterdd = isDone ? 0.0 : interpolationPolynomial.getAcceleration();
            orientationInterpolationCalculator = new OrientationInterpolationCalculator();
            differenceVector = new FrameVector3D(worldFrame);
            differenceVector.sub((FrameTuple3DReadOnly)finalPosition, (FrameTuple3DReadOnly)initialPosition);
            position1.interpolate((FrameTuple3DReadOnly)initialPosition, (FrameTuple3DReadOnly)finalPosition, parameter);
            velocity1.setAndScale(parameterd, (FrameTuple3DReadOnly)differenceVector);
            acceleration1.setAndScale(parameterdd, (FrameTuple3DReadOnly)differenceVector);
            orientation1.interpolate((FrameQuaternionReadOnly)initialOrientation, (FrameQuaternionReadOnly)finalOrientation, parameter);
            orientationInterpolationCalculator.computeAngularVelocity((FrameVector3DBasics)angularVelocity1, (FrameQuaternionBasics)initialOrientation, (FrameQuaternionBasics)finalOrientation, parameterd);
            orientationInterpolationCalculator.computeAngularAcceleration((FrameVector3DBasics)angularAcceleration1, (FrameQuaternionBasics)initialOrientation, (FrameQuaternionBasics)finalOrientation, parameterdd);
            trajToTest.compute(t);
            trajToTest.getLinearData((FramePoint3DBasics)position2, (FrameVector3DBasics)velocity2, (FrameVector3DBasics)acceleration2);
            trajToTest.getAngularData((FrameOrientation3DBasics)orientation2, (FrameVector3DBasics)angularVelocity2, (FrameVector3DBasics)angularAcceleration2);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)position1, (EuclidFrameGeometry)position2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)velocity1, (EuclidFrameGeometry)velocity2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)acceleration1, (EuclidFrameGeometry)acceleration2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)orientation1, (EuclidFrameGeometry)orientation2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)angularVelocity1, (EuclidFrameGeometry)angularVelocity2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)angularAcceleration1, (EuclidFrameGeometry)angularAcceleration2, (double)1.0E-4);
        }
        initialPosition.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)frameA, (double)100.0, (double)100.0, (double)100.0));
        finalPosition.setIncludingFrame((FrameTuple3DReadOnly)EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)frameA, (double)100.0, (double)100.0, (double)100.0));
        initialOrientation.setIncludingFrame((FrameQuaternionReadOnly)EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)frameA));
        finalOrientation.setIncludingFrame((FrameQuaternionReadOnly)EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)frameA));
        position1.changeFrame(frameA);
        orientation1.changeFrame(frameA);
        velocity1.changeFrame(frameA);
        angularVelocity1.changeFrame(frameA);
        acceleration1.changeFrame(frameA);
        angularAcceleration1.changeFrame(frameA);
        trajToTest.switchTrajectoryFrame(frameA);
        trajToTest.setInitialPose((FramePoint3DReadOnly)initialPosition, (FrameOrientation3DReadOnly)initialOrientation);
        trajToTest.setFinalPose((FramePose3DReadOnly)new FramePose3D((FrameTuple3DReadOnly)finalPosition, (FrameOrientation3DReadOnly)finalOrientation));
        trajToTest.setTrajectoryTime(trajectoryTimeProvider.getValue());
        trajToTest.initialize();
        for (t = 0.0; t <= trajectoryTimeProvider.getValue(); t += dt) {
            interpolationPolynomial.compute(t);
            isDone = t >= trajectoryTimeProvider.getValue();
            parameter = isDone ? 1.0 : interpolationPolynomial.getValue();
            parameterd = isDone ? 0.0 : interpolationPolynomial.getVelocity();
            parameterdd = isDone ? 0.0 : interpolationPolynomial.getAcceleration();
            orientationInterpolationCalculator = new OrientationInterpolationCalculator();
            differenceVector = new FrameVector3D(frameA);
            differenceVector.sub((FrameTuple3DReadOnly)finalPosition, (FrameTuple3DReadOnly)initialPosition);
            position1.interpolate((FrameTuple3DReadOnly)initialPosition, (FrameTuple3DReadOnly)finalPosition, parameter);
            velocity1.setAndScale(parameterd, (FrameTuple3DReadOnly)differenceVector);
            acceleration1.setAndScale(parameterdd, (FrameTuple3DReadOnly)differenceVector);
            orientation1.interpolate((FrameQuaternionReadOnly)initialOrientation, (FrameQuaternionReadOnly)finalOrientation, parameter);
            orientationInterpolationCalculator.computeAngularVelocity((FrameVector3DBasics)angularVelocity1, (FrameQuaternionBasics)initialOrientation, (FrameQuaternionBasics)finalOrientation, parameterd);
            orientationInterpolationCalculator.computeAngularAcceleration((FrameVector3DBasics)angularAcceleration1, (FrameQuaternionBasics)initialOrientation, (FrameQuaternionBasics)finalOrientation, parameterdd);
            trajToTest.compute(t);
            trajToTest.getLinearData((FramePoint3DBasics)position2, (FrameVector3DBasics)velocity2, (FrameVector3DBasics)acceleration2);
            trajToTest.getAngularData((FrameOrientation3DBasics)orientation2, (FrameVector3DBasics)angularVelocity2, (FrameVector3DBasics)angularAcceleration2);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)position1, (EuclidFrameGeometry)position2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)velocity1, (EuclidFrameGeometry)velocity2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)acceleration1, (EuclidFrameGeometry)acceleration2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)orientation1, (EuclidFrameGeometry)orientation2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)angularVelocity1, (EuclidFrameGeometry)angularVelocity2, (double)1.0E-4);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)angularAcceleration1, (EuclidFrameGeometry)angularAcceleration2, (double)1.0E-4);
        }
    }

    @Test
    public void testPackAngularData() {
        ReferenceFrame referenceFrame = StraightLinePoseTrajectoryGeneratorTest.createTestFrame();
        FrameQuaternion orientation = new FrameQuaternion(referenceFrame);
        YoRegistry parentRegistry = new YoRegistry("registry");
        FrameQuaternion orientationToPack = new FrameQuaternion(referenceFrame);
        orientationToPack.setYawPitchRollIncludingFrame(referenceFrame, 4.4, 3.3, 1.4);
        StraightLinePoseTrajectoryGenerator generator = new StraightLinePoseTrajectoryGenerator(this.namePrefix, referenceFrame, parentRegistry);
        orientationToPack.setIncludingFrame(generator.getOrientation());
        generator.setInitialPose((FramePoint3DReadOnly)new FramePoint3D(referenceFrame), (FrameOrientation3DReadOnly)orientation);
        generator.setFinalPose((FramePoint3DReadOnly)new FramePoint3D(referenceFrame), (FrameOrientation3DReadOnly)orientation);
        generator.setTrajectoryTime(trajectoryTime);
        Assertions.assertEquals((Object)referenceFrame, (Object)orientationToPack.getReferenceFrame());
        orientationToPack.setIncludingFrame(generator.getOrientation());
        Assertions.assertEquals((Object)referenceFrame, (Object)orientationToPack.getReferenceFrame());
        FrameVector3D angularVelocityToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        FrameVector3D angularAccelerationToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        Assertions.assertNotEquals((Object)referenceFrame, (Object)angularVelocityToPack.getReferenceFrame());
        Assertions.assertEquals((Object)ReferenceFrame.getWorldFrame(), (Object)angularVelocityToPack.getReferenceFrame());
        Assertions.assertNotEquals((Object)referenceFrame, (Object)angularAccelerationToPack.getReferenceFrame());
        Assertions.assertEquals((Object)ReferenceFrame.getWorldFrame(), (Object)angularAccelerationToPack.getReferenceFrame());
        generator.getAngularData((FrameOrientation3DBasics)orientationToPack, (FrameVector3DBasics)angularVelocityToPack, (FrameVector3DBasics)angularAccelerationToPack);
        Assertions.assertEquals((double)0.0, (double)orientationToPack.getYaw(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)orientationToPack.getPitch(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)orientationToPack.getRoll(), (double)1.0E-4);
        Assertions.assertSame((Object)referenceFrame, (Object)orientationToPack.getReferenceFrame());
        Assertions.assertEquals((double)0.0, (double)angularVelocityToPack.getX(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)angularVelocityToPack.getY(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)angularVelocityToPack.getZ(), (double)1.0E-4);
        Assertions.assertSame((Object)referenceFrame, (Object)angularVelocityToPack.getReferenceFrame());
        Assertions.assertEquals((double)0.0, (double)angularAccelerationToPack.getX(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)angularAccelerationToPack.getY(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)angularAccelerationToPack.getZ(), (double)1.0E-4);
        Assertions.assertSame((Object)referenceFrame, (Object)angularAccelerationToPack.getReferenceFrame());
    }

    @Test
    public void testIsDone() {
        ReferenceFrame referenceFrame = StraightLinePoseTrajectoryGeneratorTest.createTestFrame();
        StraightLinePoseTrajectoryGenerator generator = new StraightLinePoseTrajectoryGenerator(this.namePrefix, referenceFrame, new YoRegistry("test"));
        FrameQuaternion orientation = new FrameQuaternion(referenceFrame);
        generator.setInitialPose((FramePoint3DReadOnly)new FramePoint3D(referenceFrame), (FrameOrientation3DReadOnly)orientation);
        generator.setFinalPose((FramePoint3DReadOnly)new FramePoint3D(referenceFrame), (FrameOrientation3DReadOnly)orientation);
        generator.setTrajectoryTime(trajectoryTime);
        generator.initialize();
        generator.compute(5.0);
        Assertions.assertFalse((boolean)generator.isDone());
        generator.compute(trajectoryTime + 1.0E-4);
        Assertions.assertTrue((boolean)generator.isDone());
    }

    @Test
    public void testGet() {
        ReferenceFrame referenceFrame = StraightLinePoseTrajectoryGeneratorTest.createTestFrame();
        StraightLinePoseTrajectoryGenerator generator = new StraightLinePoseTrajectoryGenerator(this.namePrefix, referenceFrame, new YoRegistry("test"));
        Assertions.assertEquals((Object)referenceFrame, (Object)generator.getOrientation().getReferenceFrame());
    }

    @Test
    public void testPackAngularVelocity() {
        ReferenceFrame referenceFrame = StraightLinePoseTrajectoryGeneratorTest.createTestFrame();
        StraightLinePoseTrajectoryGenerator generator = new StraightLinePoseTrajectoryGenerator(this.namePrefix, referenceFrame, new YoRegistry("test"));
        FrameQuaternion orientation = new FrameQuaternion(referenceFrame);
        generator.setInitialPose((FramePoint3DReadOnly)new FramePoint3D(referenceFrame), (FrameOrientation3DReadOnly)orientation);
        generator.setFinalPose((FramePoint3DReadOnly)new FramePoint3D(referenceFrame), (FrameOrientation3DReadOnly)orientation);
        generator.setTrajectoryTime(trajectoryTime);
        FrameVector3D angularVelocityToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        Assertions.assertNotEquals((Object)referenceFrame, (Object)angularVelocityToPack.getReferenceFrame());
        angularVelocityToPack.setIncludingFrame((FrameTuple3DReadOnly)generator.getAngularVelocity());
        Assertions.assertEquals((double)0.0, (double)angularVelocityToPack.getX(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)angularVelocityToPack.getY(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)angularVelocityToPack.getZ(), (double)1.0E-4);
        Assertions.assertSame((Object)referenceFrame, (Object)angularVelocityToPack.getReferenceFrame());
    }

    @Test
    public void testPackAngularAcceleration() {
        ReferenceFrame referenceFrame = StraightLinePoseTrajectoryGeneratorTest.createTestFrame();
        StraightLinePoseTrajectoryGenerator generator = new StraightLinePoseTrajectoryGenerator(this.namePrefix, referenceFrame, new YoRegistry("test"));
        FrameQuaternion orientation = new FrameQuaternion(referenceFrame);
        generator.setInitialPose((FramePoint3DReadOnly)new FramePoint3D(referenceFrame), (FrameOrientation3DReadOnly)orientation);
        generator.setFinalPose((FramePoint3DReadOnly)new FramePoint3D(referenceFrame), (FrameOrientation3DReadOnly)orientation);
        generator.setTrajectoryTime(trajectoryTime);
        FrameVector3D angularAccelerationToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        Assertions.assertNotEquals((Object)referenceFrame, (Object)angularAccelerationToPack.getReferenceFrame());
        angularAccelerationToPack.setIncludingFrame((FrameTuple3DReadOnly)generator.getAngularAcceleration());
        Assertions.assertEquals((double)0.0, (double)angularAccelerationToPack.getX(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)angularAccelerationToPack.getY(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)angularAccelerationToPack.getZ(), (double)1.0E-4);
        Assertions.assertSame((Object)referenceFrame, (Object)angularAccelerationToPack.getReferenceFrame());
    }

    @Test
    public void testPackVelocity() {
        ReferenceFrame referenceFrame = StraightLinePoseTrajectoryGeneratorTest.createTestFrame();
        StraightLinePoseTrajectoryGenerator generator = new StraightLinePoseTrajectoryGenerator(this.namePrefix, referenceFrame, new YoRegistry("test"));
        double xValue = Math.random();
        double yValue = Math.random();
        double zValue = Math.random();
        FramePoint3D position = new FramePoint3D(referenceFrame, xValue, yValue, zValue);
        FrameQuaternion orientation = new FrameQuaternion(referenceFrame);
        generator.setInitialPose((FramePoint3DReadOnly)position, (FrameOrientation3DReadOnly)orientation);
        generator.setFinalPose((FramePoint3DReadOnly)position, (FrameOrientation3DReadOnly)orientation);
        generator.setTrajectoryTime(trajectoryTime);
        FrameVector3D velocityToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        Assertions.assertNotEquals((Object)referenceFrame, (Object)velocityToPack.getReferenceFrame());
        velocityToPack.setIncludingFrame((FrameTuple3DReadOnly)generator.getVelocity());
        Assertions.assertEquals((double)0.0, (double)velocityToPack.getX(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)velocityToPack.getY(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)velocityToPack.getZ(), (double)1.0E-4);
        Assertions.assertSame((Object)referenceFrame, (Object)velocityToPack.getReferenceFrame());
    }

    @Test
    public void testPackAcceleration() {
        ReferenceFrame referenceFrame = StraightLinePoseTrajectoryGeneratorTest.createTestFrame();
        StraightLinePoseTrajectoryGenerator generator = new StraightLinePoseTrajectoryGenerator(this.namePrefix, referenceFrame, new YoRegistry("test"));
        double xValue = Math.random();
        double yValue = Math.random();
        double zValue = Math.random();
        FramePoint3D position = new FramePoint3D(referenceFrame, xValue, yValue, zValue);
        FrameQuaternion orientation = new FrameQuaternion(referenceFrame);
        generator.setInitialPose((FramePoint3DReadOnly)position, (FrameOrientation3DReadOnly)orientation);
        generator.setFinalPose((FramePoint3DReadOnly)position, (FrameOrientation3DReadOnly)orientation);
        generator.setTrajectoryTime(trajectoryTime);
        FrameVector3D accelerationToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        Assertions.assertNotEquals((Object)referenceFrame, (Object)accelerationToPack.getReferenceFrame());
        accelerationToPack.setIncludingFrame((FrameTuple3DReadOnly)generator.getAcceleration());
        Assertions.assertEquals((double)0.0, (double)accelerationToPack.getX(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)accelerationToPack.getY(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)accelerationToPack.getZ(), (double)1.0E-4);
        Assertions.assertSame((Object)referenceFrame, (Object)accelerationToPack.getReferenceFrame());
    }

    @Test
    public void testPackLinearData() {
        ReferenceFrame referenceFrame = StraightLinePoseTrajectoryGeneratorTest.createTestFrame();
        FramePoint3D positionToPack = new FramePoint3D(referenceFrame);
        positionToPack.setIncludingFrame(referenceFrame, 4.4, 3.3, 1.4);
        StraightLinePoseTrajectoryGenerator generator = new StraightLinePoseTrajectoryGenerator(this.namePrefix, referenceFrame, new YoRegistry("test"));
        double xValue = Math.random();
        double yValue = Math.random();
        double zValue = Math.random();
        FramePoint3D position = new FramePoint3D(referenceFrame, xValue, yValue, zValue);
        FrameQuaternion orientation = new FrameQuaternion(referenceFrame);
        generator.setInitialPose((FramePoint3DReadOnly)position, (FrameOrientation3DReadOnly)orientation);
        generator.setFinalPose((FramePoint3DReadOnly)position, (FrameOrientation3DReadOnly)orientation);
        generator.setTrajectoryTime(trajectoryTime);
        positionToPack.setIncludingFrame((FrameTuple3DReadOnly)generator.getPosition());
        Assertions.assertEquals((Object)referenceFrame, (Object)positionToPack.getReferenceFrame());
        positionToPack.setIncludingFrame((FrameTuple3DReadOnly)generator.getPosition());
        Assertions.assertEquals((Object)referenceFrame, (Object)positionToPack.getReferenceFrame());
        FrameVector3D velocityToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        FrameVector3D accelerationToPack = new FrameVector3D(ReferenceFrame.getWorldFrame(), 10.0, 10.0, 10.0);
        Assertions.assertNotEquals((Object)referenceFrame, (Object)velocityToPack.getReferenceFrame());
        Assertions.assertEquals((Object)ReferenceFrame.getWorldFrame(), (Object)velocityToPack.getReferenceFrame());
        Assertions.assertNotEquals((Object)referenceFrame, (Object)accelerationToPack.getReferenceFrame());
        Assertions.assertEquals((Object)ReferenceFrame.getWorldFrame(), (Object)accelerationToPack.getReferenceFrame());
        generator.getLinearData((FramePoint3DBasics)positionToPack, (FrameVector3DBasics)velocityToPack, (FrameVector3DBasics)accelerationToPack);
        Assertions.assertEquals((double)0.0, (double)positionToPack.getX(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)positionToPack.getY(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)positionToPack.getZ(), (double)1.0E-4);
        Assertions.assertSame((Object)referenceFrame, (Object)positionToPack.getReferenceFrame());
        Assertions.assertEquals((double)0.0, (double)velocityToPack.getX(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)velocityToPack.getY(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)velocityToPack.getZ(), (double)1.0E-4);
        Assertions.assertSame((Object)referenceFrame, (Object)velocityToPack.getReferenceFrame());
        Assertions.assertEquals((double)0.0, (double)accelerationToPack.getX(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)accelerationToPack.getY(), (double)1.0E-4);
        Assertions.assertEquals((double)0.0, (double)accelerationToPack.getZ(), (double)1.0E-4);
        Assertions.assertSame((Object)referenceFrame, (Object)accelerationToPack.getReferenceFrame());
    }

    private static ReferenceFrame createTestFrame() {
        return new PoseReferenceFrame("TestFrame", worldFrame);
    }
}

