/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.robotics.math.trajectories.SimpleOrientationTrajectoryGenerator;
import us.ihmc.robotics.math.trajectories.StraightLinePoseTrajectoryGenerator;
import us.ihmc.yoVariables.providers.DoubleProvider;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SimpleOrientationTrajectoryGeneratorTest {
    private static final Random random = new Random(1516351L);
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final ReferenceFrame frameA = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"frameA", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
    private static final double EPSILON = 1.0E-10;

    @Test
    public void testCompareWithSingleFrameTrajectoryGenerator() {
        YoRegistry registry = new YoRegistry("youpiloup");
        SimpleOrientationTrajectoryGenerator trajToTest = new SimpleOrientationTrajectoryGenerator("blop", worldFrame, registry);
        double trajectoryTime = 10.0;
        FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        StraightLinePoseTrajectoryGenerator trajectoryGenerator = new StraightLinePoseTrajectoryGenerator("orientation", worldFrame, registry);
        trajectoryGenerator.setInitialPose((FramePoint3DReadOnly)new FramePoint3D(worldFrame), (FrameOrientation3DReadOnly)initialOrientation);
        trajectoryGenerator.setFinalPose((FramePoint3DReadOnly)new FramePoint3D(worldFrame), (FrameOrientation3DReadOnly)finalOrientation);
        trajectoryGenerator.setTrajectoryTime(trajectoryTime);
        trajToTest.setInitialOrientation((FrameQuaternionReadOnly)initialOrientation);
        trajToTest.setFinalOrientation((FrameQuaternionReadOnly)finalOrientation);
        trajToTest.setTrajectoryTime(trajectoryTime);
        trajectoryGenerator.initialize();
        trajToTest.initialize();
        double dt = 0.001;
        FrameQuaternion orientation1 = new FrameQuaternion();
        FrameVector3D angularVelocity1 = new FrameVector3D();
        FrameVector3D angularAcceleration1 = new FrameVector3D();
        FrameQuaternion orientation2 = new FrameQuaternion();
        FrameVector3D angularVelocity2 = new FrameVector3D();
        FrameVector3D angularAcceleration2 = new FrameVector3D();
        for (double t = 0.0; t <= trajectoryTime; t += dt) {
            trajectoryGenerator.compute(t);
            trajToTest.compute(t);
            trajectoryGenerator.getAngularData((FrameOrientation3DBasics)orientation1, (FrameVector3DBasics)angularVelocity1, (FrameVector3DBasics)angularAcceleration1);
            trajToTest.getAngularData((FrameOrientation3DBasics)orientation2, (FrameVector3DBasics)angularVelocity2, (FrameVector3DBasics)angularAcceleration2);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)orientation1, (EuclidGeometry)orientation2, (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)angularVelocity1, (EuclidGeometry)angularVelocity2, (double)1.0E-10);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)angularAcceleration1, (EuclidGeometry)angularAcceleration2, (double)1.0E-10);
        }
    }

    @Test
    public void testNegativeTime() {
        YoRegistry registry = new YoRegistry("youpiloup");
        SimpleOrientationTrajectoryGenerator trajToTest = new SimpleOrientationTrajectoryGenerator("blop", worldFrame, registry);
        DoubleProvider trajectoryTimeProvider = () -> 10.0;
        FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        trajToTest.setInitialOrientation((FrameQuaternionReadOnly)initialOrientation);
        trajToTest.setFinalOrientation((FrameQuaternionReadOnly)finalOrientation);
        trajToTest.setTrajectoryTime(trajectoryTimeProvider.getValue());
        trajToTest.initialize();
        trajToTest.compute(-5.0);
        FrameQuaternion orientation1 = new FrameQuaternion((FrameQuaternionReadOnly)initialOrientation);
        FrameVector3D angularVelocity1 = new FrameVector3D(worldFrame);
        FrameVector3D angularAcceleration1 = new FrameVector3D(worldFrame);
        FrameQuaternion orientation2 = new FrameQuaternion();
        FrameVector3D angularVelocity2 = new FrameVector3D();
        FrameVector3D angularAcceleration2 = new FrameVector3D();
        trajToTest.getAngularData((FrameOrientation3DBasics)orientation2, (FrameVector3DBasics)angularVelocity2, (FrameVector3DBasics)angularAcceleration2);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)orientation1, (EuclidFrameGeometry)orientation2, (double)1.0E-10);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)angularVelocity1, (EuclidFrameGeometry)angularVelocity2, (double)1.0E-10);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)angularAcceleration1, (EuclidFrameGeometry)angularAcceleration2, (double)1.0E-10);
    }

    @Test
    public void testTooBigTime() {
        YoRegistry registry = new YoRegistry("youpiloup");
        SimpleOrientationTrajectoryGenerator trajToTest = new SimpleOrientationTrajectoryGenerator("blop", worldFrame, registry);
        DoubleProvider trajectoryTimeProvider = () -> 10.0;
        FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        trajToTest.setInitialOrientation((FrameQuaternionReadOnly)initialOrientation);
        trajToTest.setFinalOrientation((FrameQuaternionReadOnly)finalOrientation);
        trajToTest.setTrajectoryTime(trajectoryTimeProvider.getValue());
        trajToTest.initialize();
        trajToTest.compute(15.0);
        FrameQuaternion orientation1 = new FrameQuaternion((FrameQuaternionReadOnly)finalOrientation);
        FrameVector3D angularVelocity1 = new FrameVector3D(worldFrame);
        FrameVector3D angularAcceleration1 = new FrameVector3D(worldFrame);
        FrameQuaternion orientation2 = new FrameQuaternion();
        FrameVector3D angularVelocity2 = new FrameVector3D();
        FrameVector3D angularAcceleration2 = new FrameVector3D();
        trajToTest.getAngularData((FrameOrientation3DBasics)orientation2, (FrameVector3DBasics)angularVelocity2, (FrameVector3DBasics)angularAcceleration2);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)orientation1, (EuclidFrameGeometry)orientation2, (double)1.0E-10);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)angularVelocity1, (EuclidFrameGeometry)angularVelocity2, (double)1.0E-10);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)angularAcceleration1, (EuclidFrameGeometry)angularAcceleration2, (double)1.0E-10);
    }

    @Test
    public void testMultipleFramesWithSingleFrameTrajectoryGenerators() {
        double t;
        YoRegistry registry = new YoRegistry("youpiloup");
        SimpleOrientationTrajectoryGenerator trajToTest = new SimpleOrientationTrajectoryGenerator("blop", true, worldFrame, registry);
        double trajectoryTime = 10.0;
        DoubleProvider trajectoryTimeProvider = () -> trajectoryTime;
        FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        StraightLinePoseTrajectoryGenerator trajectoryGenerator = new StraightLinePoseTrajectoryGenerator("orientation", worldFrame, registry);
        trajectoryGenerator.setInitialPose((FramePoint3DReadOnly)new FramePoint3D(worldFrame), (FrameOrientation3DReadOnly)initialOrientation);
        trajectoryGenerator.setFinalPose((FramePoint3DReadOnly)new FramePoint3D(worldFrame), (FrameOrientation3DReadOnly)finalOrientation);
        trajectoryGenerator.setTrajectoryTime(trajectoryTime);
        trajToTest.setInitialOrientation((FrameQuaternionReadOnly)initialOrientation);
        trajToTest.setFinalOrientation((FrameQuaternionReadOnly)finalOrientation);
        trajToTest.setTrajectoryTime(trajectoryTime);
        trajectoryGenerator.initialize();
        trajToTest.initialize();
        double dt = 0.001;
        FrameQuaternion orientation1 = new FrameQuaternion();
        FrameVector3D angularVelocity1 = new FrameVector3D();
        FrameVector3D angularAcceleration1 = new FrameVector3D();
        FrameQuaternion orientation2 = new FrameQuaternion();
        FrameVector3D angularVelocity2 = new FrameVector3D();
        FrameVector3D angularAcceleration2 = new FrameVector3D();
        for (t = 0.0; t <= trajectoryTime; t += dt) {
            trajectoryGenerator.compute(t);
            trajToTest.compute(t);
            trajectoryGenerator.getAngularData((FrameOrientation3DBasics)orientation1, (FrameVector3DBasics)angularVelocity1, (FrameVector3DBasics)angularAcceleration1);
            trajToTest.getAngularData((FrameOrientation3DBasics)orientation2, (FrameVector3DBasics)angularVelocity2, (FrameVector3DBasics)angularAcceleration2);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)orientation1, (EuclidFrameGeometry)orientation2, (double)1.0E-10);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)angularVelocity1, (EuclidFrameGeometry)angularVelocity2, (double)1.0E-10);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)angularAcceleration1, (EuclidFrameGeometry)angularAcceleration2, (double)1.0E-10);
        }
        initialOrientation.setIncludingFrame((FrameQuaternionReadOnly)EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)frameA));
        finalOrientation.setIncludingFrame((FrameQuaternionReadOnly)EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)frameA));
        trajectoryGenerator = new StraightLinePoseTrajectoryGenerator("orientation2", frameA, registry);
        trajectoryGenerator.setInitialPose((FramePoint3DReadOnly)new FramePoint3D(frameA), (FrameOrientation3DReadOnly)initialOrientation);
        trajectoryGenerator.setFinalPose((FramePoint3DReadOnly)new FramePoint3D(frameA), (FrameOrientation3DReadOnly)finalOrientation);
        trajectoryGenerator.setTrajectoryTime(trajectoryTime);
        trajToTest.setReferenceFrame(frameA);
        trajToTest.setInitialOrientation((FrameQuaternionReadOnly)initialOrientation);
        trajToTest.setFinalOrientation((FrameQuaternionReadOnly)finalOrientation);
        trajToTest.setTrajectoryTime(trajectoryTimeProvider.getValue());
        trajectoryGenerator.initialize();
        trajToTest.initialize();
        for (t = 0.0; t <= trajectoryTime; t += dt) {
            trajectoryGenerator.compute(t);
            trajToTest.compute(t);
            trajectoryGenerator.getAngularData((FrameOrientation3DBasics)orientation1, (FrameVector3DBasics)angularVelocity1, (FrameVector3DBasics)angularAcceleration1);
            trajToTest.getAngularData((FrameOrientation3DBasics)orientation2, (FrameVector3DBasics)angularVelocity2, (FrameVector3DBasics)angularAcceleration2);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)orientation1, (EuclidFrameGeometry)orientation2, (double)1.0E-10);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)angularVelocity1, (EuclidFrameGeometry)angularVelocity2, (double)1.0E-10);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)angularAcceleration1, (EuclidFrameGeometry)angularAcceleration2, (double)1.0E-10);
        }
    }
}

