/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.math.trajectories.core.Polynomial;
import us.ihmc.robotics.math.trajectories.core.PolynomialFactory;
import us.ihmc.robotics.math.trajectories.core.PolynomialTools;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialBasics;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialReadOnly;

public class PolynomialFactoryTest {
    private Polynomial constant5Polynomial;
    private Polynomial twoXPlus3Polynomial;
    private Polynomial fourX4ThreeX3TwoX2OneX1Polynomial;

    @BeforeEach
    public void setUp() {
        this.constant5Polynomial = new Polynomial(new double[]{5.0}, false);
        this.twoXPlus3Polynomial = new Polynomial(new double[]{2.0, 3.0}, false);
        this.fourX4ThreeX3TwoX2OneX1Polynomial = new Polynomial(new double[]{4.0, 3.0, 2.0, 1.0, 0.0}, false);
    }

    @AfterEach
    public void tearDown() {
        this.constant5Polynomial = null;
        this.twoXPlus3Polynomial = null;
        this.fourX4ThreeX3TwoX2OneX1Polynomial = null;
    }

    @Test
    public void testTimes() {
        PolynomialBasics tenXPlus15Polynomial = PolynomialFactory.times((PolynomialReadOnly)this.constant5Polynomial, (PolynomialReadOnly)this.twoXPlus3Polynomial);
        this.verifyEpsilonEquals(new double[]{15.0, 10.0}, tenXPlus15Polynomial.getCoefficients(), 1.0E-7);
        PolynomialBasics multipliedPolynomial = PolynomialFactory.times((PolynomialReadOnly)this.twoXPlus3Polynomial, (PolynomialReadOnly)this.fourX4ThreeX3TwoX2OneX1Polynomial);
        this.verifyEpsilonEquals(new double[]{0.0, 3.0, 8.0, 13.0, 18.0, 8.0}, multipliedPolynomial.getCoefficients(), 1.0E-7);
    }

    @Test
    public void testTimesScalar() {
        PolynomialBasics eighteenXPlus27Polynomial = PolynomialFactory.copyAndScale((double)9.0, (PolynomialReadOnly)this.twoXPlus3Polynomial);
        this.verifyEpsilonEquals(new double[]{27.0, 18.0}, eighteenXPlus27Polynomial.getCoefficients(), 1.0E-7);
    }

    @Test
    public void testConstructFromScaleFactorAndRoots() {
        double scaleFactor = 3.3;
        double[] realRoots = new double[]{1.1, 2.7, 3.91};
        ComplexNumber[] complexRootPairs = new ComplexNumber[]{new ComplexNumber(10.2, 7.7), new ComplexNumber(7.9, 3.3)};
        PolynomialBasics polynomial = PolynomialFactory.constructFromScaleFactorAndRoots((double)scaleFactor, (double[])realRoots, (ComplexNumber[])complexRootPairs);
        double[] objectArray = realRoots;
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Double realRoot = objectArray[i];
            polynomial.compute(realRoot.doubleValue());
            Assert.assertEquals(0.0, polynomial.getValue(), 1.0E-7);
        }
        for (ComplexNumber complexRoot : complexRootPairs) {
            this.verifyEpsilonEquals(new ComplexNumber(0.0, 0.0), PolynomialTools.evaluate((PolynomialBasics)polynomial, (ComplexNumber)complexRoot), 1.0E-6);
        }
    }

    private void verifyEpsilonEquals(double[] expectedArray, double[] actualArray, double epsilon) {
        Assert.assertEquals(expectedArray.length, actualArray.length);
        for (int i = 0; i < expectedArray.length; ++i) {
            Assert.assertEquals(expectedArray[i], actualArray[i], epsilon);
        }
    }

    private void verifyEpsilonEquals(ComplexNumber expectedComplexNumber, ComplexNumber actualComplexNumber, double epsilon) {
        Assert.assertEquals(expectedComplexNumber.real(), actualComplexNumber.real(), epsilon);
        Assert.assertEquals(expectedComplexNumber.imag(), actualComplexNumber.imag(), epsilon);
    }
}

