/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.Assertions;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.tools.EuclidCoreTools;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.trajectories.YoMinimumJerkTrajectory;
import us.ihmc.robotics.math.trajectories.interfaces.PolynomialBasics;
import us.ihmc.yoVariables.registry.YoRegistry;

public abstract class PolynomialBasicsTest {
    private static final int ITERATIONS = 1000;
    private static final double SMALL_EPSILON = 1.0E-12;

    public abstract PolynomialBasics getPolynomial(int var1);

    @Test
    public void testLinearSet() {
        PolynomialBasics traj = this.getPolynomial(2);
        Assert.assertEquals(2L, traj.getMaximumNumberOfCoefficients());
        Assert.assertEquals(0L, traj.getNumberOfCoefficients());
        traj.setLinear(1.0, 2.0, 3.0, 5.0);
        Assert.assertEquals(1.0, traj.getInitialTime(), 1.0E-12);
        Assert.assertEquals(2.0, traj.getFinalTime(), 1.0E-12);
        traj.compute(traj.getInitialTime());
        Assert.assertEquals(3.0, traj.getValue(), 1.0E-12);
        traj.compute(traj.getFinalTime());
        Assert.assertEquals(5.0, traj.getValue(), 1.0E-12);
        Assert.assertEquals(2.0, traj.getCoefficient(1), 1.0E-12);
        Assert.assertEquals(1.0, traj.getCoefficient(0), 1.0E-12);
    }

    @Test
    public void testExceptionThrownAfterShift() {
        PolynomialBasics trajectory = this.getPolynomial(5);
        trajectory.setCubic(0.0, 5.0, 0.5, 1.0, 0.6, 0.84);
        boolean caughtException = false;
        try {
            trajectory.initialize();
        }
        catch (RuntimeException e) {
            caughtException = true;
        }
        Assert.assertFalse(caughtException);
        trajectory.shiftTrajectory(0.5);
        try {
            trajectory.initialize();
        }
        catch (RuntimeException e) {
            caughtException = true;
        }
        Assert.assertTrue(caughtException);
    }

    @Test
    public void testSetConstant() throws Exception {
        Random random = new Random(3453L);
        for (int i = 0; i < 1000; ++i) {
            int maxNumberOfCoefficients = RandomNumbers.nextInt((Random)random, (int)1, (int)10);
            PolynomialBasics trajectory = this.getPolynomial(maxNumberOfCoefficients);
            double t0 = random.nextDouble();
            double tf = t0 + random.nextDouble();
            double z = RandomNumbers.nextDouble((Random)random, (double)1.0);
            Assert.assertEquals(maxNumberOfCoefficients, trajectory.getMaximumNumberOfCoefficients());
            if (maxNumberOfCoefficients < 1) {
                Assertions.assertExceptionThrown(RuntimeException.class, () -> trajectory.setConstant(t0, tf, z));
                continue;
            }
            trajectory.setConstant(t0, tf, z);
            for (double t = t0; t <= tf; t += (tf - t0) / 1000.0) {
                trajectory.compute(t);
                Assert.assertEquals(z, trajectory.getValue(), 1.0E-12);
                Assert.assertEquals(0.0, trajectory.getVelocity(), 1.0E-12);
                Assert.assertEquals(0.0, trajectory.getAcceleration(), 1.0E-12);
            }
        }
    }

    @Test
    public void testSetLinear() throws Exception {
        Random random = new Random(3453L);
        for (int i = 0; i < 1000; ++i) {
            double t;
            int maxNumberOfCoefficients = RandomNumbers.nextInt((Random)random, (int)1, (int)10);
            PolynomialBasics trajectory = this.getPolynomial(maxNumberOfCoefficients);
            double t0 = random.nextDouble();
            double tf = t0 + random.nextDouble();
            double z0 = RandomNumbers.nextDouble((Random)random, (double)1.0);
            double zf = RandomNumbers.nextDouble((Random)random, (double)1.0);
            Assert.assertEquals(maxNumberOfCoefficients, trajectory.getMaximumNumberOfCoefficients());
            if (maxNumberOfCoefficients < 2) {
                Assertions.assertExceptionThrown(RuntimeException.class, () -> trajectory.setLinear(t0, tf, z0, zf));
                continue;
            }
            trajectory.setLinear(t0, tf, z0, zf);
            double zDot = (zf - z0) / (tf - t0);
            PolynomialBasics derivative = this.getPolynomial(1);
            derivative.setConstant(t0, tf, zDot);
            trajectory.compute(t0);
            Assert.assertEquals(z0, trajectory.getValue(), 1.0E-12);
            Assert.assertEquals(zDot, trajectory.getVelocity(), 1.0E-12);
            Assert.assertEquals(0.0, trajectory.getAcceleration(), 1.0E-12);
            trajectory.compute(tf);
            Assert.assertEquals(zf, trajectory.getValue(), 1.0E-12);
            Assert.assertEquals(zDot, trajectory.getVelocity(), 1.0E-12);
            Assert.assertEquals(0.0, trajectory.getAcceleration(), 1.0E-12);
            for (t = t0; t <= tf; t += (tf - t0) / 1000.0) {
                trajectory.compute(t);
                Assert.assertEquals(EuclidCoreTools.interpolate((double)z0, (double)zf, (double)((t - t0) / (tf - t0))), trajectory.getValue(), 1.0E-12);
                Assert.assertEquals(zDot, trajectory.getVelocity(), 1.0E-12);
                Assert.assertEquals(0.0, trajectory.getAcceleration(), 1.0E-12);
                derivative.compute(t);
                Assert.assertEquals(derivative.getValue(), trajectory.getVelocity(), 1.0E-12);
                Assert.assertEquals(derivative.getVelocity(), trajectory.getAcceleration(), 1.0E-12);
            }
            trajectory.setLinear(t0, z0, zDot);
            derivative = this.getPolynomial(1);
            derivative.setConstant(t0, tf, zDot);
            trajectory.compute(t0);
            Assert.assertEquals(z0, trajectory.getValue(), 1.0E-12);
            Assert.assertEquals(zDot, trajectory.getVelocity(), 1.0E-12);
            Assert.assertEquals(0.0, trajectory.getAcceleration(), 1.0E-12);
            trajectory.compute(tf);
            Assert.assertEquals(zf, trajectory.getValue(), 1.0E-12);
            Assert.assertEquals(zDot, trajectory.getVelocity(), 1.0E-12);
            Assert.assertEquals(0.0, trajectory.getAcceleration(), 1.0E-12);
            for (t = t0; t <= tf; t += (tf - t0) / 1000.0) {
                trajectory.compute(t);
                Assert.assertEquals(EuclidCoreTools.interpolate((double)z0, (double)zf, (double)((t - t0) / (tf - t0))), trajectory.getValue(), 1.0E-12);
                Assert.assertEquals(zDot, trajectory.getVelocity(), 1.0E-12);
                Assert.assertEquals(0.0, trajectory.getAcceleration(), 1.0E-12);
                derivative.compute(t);
                Assert.assertEquals(derivative.getValue(), trajectory.getVelocity(), 1.0E-12);
                Assert.assertEquals(derivative.getVelocity(), trajectory.getAcceleration(), 1.0E-12);
            }
        }
    }

    @Test
    public void testSetQuadratic() throws Exception {
        Random random = new Random(3453L);
        for (int i = 0; i < 1000; ++i) {
            int maxNumberOfCoefficients = RandomNumbers.nextInt((Random)random, (int)1, (int)10);
            PolynomialBasics trajectory = this.getPolynomial(maxNumberOfCoefficients);
            double t0 = random.nextDouble();
            double tf = t0 + 0.5;
            double z0 = RandomNumbers.nextDouble((Random)random, (double)1.0);
            double zd0 = RandomNumbers.nextDouble((Random)random, (double)1.0);
            double zf = RandomNumbers.nextDouble((Random)random, (double)1.0);
            if (maxNumberOfCoefficients < 3) {
                Assertions.assertExceptionThrown(RuntimeException.class, () -> trajectory.setQuadratic(t0, tf, z0, zd0, zf));
                continue;
            }
            Assert.assertEquals(maxNumberOfCoefficients, trajectory.getMaximumNumberOfCoefficients());
            trajectory.setQuadratic(t0, tf, z0, zd0, zf);
            trajectory.compute(t0);
            Assert.assertEquals(z0, trajectory.getValue(), 1.0E-12);
            Assert.assertEquals(zd0, trajectory.getVelocity(), 1.0E-12);
            trajectory.compute(tf);
            Assert.assertEquals(zf, trajectory.getValue(), 1.0E-12);
            PolynomialBasics derivative = this.getPolynomial(2);
            derivative.setLinear(t0, tf, zd0, trajectory.getVelocity());
            double dt = 1.0E-8;
            for (double t = t0; t <= tf; t += (tf - t0) / 1000.0) {
                trajectory.compute(t);
                derivative.compute(t);
                Assert.assertEquals(derivative.getValue(), trajectory.getVelocity(), 1.0E-12);
                Assert.assertEquals(derivative.getVelocity(), trajectory.getAcceleration(), 1.0E-12);
                trajectory.compute(t + dt);
                double nextPosition = trajectory.getValue();
                trajectory.compute(t - dt);
                double lastPosition = trajectory.getValue();
                Assert.assertEquals(0.5 * (nextPosition - lastPosition) / dt, trajectory.getVelocity(), 1.0E-6);
            }
        }
    }

    @Test
    public void testSetCubic() throws Exception {
        Random random = new Random(3453L);
        for (int i = 0; i < 1000; ++i) {
            int maxNumberOfCoefficients = RandomNumbers.nextInt((Random)random, (int)1, (int)10);
            PolynomialBasics trajectory = this.getPolynomial(maxNumberOfCoefficients);
            double t0 = random.nextDouble();
            double tf = t0 + 0.5;
            double z0 = RandomNumbers.nextDouble((Random)random, (double)1.0);
            double zd0 = RandomNumbers.nextDouble((Random)random, (double)1.0);
            double zf = RandomNumbers.nextDouble((Random)random, (double)1.0);
            double zdf = RandomNumbers.nextDouble((Random)random, (double)1.0);
            if (maxNumberOfCoefficients < 4) {
                Assertions.assertExceptionThrown(RuntimeException.class, () -> trajectory.setCubic(t0, tf, z0, zd0, zf, zdf));
                continue;
            }
            Assert.assertEquals(maxNumberOfCoefficients, trajectory.getMaximumNumberOfCoefficients());
            trajectory.setCubic(t0, tf, z0, zd0, zf, zdf);
            trajectory.compute(t0);
            Assert.assertEquals(z0, trajectory.getValue(), 1.0E-12);
            Assert.assertEquals(zd0, trajectory.getVelocity(), 1.0E-12);
            PolynomialBasics derivative = this.getPolynomial(3);
            derivative.setQuadratic(t0, tf, zd0, trajectory.getAcceleration(), zdf);
            trajectory.compute(tf);
            Assert.assertEquals(zf, trajectory.getValue(), 1.0E-12);
            double dt = 1.0E-8;
            for (double t = t0; t <= tf; t += (tf - t0) / 1000.0) {
                trajectory.compute(t);
                derivative.compute(t);
                Assert.assertEquals(derivative.getValue(), trajectory.getVelocity(), 1.0E-12);
                Assert.assertEquals(derivative.getVelocity(), trajectory.getAcceleration(), 1.0E-12);
                trajectory.compute(t + dt);
                double nextPosition = trajectory.getValue();
                trajectory.compute(t - dt);
                double lastPosition = trajectory.getValue();
                Assert.assertEquals(0.5 * (nextPosition - lastPosition) / dt, trajectory.getVelocity(), 5.0E-6);
            }
        }
    }

    @Test
    public void testSetCubicDirectly() throws Exception {
        Random random = new Random(3453L);
        for (int i = 0; i < 1000; ++i) {
            int maxNumberOfCoefficients = RandomNumbers.nextInt((Random)random, (int)1, (int)10);
            PolynomialBasics trajectory = this.getPolynomial(maxNumberOfCoefficients);
            double duration = random.nextDouble();
            double z0 = RandomNumbers.nextDouble((Random)random, (double)1.0);
            double zd0 = RandomNumbers.nextDouble((Random)random, (double)1.0);
            double zf = RandomNumbers.nextDouble((Random)random, (double)1.0);
            double zdf = RandomNumbers.nextDouble((Random)random, (double)1.0);
            if (maxNumberOfCoefficients < 4) {
                Assertions.assertExceptionThrown(RuntimeException.class, () -> trajectory.setCubic(0.0, duration, z0, zd0, zf, zdf));
                continue;
            }
            Assert.assertEquals(maxNumberOfCoefficients, trajectory.getMaximumNumberOfCoefficients());
            trajectory.setCubicDirectly(duration, z0, zd0, zf, zdf);
            trajectory.compute(0.0);
            Assert.assertEquals(z0, trajectory.getValue(), 1.0E-12);
            Assert.assertEquals(zd0, trajectory.getVelocity(), 1.0E-12);
            PolynomialBasics derivative = this.getPolynomial(3);
            PolynomialBasics alternative = this.getPolynomial(4);
            alternative.setCubic(0.0, duration, z0, zd0, zf, zdf);
            derivative.setQuadratic(0.0, duration, zd0, trajectory.getAcceleration(), zdf);
            trajectory.compute(duration);
            for (int j = 0; j < 4; ++j) {
                Assert.assertEquals("INDEX " + j, alternative.getCoefficient(j), trajectory.getCoefficient(j), 1.0E-5);
            }
            Assert.assertEquals(zf, trajectory.getValue(), 1.0E-12);
            double dt = 1.0E-8;
            for (double t = 0.0; t <= duration; t += duration / 1000.0) {
                trajectory.compute(t);
                alternative.compute(t);
                derivative.compute(t);
                Assert.assertEquals(alternative.getValue(), trajectory.getValue(), 1.0E-12);
                Assert.assertEquals(alternative.getVelocity(), trajectory.getVelocity(), 1.0E-12);
                Assert.assertEquals(alternative.getAcceleration(), trajectory.getAcceleration(), 1.0E-8);
                Assert.assertEquals(derivative.getValue(), trajectory.getVelocity(), 1.0E-12);
                Assert.assertEquals(derivative.getVelocity(), trajectory.getAcceleration(), 1.0E-6);
            }
        }
    }

    @Test
    public void testMinimumJerkRandomInitialFinalConditions() {
        PolynomialBasics trajectory = this.getPolynomial(6);
        YoMinimumJerkTrajectory minimumJerkTrajectory = new YoMinimumJerkTrajectory("Test", new YoRegistry("Test"));
        int numberOfTests = 100000;
        double epsilon = 0.001;
        Random random = new Random(1738L);
        for (int i = 0; i < numberOfTests; ++i) {
            double x0 = RandomNumbers.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double v0 = RandomNumbers.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double a0 = RandomNumbers.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double xf = RandomNumbers.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double vf = RandomNumbers.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double af = RandomNumbers.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double t0 = RandomNumbers.nextDouble((Random)random, (double)-10.0, (double)10.0);
            double tf = t0 + RandomNumbers.nextDouble((Random)random, (double)0.1, (double)10.0);
            trajectory.setQuintic(t0, tf, x0, v0, a0, xf, vf, af);
            trajectory.compute(RandomNumbers.nextDouble((Random)random, (double)-10.0, (double)10.0));
            trajectory.compute(t0);
            Assert.assertEquals(x0, trajectory.getValue(), epsilon);
            Assert.assertEquals(v0, trajectory.getVelocity(), epsilon);
            Assert.assertEquals(a0, trajectory.getAcceleration(), epsilon);
            trajectory.compute(tf);
            Assert.assertEquals(xf, trajectory.getValue(), epsilon);
            Assert.assertEquals(vf, trajectory.getVelocity(), epsilon);
            Assert.assertEquals(af, trajectory.getAcceleration(), epsilon);
            minimumJerkTrajectory.setParams(x0, v0, a0, xf, vf, af, t0, tf);
            for (double time = t0; time <= tf; time += 0.005) {
                trajectory.compute(time);
                minimumJerkTrajectory.computeTrajectory(time);
                Assert.assertEquals(minimumJerkTrajectory.getPosition(), trajectory.getValue(), 0.005);
                Assert.assertEquals(minimumJerkTrajectory.getVelocity(), trajectory.getVelocity(), 0.05);
                Assert.assertEquals(minimumJerkTrajectory.getAcceleration(), trajectory.getAcceleration(), 0.5);
            }
        }
    }

    @Test
    public void testZeroLength() {
        PolynomialBasics minimumJerkTrajectory = this.getPolynomial(6);
        double t = 5.0E-8;
        minimumJerkTrajectory.setQuintic(0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        minimumJerkTrajectory.compute(t);
        if (Double.isNaN(minimumJerkTrajectory.getValue()) || Double.isNaN(minimumJerkTrajectory.getVelocity()) || Double.isNaN(minimumJerkTrajectory.getAcceleration())) {
            throw new RuntimeException("TestMinimumJerkTrajectory.testZeroLength: failed on zero displacement");
        }
    }
}

