/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameOrientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameTuple3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DBasics;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionBasics;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.Tuple4DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.geometry.RotationTools;
import us.ihmc.robotics.math.QuaternionCalculus;
import us.ihmc.robotics.math.trajectories.HermiteCurveBasedOrientationTrajectoryGenerator;
import us.ihmc.yoVariables.registry.YoRegistry;

public class HermiteCurveBasedOrientationTrajectoryGeneratorTest {
    private static final boolean DEBUG = false;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testDerivativesConsistency() throws Exception {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        Random random = new Random(5165165161L);
        double dt = 1.0E-5;
        double trajectoryTime = 3.0;
        double startIntegrationTime = 1.0;
        double endIntegrationTime = 2.0;
        FrameQuaternion currentOrientation = new FrameQuaternion();
        FrameVector3D currentAngularVelocity = new FrameVector3D();
        FrameVector3D currentAngularAcceleration = new FrameVector3D();
        FrameQuaternion orientationFromIntegration = new FrameQuaternion();
        Vector3D angularVelocityVector = new Vector3D();
        Quaternion quaternionFromIntegration = new Quaternion();
        Quaternion integratedAngularVelocity = new Quaternion();
        FrameVector3D angularVelocityFromIntegration = new FrameVector3D();
        Vector3D integratedAngularAcceleration = new Vector3D();
        HermiteCurveBasedOrientationTrajectoryGenerator traj = new HermiteCurveBasedOrientationTrajectoryGenerator("traj", worldFrame, new YoRegistry("null"));
        traj.setTrajectoryTime(trajectoryTime);
        for (int i = 0; i < 5; ++i) {
            FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
            FrameVector3D initialAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0);
            FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
            FrameVector3D finalAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0);
            traj.setInitialConditions((FrameOrientation3DReadOnly)initialOrientation, (FrameVector3DReadOnly)initialAngularVelocity);
            traj.setFinalConditions((FrameOrientation3DReadOnly)finalOrientation, (FrameVector3DReadOnly)finalAngularVelocity);
            traj.initialize();
            traj.compute(startIntegrationTime - dt);
            orientationFromIntegration.setIncludingFrame(traj.getOrientation());
            angularVelocityFromIntegration.setIncludingFrame((FrameTuple3DReadOnly)traj.getAngularVelocity());
            for (double time = startIntegrationTime; time <= endIntegrationTime; time += dt) {
                traj.compute(time);
                traj.getAngularData((FrameOrientation3DBasics)currentOrientation, (FrameVector3DBasics)currentAngularVelocity, (FrameVector3DBasics)currentAngularAcceleration);
                angularVelocityVector.set((Tuple3DReadOnly)currentAngularVelocity);
                RotationTools.integrateAngularVelocity((Vector3DReadOnly)angularVelocityVector, (double)dt, (QuaternionBasics)integratedAngularVelocity);
                quaternionFromIntegration.set((QuaternionReadOnly)orientationFromIntegration);
                quaternionFromIntegration.multiply((QuaternionReadOnly)integratedAngularVelocity, (QuaternionReadOnly)quaternionFromIntegration);
                orientationFromIntegration.set((QuaternionReadOnly)quaternionFromIntegration);
                integratedAngularAcceleration.set((Tuple3DReadOnly)currentAngularAcceleration);
                integratedAngularAcceleration.scale(dt);
                angularVelocityFromIntegration.add((Tuple3DReadOnly)integratedAngularAcceleration);
                Assert.assertTrue(currentOrientation.epsilonEquals((EuclidFrameGeometry)orientationFromIntegration, 1.0E-4));
                Assert.assertTrue(currentAngularVelocity.epsilonEquals((EuclidFrameGeometry)angularVelocityFromIntegration, 0.001));
            }
        }
    }

    @Test
    public void testLimitConditions() throws Exception {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        Random random = new Random(5165165161L);
        HermiteCurveBasedOrientationTrajectoryGenerator traj = new HermiteCurveBasedOrientationTrajectoryGenerator("traj", worldFrame, new YoRegistry("null"));
        double trajectoryTime = 5.0;
        traj.setTrajectoryTime(trajectoryTime);
        for (int i = 0; i < 10000; ++i) {
            FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
            FrameVector3D initialAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame, (double)-5.0, (double)5.0, (double)-5.0, (double)5.0, (double)-5.0, (double)5.0);
            FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
            FrameVector3D finalAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame, (double)-5.0, (double)5.0, (double)-5.0, (double)5.0, (double)-5.0, (double)5.0);
            FrameVector3D zeroAngularAcceleration = new FrameVector3D();
            traj.setInitialConditions((FrameOrientation3DReadOnly)initialOrientation, (FrameVector3DReadOnly)initialAngularVelocity);
            traj.setFinalConditions((FrameOrientation3DReadOnly)finalOrientation, (FrameVector3DReadOnly)finalAngularVelocity);
            traj.initialize();
            FrameQuaternion currentOrientation = new FrameQuaternion();
            FrameVector3D currentAngularVelocity = new FrameVector3D();
            FrameVector3D currentAngularAcceleration = new FrameVector3D();
            double dt = 1.0E-8;
            traj.compute(0.0 + dt);
            traj.getAngularData((FrameOrientation3DBasics)currentOrientation, (FrameVector3DBasics)currentAngularVelocity, (FrameVector3DBasics)currentAngularAcceleration);
            double orientationEpsilon = 5.0E-4;
            double velocityEpsilon = 5.0E-4;
            double accelerationEpsilon = 5.0E-4;
            boolean goodInitialOrientation = initialOrientation.epsilonEquals((EuclidFrameGeometry)currentOrientation, orientationEpsilon);
            boolean goodInitialVelocity = initialAngularVelocity.epsilonEquals((EuclidFrameGeometry)currentAngularVelocity, velocityEpsilon);
            boolean goodInitialAngularAcceleration = zeroAngularAcceleration.epsilonEquals((EuclidFrameGeometry)currentAngularAcceleration, accelerationEpsilon);
            traj.compute(trajectoryTime - dt);
            traj.getAngularData((FrameOrientation3DBasics)currentOrientation, (FrameVector3DBasics)currentAngularVelocity, (FrameVector3DBasics)currentAngularAcceleration);
            boolean goodFinalOrientation = finalOrientation.geometricallyEquals((EuclidFrameGeometry)currentOrientation, orientationEpsilon);
            boolean goodFinalAngularVelocity = finalAngularVelocity.epsilonEquals((EuclidFrameGeometry)currentAngularVelocity, velocityEpsilon);
            boolean goodFinalAngularAcceleration = zeroAngularAcceleration.epsilonEquals((EuclidFrameGeometry)currentAngularAcceleration, accelerationEpsilon);
            if (!(goodInitialOrientation && goodFinalOrientation && goodInitialVelocity && goodFinalAngularVelocity)) {
                this.printLimitConditions(initialOrientation, initialAngularVelocity, finalOrientation, finalAngularVelocity);
            }
            Assert.assertTrue(goodInitialOrientation);
            Assert.assertTrue(goodFinalOrientation);
            Assert.assertTrue(goodInitialVelocity);
            Assert.assertTrue(goodFinalAngularVelocity);
        }
    }

    @Test
    public void testContinuityForSlowTrajectory() throws Exception {
        QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        Random random = new Random(5165165161L);
        HermiteCurveBasedOrientationTrajectoryGenerator traj = new HermiteCurveBasedOrientationTrajectoryGenerator("traj", worldFrame, new YoRegistry("null"));
        double trajectoryTime = 10.0;
        double maxVelocityRecorded = 0.0;
        double maxAccelerationRecorded = 0.0;
        double maxJerkRecorded = 0.0;
        traj.setTrajectoryTime(trajectoryTime);
        for (int i = 0; i < 100; ++i) {
            double dt;
            FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
            FrameVector3D initialAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
            FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
            FrameVector3D finalAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame);
            traj.setInitialConditions((FrameOrientation3DReadOnly)initialOrientation, (FrameVector3DReadOnly)initialAngularVelocity);
            traj.setFinalConditions((FrameOrientation3DReadOnly)finalOrientation, (FrameVector3DReadOnly)finalAngularVelocity);
            traj.initialize();
            FrameQuaternion currentOrientation = new FrameQuaternion();
            FrameVector3D currentAngularVelocity = new FrameVector3D();
            FrameVector3D currentAngularAcceleration = new FrameVector3D();
            Quaternion currentQuaternion = new Quaternion();
            Quaternion previousQuaternion = new Quaternion();
            Vector3D delta = new Vector3D();
            FrameQuaternion previousOrientation = new FrameQuaternion();
            FrameVector3D previousAngularVelocity = new FrameVector3D();
            FrameVector3D previousAngularAcceleration = new FrameVector3D();
            double maxVelocity = 2.0;
            double maxAcceleration = 1.0;
            double maxJerk = 60.0;
            traj.compute(0.0);
            traj.getAngularData((FrameOrientation3DBasics)previousOrientation, (FrameVector3DBasics)previousAngularVelocity, (FrameVector3DBasics)previousAngularAcceleration);
            for (double time = dt = 0.01; time <= trajectoryTime; time += dt) {
                traj.compute(time);
                traj.getAngularData((FrameOrientation3DBasics)currentOrientation, (FrameVector3DBasics)currentAngularVelocity, (FrameVector3DBasics)currentAngularAcceleration);
                currentQuaternion.set((QuaternionReadOnly)currentOrientation);
                previousQuaternion.set((QuaternionReadOnly)previousOrientation);
                if (currentQuaternion.dot((Tuple4DReadOnly)previousQuaternion) < 0.0) {
                    previousQuaternion.negate();
                }
                currentQuaternion.multiplyConjugateOther((QuaternionReadOnly)previousQuaternion);
                quaternionCalculus.log((QuaternionReadOnly)currentQuaternion, (Vector3DBasics)delta);
                double velocityFD = delta.length() / dt;
                maxVelocityRecorded = Math.max(maxVelocityRecorded, velocityFD);
                boolean velocityLow = velocityFD < maxVelocity;
                previousAngularVelocity.sub((FrameTuple3DReadOnly)currentAngularVelocity);
                double accelerationFD = previousAngularVelocity.length() / dt;
                maxAccelerationRecorded = Math.max(maxAccelerationRecorded, accelerationFD);
                boolean accelerationLow = accelerationFD < maxAcceleration;
                previousAngularAcceleration.sub((FrameTuple3DReadOnly)currentAngularAcceleration);
                double jerkFD = previousAngularAcceleration.length() / dt;
                maxJerkRecorded = Math.max(maxJerkRecorded, jerkFD);
                boolean jerkLow = jerkFD < maxJerk;
                Assert.assertTrue(velocityLow);
                Assert.assertTrue(accelerationLow);
                traj.getAngularData((FrameOrientation3DBasics)previousOrientation, (FrameVector3DBasics)previousAngularVelocity, (FrameVector3DBasics)previousAngularAcceleration);
            }
        }
    }

    @Test
    public void testContinuityForFastishTrajectory() throws Exception {
        QuaternionCalculus quaternionCalculus = new QuaternionCalculus();
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        Random random = new Random(5165165161L);
        HermiteCurveBasedOrientationTrajectoryGenerator traj = new HermiteCurveBasedOrientationTrajectoryGenerator("traj", worldFrame, new YoRegistry("null"));
        double trajectoryTime = 2.0;
        double maxVelocityRecorded = 0.0;
        double maxAccelerationRecorded = 0.0;
        double maxJerkRecorded = 0.0;
        traj.setTrajectoryTime(trajectoryTime);
        for (int i = 0; i < 1000; ++i) {
            double dt;
            FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
            FrameVector3D initialAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0);
            FrameQuaternion finalOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
            FrameVector3D finalAngularVelocity = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)worldFrame, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0, (double)-10.0, (double)10.0);
            traj.setInitialConditions((FrameOrientation3DReadOnly)initialOrientation, (FrameVector3DReadOnly)initialAngularVelocity);
            traj.setFinalConditions((FrameOrientation3DReadOnly)finalOrientation, (FrameVector3DReadOnly)finalAngularVelocity);
            traj.initialize();
            FrameQuaternion currentOrientation = new FrameQuaternion();
            FrameVector3D currentAngularVelocity = new FrameVector3D();
            FrameVector3D currentAngularAcceleration = new FrameVector3D();
            Quaternion currentQuaternion = new Quaternion();
            Quaternion previousQuaternion = new Quaternion();
            Vector3D delta = new Vector3D();
            FrameQuaternion previousOrientation = new FrameQuaternion();
            FrameVector3D previousAngularVelocity = new FrameVector3D();
            FrameVector3D previousAngularAcceleration = new FrameVector3D();
            double maxVelocity = 20.0;
            double maxAcceleration = 50.0;
            double maxJerk = 3000.0;
            traj.compute(0.0);
            traj.getAngularData((FrameOrientation3DBasics)previousOrientation, (FrameVector3DBasics)previousAngularVelocity, (FrameVector3DBasics)previousAngularAcceleration);
            for (double time = dt = 0.01; time <= trajectoryTime; time += dt) {
                traj.compute(time);
                traj.getAngularData((FrameOrientation3DBasics)currentOrientation, (FrameVector3DBasics)currentAngularVelocity, (FrameVector3DBasics)currentAngularAcceleration);
                currentQuaternion.set((QuaternionReadOnly)currentOrientation);
                previousQuaternion.set((QuaternionReadOnly)previousOrientation);
                if (currentQuaternion.dot((Tuple4DReadOnly)previousQuaternion) < 0.0) {
                    previousQuaternion.negate();
                }
                currentQuaternion.multiplyConjugateOther((QuaternionReadOnly)previousQuaternion);
                quaternionCalculus.log((QuaternionReadOnly)currentQuaternion, (Vector3DBasics)delta);
                double velocityFD = delta.length() / dt;
                maxVelocityRecorded = Math.max(maxVelocityRecorded, velocityFD);
                boolean velocityLow = velocityFD < maxVelocity;
                previousAngularVelocity.sub((FrameTuple3DReadOnly)currentAngularVelocity);
                double accelerationFD = previousAngularVelocity.length() / dt;
                maxAccelerationRecorded = Math.max(maxAccelerationRecorded, accelerationFD);
                boolean accelerationLow = accelerationFD < maxAcceleration;
                Assert.assertTrue(velocityLow);
                Assert.assertTrue(accelerationLow);
                previousAngularAcceleration.sub((FrameTuple3DReadOnly)currentAngularAcceleration);
                double jerkFD = previousAngularAcceleration.length() / dt;
                maxJerkRecorded = Math.max(maxJerkRecorded, jerkFD);
                boolean jerkLow = jerkFD < maxJerk;
                Assert.assertTrue(jerkLow);
                traj.getAngularData((FrameOrientation3DBasics)previousOrientation, (FrameVector3DBasics)previousAngularVelocity, (FrameVector3DBasics)previousAngularAcceleration);
            }
        }
    }

    @Test
    public void testMostBasicTrajectory() throws Exception {
        ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
        Random random = new Random(5165165161L);
        double dt = 1.0E-5;
        double trajectoryTime = 3.0;
        double startIntegrationTime = 1.0;
        double endIntegrationTime = 2.0;
        FrameQuaternion currentOrientation = new FrameQuaternion();
        FrameVector3D currentAngularVelocity = new FrameVector3D();
        FrameVector3D currentAngularAcceleration = new FrameVector3D();
        HermiteCurveBasedOrientationTrajectoryGenerator traj = new HermiteCurveBasedOrientationTrajectoryGenerator("traj", worldFrame, new YoRegistry("null"));
        traj.setTrajectoryTime(trajectoryTime);
        for (int i = 0; i < 5; ++i) {
            FrameQuaternion initialOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
            FrameVector3D angularVelocity = new FrameVector3D(worldFrame);
            traj.setInitialConditions((FrameOrientation3DReadOnly)initialOrientation, (FrameVector3DReadOnly)angularVelocity);
            traj.setFinalConditions((FrameOrientation3DReadOnly)initialOrientation, (FrameVector3DReadOnly)angularVelocity);
            traj.initialize();
            for (double time = startIntegrationTime; time <= endIntegrationTime; time += dt) {
                traj.compute(time);
                traj.getAngularData((FrameOrientation3DBasics)currentOrientation, (FrameVector3DBasics)currentAngularVelocity, (FrameVector3DBasics)currentAngularAcceleration);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)initialOrientation, (EuclidFrameGeometry)currentOrientation, (double)0.01);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)angularVelocity, (EuclidFrameGeometry)currentAngularVelocity, (double)0.01);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)angularVelocity, (EuclidFrameGeometry)currentAngularAcceleration, (double)0.01);
            }
        }
    }

    private void printLimitConditions(FrameQuaternion initialOrientation, FrameVector3D initialAngularVelocity, FrameQuaternion finalOrientation, FrameVector3D finalAngularVelocity) {
        System.out.println("FrameOrientation initialOrientation" + this.toStringFrameOrientationForVizualizer(initialOrientation));
        System.out.println("FrameVector initialAngularVelocity" + this.toStringFrameVectorForVizualizer(initialAngularVelocity));
        System.out.println("FrameOrientation finalOrientation" + this.toStringFrameOrientationForVizualizer(finalOrientation));
        System.out.println("FrameVector finalAngularVelocity" + this.toStringFrameVectorForVizualizer(finalAngularVelocity));
    }

    private String toStringFrameOrientationForVizualizer(FrameQuaternion frameOrientation) {
        double qx = frameOrientation.getX();
        double qy = frameOrientation.getY();
        double qz = frameOrientation.getZ();
        double qs = frameOrientation.getS();
        return " = new FrameOrientation(worldFrame, " + qx + ", " + qy + ", " + qz + ", " + qs + ");";
    }

    private String toStringFrameVectorForVizualizer(FrameVector3D frameVector) {
        double x = frameVector.getX();
        double y = frameVector.getY();
        double z = frameVector.getZ();
        return " = new FrameVector(worldFrame, " + x + ", " + y + ", " + z + ");";
    }
}

