/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.trajectories;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.FrameVector3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.referenceFrame.interfaces.FrameVector3DReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.robotics.math.trajectories.Polynomial3DBasicsTest;
import us.ihmc.robotics.math.trajectories.interfaces.FramePolynomial3DBasics;

public abstract class FramePolynomial3DBasicsTest
extends Polynomial3DBasicsTest {
    public abstract FramePolynomial3DBasics getPolynomial(int var1, ReferenceFrame var2);

    @Test
    public void testChangeFrameCubic() throws Exception {
        Random random = new Random(3453L);
        for (int i = 0; i < 1000; ++i) {
            int maxNumberOfCoefficients = RandomNumbers.nextInt((Random)random, (int)4, (int)10);
            FramePolynomial3DBasics transformedTrajectory = this.getPolynomial(maxNumberOfCoefficients, ReferenceFrame.getWorldFrame());
            double t0 = random.nextDouble();
            double tf = t0 + 0.5;
            ReferenceFrame frame = EuclidFrameRandomTools.nextReferenceFrame((Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame(), (boolean)false);
            FramePolynomial3DBasics trajectoryWithTransformedInputs = this.getPolynomial(maxNumberOfCoefficients, frame);
            FramePoint3D z0 = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame(), (double)1.0);
            FrameVector3D zd0 = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame());
            FramePoint3D zf = EuclidFrameRandomTools.nextFramePoint3D((Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame());
            FrameVector3D zdf = EuclidFrameRandomTools.nextFrameVector3D((Random)random, (ReferenceFrame)ReferenceFrame.getWorldFrame());
            transformedTrajectory.setCubic(t0, tf, (FramePoint3DReadOnly)z0, (FrameVector3DReadOnly)zd0, (FramePoint3DReadOnly)zf, (FrameVector3DReadOnly)zdf);
            transformedTrajectory.changeFrame(frame);
            z0.changeFrame(frame);
            zd0.changeFrame(frame);
            zf.changeFrame(frame);
            zdf.changeFrame(frame);
            transformedTrajectory.compute(t0);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)z0, (EuclidFrameGeometry)transformedTrajectory.getPosition(), (double)1.0E-12);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)zd0, (EuclidFrameGeometry)transformedTrajectory.getVelocity(), (double)1.0E-12);
            transformedTrajectory.compute(tf);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)zf, (EuclidFrameGeometry)transformedTrajectory.getPosition(), (double)1.0E-12);
            EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)zdf, (EuclidFrameGeometry)transformedTrajectory.getVelocity(), (double)1.0E-12);
            trajectoryWithTransformedInputs.setCubic(t0, tf, (FramePoint3DReadOnly)z0, (FrameVector3DReadOnly)zd0, (FramePoint3DReadOnly)zf, (FrameVector3DReadOnly)zdf);
            double dt = 0.001;
            for (double t = t0; t <= tf; t += dt) {
                transformedTrajectory.compute(t);
                trajectoryWithTransformedInputs.compute(t);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)trajectoryWithTransformedInputs.getPosition(), (EuclidFrameGeometry)transformedTrajectory.getPosition(), (double)1.0E-12);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)trajectoryWithTransformedInputs.getVelocity(), (EuclidFrameGeometry)transformedTrajectory.getVelocity(), (double)1.0E-12);
                EuclidFrameTestTools.assertGeometricallyEquals((EuclidFrameGeometry)trajectoryWithTransformedInputs.getAcceleration(), (EuclidFrameGeometry)transformedTrajectory.getAcceleration(), (double)1.0E-12);
            }
        }
    }
}

