/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.frames;

import java.util.Random;
import org.ejml.data.DMatrix;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.RandomMatrices_DDRM;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.matrixlib.MatrixTestTools;
import us.ihmc.robotics.math.frames.YoMatrix;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class YoMatrixTest {
    @Test
    public void testSimpleYoMatrixExample() {
        int maxNumberOfRows = 4;
        int maxNumberOfColumns = 8;
        YoRegistry registry = new YoRegistry("testRegistry");
        YoMatrix yoMatrix = new YoMatrix("testMatrix", maxNumberOfRows, maxNumberOfColumns, registry);
        Assertions.assertEquals((int)maxNumberOfRows, (int)yoMatrix.getNumRows());
        Assertions.assertEquals((int)maxNumberOfColumns, (int)yoMatrix.getNumCols());
        DMatrixRMaj denseMatrix = new DMatrixRMaj(maxNumberOfRows, maxNumberOfColumns);
        yoMatrix.reshape(maxNumberOfRows, maxNumberOfColumns);
        yoMatrix.zero();
        yoMatrix.get((DMatrix)denseMatrix);
        MatrixTestTools.assertMatrixEqualsZero((DMatrix)denseMatrix, (double)1.0E-10);
        Random random = new Random(1984L);
        DMatrixRMaj randomMatrix = RandomMatrices_DDRM.rectangle((int)maxNumberOfRows, (int)maxNumberOfColumns, (Random)random);
        yoMatrix.set((DMatrix)randomMatrix);
        DMatrixRMaj checkMatrix = new DMatrixRMaj(maxNumberOfRows, maxNumberOfColumns);
        yoMatrix.get((DMatrix)checkMatrix);
        MatrixTestTools.assertMatrixEquals((DMatrix)randomMatrix, (DMatrix)checkMatrix, (double)1.0E-10);
        Assertions.assertEquals((double)registry.findVariable(YoMatrix.getFieldName((String)"testMatrix", (int)0, (int)0)).getValueAsDouble(), (double)checkMatrix.get(0, 0), (double)1.0E-10);
    }

    @Test
    public void testYoMatrixDimensioning() {
        int maxNumberOfRows = 4;
        int maxNumberOfColumns = 8;
        String name = "testMatrix";
        YoRegistry registry = new YoRegistry("testRegistry");
        YoMatrix yoMatrix = new YoMatrix(name, maxNumberOfRows, maxNumberOfColumns, registry);
        int smallerRows = maxNumberOfRows - 2;
        int smallerColumns = maxNumberOfColumns - 3;
        DMatrixRMaj denseMatrix = new DMatrixRMaj(smallerRows, smallerColumns);
        try {
            yoMatrix.get((DMatrix)denseMatrix);
            Assertions.fail((String)"Should throw an exception if the size isn't right!");
        }
        catch (Exception exception) {
            // empty catch block
        }
        yoMatrix.reshape(maxNumberOfRows, maxNumberOfColumns);
        yoMatrix.zero();
        yoMatrix.getAndReshape(denseMatrix);
        MatrixTestTools.assertMatrixEqualsZero((DMatrix)denseMatrix, (double)1.0E-10);
        Assertions.assertEquals((int)maxNumberOfRows, (int)denseMatrix.getNumRows());
        Assertions.assertEquals((int)maxNumberOfColumns, (int)denseMatrix.getNumCols());
        Assertions.assertEquals((int)maxNumberOfRows, (int)yoMatrix.getNumRows());
        Assertions.assertEquals((int)maxNumberOfColumns, (int)yoMatrix.getNumCols());
        Random random = new Random(1984L);
        DMatrixRMaj randomMatrix = RandomMatrices_DDRM.rectangle((int)maxNumberOfRows, (int)maxNumberOfColumns, (Random)random);
        yoMatrix.set((DMatrix)randomMatrix);
        DMatrixRMaj checkMatrix = new DMatrixRMaj(maxNumberOfRows, maxNumberOfColumns);
        yoMatrix.get((DMatrix)checkMatrix);
        MatrixTestTools.assertMatrixEquals((DMatrix)randomMatrix, (DMatrix)checkMatrix, (double)1.0E-10);
        DMatrixRMaj smallerMatrix = RandomMatrices_DDRM.rectangle((int)smallerRows, (int)smallerColumns, (Random)random);
        yoMatrix.set((DMatrix)smallerMatrix);
        Assertions.assertEquals((int)smallerRows, (int)smallerMatrix.getNumRows());
        Assertions.assertEquals((int)smallerColumns, (int)smallerMatrix.getNumCols());
        Assertions.assertEquals((int)smallerRows, (int)yoMatrix.getNumRows());
        Assertions.assertEquals((int)smallerColumns, (int)yoMatrix.getNumCols());
        DMatrixRMaj checkMatrix2 = new DMatrixRMaj(1, 1);
        yoMatrix.getAndReshape(checkMatrix2);
        MatrixTestTools.assertMatrixEquals((DMatrix)smallerMatrix, (DMatrix)checkMatrix2, (double)1.0E-10);
        this.checkMatrixYoVariablesEqualsCheckMatrixAndOutsideValuesAreNaN(name, maxNumberOfRows, maxNumberOfColumns, checkMatrix2, registry);
    }

    @Test
    public void testYoMatrixSetToZero() {
        int maxNumberOfRows = 4;
        int maxNumberOfColumns = 8;
        String name = "testMatrixForZero";
        YoRegistry registry = new YoRegistry("testRegistry");
        YoMatrix yoMatrix = new YoMatrix(name, maxNumberOfRows, maxNumberOfColumns, registry);
        Random random = new Random(1984L);
        DMatrixRMaj randomMatrix = RandomMatrices_DDRM.rectangle((int)maxNumberOfRows, (int)maxNumberOfColumns, (Random)random);
        yoMatrix.set((DMatrix)randomMatrix);
        int numberOfRows = 2;
        int numberOfColumns = 6;
        yoMatrix.reshape(numberOfRows, numberOfColumns);
        yoMatrix.zero();
        DMatrixRMaj zeroMatrix = new DMatrixRMaj(numberOfRows, numberOfColumns);
        zeroMatrix.zero();
        this.checkMatrixYoVariablesEqualsCheckMatrixAndOutsideValuesAreNaN(name, maxNumberOfRows, maxNumberOfColumns, zeroMatrix, registry);
    }

    @Test
    public void testYoMatrixSetTooBig() {
        int maxNumberOfRows = 4;
        int maxNumberOfColumns = 8;
        String name = "testMatrix";
        YoRegistry registry = new YoRegistry("testRegistry");
        YoMatrix yoMatrix = new YoMatrix(name, maxNumberOfRows, maxNumberOfColumns, registry);
        DMatrixRMaj tooBigMatrix = new DMatrixRMaj(maxNumberOfRows + 1, maxNumberOfColumns);
        try {
            yoMatrix.set((DMatrix)tooBigMatrix);
            Assertions.fail((String)"Too Big");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        tooBigMatrix = new DMatrixRMaj(maxNumberOfRows, maxNumberOfColumns + 1);
        try {
            yoMatrix.set((DMatrix)tooBigMatrix);
            Assertions.fail((String)"Too Big");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        DMatrixRMaj okMatrix = new DMatrixRMaj(0, maxNumberOfColumns + 10);
        yoMatrix.set((DMatrix)okMatrix);
        this.assertMatrixYoVariablesAreNaN(name, maxNumberOfRows, maxNumberOfColumns, registry);
        DMatrixRMaj checkMatrix = new DMatrixRMaj(1, 1);
        yoMatrix.getAndReshape(checkMatrix);
        Assertions.assertEquals((int)0, (int)checkMatrix.getNumRows());
        Assertions.assertEquals((int)(maxNumberOfColumns + 10), (int)checkMatrix.getNumCols());
        okMatrix = new DMatrixRMaj(maxNumberOfRows + 10, 0);
        yoMatrix.set((DMatrix)okMatrix);
        this.assertMatrixYoVariablesAreNaN(name, maxNumberOfRows, maxNumberOfColumns, registry);
        checkMatrix = new DMatrixRMaj(1, 1);
        yoMatrix.getAndReshape(checkMatrix);
        Assertions.assertEquals((int)(maxNumberOfRows + 10), (int)checkMatrix.getNumRows());
        Assertions.assertEquals((int)0, (int)checkMatrix.getNumCols());
    }

    private void checkMatrixYoVariablesEqualsCheckMatrixAndOutsideValuesAreNaN(String name, int maxNumberOfRows, int maxNumberOfColumns, DMatrixRMaj checkMatrix, YoRegistry registry) {
        int smallerRows = checkMatrix.getNumRows();
        int smallerColumns = checkMatrix.getNumCols();
        for (int row = 0; row < maxNumberOfRows; ++row) {
            for (int column = 0; column < maxNumberOfColumns; ++column) {
                YoDouble variable = (YoDouble)registry.findVariable(YoMatrix.getFieldName((String)name, (int)row, (int)column));
                if (row < smallerRows && column < smallerColumns) {
                    Assertions.assertEquals((double)checkMatrix.get(row, column), (double)variable.getDoubleValue(), (double)1.0E-10);
                    continue;
                }
                Assertions.assertTrue((boolean)Double.isNaN(variable.getDoubleValue()), (String)("Values outside aren't NaN, instead are " + variable.getDoubleValue()));
            }
        }
    }

    private void assertMatrixYoVariablesAreNaN(String name, int maxNumberOfRows, int maxNumberOfColumns, YoRegistry registry) {
        for (int row = 0; row < maxNumberOfRows; ++row) {
            for (int column = 0; column < maxNumberOfColumns; ++column) {
                YoDouble variable = (YoDouble)registry.findVariable(YoMatrix.getFieldName((String)name, (int)row, (int)column));
                Assertions.assertTrue((boolean)Double.isNaN(variable.getDoubleValue()));
            }
        }
    }
}

