/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.frames;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.axisAngle.AxisAngle;
import us.ihmc.euclid.axisAngle.interfaces.AxisAngleReadOnly;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.exceptions.ReferenceFrameMismatchException;
import us.ihmc.euclid.referenceFrame.interfaces.EuclidFrameGeometry;
import us.ihmc.euclid.referenceFrame.interfaces.FrameQuaternionReadOnly;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameRandomTools;
import us.ihmc.euclid.referenceFrame.tools.EuclidFrameTestTools;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.robotics.geometry.RotationTools;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameQuaternion;
import us.ihmc.yoVariables.registry.YoRegistry;

public class YoFrameQuaternionTest {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private static final double EPS = 1.0E-8;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testInitialization() {
        YoRegistry registry = new YoRegistry("blop");
        YoFrameQuaternion yoFrameQuaternion = new YoFrameQuaternion("test", worldFrame, registry);
        yoFrameQuaternion.checkReferenceFrameMatch(worldFrame);
        Quaternion quat4dActual = new Quaternion((QuaternionReadOnly)yoFrameQuaternion);
        Quaternion quat4dExpected = new Quaternion(0.0, 0.0, 0.0, 1.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quat4dExpected, (EuclidGeometry)quat4dActual, (double)1.0E-8);
        AxisAngle axisAngle4dActual = new AxisAngle((Orientation3DReadOnly)yoFrameQuaternion);
        AxisAngle axisAngle4dExpected = new AxisAngle(1.0, 0.0, 0.0, 0.0);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)axisAngle4dExpected, (EuclidGeometry)axisAngle4dActual, (double)1.0E-8);
        RotationMatrix matrix3dActual = new RotationMatrix((Orientation3DReadOnly)yoFrameQuaternion);
        RotationMatrix matrix3dExpected = new RotationMatrix();
        matrix3dExpected.setIdentity();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)matrix3dExpected, (EuclidGeometry)matrix3dActual, (double)1.0E-8);
        FrameQuaternion frameOrientationActual = new FrameQuaternion((FrameQuaternionReadOnly)yoFrameQuaternion);
        FrameQuaternion frameOrientationExpected = new FrameQuaternion(worldFrame);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)frameOrientationExpected, (EuclidFrameGeometry)frameOrientationActual, (double)1.0E-8);
        YawPitchRoll yawPitchRollActual = new YawPitchRoll((Orientation3DReadOnly)yoFrameQuaternion);
        YawPitchRoll yawPitchRollExpected = new YawPitchRoll();
        EuclidCoreTestTools.assertEquals((EuclidGeometry)yawPitchRollExpected, (EuclidGeometry)yawPitchRollActual, (double)1.0E-8);
    }

    @Test
    public void testSetters() {
        Random random = new Random(1972L);
        YoRegistry registry = new YoRegistry("blop");
        YoFrameQuaternion yoFrameQuaternion = new YoFrameQuaternion("test", worldFrame, registry);
        RotationMatrix matrix3dExpected = new RotationMatrix();
        RotationMatrix matrix3dActual = new RotationMatrix();
        Quaternion quat4dExpected = EuclidCoreRandomTools.nextQuaternion((Random)random);
        yoFrameQuaternion.set((QuaternionReadOnly)quat4dExpected);
        Quaternion quat4dActual = new Quaternion((QuaternionReadOnly)yoFrameQuaternion);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)quat4dExpected, (EuclidGeometry)quat4dActual, (double)1.0E-8);
        AxisAngle axisAngle4dExpected = EuclidCoreRandomTools.nextAxisAngle((Random)random);
        yoFrameQuaternion.set((Orientation3DReadOnly)axisAngle4dExpected);
        AxisAngle axisAngle4dActual = new AxisAngle((Orientation3DReadOnly)yoFrameQuaternion);
        Assertions.assertTrue((boolean)RotationTools.axisAngleEpsilonEqualsIgnoreFlippedAxes((AxisAngleReadOnly)axisAngle4dExpected, (AxisAngleReadOnly)axisAngle4dActual, (double)1.0E-8));
        matrix3dExpected.set((Orientation3DReadOnly)EuclidCoreRandomTools.nextAxisAngle((Random)random));
        yoFrameQuaternion.set((Orientation3DReadOnly)matrix3dExpected);
        matrix3dActual.set((Orientation3DReadOnly)yoFrameQuaternion);
        EuclidCoreTestTools.assertGeometricallyEquals((EuclidGeometry)matrix3dExpected, (EuclidGeometry)matrix3dActual, (double)1.0E-8);
        FrameQuaternion frameOrientationExpected = new FrameQuaternion(worldFrame);
        frameOrientationExpected.set((QuaternionReadOnly)EuclidCoreRandomTools.nextQuaternion((Random)random));
        yoFrameQuaternion.set((FrameQuaternionReadOnly)frameOrientationExpected);
        FrameQuaternion frameOrientationActual = new FrameQuaternion((FrameQuaternionReadOnly)yoFrameQuaternion);
        EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)frameOrientationExpected, (EuclidFrameGeometry)frameOrientationActual, (double)1.0E-8);
        YawPitchRoll yawPitchRollExpected = EuclidCoreRandomTools.nextYawPitchRoll((Random)random);
        yoFrameQuaternion.set((Orientation3DReadOnly)yawPitchRollExpected);
        YawPitchRoll yawPitchRollActual = new YawPitchRoll();
        yawPitchRollActual.set((Orientation3DReadOnly)yoFrameQuaternion);
        matrix3dActual.set((Orientation3DReadOnly)yawPitchRollActual);
        matrix3dExpected.set((Orientation3DReadOnly)yawPitchRollExpected);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)matrix3dExpected, (EuclidGeometry)matrix3dActual, (double)1.0E-8);
    }

    @Test
    public void testReferenceFramesMismatching() {
        Random random = new Random(1984L);
        ReferenceFrame testFrame = ReferenceFrameTools.constructFrameWithUnchangingTransformToParent((String)"chou", (ReferenceFrame)worldFrame, (RigidBodyTransformReadOnly)EuclidCoreRandomTools.nextRigidBodyTransform((Random)random));
        YoRegistry registry = new YoRegistry("blop");
        YoFrameQuaternion yoFrameQuaternion = new YoFrameQuaternion("test", worldFrame, registry);
        FrameQuaternion frameOrientation = new FrameQuaternion(testFrame);
        boolean hasReferenceFrameMismatchExceptionBeenThrown = false;
        try {
            yoFrameQuaternion.set((FrameQuaternionReadOnly)frameOrientation);
        }
        catch (ReferenceFrameMismatchException e) {
            hasReferenceFrameMismatchExceptionBeenThrown = true;
        }
        Assertions.assertTrue((boolean)hasReferenceFrameMismatchExceptionBeenThrown);
        frameOrientation = new FrameQuaternion(worldFrame);
        hasReferenceFrameMismatchExceptionBeenThrown = false;
        try {
            yoFrameQuaternion.set((FrameQuaternionReadOnly)frameOrientation);
        }
        catch (ReferenceFrameMismatchException e) {
            hasReferenceFrameMismatchExceptionBeenThrown = true;
        }
        Assertions.assertFalse((boolean)hasReferenceFrameMismatchExceptionBeenThrown);
    }

    @Test
    public void testMultiplication() {
        Random random = new Random(1776L);
        YoRegistry registry = new YoRegistry("blop");
        YoFrameQuaternion yoFrameQuaternion = new YoFrameQuaternion("test", worldFrame, registry);
        Quaternion quat4dActual = new Quaternion();
        Quaternion quat4dExpected = new Quaternion();
        FrameQuaternion frameOrientation = new FrameQuaternion(worldFrame);
        for (int i = 0; i < 1000; ++i) {
            Quaternion quat4dA = EuclidCoreRandomTools.nextQuaternion((Random)random);
            Quaternion quat4dB = EuclidCoreRandomTools.nextQuaternion((Random)random);
            quat4dExpected.multiply((QuaternionReadOnly)quat4dA, (QuaternionReadOnly)quat4dB);
            yoFrameQuaternion.set((QuaternionReadOnly)quat4dA);
            yoFrameQuaternion.multiply((QuaternionReadOnly)quat4dB);
            quat4dActual.set((QuaternionReadOnly)yoFrameQuaternion);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quat4dExpected, (EuclidGeometry)quat4dActual, (double)1.0E-8);
            yoFrameQuaternion.set((QuaternionReadOnly)quat4dA);
            frameOrientation.set((QuaternionReadOnly)quat4dB);
            yoFrameQuaternion.multiply((FrameQuaternionReadOnly)frameOrientation);
            quat4dActual.set((QuaternionReadOnly)yoFrameQuaternion);
            EuclidCoreTestTools.assertEquals((EuclidGeometry)quat4dExpected, (EuclidGeometry)quat4dActual, (double)1.0E-8);
        }
    }

    @Test
    public void testInterpolate() {
        Random random = new Random(1776L);
        YoRegistry registry = new YoRegistry("blop");
        FrameQuaternion initialFrameOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        FrameQuaternion finalFrameOrientation = EuclidFrameRandomTools.nextFrameQuaternion((Random)random, (ReferenceFrame)worldFrame);
        FrameQuaternion interpolatedFrameOrientation = new FrameQuaternion(worldFrame);
        YoFrameQuaternion initialYoFrameQuaternion = new YoFrameQuaternion("init", worldFrame, registry);
        initialYoFrameQuaternion.set((FrameQuaternionReadOnly)initialFrameOrientation);
        YoFrameQuaternion finalYoFrameQuaternion = new YoFrameQuaternion("final", worldFrame, registry);
        finalYoFrameQuaternion.set((FrameQuaternionReadOnly)finalFrameOrientation);
        YoFrameQuaternion interpolatedYoFrameQuaternion = new YoFrameQuaternion("interpolated", worldFrame, registry);
        FrameQuaternion temp = new FrameQuaternion();
        for (double alpha = -0.1; alpha <= 1.1; alpha += 0.05) {
            interpolatedFrameOrientation.interpolate((FrameQuaternionReadOnly)initialFrameOrientation, (FrameQuaternionReadOnly)finalFrameOrientation, alpha);
            interpolatedYoFrameQuaternion.interpolate((FrameQuaternionReadOnly)initialYoFrameQuaternion, (FrameQuaternionReadOnly)finalYoFrameQuaternion, alpha);
            temp.setIncludingFrame((FrameQuaternionReadOnly)interpolatedYoFrameQuaternion);
            EuclidFrameTestTools.assertEquals((EuclidFrameGeometry)interpolatedFrameOrientation, (EuclidFrameGeometry)temp, (double)1.0E-8);
        }
    }
}

