/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.robotics.dataStructures.ComplexNumber;
import us.ihmc.robotics.dataStructures.ObsoletePolynomial;
import us.ihmc.robotics.linearDynamicSystems.LinearDynamicSystem;
import us.ihmc.robotics.linearDynamicSystems.MatlabChart;
import us.ihmc.robotics.linearDynamicSystems.TransferFunction;
import us.ihmc.robotics.linearDynamicSystems.TransferFunctionToStateSpaceConverter;
import us.ihmc.robotics.math.filters.YoLinearDynamicSystem;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

class YoLinearDynamicSystemTest {
    YoLinearDynamicSystemTest() {
    }

    @Test
    void testYoLinearDynamicSystem() {
        boolean displayChart = false;
        YoRegistry registry = new YoRegistry("test");
        double zeta = 0.5;
        double wn = Math.PI * 2;
        TransferFunction transferFunctionOne = TransferFunction.constructSecondOrderTransferFunction((double)1.0, (double)wn, (double)zeta);
        double dcScale = 1.0;
        double[] realZeros = new double[]{-4.0};
        ComplexNumber[] complexPairZeros = null;
        double[] realPoles = new double[]{-2.0};
        ComplexNumber[] complexPairPoles = null;
        ObsoletePolynomial numeratorPolynomialTwo = ObsoletePolynomial.constructFromScaleFactorAndRoots((double)dcScale, (double[])realZeros, complexPairZeros);
        ObsoletePolynomial denominatorPolynomialTwo = ObsoletePolynomial.constructFromScaleFactorAndRoots((double)0.25, (double[])realPoles, complexPairPoles);
        TransferFunction transferFunctionTwo = new TransferFunction(numeratorPolynomialTwo, denominatorPolynomialTwo);
        TransferFunction transferFunction = transferFunctionOne.times(transferFunctionTwo);
        LinearDynamicSystem linearDynamicSystem = TransferFunctionToStateSpaceConverter.convertTransferFunctionToStateSpaceControllableCanonicalForm((TransferFunction)transferFunction);
        Assertions.assertEquals((int)transferFunction.getOrder(), (int)linearDynamicSystem.getOrder());
        Assertions.assertEquals((int)1, (int)linearDynamicSystem.getInputSize());
        Assertions.assertEquals((int)1, (int)linearDynamicSystem.getOutputSize());
        String statePrefix = "x_";
        String inputPrefix = "u_";
        String outputPrefix = "y_";
        YoLinearDynamicSystem dynamicSystem = new YoLinearDynamicSystem(linearDynamicSystem, statePrefix, inputPrefix, outputPrefix, registry);
        double dt = 0.001;
        double finalTime = 2.0;
        int numberOfSteps = (int)(finalTime / dt);
        double amplitude = 1.0;
        double frequency = 0.25;
        YoDouble time = new YoDouble("time", registry);
        double[] output = new double[numberOfSteps];
        double[] timeArray = new double[numberOfSteps];
        for (int i = 0; i < numberOfSteps; ++i) {
            timeArray[i] = time.getValue();
            double[] input = new double[]{amplitude * Math.sin(Math.PI * 8 * frequency * time.getDoubleValue())};
            dynamicSystem.update(input, dt);
            output[i] = dynamicSystem.getOutput()[0];
            time.add(dt);
        }
        if (displayChart) {
            MatlabChart chart = new MatlabChart();
            chart.plot(timeArray, output, "-r", 2.0f, "YoLinearDynamicSystemTest");
            chart.RenderPlot();
            chart.title("YoLinearDynamicSystemTest");
            chart.xlabel("t");
            chart.ylabel("x");
            chart.grid("on", "on");
            chart.displayInJFrame();
            ThreadTools.sleepForever();
        }
    }
}

