/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.Random;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.SimpleMovingAverageFilteredYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SimpleMovingAverageFilteredYoVariableTest {
    @Test
    public void testWithFixedSizeDoubleArrays() throws Exception {
        for (int i = 0; i < 100; ++i) {
            YoRegistry registry = new YoRegistry("Blop");
            Random random = new Random(6541654L);
            int windowSize = RandomNumbers.nextInt((Random)random, (int)1, (int)1000);
            SimpleMovingAverageFilteredYoVariable sma = new SimpleMovingAverageFilteredYoVariable("tested", windowSize, registry);
            double amplitude = 100.0;
            double[] randomArray = RandomNumbers.nextDoubleArray((Random)random, (int)windowSize, (double)amplitude);
            double expected = 0.0;
            for (double val : randomArray) {
                expected += val / (double)windowSize;
            }
            for (int j = 0; j < randomArray.length; ++j) {
                Assert.assertFalse(sma.getHasBufferWindowFilled());
                sma.update(randomArray[j]);
            }
            Assert.assertTrue(sma.getHasBufferWindowFilled());
            Assert.assertEquals(expected, sma.getDoubleValue(), 1.0E-10);
        }
    }
}

