/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.HysteresisFilteredYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class HysteresisFilteredYoVariableTest {
    YoRegistry registry = new YoRegistry("TestHysteresisFilteredYoVariable");
    private YoDouble guideLineHysteresis = new YoDouble("guideLineHyst", this.registry);
    private HysteresisFilteredYoVariable filteredYoVariable = new HysteresisFilteredYoVariable("test", this.registry, this.guideLineHysteresis);
    private double epsilon = 1.0E-7;

    @BeforeEach
    public void setUp() throws Exception {
    }

    @AfterEach
    public void tearDown() throws Exception {
    }

    @Test
    public void testNoHysteresis() {
        this.guideLineHysteresis.set(0.0);
        double stepSize = 0.031415926535897934;
        double maximumValue = Math.PI * 2;
        double[] x = this.getAbscissa(stepSize, maximumValue);
        double[] unfilteredValues = this.sin(x);
        double[] filteredValues = this.filter(unfilteredValues, this.filteredYoVariable);
        int n = filteredValues.length;
        for (int i = 0; i < n; ++i) {
            Assert.assertTrue(Math.abs(filteredValues[i] - unfilteredValues[i]) < this.epsilon);
        }
    }

    @Test
    public void testSomeHysteresis() {
        this.guideLineHysteresis.set(0.2);
        double stepSize = 0.06283185307179587;
        double maximumValue = Math.PI * 4;
        double[] x = this.getAbscissa(stepSize, maximumValue);
        double[] unfilteredValues = this.sin(x);
        double[] filteredValues = this.filter(unfilteredValues, this.filteredYoVariable);
        int n = filteredValues.length;
    }

    private double[] getAbscissa(double stepSize, double maximumValue) {
        int numberOfSteps = (int)(maximumValue / stepSize);
        double[] ret = new double[numberOfSteps];
        for (int i = 0; i < numberOfSteps; ++i) {
            ret[i] = (double)i * stepSize;
        }
        return ret;
    }

    private double[] sin(double[] abscissa) {
        int n = abscissa.length;
        double[] ret = new double[n];
        for (int i = 0; i < n; ++i) {
            ret[i] = Math.sin(abscissa[i]);
        }
        return ret;
    }

    private double[] filter(double[] unfilteredValues, HysteresisFilteredYoVariable hysteresisFilteredYoVariable) {
        int n = unfilteredValues.length;
        double[] ret = new double[n];
        for (int i = 0; i < n; ++i) {
            hysteresisFilteredYoVariable.update(unfilteredValues[i]);
            ret[i] = hysteresisFilteredYoVariable.getDoubleValue();
        }
        return ret;
    }
}

