/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.GlitchFilteredYoBoolean;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;

public class GlitchFilteredYoBooleanTest {
    public static final int WINDOW_SIZE = 10;
    private YoRegistry registry;
    private YoBoolean yoVariableToFilter;
    private GlitchFilteredYoBoolean filteredVariable;

    @BeforeEach
    public void setUp() {
        this.registry = new YoRegistry("testRegistry");
        this.yoVariableToFilter = new YoBoolean("variableToFilter", this.registry);
        this.filteredVariable = new GlitchFilteredYoBoolean("filteredVariable", this.registry, this.yoVariableToFilter, 10);
    }

    @AfterEach
    public void tearDown() {
        this.registry = null;
        this.yoVariableToFilter = null;
        this.filteredVariable = null;
    }

    @Test
    public void testConstructors_Set_Get() {
        GlitchFilteredYoBoolean number1 = new GlitchFilteredYoBoolean("stringInt", 10);
        GlitchFilteredYoBoolean number2 = new GlitchFilteredYoBoolean("stringYoVariableRegistryInt", this.registry, 10);
        GlitchFilteredYoBoolean number3 = new GlitchFilteredYoBoolean("stringBooleanYoVariableInt", this.yoVariableToFilter, 10);
        GlitchFilteredYoBoolean number4 = new GlitchFilteredYoBoolean("stringYoVariableRegistryBooleanYoVariableInt", this.registry, this.yoVariableToFilter, 10);
        GlitchFilteredYoBoolean[] array = new GlitchFilteredYoBoolean[]{number1, number2, number3, number4};
        for (int i = 0; i < array.length; ++i) {
            Assert.assertFalse(array[i].getBooleanValue());
            array[i].set(true);
            Assert.assertTrue(array[i].getBooleanValue());
            array[i].set(false);
            Assert.assertFalse(array[i].getBooleanValue());
        }
    }

    @Test
    public void testUpdate() {
        int windowSize = 3;
        this.filteredVariable.set(true);
        this.filteredVariable.setWindowSize(windowSize);
        int numberOfSets = windowSize * 20;
        int counter = 0;
        for (int i = 0; i < windowSize + 10; ++i) {
            this.filteredVariable.update(false);
            if (++counter < windowSize) {
                Assert.assertTrue(this.filteredVariable.getBooleanValue());
                continue;
            }
            Assert.assertFalse(this.filteredVariable.getBooleanValue());
        }
        this.filteredVariable = null;
        try {
            this.filteredVariable.update();
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testCounter() {
        int windowSize = 10;
        this.filteredVariable.set(true);
        this.filteredVariable.setWindowSize(windowSize);
        for (int i = 0; i < (int)((double)windowSize / 2.0); ++i) {
            this.filteredVariable.update(this.filteredVariable.getBooleanValue());
            Assert.assertEquals(this.filteredVariable.counter.getIntegerValue(), 0L);
        }
    }

    @Test
    public void testFiltering() {
        int i;
        this.yoVariableToFilter.set(true);
        for (i = 0; i < 5; ++i) {
            this.filteredVariable.update();
        }
        Assert.assertFalse(this.yoVariableToFilter.getBooleanValue() == this.filteredVariable.getBooleanValue());
        for (i = 0; i < 5; ++i) {
            this.filteredVariable.update();
        }
        Assert.assertTrue(this.yoVariableToFilter.getBooleanValue() == this.filteredVariable.getBooleanValue());
    }
}

