/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.FirstOrderBandPassFilteredYoVariable;
import us.ihmc.robotics.math.filters.FirstOrderFilteredYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class FirstOrderFilteredYoVariableTest {
    private final YoRegistry registry = new YoRegistry("testRegistry");
    private final YoDouble yoTime = new YoDouble("yoTime", this.registry);
    private final double DT = 0.001;

    @Test
    public void testHighPassAttenuationForSinusoidalInput() {
        double cutoffFrequencyRadPerSec;
        double inputFrequencyRadPerSec = 15.0;
        double filterAttenuation = 1.0;
        FirstOrderFilteredYoVariable highPassFilteredYoVariable = new FirstOrderFilteredYoVariable("highPass", "", cutoffFrequencyRadPerSec / (Math.PI * 2), this.yoTime, FirstOrderFilteredYoVariable.FirstOrderFilterType.HIGH_PASS, this.registry);
        for (cutoffFrequencyRadPerSec = inputFrequencyRadPerSec / 5.0; filterAttenuation > 0.1 && cutoffFrequencyRadPerSec > 0.0; cutoffFrequencyRadPerSec += 10.0) {
            highPassFilteredYoVariable.setCutoffFrequencyHz(cutoffFrequencyRadPerSec / (Math.PI * 2));
            filterAttenuation = this.computeSteadyStateFilteredOutputAmplitude(this.yoTime, 0.001, inputFrequencyRadPerSec, highPassFilteredYoVariable);
            double properHighPassAttenuation = this.computeProperHighPassAttenuation(inputFrequencyRadPerSec, cutoffFrequencyRadPerSec);
            Assert.assertEquals(properHighPassAttenuation, filterAttenuation, 0.01);
        }
    }

    @Test
    public void testLowPassAttenuationForSinusoidalInput() {
        double cutoffFrequencyRadPerSec;
        double inputFrequencyRadPerSec = 10.0;
        double filterAttenuation = 1.0;
        FirstOrderFilteredYoVariable lowPassFilteredYoVariable = new FirstOrderFilteredYoVariable("lowPass", "", cutoffFrequencyRadPerSec / (Math.PI * 2), this.yoTime, FirstOrderFilteredYoVariable.FirstOrderFilterType.LOW_PASS, this.registry);
        for (cutoffFrequencyRadPerSec = inputFrequencyRadPerSec * 5.0; filterAttenuation > 0.1 && cutoffFrequencyRadPerSec > 0.0; cutoffFrequencyRadPerSec -= 10.0) {
            lowPassFilteredYoVariable.setCutoffFrequencyHz(cutoffFrequencyRadPerSec / (Math.PI * 2));
            filterAttenuation = this.computeSteadyStateFilteredOutputAmplitude(this.yoTime, 0.001, inputFrequencyRadPerSec, lowPassFilteredYoVariable);
            double properLowPassAttenuation = this.computeProperLowPassAttenuation(inputFrequencyRadPerSec, cutoffFrequencyRadPerSec);
            Assert.assertEquals(properLowPassAttenuation, filterAttenuation, 0.01);
        }
    }

    @Test
    public void testBandPassAttenuationForSinusoidalInput() {
        double b;
        double inputFrequencyRadPerSec = 10.0;
        double a = inputFrequencyRadPerSec / 5.0;
        double filterAttenuation = 1.0;
        FirstOrderBandPassFilteredYoVariable bandPassFilteredYoVariable = new FirstOrderBandPassFilteredYoVariable("sineWave", "", a, b, this.yoTime, this.registry);
        for (b = inputFrequencyRadPerSec * 5.0; filterAttenuation > 0.1 && a > 0.0 && b > 0.0; a -= 10.0, b -= 10.0) {
            bandPassFilteredYoVariable.setPassBand(a / (Math.PI * 2), b / (Math.PI * 2));
            filterAttenuation = this.computeSteadyStateFilteredOutputAmplitude(this.yoTime, 0.001, inputFrequencyRadPerSec, (FirstOrderFilteredYoVariable)bandPassFilteredYoVariable);
            double properBandPassAttenuation = this.computeProperBandPassAttenuation(inputFrequencyRadPerSec, a, b);
            Assert.assertEquals(properBandPassAttenuation, filterAttenuation, 0.01);
        }
    }

    private double computeProperLowPassAttenuation(double inputFreq_RadPerSec, double cutoffFreq_RadPerSec) {
        double ret = cutoffFreq_RadPerSec / Math.sqrt(inputFreq_RadPerSec * inputFreq_RadPerSec + cutoffFreq_RadPerSec * cutoffFreq_RadPerSec);
        return ret;
    }

    private double computeProperHighPassAttenuation(double inputFreq_RadPerSec, double cutoffFreq_RadPerSec) {
        double ret = inputFreq_RadPerSec / Math.sqrt(inputFreq_RadPerSec * inputFreq_RadPerSec + cutoffFreq_RadPerSec * cutoffFreq_RadPerSec);
        return ret;
    }

    private double computeProperBandPassAttenuation(double inputFreq_RadPerSec, double minFreq_RadPerSec, double maxFreq_RadPerSec) {
        double highPass = this.computeProperHighPassAttenuation(inputFreq_RadPerSec, minFreq_RadPerSec);
        double lowPass = this.computeProperLowPassAttenuation(inputFreq_RadPerSec, maxFreq_RadPerSec);
        double ret = highPass * lowPass;
        return ret;
    }

    private double computeSteadyStateFilteredOutputAmplitude(YoDouble yoTime, double DT, double inputFrequencyRadPerSec, FirstOrderFilteredYoVariable filteredYoVariable) {
        double filterOutput_oldest = 0.0;
        double filterOutput_old = 0.0;
        double filterOutputPeak = 0.0;
        double filterOutputPeakOld = 0.0;
        double filterOutputPeakPercentChange = 100.0;
        boolean filterOutputHasReachedSteadyState = false;
        filteredYoVariable.reset();
        int i = 0;
        while (!filterOutputHasReachedSteadyState) {
            boolean filterOutputJustHitAPeak;
            double t = (double)i * DT;
            yoTime.set(t);
            double sineWaveInput = Math.sin(inputFrequencyRadPerSec * t);
            filteredYoVariable.update(sineWaveInput);
            double filterOutput = filteredYoVariable.getDoubleValue();
            boolean bl = filterOutputJustHitAPeak = filterOutput_old > filterOutput_oldest && filterOutput_old > filterOutput;
            if (filterOutputJustHitAPeak) {
                filterOutputPeak = filterOutput_old;
                filterOutputPeakPercentChange = 100.0 * Math.abs((filterOutputPeak - filterOutputPeakOld) / filterOutputPeak);
                filterOutputPeakOld = filterOutputPeak;
            }
            filterOutputHasReachedSteadyState = filterOutputPeakPercentChange < 1.0E-6;
            filterOutput_oldest = filterOutput_old;
            filterOutput_old = filterOutput;
            ++i;
        }
        return filterOutputPeak;
    }
}

