/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.robotics.math.filters;

import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.tools.ReferenceFrameTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.robotics.math.filters.FilteredVelocityYoFrameVector2d;
import us.ihmc.robotics.math.filters.FilteredVelocityYoVariable;
import us.ihmc.yoVariables.registry.YoRegistry;

public class FilteredVelocityYoFrameVector2dTest {
    private static final double EPSILON = 1.0E-15;

    @AfterEach
    public void tearDown() {
        ReferenceFrameTools.clearWorldFrameTree();
    }

    @Test
    public void testConsistencyWithAlphaFilteredYoVariable() {
        Random random = new Random(3453456L);
        for (int i = 0; i < 100; ++i) {
            double dt = EuclidCoreRandomTools.nextDouble((Random)random, (double)1.0E-7, (double)0.1);
            double alpha = random.nextDouble();
            YoRegistry registry = new YoRegistry("blop");
            FilteredVelocityYoFrameVector2d filteredPoint = new FilteredVelocityYoFrameVector2d("tested", "", () -> alpha, dt, registry, ReferenceFrame.getWorldFrame());
            FilteredVelocityYoVariable xFiltered = new FilteredVelocityYoVariable("xRef", "", alpha, dt, registry);
            FilteredVelocityYoVariable yFiltered = new FilteredVelocityYoVariable("yRef", "", alpha, dt, registry);
            Point2D unfilteredPoint = new Point2D();
            for (int j = 0; j < 10; ++j) {
                unfilteredPoint.scaleAdd(dt, (Tuple2DReadOnly)EuclidCoreRandomTools.nextPoint2D((Random)random), (Tuple2DReadOnly)unfilteredPoint);
                filteredPoint.update((Tuple2DReadOnly)unfilteredPoint);
                xFiltered.update(unfilteredPoint.getX());
                yFiltered.update(unfilteredPoint.getY());
                EuclidCoreTestTools.assertEquals((EuclidGeometry)new Point2D(xFiltered.getValue(), yFiltered.getValue()), (EuclidGeometry)filteredPoint, (double)1.0E-15);
            }
        }
    }
}

